<?php

class GestAvdStockMvtControllerOverride extends GestAvdStockMvtController 
{
    public function initContent()
    {
        ModuleAdminController::initContent();
        
        Module::getInstanceByName('imaxmultialmacen');

        $filtros = ['fm_product_name', 'fm_reference', 'fm_manufacturer', 'fm_order', 'fm_order_status_name', 'fm_stock_quantity',
            'fm_physical_quantity', 'fm_reserved_quantity', 'fm_mvt_physical', 'fm_mvt_reserved', 'fm_sign', 'fm_employee', 'fm_reason_presta',
            'fm_comments', 'fm_date_ini', 'fm_date_fin', 'fm_attribute'];
        
        $filter                        = false;
        $reset                         = false;
        $this->context->cookie->filter = false;
        if (Tools::isSubmit('npag2')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('ordersxpag');
        }
        if (Tools::isSubmit('order_pagination')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('order_pagination');
        }
        if (!$this->context->cookie->mostradosPorPagina) {
            //mostrar 10 facturas por defecto
            $mostradosPorPagina = 10;
        } else {
            $mostradosPorPagina = $this->context->cookie->mostradosPorPagina;
        }
        $mensaje = false;
        $info    = false;

        if (Tools::isSubmit('searchReset'))
            $reset=true;

        if (Tools::isSubmit('uploadCSV'))
        {
            $row = 1;
             $handle = fopen($_FILES['file']['tmp_name'], "r");
            $headers = fgetcsv($handle, 1000, ";");
            $estados=array();
            while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) 
            {
                if(count($data)==3)
                {
                    $reference=$data[0];
                    $quantity=$data[1];
                    $comments=$data[2];

                   $estado= StockAvailable::insertInventario($reference,$quantity,$comments,$row);
                   if($estado)
                    $estados[]=$estado;
                    $row++;

                }

            }
            fclose($handle);
                if($estados)
                {
                    $mensaje=true;
                    $men0   = "Errores en importación: ";
                    $men1   = "Importación ok: ";
                    foreach($estados as $e)
                    {
                        if($e[0]!="Ok")
                            $men0 .=$e[1]." :: ".$e[2].", ";
                        else
                            $men1 .=$e[1].", ";
                    }
                    $info[0]=$men0;   
                    $info[1]=$men1;

                }
    
        } 



        if (Tools::isSubmit('searchMovimientos')) {
            $task            = Tools::getValue('submitState');

            $movimientoSelected = Tools::getValue('id_stock_available_advancedSelected');
            $control         = false;
            $p=0;

            
            if ($task < 9) {
                if ($movimientoSelected != "") {
                    $control = false;
                } else {
                    $control = true;
                }
            }


            if (!$control) {
                switch ($task) {
                    case 1:
                        $tipo = "CSV";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 2:
                        $tipo     = "CSV";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info     = $this->sendMailCSV($fileName);
                        $mensaje  = true;
                        break;
                    case 3:
                        $tipo = "XLSX";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 4:
                        $tipo     = "XLSX";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info     = $this->sendMailXLSX($fileName);
                        $mensaje  = true;
                        break;
                    case 5:
                        $this->createPDF($movimientoSelected);
                        break;
                    case 6:
                        $fileName = $this->createPDF($movimientoSelected, true);
                        $info     = $this->sendMailPDF($fileName);
                        $mensaje  = true;
                        break;
                    case 7:
                        $this->importarCSV();
                        break;
                    case 8:
                        $info    = $this->sendMailImprimirFacturas($movimientoSelected);
                        $mensaje = true;
                        break;
                    case 9:
                        $filter = true;
                        break;
                    case 10:
                        $reset = true;
                        break;
                    case 11:
                        $filter = true;
                        break;
                    default:
                        # code...
                        break;
                }
                foreach (glob("../../../../modules/gestavdstock/tmp/*.*") as $filename) {
                    if (strpos($filename, 'index.php') === false) {
                        unlink($filename);
                    }
                }
            } else {
                $info    = array($this->l('You must select the items to export reports'), false);
                $mensaje = true;
            }
        }
        $paginaActual = 1;
        if (Tools::isSubmit('npag')) {
            $paginaActual = Tools::getValue('numpag');
        }
        $movimientoInicial = ($paginaActual - 1) * $mostradosPorPagina;
        $sql            = 'SELECT COUNT(*) AS total FROM `' . _DB_PREFIX_ . 'stock_available_advanced`';
        $fila           = Db::getInstance()->executeS($sql);
        $cont_movimientos  = $fila[0]['total'];
        /************************/
        if ($filter) {
            //Guardamos los filtros en la cookie
            foreach($filtros as $filtro) {
                $this->context->cookie->$filtro = Tools::getValue(str_replace('fm_', 'movimientosFilter_', $filtro));
            }
            if($this->context->cookie->fm_date_ini == '') {
                $fm_date_ini = "1970-01-01 00:00:00";
            }
            else {
                $ini = explode("/", $this->context->cookie->fm_date_ini);
                $fm_date_ini = $ini[2].'-'.$ini[1].'-'.$ini[0].' 00:00:00';
                $this->context->cookie->fm_date_ini = $fm_date_ini;
            }
            if($this->context->cookie->fm_date_fin == '') {
                $fm_date_fin = date("Y-m-d H:i:s");
            }
            else {
                $fin = explode("/", $this->context->cookie->fm_date_fin);
                $fm_date_fin = $fin[2].'-'.$fin[1].'-'.$fin[0].' 23:59:59';
                $this->context->cookie->fm_date_fin = $fm_date_fin;
            }
            $this->context->cookie->filter = true;
        }
        
        if ($reset) {
            //Reseteamos los filtros
            foreach($filtros as $filtro) {
                unset($this->context->cookie->$filtro);
            }
            $this->context->cookie->filter = false;
        }
       
        if (!$this->context->cookie->fm_product_name) {
            $fm_product_name = '';
        } else {
            $fm_product_name = $this->context->cookie->fm_product_name;
        }
        
        //Asignamos los filtros
        if(Tools::isSubmit('sortMovimientos')) {
            $this->context->cookie->order_way = Tools::getValue('order_way');
            $this->context->cookie->fm_attribute = Tools::getValue('fm_attribute');
        }
        
        if(empty($this->context->cookie->fm_attribute)) {
            $this->context->cookie->fm_attribute = 'a.`date_add`';
        }

        if(isset($this->context->cookie->order_way)) {
            $order_way = $this->context->cookie->order_way;
        }
        else {
            $order_way = '';
        }

        $p = array();
        foreach($filtros as $filtro) {
            $valor = (isset($this->context->cookie->$filtro) ? $this->context->cookie->$filtro : '');
            $this->context->smarty->assign($filtro, $valor);
            array_push($p, $valor);
        }


        $movimientos = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way);
        $sNumero       = true;
        $cunt          = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way, $sNumero);
        $cont_movimientos = $cunt[0]['cantidad'];
        /************************/
        if (isset($this->context->cookie->fm_product_name)
                || isset($this->context->cookie->fm_reference)
                || isset($this->context->cookie->fm_manufacturer)
                || isset($this->context->cookie->fm_order)
                || isset($this->context->cookie->fm_order_status_name)
                || isset($this->context->cookie->fm_stock_quantity)
                || isset($this->context->cookie->fm_physical_quantity)
                || isset($this->context->cookie->fm_reserved_quantity)
                || isset($this->context->cookie->fm_mvt_physical)
                || isset($this->context->cookie->fm_mvt_reserved)
                || isset($this->context->cookie->fm_sign)
                || isset($this->context->cookie->fm_employee)
                || isset($this->context->cookie->fm_reason_presta)
                || isset($this->context->cookie->fm_comments)
                || isset($this->context->cookie->fm_date_ini)
                || isset($this->context->cookie->fm_date_fin)) {
            $this->context->cookie->filter = true;
        }
        /************************/
        $path           = 'index.php?controller=GestAvdStockMvt&token=';
        $sortMovimientos   = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&sortMovimientos';
        $admin_token    = Tools::getAdminTokenLite('AdminOrders');
        $module_token   = Tools::getAdminTokenLite('AdminModules');
        $updateMovimientos = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&updateMovimientos';
        $searchMovimientos = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&searchMovimientos';
        $uploadCSV = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&uploadCSV';
        $paginacion     = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&npag';
        $paginacion2    = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&npag2';
        $ver            = $path . Tools::getAdminTokenLite('GestAvdStockMvt') . '&ver';
        $urlVProduct  = 'index.php?controller=AdminProducts';
        $urlVProduct .='&token='.Tools::getAdminTokenLite('AdminProducts');
        $urlVProduct .='&id_product=';
        
        $urlDFactura    = $this->context->link->getAdminLink('AdminPdf') . '&submitAction=generateInvoicePDF&id_order=';
        if (empty($_SERVER['HTTPS'])) {
            $protocolo = 'http://';
        } else {
            $protocolo = 'https://';
        }
        $urltienda = $protocolo . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . "modules/gestavdstock/";
        $urlEditComment=$urltienda."editCommentAdvanced.php";
        /************************/
        $paginasTotales = ceil($cont_movimientos / $mostradosPorPagina);

        $this->context->smarty->assign(array(
            'mensaje'            => $mensaje,
            'id_employee'        => Context::getContext()->employee->id,
            'uploadCSV'          => $uploadCSV,
            'info'               => $info,
            'admin_token'        => $admin_token,
            'module_token'       => $module_token,
            'updateMovimientos'     => $updateMovimientos,
            'sortMovimientos'       => $sortMovimientos,
            'filter'             => $this->context->cookie->filter,
            'cont_movimientos'      => $cont_movimientos,
            'movimientos'           => $movimientos,
            'searchMovimientos'     => $searchMovimientos,
            'paginacion'         => $paginacion,
            'paginacion2'        => $paginacion2,
            'paginasTotales'     => $paginasTotales,
            'paginaActual'       => $paginaActual,
            'mostradosPorPagina' => $mostradosPorPagina,
            'ver'                => $ver,
            'urlVProduct'       => $urlVProduct,
            'urlDescargaFactura' => $urlDFactura,
            'urlEditComment' => $urlEditComment,
            'urltienda'          => $urltienda,
            'link' => $this->context->link
        ));
        $this->setTemplate('../../../../modules/imaxmultialmacen/views/templates/admin/adminMvt.tpl');
    }
    public function searchMovimientosBy($p, $inVIn = null, $limit = null, $order = null, $sacarNumero = false)
    {
       $fm_product_name           = trim($p[0]);
        $fm_reference          = trim($p[1]);
        $fm_manufacturer          = trim($p[2]);
        $fm_order    = trim($p[3]);
        $fm_order_status_name = trim($p[4]);
        $fm_stock_quantity              = trim($p[5]);
        $fm_physical_quantity          = trim($p[6]);
        $fm_reserved_quantity          = trim($p[7]);
        $fm_mvt_physical   = trim($p[8]);
        $fm_mvt_reserved  = trim($p[9]);
        $fm_sign      = trim($p[10]);
        $fm_employee      = trim($p[11]);
        $fm_reason_presta      = trim($p[12]);
        $fm_comments      = trim($p[13]);
        $date_ini           = trim($p[14]);
        $date_fin           = trim($p[15]);
        $fm_attribute          = trim($p[16]);

        //lang
        $id_lang=$this->context->language->id;

        if ($limit == null) {
            $limit = 1000;
        }

        if($sacarNumero) {
            $sql = 'SELECT COUNT(*) cantidad ';
        }
        else {
            $sql = 'SELECT distinct a.*, osl.name as order_status_name, concat(e.firstname," ",e.lastname) as employee, m.name as manufacturer ';
        }
        $sql .= 'FROM ' . _DB_PREFIX_ . 'stock_available_advanced a ';
        $sql .= 'INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema ON a.id_stock_available_advanced = ema.id_stock_available_advanced ';
        $sql .= 'INNER JOIN `'._DB_PREFIX_.'warehouse` w ON ema.id_warehouse = w.id_warehouse ';
        $sql .= 'INNER JOIN ' . _DB_PREFIX_ . 'product p ON (p.id_product = a.id_product) ';
        $sql .= 'LEFT JOIN ' . _DB_PREFIX_ . 'employee e ON (e.id_employee = a.id_employee) ';
        $sql .= 'LEFT JOIN ' . _DB_PREFIX_ . 'manufacturer m ON (m.id_manufacturer = p.id_manufacturer) ';
        $sql .= 'INNER JOIN  ' . _DB_PREFIX_ . 'order_state_lang osl ON (a.id_order_status = osl.id_order_state and osl.id_lang='.$id_lang.') WHERE 1 ';
        $sql .= 'AND a.comments!="StockInicial" ';
        $sql .= 'AND (a.id_employee!="0" OR (a.id_employee="0" AND a.id_order!=0)) AND ema.id_warehouse = ' . 
                (int) Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'ALMACEN_GENERAL') . ' ';
       
        if ($fm_product_name !== '') {
            $sql = $sql . 'AND a.`product_name`  LIKE "%' .  pSQL ($fm_product_name) . '%" ';
        }
        if ($fm_reference !== '') {
            $sql = $sql . 'AND a.`reference` LIKE "%' . pSQL($fm_reference) . '%" ';
        }
        if ($fm_manufacturer !== '') {
            $sql = $sql . 'AND m.`name` LIKE "%' . pSQL($fm_manufacturer) . '%" ';
        }
        if ($fm_order !== '') {
            $sql = $sql . 'AND a.`id_order`=' . (int) $fm_order .  ' ';
        }
        if ($fm_order_status_name !== '') {
            $sql = $sql . 'AND osl.`name` LIKE "%' . pSQL($fm_order_status_name) . '%" ';
        }
        if ($fm_stock_quantity !== '') {
            $sql = $sql . 'AND a.`stock_quantity`="' . (int) ($fm_stock_quantity) .  '" ';
        }
        if ($fm_reserved_quantity !== '') {
            $sql = $sql . 'AND a.`reserved_quantity`="' . (int) ($fm_reserved_quantity) .  '" ';
        }
        if ($fm_physical_quantity !== '') {
            $sql = $sql . 'AND a.`physical_quantity`="' . (int) ($fm_physical_quantity) .  '" ';
        }
        if ($fm_mvt_physical !== '') {
            $sql = $sql . 'AND a.`mvt_physical`="' . (int) ($fm_mvt_physical) .  '" ';
        }
        if ($fm_mvt_reserved !== '') {
            $sql = $sql . 'AND a.`mvt_reserved`="' . (int) ($fm_mvt_reserved ) .  '" ';
        }
        if ($fm_sign !== '') {
            $sql = $sql . 'AND a.`sign`=' . (int) ($fm_sign) . '%" ';
        }
        if ($fm_employee !== '') {
            $sql = $sql . 'AND concat(e.firstname," ",e.lastname) LIKE "%' . pSQL($fm_employee) . '%" ';
        }
        if ($fm_reason_presta !== '') {
            $sql = $sql . 'AND a.`reason_presta` LIKE "%' . pSQL($fm_reason_presta) . '%" ';
        }
        if ($fm_comments !== '') {
            $sql = $sql . 'AND a.`comments` LIKE "%' . pSQL($fm_comments) . '%" ';
        }
        if ($date_ini !== '' || $date_fin !== '') {
            $sql = $sql . 'AND a.`date_add` BETWEEN "' . pSQL($date_ini) . '" AND "' . pSQL($date_fin) . '" ';
        }

        $_order_by =  $fm_attribute ? ' ORDER BY '. $fm_attribute .' '. ((string) $order ? $order : 'DESC ') . ', a.id_stock_available_advanced DESC' : ' ORDER BY a.id_stock_available_advanced DESC ';
        $sql = $sql . $_order_by;

        if (!$sacarNumero) {
            $sql = $sql . ' LIMIT ' . (int) $inVIn . ', ' . (int) $limit;
        }

        $movimientos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        //añadir atributo
        $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');

        if (!$sacarNumero && (is_array($movimientos) || is_object($movimientos))) {
            foreach($movimientos as &$movimiento) {
                //Obtenemos la imagen
                $image = [];
                if($movimiento['id_product_attribute']) {
                    $image = Image::getBestImageAttribute($this->context->shop->id, $id_lang, $movimiento['id_product'], $movimiento['id_product_attribute']);
                }

                if(!$image) {
                    $image = Image::getCover($movimiento['id_product']);
                }
                if(!$image) {
                    $image['id_image'] = $this->context->language->iso_code.'-default';
                }
                $product = new Product($movimiento['id_product']);
                $imagePath = $this->context->link->getImageLink($product->link_rewrite[$id_lang], $image['id_image'], 'small_default');
                $movimiento['image'] = $imagePath;
            }

        }

        return $movimientos;
    }
    
    public function generateCabeceraLinea()
    {
        $titles = array("NOMBRE PRODUCTO", "REFERENCIA", "FABRICANTE", "PEDIDO","ESTADO PEDIDO","CANTIDAD STOCK", "CANTIDAD FÍSICA", "CANTIDAD RESERVADA","MOV. FÍSICO","MOV. RESERVADO","EMPLEADO","RAZÓN PS", "ALMACÉN", "COMENTARIOS","FECHA");
        return $titles;
    }


    public function generateLinea($id_stock,$excel = false)
    {
         $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        
        $sql = 'SELECT  a.* ,osl.name as order_status_name, concat(e.firstname," ",e.lastname) as employee, m.name as manufacturer ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'stock_available_advanced a ';
        $sql .= 'INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema ON a.id_stock_available_advanced = ema.id_stock_available_advanced ';
        $sql .= 'INNER JOIN `'._DB_PREFIX_.'warehouse` w ON ema.id_warehouse = w.id_warehouse ';
        $sql .= 'INNER JOIN ' . _DB_PREFIX_ . 'product p ON (p.id_product = a.id_product) ';
        $sql .= 'INNER JOIN ' . _DB_PREFIX_ . 'employee e ON (e.id_employee = a.id_employee) ';
        $sql .= 'LEFT JOIN ' . _DB_PREFIX_ . 'manufacturer m ON (m.id_manufacturer = p.id_manufacturer) ';
        $sql .= 'INNER JOIN  ' . _DB_PREFIX_ . 'order_state_lang osl ON (a.id_order_status = osl.id_order_state and osl.id_lang='.$id_lang.') WHERE 1 ';
        $sql .= 'AND a.comments!="StockInicial" ';
        $sql .= 'AND (a.id_employee!="0" OR (a.id_employee="0" AND a.id_order!=0)) ';
        $sql.='AND a.id_stock_available_advanced ="'.$id_stock.'"';



         $movimiento = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);

         
         $linea                    = array();
         $linea['NOMBRE PRODUCTO']=$movimiento['product_name'];
         $linea['REFERENCIA']=$movimiento['reference'];
         $linea['FABRICANTE']=$movimiento['manufacturer'];
         $linea['PEDIDO']=$movimiento['id_order'];
         $linea['ESTADO PEDIDO']=$movimiento['order_status_name'];
         $linea['CANTIDAD STOCK']=$movimiento['stock_quantity'];
         $linea['CANTIDAD FÍSICA']=$movimiento['physical_quantity'];
         $linea['CANTIDAD RESERVADA']=$movimiento['reserved_quantity'];
         $linea['MOV. FÍSICO']=$movimiento['mvt_physical'];
         $linea['MOV. RESERVADO']=$movimiento['mvt_reserved'];
         $linea['EMPLEADO']=$movimiento['employee'];
         $linea['RAZÓN PS']=$movimiento['reason_presta'];
         $linea['COMENTARIOS']=$movimiento['comments'];
         $linea['FECHA']=$this->cambiaf_a_espanol(substr($movimiento['date_add'],0,10))." ".substr($movimiento['date_add'],11);
         
         

        return $linea;
    }
}
