<?php

class GestAvdStockControllerOverride extends GestAvdStockController //TODO: Con miles de entradas tarda en cargar la visualización.
{

    public function initContent() {
        ModuleAdminController::initContent();
        
        Module::getInstanceByName('imaxmultialmacen');
        
        $filtros = ['f_product_name', 'f_reference', 'f_manufacturer', 'f_order', 'f_order_status_name', 'f_stock_quantity',
            'f_physical_quantity', 'f_reserved_quantity', 'f_mvt_physical', 'f_mvt_reserved', 'f_sign', 'f_employee', 'f_reason_presta',
            'f_comments', 'f_date_ini', 'f_date_fin', 'f_attribute'];
        $filter = false;
        $reset = false;
        $this->context->cookie->filter = false;
        if(Tools::isSubmit('npag2')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('ordersxpag');
        }
        if(Tools::isSubmit('order_pagination')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('order_pagination');
        }
        if(!$this->context->cookie->mostradosPorPagina) {
            //mostrar 10 facturas por defecto
            $mostradosPorPagina = 10;
        }
        else {
            $mostradosPorPagina = $this->context->cookie->mostradosPorPagina;
        }
        $mensaje = false;
        $info = [];

        if(Tools::isSubmit('uploadCSV')) {
            $row = 1;
            $handle = fopen($_FILES['file']['tmp_name'], "r");
            $headers = fgetcsv($handle, 1000, ";");
            $estados = array();
            while(($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
                if(count($data) >= 3) {
                    $reference = $data[0];
                    $quantity = $data[1];
                    $comments = $data[2];
                    $id_warehouse = (!empty($data[3]) ? $data[3] : null);
                    
                    $estado = StockAvailable::insertInventario($reference, $quantity, $comments, $row, $id_warehouse);

                    if($estado)
                        $estados[] = $estado;
                    $row++;
                }
            }
            fclose($handle);
            if($estados) {
                $mensaje = true;
                $info['ok'] = '';
                $info['error'] = '';
                $men0 = '';
                $men1 = '';
                foreach($estados as $e) {
                    if($e[0] == "Ok") {
                        $men0 .= $e[1]." :: ".$e[2].", ";
                    }
                    else {
                        $men1 .= " ".$e[1].$e[2]." || ";
                    }
                }
                if($men0) {
                    $info['ok'] = 'Importación ok: '.$men0;
                }
                if($men1) {
                    $info['error'] = 'Errores en importación: '.$men1;
                }
            }
        }
        
        if (Tools::isSubmit('uploadCSVCompleto')) {
            $almacenError = Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'ALMACEN_ERROR');
            $row = 1;
            $handle = fopen($_FILES['file2']['tmp_name'], "r");
            $headers = fgetcsv($handle, 1000, ";");
            $estados=array();
            while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
                if(count($data) >= 5) {
                    $reference=$data[0];
                    $quantity=$data[1];
                    $fisicas=$data[2];
                    $reservadas=$data[3];
                    $comments=$data[4];
                    $id_warehouse = (!empty($data[5]) ? $data[5] : $almacenError);

                    $estado = StockAvailable::insertInventarioCompleto($reference,$quantity,$fisicas,$reservadas,$comments,
                            Context::getContext()->employee->id,$row,$id_warehouse);

                    if($estado) {
                        $estados[]=$estado;
                    }
                    $row++;
                }
            }
            fclose($handle);
            if($estados) {
                $mensaje=true;
                $info['ok'] = '';
                $info['error'] = '';
                $men0 = '';
                $men1 = '';
                foreach($estados as $e) {
                    if($e[0]=="Ok") {
                        $men0 .=$e[1]." :: ".$e[2].", ";
                    }
                    else {
                        $men1 .=" ".$e[1].$e[2]." || ";
                    }
                }
                if($men0) {
                    $info['ok'] = 'Importación Stock Completo ok: '.$men0;
                }
                if($men1) {
                    $info['error'] = 'Errores en importación Stock Completo: '.$men1;
                }
            }
        } 

        if(Tools::isSubmit('searchMovimientos')) {
            $task = Tools::getValue('submitState');
            $movimientoSelected = Tools::getValue('id_stock_advancedSelected');
            $control = false;
            $p = 0;

            if($task < 9) {
                if($movimientoSelected != "") {
                    $control = false;
                }
                else {
                    $control = true;
                }
            }


            if(!$control) {
                switch($task) {
                    case 1:
                        $tipo = "CSV";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 2:
                        $tipo = "CSV";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info = $this->sendMailCSV($fileName);
                        $mensaje = true;
                        break;
                    case 3:
                        $tipo = "XLSX";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 4:
                        $tipo = "XLSX";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info = $this->sendMailXLSX($fileName);
                        $mensaje = true;
                        break;
                    case 5:
                        $info = $this->cambiarStock($movimientoSelected);
                        $mensaje = true;
                        break;
                    case 6:
                        $fileName = $this->createPDF($movimientoSelected, true);
                        $info = $this->sendMailPDF($fileName);
                        $mensaje = true;
                        break;
                    case 7:
                        $this->importarCSV();
                        break;
                    case 8:
                        $info = $this->sendMailImprimirFacturas($movimientoSelected);
                        $mensaje = true;
                        break;
                    case 9:
                        $filter = true;
                        break;
                    case 10:
                        $reset = true;
                        break;
                    case 11:
                        $filter = true;
                        break;
                    default:
                        # code...
                        break;
                }
                foreach(glob("../../../../modules/gestavdstock/tmp/*.*") as $filename) {
                    if(strpos($filename, 'index.php') === false) {
                        unlink($filename);
                    }
                }
            }
            else {
                $info = array('error' => $this->l('You must select the items to export reports'), 'ok' => false);
                $mensaje = true;
            }
        }
        $paginaActual = 1;
        if(Tools::isSubmit('npag')) {
            $paginaActual = Tools::getValue('numpag');
        }
        $movimientoInicial = ($paginaActual - 1) * $mostradosPorPagina;
        $sql = 'SELECT COUNT(*) AS total FROM `'._DB_PREFIX_.'stock_available_advanced`';
        $fila = Db::getInstance()->executeS($sql);
        $cont_movimientos = $fila[0]['total'];
        /*         * ********************* */
        if($filter) {
            //Guardamos los filtros en la cookie
            foreach($filtros as $filtro) {
                $this->context->cookie->$filtro = Tools::getValue(str_replace('f_', 'movimientosFilter_', $filtro));
            }
            if($this->context->cookie->f_date_ini == '') {
                $f_date_ini = "1970-01-01 00:00:00";
            }
            else {
                $ini = explode("/", $this->context->cookie->f_date_ini);
                $f_date_ini = $ini[2].'-'.$ini[1].'-'.$ini[0].' 00:00:00';
                $this->context->cookie->f_date_ini = $f_date_ini;
            }
            if($this->context->cookie->f_date_fin == '') {
                $f_date_fin = date("Y-m-d H:i:s");
            }
            else {
                $fin = explode("/", $this->context->cookie->f_date_fin);
                $f_date_fin = $fin[2].'-'.$fin[1].'-'.$fin[0].' 23:59:59';
                $this->context->cookie->f_date_fin = $f_date_fin;
            }
            $this->context->cookie->filter = true;
        }


        if($reset) {
            //Reseteamos los filtros
            foreach($filtros as $filtro) {
                unset($this->context->cookie->$filtro);
            }
            $this->context->cookie->filter = false;
        }
        //Asignamos los filtros
        if(Tools::isSubmit('sortMovimientos')) {
            $this->context->cookie->order_way = Tools::getValue('order_way');
            $this->context->cookie->f_attribute = Tools::getValue('f_attribute');
        }
        
        if(empty($this->context->cookie->f_attribute)) {
            $this->context->cookie->f_attribute = 's.`id_stock`';
        }

        if(isset($this->context->cookie->order_way)) {
            $order_way = $this->context->cookie->order_way;
        }
        else {
            $order_way = '';
        }
        
        $p = array();
        foreach($filtros as $filtro) {
            $valor = (isset($this->context->cookie->$filtro) ? $this->context->cookie->$filtro : '');
            $this->context->smarty->assign($filtro, $valor);
            array_push($p, $valor);
        }

        $movimientos = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way);
        $sNumero = true;
        $cunt = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way, $sNumero, true);
        $cont_movimientos = $cunt[0]['cantidad'];
        /*         * ********************* */
        if(isset($this->context->cookie->f_product_name) || 
                isset($this->context->cookie->f_reference) || isset($this->context->cookie->f_manufacturer) || 
                isset($this->context->cookie->f_order) || isset($this->context->cookie->f_order_status_name) || 
                isset($this->context->cookie->f_stock_quantity) || isset($this->context->cookie->f_physical_quantity) || 
                isset($this->context->cookie->f_reserved_quantity) || isset($this->context->cookie->f_mvt_physical) || 
                isset($this->context->cookie->f_mvt_reserved) || isset($this->context->cookie->f_sign) || 
                isset($this->context->cookie->f_employee) || isset($this->context->cookie->f_reason_presta) || 
                isset($this->context->cookie->f_comments) || isset($this->context->cookie->f_date_ini) || 
                isset($this->context->cookie->f_date_fin)) {
            $this->context->cookie->filter = true;
        }
        /*         * ********************* */
        $path = 'index.php?controller=GestAvdStock&token=';
        $sortMovimientos = $path.Tools::getAdminTokenLite('GestAvdStock').'&sortMovimientos';
        $admin_token = Tools::getAdminTokenLite('AdminOrders');
        $module_token = Tools::getAdminTokenLite('AdminModules');
        $updateMovimientos = $path.Tools::getAdminTokenLite('GestAvdStock').'&updateMovimientos';
        $searchMovimientos = $path.Tools::getAdminTokenLite('GestAvdStock').'&searchMovimientos';
        $uploadCSV = $path.Tools::getAdminTokenLite('GestAvdStock').'&uploadCSV';
        $uploadCSVCompleto = $path . Tools::getAdminTokenLite('GestAvdStock') . '&uploadCSVCompleto';
        $changeQuantity = $path.Tools::getAdminTokenLite('GestAvdStock').'&changeQuantity';
        $paginacion = $path.Tools::getAdminTokenLite('GestAvdStock').'&npag';
        $paginacion2 = $path.Tools::getAdminTokenLite('GestAvdStock').'&npag2';
        $ver = $path.Tools::getAdminTokenLite('GestAvdStock').'&ver';
        $urlVPedido = $this->context->link->getAdminLink('AdminOrders').'&vieworder&id_order=';
        $urlVProduct = 'index.php?controller=AdminProducts';
        $urlVProduct .= '&token='.Tools::getAdminTokenLite('AdminProducts');
        $urlVProduct .= '&id_product=';

        $urlMovimientos = $this->context->link->getAdminLink('GestAvdStockMvt').'&searchMovimientos&submitState=9&movimientosFilter_reference=';
        $urlDFactura = $this->context->link->getAdminLink('AdminPdf').'&submitAction=generateInvoicePDF&id_order=';
        if(empty($_SERVER['HTTPS'])) {
            $protocolo = 'http://';
        }
        else {
            $protocolo = 'https://';
        }
        $urltienda = $protocolo.$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/gestavdstock/";
        $urlEditComment = $urltienda."../imaxmultialmacen/override/modules/gestavdstock/editCommentStock.php";
        $urlEditQuantity = $urltienda."../imaxmultialmacen/override/modules/gestavdstock/editQuantityStock.php";
        $urlEditStockDB = $urltienda."../imaxmultialmacen/override/modules/gestavdstock/editValores.php";
        $urllogs = $urltienda."logs/todocampers.log";
        $urllogsclean = $urltienda."cleanlog.php";
        /*         * ********************* */
        $paginasTotales = ceil($cont_movimientos / $mostradosPorPagina);
        $almacenesVirtuales = array_keys((new AlmacenesVirtuales())->cargarRelaciones());
        $this->context->smarty->assign(array(
            'mensaje' => $mensaje,
            'id_employee' => Context::getContext()->employee->id,
            'uploadCSV' => $uploadCSV,
            'uploadCSVCompleto'  => $uploadCSVCompleto,
            'changeQuantity' => $changeQuantity,
            'info' => $info,
            'admin_token' => $admin_token,
            'module_token' => $module_token,
            'updateMovimientos' => $updateMovimientos,
            'sortMovimientos' => $sortMovimientos,
            'filter' => $this->context->cookie->filter,
            'cont_movimientos' => $cont_movimientos,
            'movimientos' => $movimientos,
            'searchMovimientos' => $searchMovimientos,
            'paginacion' => $paginacion,
            'paginacion2' => $paginacion2,
            'paginasTotales' => $paginasTotales,
            'paginaActual' => $paginaActual,
            'mostradosPorPagina' => $mostradosPorPagina,
            'ver' => $ver,
            'urlVerPedido' => $urlVPedido,
            'urlVProduct' => $urlVProduct,
            'urlDescargaFactura' => $urlDFactura,
            'urlEditComment' => $urlEditComment,
            'urlEditStockDB' => $urlEditStockDB,
            'urltienda' => $urltienda,
            'urlMovimientos' => $urlMovimientos,
            'urlEditQuantity' => $urlEditQuantity,
            'urllogs' => $urllogs,
            'urllogsclean' => $urllogsclean,
            'almacenError' => Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'ALMACEN_ERROR'),
            'almacenes' => array_filter(Warehouse::getWarehouses(), function($almacen) use ($almacenesVirtuales) {
                return !in_array($almacen['id_warehouse'], $almacenesVirtuales);
            })
        ));
        $this->setTemplate('../../../../modules/imaxmultialmacen/views/templates/admin/admin.tpl');
        
        $this->context->cookie->write();
    }

    public function searchMovimientosBy($p, $inVIn = null, $limit = null, $order = null, $sacarNumero = false, $cort = false) {
        $f_product_name = $p[0];
        $f_reference = $p[1];
        $f_manufacturer = $p[2];
        $f_order = $p[3];
        $f_order_status_name = $p[4];
        $f_stock_quantity = $p[5];
        $f_physical_quantity = $p[6];
        $f_reserved_quantity = $p[7];
        $f_mvt_physical = $p[8];
        $f_mvt_reserved = $p[9];
        $f_sign = $p[10];
        $f_employee = $p[11];
        $f_reason_presta = $p[12];
        $f_comments = $p[13];
        $date_ini = $p[14];
        $date_fin = $p[15];
        $f_attribute = $p[16];

        //lang
        $id_lang = $this->context->language->id;

        if($limit == null) {
            $limit = 1000;
        }

        if($cort) {
            $campos = 'COUNT(*) cantidad';
        }
        else {
            $campos = 'COALESCE(pa.reference, p.reference) refCompleta, m.name manufacturer, s.*, usable_quantity quantity,
                    CAST(physical_quantity AS SIGNED) - CAST(usable_quantity AS SIGNED) as reserved_quantity, esa.comments';
        }
        $sql = '
            SELECT '.$campos.' FROM `'._DB_PREFIX_.'stock` s
                LEFT JOIN `'._DB_PREFIX_.'warehouse` w ON s.id_warehouse = w.id_warehouse
                LEFT JOIN `'._DB_PREFIX_.'product` p ON s.id_product = p.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON s.id_product = pl.id_product AND pl.id_lang = '.$id_lang.'
                LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON s.id_product_attribute = pa.id_product_attribute
                LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON p.id_manufacturer = m.id_manufacturer
                LEFT JOIN `'._DB_PREFIX_.imaxmultialmacen::prefijo.'extraStock_advanced` esa ON s.id_stock = esa.id_stock ';
        $sql .= 'WHERE 1 ';
        $sql .= 'AND p.reference NOT LIKE "%'.pSQL("Pack").'%" AND (pa.reference NOT LIKE "%'.pSQL("Pack").'%" OR pa.reference IS NULL) AND
            (pa.id_product_attribute != 0 OR NOT EXISTS(SELECT pa2.id_product FROM `'._DB_PREFIX_.'product_attribute` pa2 
                WHERE pa2.id_product = p.id_product)) AND s.id_warehouse = ' . 
                (int) Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'ALMACEN_GENERAL') . ' ';

        if($f_product_name != '') {
            $sql = $sql.'AND pl.`name` LIKE "%'.pSQL($f_product_name).'%" ';
        }
        if($f_reference != '') {
            $sql = $sql.'AND (p.reference LIKE "%'.pSQL($f_reference).'%" OR pa.reference LIKE "%'.pSQL($f_reference).'%") ';
        }
        if($f_manufacturer != '') {
            $sql = $sql.'AND `manufacturer` LIKE "%'.pSQL($f_manufacturer).'%" ';
        }

        if(($f_stock_quantity != '') || ($f_stock_quantity == "0")) {
            $sql = $sql.'AND s.`usable_quantity`='.(int) ($f_stock_quantity).' ';
        }

        if(($f_physical_quantity != '') || ($f_physical_quantity == "0")) {
            $sql = $sql.'AND s.`physical_quantity`='.(int) ($f_physical_quantity).' ';
        }

        if(($f_reserved_quantity != '') || ($f_reserved_quantity == "0")) {
            $sql = $sql.'HAVING `reserved_quantity`='.(int) ($f_reserved_quantity).' ';
        }

        if($f_comments != '') {
            $sql = $sql.'AND esa.`comments` LIKE "%'.pSQL($f_comments).'%" ';
        }

        $sql = $sql.' ORDER BY '.$f_attribute.' '.((string) $order ? $order : 'DESC ');
        if(!$sacarNumero) {
            $sql = $sql.' LIMIT '.(int) $inVIn.', '.(int) $limit;
        }

        $stocks = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        if(!$cort) {
            if($stocks) {
                foreach($stocks as &$stock) {
                    //Completamos el nombre
                    $stock['nombreCompleto'] = Product::getProductName($stock['id_product'], $stock['id_product_attribute']);
                    //Obtenemos la imagen
                    $image = [];
                    if($stock['id_product_attribute']) {
                        $image = Image::getBestImageAttribute($this->context->shop->id, $id_lang, $stock['id_product'], $stock['id_product_attribute']);
                    }

                    if(!$image) {
                        $image = Image::getCover($stock['id_product']);
                    }
                    if(!$image) {
                        $image['id_image'] = $this->context->language->iso_code.'-default';
                    }
                    $product = new Product($stock['id_product']);
                    $imagePath = $this->context->link->getImageLink($product->link_rewrite[$id_lang], $image['id_image'], 'small_default');
                    $stock['image'] = $imagePath;
                }
            }
        }

        return $stocks;
    }

    public function cambiarStock($boxes) {
        $comment            = Tools::getValue('commentG');
        $commentSql = pSQL($comment);
        $quantity            = Tools::getValue('quantityG');
        $id_warehouse = Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'ALMACEN_ERROR');

        if($id_warehouse) {
            foreach ($boxes as $id_stock) {
                //Buscar reference que hace falta
                $id_stock = (int)$id_stock;
                $sql = '
                    SELECT COALESCE(pa.reference, p.reference) refCompleta, s.id_warehouse FROM `'._DB_PREFIX_.'stock` s
                        LEFT JOIN `'._DB_PREFIX_.'product` p ON s.id_product = p.id_product
                        LEFT JOIN `'._DB_PREFIX_."product_attribute` pa ON s.id_product_attribute = pa.id_product_attribute
                    WHERE s.id_stock = $id_stock";

                if($row = Db::getInstance()->getRow($sql))
                {
                    $reference = $row['refCompleta'];
                    $resultado = StockAvailable::insertInventario($reference,$quantity,$comment,$id_stock,$id_warehouse);
                    if($resultado[0] == 'Ok') {
                        //Introducimos el comentario
                        $sql="REPLACE INTO " . _DB_PREFIX_ . "imax_multi_alma_extraStock_advanced (id_stock, comments) VALUES ($id_stock, '$commentSql')";
                        Db::getInstance()->execute($sql);
                    }
                }
                else
                {
                    $info     = $this->l('Update stock Error in id_stock: '.$id_stock);
                    $correcto = false;
                    return array('error' => $info,  'ok' => $correcto);
                }
            }

            $result = array('error' => false, 'ok' => $this->l('Update stock ok'));
        }
        else {
            $result = array('error' => true, 'ok' => $this->l('Almacén para productos desubicados no configurado.'));
        }
        
        return $result;
    }

    public function generateLinea($id_stock,$excel = false)
    {
        $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        $sql = '
            SELECT COALESCE(pa.reference, p.reference) refCompleta, m.name manufacturer, s.*,
                    CAST(physical_quantity AS SIGNED) - CAST(usable_quantity AS SIGNED) as reserved_quantity, esa.comments FROM `'._DB_PREFIX_.'stock` s
                LEFT JOIN `'._DB_PREFIX_.'warehouse` w ON s.id_warehouse = w.id_warehouse
                LEFT JOIN `'._DB_PREFIX_.'product` p ON s.id_product = p.id_product
                LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON s.id_product = pl.id_product AND pl.id_lang = '.$id_lang.'
                LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON s.id_product_attribute = pa.id_product_attribute
                LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON p.id_manufacturer = m.id_manufacturer
                LEFT JOIN `'._DB_PREFIX_.imaxmultialmacen::prefijo.'extraStock_advanced` esa ON s.id_stock = esa.id_stock 
            WHERE p.reference NOT LIKE "%'.pSQL("Pack").'%" AND (pa.reference NOT LIKE "%'.pSQL("Pack").'%" OR pa.reference IS NULL) AND s.id_stock = "'.(int)$id_stock.'"';

         $movimiento = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);

         $linea                    = array();
         $linea['NOMBRE PRODUCTO']=Product::getProductName($movimiento['id_product'], $movimiento['id_product_attribute']);
         $linea['REFERENCIA']=$movimiento['refCompleta'];
         $linea['FABRICANTE']=$movimiento['manufacturer'];
         $linea['CANTIDAD STOCK']=$movimiento['usable_quantity'];
         $linea['CANTIDAD FÍSICA']=$movimiento['physical_quantity'];
         $linea['CANTIDAD RESERVADA']=$movimiento['reserved_quantity'];
         $linea['COMENTARIOS']=$movimiento['comments'];

        return $linea;
    }
    
    public function generateCabeceraLinea()
    {
        $titles = array("NOMBRE PRODUCTO", "REFERENCIA", "FABRICANTE", "CANTIDAD STOCK", "CANTIDAD FÍSICA", "CANTIDAD RESERVADA", "COMENTARIOS");
        return $titles;
    }
}
