<?php
class StockManager extends StockManagerCore 
{
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getStockByCarrier($id_product = 0, $id_product_attribute = 0, $delivery_option = null) {
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $modo = $imax->getModoActual();
        if($modo == ImaxMultiAlmacen::MODO_ORDENADOS) {
            $stock_quantity = parent::getStockByCarrier($id_product, $id_product_attribute, $delivery_option);
        }
        else {
            if (!(int) $id_product || !is_array($delivery_option) || !is_int($id_product_attribute)) {
                return false;
            }
            $stock_quantity = 0;
            $warehouse = Module::getInstanceByName('imaxmultialmacen')->getWarehouse();
            if (Validate::isLoadedObject($warehouse)) {
                $carriers = $warehouse->getWsCarriers();
                if (is_array($carriers) && !empty($carriers)) {
                    $stock_quantity += Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT SUM(s.`usable_quantity`) as quantity
						FROM ' . _DB_PREFIX_ . 'stock s
						LEFT JOIN ' . _DB_PREFIX_ . 'warehouse_carrier wc ON wc.`id_warehouse` = s.`id_warehouse`
						LEFT JOIN ' . _DB_PREFIX_ . 'carrier c ON wc.`id_carrier` = c.`id_reference`
						WHERE s.`id_product` = ' . (int) $id_product . ' AND s.`id_product_attribute` = ' . (int) $id_product_attribute . ' 
                            AND s.`id_warehouse` = ' . $warehouse->id . ' AND c.`id_carrier` IN (' . rtrim($delivery_option[(int) Context::getContext()->cart->id_address_delivery], ',') . ') 
                        GROUP BY s.`id_product`');
                } else {
                    $stock_quantity += Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT SUM(s.`usable_quantity`) as quantity
						FROM ' . _DB_PREFIX_ . 'stock s
						WHERE s.`id_product` = ' . (int) $id_product . ' AND s.`id_product_attribute` = ' . (int) $id_product_attribute . ' 
                            AND s.`id_warehouse` = ' . $warehouse->id . ' 
                        GROUP BY s.`id_product`');
                }
            }
        }
        return $stock_quantity;
    }
}
