<?php
class StockAvailable extends StockAvailableCore 
{
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function synchronize($id_product, $order_id_shop = null) { }
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getQuantityAvailableByProduct($id_product = null, $id_product_attribute = null, $id_shop = null, $id_warehouse = null) {
        $context = Context::getContext();
        if ($id_product_attribute === null) {
            $id_product_attribute = 0;
        }
        
        if(!$id_warehouse) {
            if(Validate::isLoadedObject($context->warehouse)) {
                $id_warehouse = $context->warehouse->id;
            }
            else {
                $id_warehouse = -1;
            }
        }
        
        $key = 'StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '-' . (int) $id_product_attribute . '-' . (int)$id_warehouse;
        if (!Cache::isStored($key)) {
            $query = new DbQuery();
            $query->select('SUM(usable_quantity)');
            $query->from('stock');
            if ($id_product !== null) {
                $query->where('id_product = ' . (int) $id_product);
            }
            $query->where('id_product_attribute = ' . (int) $id_product_attribute);
            if($id_warehouse != -1) {
                $query->where('id_warehouse = ' . (int) $id_warehouse);
            }
            $result = (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query);
            Cache::store($key, $result);
            return $result;
        }
        return Cache::retrieve($key);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function postSave() { return true; }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function updateQuantity($id_product, $id_product_attribute, $delta_quantity, $id_shop = null, $add_movement = false, $params = array(), $id_warehouse = null) {
        if($id_warehouse || Validate::isLoadedObject(Context::getContext()->warehouse)) {
            $currentQuantity = self::getQuantityAvailableByProduct($id_product, $id_product_attribute, $id_shop, $id_warehouse);
            $result = self::setQuantity($id_product, $id_product_attribute, $currentQuantity + $delta_quantity, $id_shop, $add_movement, $id_warehouse);
        }
        else {
            if($delta_quantity > 0) {
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
                $currentQuantity = self::getQuantityAvailableByProduct($id_product, $id_product_attribute, $id_shop, $id_warehouse);
                $result = self::setQuantity($id_product, $id_product_attribute, $currentQuantity + $delta_quantity, $id_shop, $add_movement, $id_warehouse);
            }
            else {
                $result = false;
                
                $infosStock = StockOrdenado::getInstance()->obtenerStockOrdenado($id_product, $id_product_attribute);
                $i = 0;
                $count = count($infosStock);
                while($delta_quantity < 0 && $i < $count) {
                    $infoStock = $infosStock[$i];
                    if($i == $count - 1) {
                        $newQuantity = $infoStock['usable_quantity'] + $delta_quantity;
                        $delta_quantity = 0;
                    }
                    else {
                        if($infoStock['usable_quantity'] >= abs($delta_quantity)) {
                            $newQuantity = $infoStock['usable_quantity'] + $delta_quantity;
                        }
                        else {
                            $newQuantity = 0;
                        }
                        $delta_quantity += $infoStock['usable_quantity'];
                    }
                    $result = self::setQuantity($id_product, $id_product_attribute, $newQuantity, $id_shop, $add_movement, $infoStock['id_warehouse']);
                    $i++;
                }
            }
        }
        
        return $result;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function setQuantity($id_product, $id_product_attribute, $quantity, $id_shop = null, $add_movement = true, 
            $id_warehouse = null, $comments = '') {
        if (!Validate::isUnsignedId($id_product)) {
            return false;
        }
        
        $context = Context::getContext();
        if(!$id_warehouse) {
            if(Validate::isLoadedObject($context->warehouse)) {
                $id_warehouse = $context->warehouse->id;
            }
            else {
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
            }
        }
        if ($id_shop === null && Shop::getContext() != Shop::CONTEXT_GROUP) {
            $id_shop = (int) $context->shop->id;
        }
        $id_stock = (int) self::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
        $quantity = (int)($quantity >= 0 ? $quantity : 0);
        if ($id_stock) {
            $stockObj = new Stock($id_stock);
            $deltaQuantity = -1 * ((int) $stockObj->usable_quantity - (int) $quantity);
            $stockObj->usable_quantity = $quantity;
            $modo = Module::getInstanceByName('imaxmultialmacen')->getModoActual();
            if(!Configuration::getGlobalValue(ImaxMultiAlmacen::prefijo . 'DISTINGUIR_FISICO') || $modo == ImaxMultiAlmacen::MODO_ORDENADOS) {
                $stockObj->physical_quantity = $quantity;
            }
            $stockObj->update();
            if(!$deltaQuantity) {
                $add_movement = false;
            }
        } 
        else {
            $stockObj = new Stock();
            $deltaQuantity = -1 * ((int) $stockObj->usable_quantity - (int) $quantity);
            $stockObj->id_product = (int) $id_product;
            $stockObj->id_product_attribute = (int) $id_product_attribute;
            $stockObj->id_warehouse = (int)$id_warehouse;
            $stockObj->usable_quantity = $quantity;
            $stockObj->physical_quantity = $quantity;
            $stockObj->price_te = 0;
            $stockObj->add();
        }
        
        $id_stock_available = self::getStockAvailableIdByProductId($id_product, 0, $id_shop);
        if(!$id_stock_available) {
            $stock_available = new StockAvailable();
            $stock_available->quantity = null;
            $stock_available->out_of_stock = 2;
            $stock_available->id_product = (int) $id_product;
            $stock_available->id_product_attribute = 0;
            if ($id_shop === null) {
                $shop_group = Shop::getContextShopGroup();
            } 
            else {
                $shop_group = new ShopGroup((int) Shop::getGroupFromShop((int) $id_shop));
            }
            if ($shop_group->share_stock) {
                $stock_available->id_shop = 0;
                $stock_available->id_shop_group = (int) $shop_group->id;
            } 
            else {
                $stock_available->id_shop = (int) $id_shop;
                $stock_available->id_shop_group = 0;
            }
            $stock_available->add();
        }
        if($add_movement && Module::isEnabled('gestavdstock')) {
            $sql = '
                SELECT * FROM `'._DB_PREFIX_.'stock_available_advanced` saa
                    INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema 
                        ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
                WHERE id_product="'.(int)$id_product.'" and id_product_attribute="'.(int)$id_product_attribute.'" 
                    and id_warehouse = "'.(int)$id_warehouse.'" 
                order by date_add DESC';
            if(!$comments) {
                $comments="Establecida de forma Manual";
            }
            if($row = Db::getInstance()->getRow($sql)){
                $physical_quantity = $stockObj->usable_quantity + $row['reserved_quantity'];
                $mvt_physical = $physical_quantity - $row['physical_quantity'];
                $reserved_quantity = $row['reserved_quantity'];
                $stockObj->physical_quantity = $physical_quantity;
                $stockObj->update();
            }
            else{
                $mvt_physical = $stockObj->usable_quantity;
                $reserved_quantity = 0;
                $physical_quantity = $stockObj->usable_quantity;
                $stockObj->physical_quantity = $physical_quantity;
                $stockObj->update();
            }
            $date_add= date('Y-m-d H:i:s');
            $id_stock_mvt_reason="Edición de Producto";
            $sign=-1;
            if($mvt_physical>0) {
                 $sign=1;
            }
            $mvt_reserved=0;
            $id_order=0;
            $id_order_status=0;
            $id_employee = (Validate::isLoadedObject(Context::getContext()->employee) ? Context::getContext()->employee->id : 0);
            $lang_id = Context::getContext()->language->id;
            $productT = new Product($id_product, false, $lang_id);
            $product_name=$productT->name;
            $reference=$productT->reference;
            if($id_product_attribute>0)
            {
                $reference=StockAvailable::getReferenceAtributo($id_product,$id_product_attribute);
                $product_name=$product_name. " - ". StockAvailable::getNameAtributo($id_product_attribute);
            }
            $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
                VALUES ("'.pSQL($product_name).'","'.pSQL($reference).'","'.(int)$id_product.'","'.(int)$id_product_attribute.'","'.(int)$id_order.'","'.(int)$id_order_status.'","'.(int)$stockObj->usable_quantity.'","'.(int)$physical_quantity.'","'.(int)$reserved_quantity.'","'.(int)$mvt_physical.'","'.(int)$mvt_reserved.'","'.(int)$sign.'","'.(int)$id_employee.'","'.pSQL($id_stock_mvt_reason).'","'.pSQL($comments).'","'.pSQL($date_add).'")';
            Db::getInstance()->execute($sql);
            
            $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
            $id_warehouse = (int)$id_warehouse;
            Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
                (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $id_warehouse)");
        }
        
        Hook::exec(
            'actionUpdateQuantity',
            array(
                'id_product' => $id_product,
                'id_product_attribute' => $id_product_attribute,
                'quantity' => $stockObj->usable_quantity,
                'id_warehouse' => (int)$id_warehouse
            )
        );
        
        Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '-' . (int) $id_product_attribute . '-' . (int)$id_warehouse);
        Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '-0-' . (int)$id_warehouse);
        if(!Validate::isLoadedObject($context->warehouse)) {
            Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '-' . (int) $id_product_attribute . '-' . -1);
            Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '-0-' . -1);            
        }
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function insertInventario($reference, $quantity, $comments, $fila, $id_warehouse = null)
    {
        $id_product="";
        $id_shop = null; $add_movement = true;
        $sql = 'SELECT  id_product,id_product_attribute ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.reference="' . $reference . '" ';
        if($row = Db::getInstance()->getRow($sql))
        {
            $id_product=$row['id_product'];
            $id_product_attribute=$row['id_product_attribute'];
        }
        else
        {
            $sql = 'SELECT  id_product ';
            $sql .= 'FROM ' . _DB_PREFIX_ . 'product p ';
            $sql .= 'WHERE p.reference="' . $reference . '" ';
            if($row = Db::getInstance()->getRow($sql))
            {
                $id_product=$row['id_product'];
                $id_product_attribute=0;
            }
        }
        if($id_product){
            if(!$id_warehouse && Module::isEnabled('imaximprimepedidosservidor')) {
                $imprime = Module::getInstanceByName('imaximprimepedidosservidor');
                $opcionesAlmacen = $imprime->cargarOpcionAlmacen($id_product, $id_product_attribute);
                $id_warehouse = $opcionesAlmacen['almacenEntradaPorDefecto'];
            }
            
            self::setQuantity($id_product, $id_product_attribute, $quantity, null, true, $id_warehouse, $comments);
            $ok[0]="Ok";
            $ok[1]="Fila ".$fila;
            $ok[2]="Importado Correctamente";
            return $ok;
        }
        else
        {
            $error[0]="Error";
            $error[1]="Fila ".$fila;
            $error[2]="No existe Referencia";
            
            return $error;
        }
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function insertInventarioCompleto($reference,$quantityS,$quantityF,$quantityR,$comments,$id_employee,$fila,
            $id_warehouse = null,$cleanStock = false)
    {
        $ok = [];
        $date_add = date('Y-m-d H:i:s');
        $referenceSql = pSQL($reference);
        $sql = 'SELECT id_product, id_product_attribute FROM `'._DB_PREFIX_."product_attribute` WHERE reference = '$referenceSql'";
        $row = Db::getInstance()->getRow($sql);
        if(!$row) {
            $sql = 'SELECT id_product, 0 id_product_attribute FROM `'._DB_PREFIX_."product` WHERE reference = '$referenceSql'";
            $row = Db::getInstance()->getRow($sql);
        }
        if($row) {
            $ok[0]="Ok";
            $ok[1]="Fila ".$fila;
            $ok[2]="Importado Correctamente con Referencia: ".$reference;
            $row['product_name'] = Product::getProductName($row['id_product'], $row['id_product_attribute']);
        }
        else {
            $ok[0]="Error";
            $ok[1]="Fila ".$fila;
            $ok[2]="No existe Referencia: ".$reference;
        }
        
        if($ok[0] == 'Ok') {
            $id_product = (int)$row['id_product'];
            $id_product_attribute = (int)$row['id_product_attribute'];
            $id_warehouse = (int)$id_warehouse;
            if(!$id_warehouse) {
                if(Validate::isLoadedObject(Context::getContext()->warehouse)) {
                    $id_warehouse = Context::getContext()->warehouse->id;
                }
                else {
                    $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
                }
            }
            
            if($cleanStock) {
                $cleanWarehouses = Db::getInstance()->executeS('
                    SELECT DISTINCT ema.id_warehouse FROM `' . _DB_PREFIX_ . 'stock_available_advanced` saa
                        INNER JOIN `' . _DB_PREFIX_ . 'imax_multi_alma_extraMovimiento_advanced` ema 
                            ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
                        LEFT JOIN `' . _DB_PREFIX_ . "imax_multi_alma_almacenStockVirtual` asv 
                            ON ema.id_warehouse = asv.id_warehouse
                    WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute AND ema.id_warehouse != $id_warehouse AND 
                        asv.id_warehouse IS NULL");
                foreach($cleanWarehouses as $cleanWarehouse) {
                    self::setStockCompleto($row['product_name'], $row['id_product'], $row['id_product_attribute'], 0, 0, 0, $id_employee, 
                            $comments, $cleanWarehouse['id_warehouse'], $date_add, $reference);
                }
            }
            
            self::setStockCompleto($row['product_name'], $row['id_product'], $row['id_product_attribute'], $quantityS, $quantityF, $quantityR, 
                    $id_employee, $comments, $id_warehouse, $date_add, $reference);
            
            $multialmacen = Module::getInstanceByName('imaxmultialmacen');
            $multialmacen->getFunciones()->actualizarStockVirtualProducto($id_product, $id_product_attribute);
        }     
        
        return $ok;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private static function setStockCompleto($product_name, $id_product, $id_product_attribute, $quantityS, $quantityF, $quantityR, $id_employee,
            $comments, $id_warehouse, $date_add, $reference) {
        $product_name = pSQL($product_name);
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $quantityS = (int)$quantityS;
        $quantityF = (int)$quantityF;
        $quantityR = (int)$quantityR;
        $id_employee = (int)$id_employee;
        $comments = pSQL($comments);
        $id_warehouse = (int)$id_warehouse;
        $date_add = pSQL($date_add);
        $reference = pSQL($reference);
        
        $sql = 'INSERT INTO ' . _DB_PREFIX_ ."stock_available_advanced 
            (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
            VALUES ('$product_name', '$reference', $id_product, $id_product_attribute, 0, 0, $quantityS, $quantityF, $quantityR, 0, 0, -1, $id_employee, '', '$comments', '$date_add')";
        Db::getInstance()->execute($sql);
        $id_stock_available_advanced = Db::getInstance()->Insert_ID();
        $sql = 'REPLACE INTO ' . _DB_PREFIX_."imax_multi_alma_extraMovimiento_advanced (id_stock_available_advanced, id_warehouse) 
            VALUES ('$id_stock_available_advanced', '$id_warehouse')";
        Db::getInstance()->execute($sql);
        self::setQuantity($id_product, $id_product_attribute, $quantityS, null, false, $id_warehouse);
        $sql="UPDATE `" . _DB_PREFIX_ . "stock` set physical_quantity='$quantityF'
            where id_product='$id_product' and id_product_attribute=$id_product_attribute and id_warehouse = $id_warehouse";
        Db::getInstance()->execute($sql);
        $sql="SELECT id_stock FROM " . _DB_PREFIX_ . "stock where id_product='$id_product' and id_product_attribute=$id_product_attribute and id_warehouse = $id_warehouse";
        $id_stock = (int)Db::getInstance()->getValue($sql);
        $sql="REPLACE INTO " . _DB_PREFIX_ . "imax_multi_alma_extraStock_advanced (id_stock, comments) VALUES ($id_stock, '$comments')";
        Db::getInstance()->execute($sql);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function resetProductFromStockAvailableByShopGroup(ShopGroup $shop_group) { }
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute = null, $id_warehouse = null) {
        if (!Validate::isUnsignedId($id_product)) {
            return false;
        }
        
        $context = Context::getContext();
        if(!$id_warehouse) {
            if(Validate::isLoadedObject($context->warehouse)) {
                $id_warehouse = $context->warehouse->id;
            }
            else {
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
            }
        }
        $query = new DbQuery();
        $query->select('id_stock');
        $query->from('stock');
        $query->where('id_product = ' . (int) $id_product);
        $query->where('id_warehouse = ' . (int) $id_warehouse);
        if ($id_product_attribute !== null) {
            $query->where('id_product_attribute = ' . (int) $id_product_attribute);
        }
        return (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getReferenceAtributo($id_product,$id_product_attribute)
    {
        $sql = 'SELECT  reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.id_product_attribute=' . $id_product_attribute . ' and p.id_product=' . $id_product .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['reference'];
        }
        else
            return "";
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getNameAtributo($id_product_attribute)
    {
        $id_lang=Context::getContext()->language->id;
        $sql = 'SELECT  name ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'attribute_lang a ';
        $sql .= 'WHERE a.id_attribute=' . $id_product_attribute . ' and a.id_lang=' . $id_lang .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['name'];
        }
        else
            return "";
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function add($autodate = true, $null_values = false) {
        if($this->quantity === null) {
            $this->quantity = 0;
            $movimiento = false;
        }
        else {
            $movimiento = true;
        }
        
        $resultado = parent::add($autodate, $null_values);
        if($resultado && $movimiento) {
            self::setQuantity($this->id_product, $this->id_product_attribute, $this->quantity, $this->id_shop);
        }
        return $resultado;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function update($null_values = false) {
        $resultado = parent::update($null_values);
        if($resultado) {
            self::setQuantity($this->id_product, $this->id_product_attribute, $this->quantity, $this->id_shop);
        }
        return $resultado;
    }
}
