<?php
use PrestaShop\PrestaShop\Adapter\MailTemplate\MailPartialTemplateRenderer;
use PrestaShop\PrestaShop\Adapter\StockManager as StockManagerAdapter;
use PrestaShop\PrestaShop\Core\Stock\StockManager;
class OrderHistory extends OrderHistoryCore
{
    public function getReferenceAtributo($id_product,$id_product_attribute)
    {
        $sql = 'SELECT  reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.id_product_attribute=' . $id_product_attribute . ' and p.id_product=' . $id_product .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['reference'];
        }
        else
            return "";
    }
    public function getNameAtributo($id_product_attribute)
    {
        $id_lang=Context::getContext()->language->id;
        $sql = 'SELECT  name ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'attribute_lang a ';
        $sql .= 'WHERE a.id_attribute=' . $id_product_attribute . ' and a.id_lang=' . $id_lang .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['name'];
        }
        else
            return "";
    }
    
    
    
    
    
    
    
    
    
    
    
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function changeIdOrderState($new_order_state, $id_order, $use_existing_payment = false) {
        if (!$new_order_state || !$id_order) {
            return;
        }
        
        if (!is_object($id_order) && is_numeric($id_order)) {
            $order = new Order((int) $id_order);
        } elseif (is_object($id_order)) {
            $order = $id_order;
        } else {
            return;
        }
        $new_os = new OrderState((int) $new_order_state, $order->id_lang);
        $old_os = $order->getCurrentOrderState();
        
        parent::changeIdOrderState($new_order_state, $id_order, $use_existing_payment);
        
        $context = Context::getContext();
        $multialmacen = Module::getInstanceByName('imaxmultialmacen');
        $id_warehouse = $multialmacen->getFunciones()->cargarAlmacenPedido($order->id);
        if(!$id_warehouse) {
            if(Validate::isLoadedObject($context->warehouse)) {
                $id_warehouse = $context->warehouse->id;
            }
            else {
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
            }
        }
        $almacenesVirtuales = array_keys((new AlmacenesVirtuales())->cargarRelaciones());
        $esVirtual = in_array($id_warehouse, $almacenesVirtuales);
        $error_or_canceled_statuses = [Configuration::get('PS_OS_ERROR'), Configuration::get('PS_OS_CANCELED')];
        foreach($order->getProductsDetail() as $product) {
            $lang_id = Context::getContext()->language->id;
            $productT = new Product($product['product_id'], false, $lang_id);
            $product_name = $productT->name;
            $reference = $productT->reference;
            if($product['product_attribute_id'] > 0) {
                $reference = OrderHistory::getReferenceAtributo($product['product_id'], $product['product_attribute_id']);
                $product_name = $product_name." - ".OrderHistory::getNameAtributo($product['product_attribute_id']);
            }
            $id_product = $product['product_id'];
            $id_product_attribute = $product['product_attribute_id'];
            $product_quantity = $product['product_quantity'];
            $sqlSelect = '
                SELECT * FROM '._DB_PREFIX_.'stock_available_advanced saa
                    INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema 
                        ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
                WHERE id_product="'.(int)$id_product.'" and id_product_attribute="'.(int)$id_product_attribute.'" 
                    and id_warehouse = "'.(int)$id_warehouse.'" 
                order by saa.id_stock_available_advanced DESC';
            $row = Db::getInstance()->getRow($sqlSelect);
            $reserved_quantity = 0;
            $physical_quantity = 0;
            
            if($old_os) {
                if(in_array($new_os->id, $error_or_canceled_statuses) &&
                        !in_array($old_os->id, $error_or_canceled_statuses)) {
                    $comments = "Cambios de Pedidos";
                    $sign = 1;
                    $id_stock_mvt_reason = "Cancelado o Error";
                    if($old_os->shipped == 1) {
                        if($esVirtual) {
                            $almacenStockVirtual = new AlmacenStockVirtual($id_warehouse);
                            $almacenStockVirtual->deshacerUltimoMovimientoPedido($order->id, $id_product, $id_product_attribute);
                        }
                        else {
                            if($row) {
                                $reserved_quantity = $row['reserved_quantity'];
                                $physical_quantity = $row['physical_quantity'] + $product_quantity;
                            }
                            else {
                                $comments .= ' (sin datos)';
                            }
                            $mvt_reserved = 0;
                            $mvt_physical = $product_quantity;
                            $stock_quantity = $physical_quantity - $reserved_quantity;
                            $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                                    $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                                    $id_stock_mvt_reason, $comments, $id_warehouse);
                        }
                    }
                    else {
                        if($row) {
                            $reserved_quantity = $row['reserved_quantity'] - $product_quantity;
                            $physical_quantity = $row['physical_quantity'];
                        }
                        else {
                            $comments .= ' (sin datos)';
                        }
                        $mvt_reserved = -$product_quantity;
                        $mvt_physical = 0;
                        $stock_quantity = $physical_quantity - $reserved_quantity;
                        $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                                $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                                $id_stock_mvt_reason, $comments, $id_warehouse);
                    }
                }
                elseif($new_os->shipped == 0 && $old_os->shipped == 0) {
                    $comments = "Cambios de Pedidos";
                    if($row) {
                        $reserved_quantity = $row['reserved_quantity'];
                        $physical_quantity = $row['physical_quantity'];
                    }
                    else {
                        $comments .= ' (sin datos)';
                    }
                    $id_stock_mvt_reason = "Cambio Estado Pedido";
                    $sign = 1;
                    $mvt_physical = 0;
                    $mvt_reserved = 0;
                    $stock_quantity = $physical_quantity - $reserved_quantity;
                    $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                            $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                            $id_stock_mvt_reason, $comments, $id_warehouse);
                }
                elseif($new_os->shipped == 1 && $old_os->shipped == 0) {
                    $comments = "Pedido Enviado";
                    $id_stock_mvt_reason = "Cambio Estado Pedido";
                    if($esVirtual) {
                        if($row) {
                            $reserved_quantity = $row['reserved_quantity'];
                            $physical_quantity = $row['physical_quantity'];
                        }
                        else {
                            $comments .= ' (sin datos)';
                        }
                        $mvt_physical = 0;
                        $mvt_reserved = 0;
                        $sign = 1;
                    }
                    else {
                        if($row) {
                            $reserved_quantity = $row['reserved_quantity'] - $product_quantity;
                            $physical_quantity = $row['physical_quantity'] - $product_quantity;
                        }
                        else {
                            $comments .= ' (sin datos)';
                        }
                        $mvt_physical = -$product_quantity;
                        $mvt_reserved = -$product_quantity;
                        $sign = -1;
                    }
                    $stock_quantity = $physical_quantity - $reserved_quantity;
                    
                    $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                            $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                            $id_stock_mvt_reason, $comments, $id_warehouse);
                }
                elseif($new_os->shipped == 1 && $old_os->shipped == 1) {
                    $comments = "Pedido Sigue Enviado";
                    $mvt_reserved = 0;
                    if($row) {
                        $reserved_quantity = $row['reserved_quantity'];
                        $physical_quantity = $row['physical_quantity'];
                    }
                    else {
                        $comments .= ' (sin datos)';
                    }
                    $id_stock_mvt_reason = "Cambio Estado Pedido";
                    $mvt_physical = 0;
                    $sign = 1;
                    $stock_quantity = $physical_quantity - $reserved_quantity;
                    $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                            $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                            $id_stock_mvt_reason, $comments, $id_warehouse);
                }
            }
            else {
                if($new_os->shipped == 0) {
                    $comments = "Cambios de Pedidos";
                    if($row) {
                        $reserved_quantity = $product_quantity + $row['reserved_quantity'];
                        $physical_quantity = $row['physical_quantity'];
                    }
                    else {
                        $comments .= ' (sin datos)';
                    }
                    $id_stock_mvt_reason = "Cambio Estado Pedido";
                    $sign = -1;
                    $mvt_physical = 0;
                    $mvt_reserved = $product_quantity;
                    $stock_quantity = $physical_quantity - $reserved_quantity;
                    $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                            $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                            $id_stock_mvt_reason, $comments, $id_warehouse);
                }
                else {
                    $comments = "Pedido Enviado";
                    $id_stock_mvt_reason = "Cambio Estado Pedido";
                    if($esVirtual) {
                        if($row) {
                            $reserved_quantity = $row['reserved_quantity'];
                            $physical_quantity = $row['physical_quantity'];
                        }
                        else {
                            $comments .= ' (sin datos)';
                        }
                        $mvt_physical = 0;
                        $mvt_reserved = 0;
                        $sign = 1;
                    }
                    else {
                        if($row) {
                            $reserved_quantity = $row['reserved_quantity'];
                            $physical_quantity = $row['physical_quantity'] - $product_quantity;
                        }
                        else {
                            $comments .= ' (sin datos)';
                        }
                        $mvt_physical = -$product_quantity;
                        $mvt_reserved = 0;
                        $sign = -1;
                    }
                    $stock_quantity = $physical_quantity - $reserved_quantity;
                    
                    $this->insertarStock($product_name, $reference, $id_product, $id_product_attribute, $order->id, $new_os->id, 
                            $stock_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, 
                            $id_stock_mvt_reason, $comments, $id_warehouse);
                }
            }
        }
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private function insertarStock($product_name, $reference, $id_product, $id_product_attribute, $id_order, $id_order_status, $stock_quantity, 
            $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, $id_stock_mvt_reason, $comments, $id_warehouse) {
        $id_employee = (Validate::isLoadedObject(Context::getContext()->employee) ? Context::getContext()->employee->id : 0);
        $date_add = date('Y-m-d H:i:s');
        $sql = 'INSERT INTO '._DB_PREFIX_.'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
                        VALUES ("'.pSQL($product_name).'","'.pSQL($reference).'","'.(int)$id_product.'","'.(int)$id_product_attribute.'","'.(int)$id_order.'","'.(int)$id_order_status.'","'.(int)$stock_quantity.'","'.(int)$physical_quantity.'","'.(int)$reserved_quantity.'","'.(int)$mvt_physical.'","'.(int)$mvt_reserved.'","'.(int)$sign.'","'.(int)$id_employee.'","'.pSQL($id_stock_mvt_reason).'","'.pSQL($comments).'","'.pSQL($date_add).'")';
        Db::getInstance()->execute($sql);
        
        $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
        $id_warehouse = (int)$id_warehouse;
        Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
            (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $id_warehouse)");
    }
}