<?php
use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;
class ProductPresenterFactory extends ProductPresenterFactoryCore 
{
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private $context;
    /**
     * ProductPresenterFactory constructor.
     *
     * @param Context $context
     * @param \TaxConfiguration|null $taxConfiguration
     */
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function __construct(Context $context, TaxConfiguration $taxConfiguration = null)
    {
        parent::__construct($context, $taxConfiguration);
        $this->context = $context;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function getPresenter()
    {
        require_once _PS_MODULE_DIR_.'imaxmultialmacen/classes/ImaxProductPresenter.php';
        require_once _PS_MODULE_DIR_.'imaxmultialmacen/classes/ImaxProductListingPresenter.php';
        
        $imageRetriever = new ImageRetriever(
            $this->context->link
        );
        if (is_a($this->context->controller, 'ProductListingFrontControllerCore')) {
            return new ImaxProductListingPresenter(
                $imageRetriever,
                $this->context->link,
                new PriceFormatter(),
                new ProductColorsRetriever(),
                $this->context->getTranslator()
            );
        }
        return new ImaxProductPresenter(
            $imageRetriever,
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
    }
}
