<?php
use PrestaShop\PrestaShop\Core\Product\Search\ProductSearchContext;
class ProductAssembler extends ProductAssemblerCore 
{
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private $context;
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private $searchContext;
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function __construct(Context $context)
    {
        parent::__construct($context);
        
        $this->context = $context;
        $this->searchContext = new ProductSearchContext($context);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function assembleProduct(array $rawProduct)
    {
        $enrichedProduct = $this->addMissingProductFields($rawProduct);
        return Product::getProductProperties(
            $this->searchContext->getIdLang(),
            $enrichedProduct,
            $this->context
        );
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private function addMissingProductFields(array $rawProduct)
    {
        $idShop = (int) $this->searchContext->getIdShop();
        $idLang = (int) $this->searchContext->getIdLang();
        $idProduct = (int) $rawProduct['id_product'];
        $prefix = _DB_PREFIX_;
        $nbDaysNewProduct = (int) Configuration::get('PS_NB_DAYS_NEW_PRODUCT');
        if (!Validate::isUnsignedInt($nbDaysNewProduct)) {
            $nbDaysNewProduct = 20;
        }
        $now = date('Y-m-d') . ' 00:00:00';
        if(Validate::isLoadedObject($this->context->warehouse)) {
            $id_warehouse = (int)$this->context->warehouse->id;
            $almacenesOrdenados = false;
        }
        else {
            $almacenesOrdenados = true;
        }
        $sql = "SELECT
                    p.*,
                    pl.*,
                    sa.out_of_stock,
                    IFNULL(".($almacenesOrdenados ? 'SUM(sw.usable_quantity)' : 'sw.usable_quantity').", 0) as quantity,
                    (DATEDIFF(
				p.`date_add`,
				DATE_SUB(
					'$now',
					INTERVAL $nbDaysNewProduct DAY
				)
			) > 0) as new
                FROM {$prefix}product p
                LEFT JOIN {$prefix}product_lang pl
                    ON pl.id_product = p.id_product
                    AND pl.id_shop = $idShop
                    AND pl.id_lang = $idLang
                LEFT JOIN {$prefix}stock_available sa
			        ON sa.id_product = p.id_product 
			        AND sa.id_shop = $idShop
                LEFT JOIN `{$prefix}stock` sw
                    ON sw.id_product = p.id_product".($almacenesOrdenados ? '' : " AND sw.id_warehouse = $id_warehouse")."
			    WHERE p.id_product = $idProduct";
        if($almacenesOrdenados) {
            $sql .= ' GROUP BY sw.`id_product`';
        }
        $rows = Db::getInstance()->executeS($sql);
        if ($rows === false) {
            return $rawProduct;
        }
        return array_merge($rows[0], $rawProduct);
    }
}
