<?php
class Product extends ProductCore 
{
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function isColorUnavailable($id_attribute, $id_shop) {
        $warehouse = Context::getContext()->warehouse;
        if(Validate::isLoadedObject($warehouse)) {
            return Db::getInstance()->getValue(
                '
                SELECT s.id_product_attribute
                FROM ' . _DB_PREFIX_ . 'stock s
                WHERE id_product=' . (int) $this->id . " AND usable_quantity <= 0 AND id_warehouse = $warehouse->id
                AND EXISTS (
                    SELECT 1
                    FROM " . _DB_PREFIX_ . 'product_attribute pa
                    JOIN ' . _DB_PREFIX_ . 'product_attribute_combination pac
                        ON (pac.id_product_attribute AND pa.id_product_attribute)
                    WHERE s.id_product_attribute = pa.id_product_attribute AND pa.id_product=' . (int) $this->id . ' AND pac.id_attribute=' . (int) $id_attribute . '
                )'
            );
        }
        else {
            return Db::getInstance()->getValue('   
                SELECT s.id_product_attribute
                FROM ' . _DB_PREFIX_ . 'stock s
                WHERE id_product=1
                AND EXISTS (
                    SELECT 1
                    FROM ' . _DB_PREFIX_ . 'product_attribute pa
                    JOIN ' . _DB_PREFIX_ . 'product_attribute_combination pac
                        ON (pac.id_product_attribute AND pa.id_product_attribute)
                    WHERE s.id_product_attribute = pa.id_product_attribute AND pa.id_product=1 AND pac.id_attribute=1)
                GROUP BY id_product_attribute
                HAVING SUM(usable_quantity) <= 0');
        }
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getDefaultAttribute($id_product, $minimum_quantity = 0, $reset = false)
    {
        static $combinations = array();
        if (!Combination::isFeatureActive()) {
            return 0;
        }
        if ($reset && isset($combinations[$id_product])) {
            unset($combinations[$id_product]);
        }
        if (!isset($combinations[$id_product])) {
            $combinations[$id_product] = array();
        }
        if (isset($combinations[$id_product][$minimum_quantity])) {
            return $combinations[$id_product][$minimum_quantity];
        }
        $sql = 'SELECT product_attribute_shop.id_product_attribute
                FROM ' . _DB_PREFIX_ . 'product_attribute pa
                ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                WHERE pa.id_product = ' . (int) $id_product;
        $result_no_filter = Db::getInstance()->getValue($sql);
        if (!$result_no_filter) {
            $combinations[$id_product][$minimum_quantity] = 0;
            return 0;
        }
        
        $context = Context::getContext();
        if(Validate::isLoadedObject($context->warehouse) || $minimum_quantity <= 0) {
            $result = self::getDefaultAttributeAlmacen($id_product, $minimum_quantity, $context);
        }
        else {
            $result = self::getDefaultAttributeOrdenados($id_product, $minimum_quantity);
        }
        if (!$result) {
            $sql = 'SELECT product_attribute_shop.id_product_attribute
                    FROM ' . _DB_PREFIX_ . 'product_attribute pa
                    ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                    ' . ($minimum_quantity > 0 ? Product::sqlStock('pa', 'pa') : '') .
                    ' WHERE pa.id_product = ' . (int) $id_product
                    . ($minimum_quantity > 0 ? ' AND IFNULL(stock.quantity, 0) >= ' . (int) $minimum_quantity : '');
            $result = Db::getInstance()->getValue($sql);
        }
        if (!$result) {
            $sql = 'SELECT product_attribute_shop.id_product_attribute
                    FROM ' . _DB_PREFIX_ . 'product_attribute pa
                    ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                    WHERE product_attribute_shop.`default_on` = 1
                    AND pa.id_product = ' . (int) $id_product;
            $result = Db::getInstance()->getValue($sql);
        }
        if (!$result) {
            $result = $result_no_filter;
        }
        $combinations[$id_product][$minimum_quantity] = $result;
        return $result;
    }
    
    /**
     * Devuelve el resultado de la consulta para un solo almacen.
     * @param int $id_product
     * @param int $minimum_quantity
     * @param Context $context
     * @return int
     */
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private static function getDefaultAttributeAlmacen($id_product, $minimum_quantity, $context) {
        $sql = 'SELECT product_attribute_shop.id_product_attribute
                FROM ' . _DB_PREFIX_ . 'product_attribute pa
                ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                ' . ($minimum_quantity > 0 ? 
                        'LEFT JOIN `' . _DB_PREFIX_ . 'stock` sw
                            ON sw.id_product = pa.id_product AND sw.id_product_attribute = pa.id_product_attribute AND sw.id_warehouse = '.(int)$context->warehouse->id.'' : '') .
                ' WHERE product_attribute_shop.default_on = 1 '
                . ($minimum_quantity > 0 ? ' AND IFNULL(sw.usable_quantity, 0) >= ' . (int) $minimum_quantity : '') .
                ' AND pa.id_product = ' . (int) $id_product;
        return Db::getInstance()->getValue($sql);
    }
    
    /**
     * Devuelve el resultado de la consulta para almacenes ordenados.
     * @param int $id_product
     * @param int $minimum_quantity
     * @return int
     */
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private static function getDefaultAttributeOrdenados($id_product, $minimum_quantity) {
        $sql = 'SELECT product_attribute_shop.id_product_attribute
                FROM ' . _DB_PREFIX_ . 'product_attribute pa
                ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                    LEFT JOIN `' . _DB_PREFIX_ . 'stock` sw
                        ON sw.id_product = pa.id_product AND sw.id_product_attribute = pa.id_product_attribute'.
                ' WHERE product_attribute_shop.default_on = 1
                AND pa.id_product = ' . (int) $id_product. '
                GROUP BY id_product_attribute
                HAVING SUM(sw.usable_quantity) >= '. (int) $minimum_quantity;
        return Db::getInstance()->getValue($sql);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getNewProducts($id_lang, $page_number = 0, $nb_products = 10, $count = false, $order_by = null, $order_way = null, Context $context = null)
    {
        $now = date('Y-m-d') . ' 00:00:00';
        if (!$context) {
            $context = Context::getContext();
        }
        $front = true;
        if (!in_array($context->controller->controller_type, array('front', 'modulefront'))) {
            $front = false;
        }
        if ($page_number < 1) {
            $page_number = 1;
        }
        if ($nb_products < 1) {
            $nb_products = 10;
        }
        if (empty($order_by) || $order_by == 'position') {
            $order_by = 'date_add';
        }
        if (empty($order_way)) {
            $order_way = 'DESC';
        }
        if ($order_by == 'id_product' || $order_by == 'price' || $order_by == 'date_add' || $order_by == 'date_upd') {
            $order_by_prefix = 'product_shop';
        } elseif ($order_by == 'name') {
            $order_by_prefix = 'pl';
        }
        if (!Validate::isOrderBy($order_by) || !Validate::isOrderWay($order_way)) {
            die(Tools::displayError());
        }
        $sql_groups = '';
        if (Group::isFeatureActive()) {
            $groups = FrontController::getCurrentCustomerGroups();
            $sql_groups = ' AND EXISTS(SELECT 1 FROM `' . _DB_PREFIX_ . 'category_product` cp
                JOIN `' . _DB_PREFIX_ . 'category_group` cg ON (cp.id_category = cg.id_category AND cg.`id_group` ' . (count($groups) ? 'IN (' . implode(',', $groups) . ')' : '= ' . (int) Configuration::get('PS_UNIDENTIFIED_GROUP')) . ')
                WHERE cp.`id_product` = p.`id_product`)';
        }
        if (strpos($order_by, '.') > 0) {
            $order_by = explode('.', $order_by);
            $order_by_prefix = $order_by[0];
            $order_by = $order_by[1];
        }
        $nb_days_new_product = (int) Configuration::get('PS_NB_DAYS_NEW_PRODUCT');
        if ($count) {
            $sql = 'SELECT COUNT(p.`id_product`) AS nb
                    FROM `' . _DB_PREFIX_ . 'product` p
                    ' . Shop::addSqlAssociation('product', 'p') . '
                    WHERE product_shop.`active` = 1
                    AND product_shop.`date_add` > "' . date('Y-m-d', strtotime('-' . $nb_days_new_product . ' DAY')) . '"
                    ' . ($front ? ' AND product_shop.`visibility` IN ("both", "catalog")' : '') . '
                    ' . $sql_groups;
            return (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($sql);
        }
        
        $result = self::getNewProductsAlmacen($id_lang, $page_number, $nb_products, $order_by, $order_way, $context, $now, 
                $nb_days_new_product, $order_by_prefix, $front, !Validate::isLoadedObject($context->warehouse));
        if (!$result) {
            return false;
        }
        if ($order_by == 'price') {
            Tools::orderbyPrice($result, $order_way);
        }
        $products_ids = array();
        foreach ($result as $row) {
            $products_ids[] = $row['id_product'];
        }
        Product::cacheFrontFeatures($products_ids, $id_lang);
        return Product::getProductsProperties((int) $id_lang, $result);
    }
    
    /**
     * Devuelve el resultado de la consulta.
     * @param int $id_lang
     * @param int $page_number
     * @param int $nb_products
     * @param string $order_by
     * @param string $order_way
     * @param Context $context
     * @param int $now
     * @param int $nb_days_new_product
     * @param string $order_by_prefix
     * @param boolean $front
     * @param boolean $almacenesOrdenados
     * @return array
     */
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private static function getNewProductsAlmacen($id_lang, $page_number, $nb_products, $order_by, $order_way, Context $context, $now, 
            $nb_days_new_product, $order_by_prefix, $front, $almacenesOrdenados) {
        $sql = new DbQuery();
        $sql->select(
            'p.*, product_shop.*, stock.out_of_stock, IFNULL('.($almacenesOrdenados ? 'SUM(sw.usable_quantity)' : 'sw.usable_quantity').', 0) as quantity, pl.`description`, pl.`description_short`, pl.`link_rewrite`, pl.`meta_description`,
            pl.`meta_keywords`, pl.`meta_title`, pl.`name`, pl.`available_now`, pl.`available_later`, image_shop.`id_image` id_image, il.`legend`, m.`name` AS manufacturer_name,
            (DATEDIFF(product_shop.`date_add`,
                DATE_SUB(
                    "' . $now . '",
                    INTERVAL ' . $nb_days_new_product . ' DAY
                )
            ) > 0) as new'
        );
        $sql->from('product', 'p');
        $sql->join(Shop::addSqlAssociation('product', 'p'));
        $sql->leftJoin(
            'product_lang',
            'pl',
            '
            p.`id_product` = pl.`id_product`
            AND pl.`id_lang` = ' . (int) $id_lang . Shop::addSqlRestrictionOnLang('pl')
        );
        $sql->leftJoin('image_shop', 'image_shop', 'image_shop.`id_product` = p.`id_product` AND image_shop.cover=1 AND image_shop.id_shop=' . (int) $context->shop->id);
        $sql->leftJoin('image_lang', 'il', 'image_shop.`id_image` = il.`id_image` AND il.`id_lang` = ' . (int) $id_lang);
        $sql->leftJoin('manufacturer', 'm', 'm.`id_manufacturer` = p.`id_manufacturer`');
        if($almacenesOrdenados) {
            $sql->leftJoin('stock', 'sw', 'sw.`id_product` = p.`id_product` AND sw.`id_product_attribute` = 0');
        }
        else {
            $sql->leftJoin('stock', 'sw', 'sw.`id_product` = p.`id_product` AND sw.`id_product_attribute` = 0 AND sw.id_warehouse = ' . (int)$context->warehouse->id);
        }
        $sql->where('product_shop.`active` = 1');
        if ($front) {
            $sql->where('product_shop.`visibility` IN ("both", "catalog")');
        }
        $sql->where('product_shop.`date_add` > "' . date('Y-m-d', strtotime('-' . $nb_days_new_product . ' DAY')) . '"');
        if (Group::isFeatureActive()) {
            $groups = FrontController::getCurrentCustomerGroups();
            $sql->where('EXISTS(SELECT 1 FROM `' . _DB_PREFIX_ . 'category_product` cp
                JOIN `' . _DB_PREFIX_ . 'category_group` cg ON (cp.id_category = cg.id_category AND cg.`id_group` ' . (count($groups) ? 'IN (' . implode(',', $groups) . ')' : '=' . (int) Configuration::get('PS_UNIDENTIFIED_GROUP')) . ')
                WHERE cp.`id_product` = p.`id_product`)');
        }
        
        if($almacenesOrdenados) {
            $sql->groupBy('sw.`id_product`');
        }
        $sql->orderBy((isset($order_by_prefix) ? pSQL($order_by_prefix) . '.' : '') . '`' . pSQL($order_by) . '` ' . pSQL($order_way));
        $sql->limit($nb_products, (int) (($page_number - 1) * $nb_products));
        if (Combination::isFeatureActive()) {
            $sql->select('product_attribute_shop.minimal_quantity AS product_attribute_minimal_quantity, IFNULL(product_attribute_shop.id_product_attribute,0) id_product_attribute');
            $sql->leftJoin('product_attribute_shop', 'product_attribute_shop', 'p.`id_product` = product_attribute_shop.`id_product` AND product_attribute_shop.`default_on` = 1 AND product_attribute_shop.id_shop=' . (int) $context->shop->id);
        }
        $sql->join(Product::sqlStock('p', 0));
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getPricesDrop(
        $id_lang,
        $page_number = 0,
        $nb_products = 10,
        $count = false,
        $order_by = null,
        $order_way = null,
        $beginning = false,
        $ending = false,
        Context $context = null
    ) {
        if (!Validate::isBool($count)) {
            die(Tools::displayError());
        }
        if (!$context) {
            $context = Context::getContext();
        }
        if ($page_number < 1) {
            $page_number = 1;
        }
        if ($nb_products < 1) {
            $nb_products = 10;
        }
        if (empty($order_by) || $order_by == 'position') {
            $order_by = 'price';
        }
        if (empty($order_way)) {
            $order_way = 'DESC';
        }
        if ($order_by == 'id_product' || $order_by == 'price' || $order_by == 'date_add' || $order_by == 'date_upd') {
            $order_by_prefix = 'product_shop';
        } elseif ($order_by == 'name') {
            $order_by_prefix = 'pl';
        }
        if (!Validate::isOrderBy($order_by) || !Validate::isOrderWay($order_way)) {
            die(Tools::displayError());
        }
        $current_date = date('Y-m-d H:i:00');
        $ids_product = Product::_getProductIdByDate((!$beginning ? $current_date : $beginning), (!$ending ? $current_date : $ending), $context);
        $tab_id_product = array();
        foreach ($ids_product as $product) {
            if (is_array($product)) {
                $tab_id_product[] = (int) $product['id_product'];
            } else {
                $tab_id_product[] = (int) $product;
            }
        }
        $front = true;
        if (!in_array($context->controller->controller_type, array('front', 'modulefront'))) {
            $front = false;
        }
        $sql_groups = '';
        if (Group::isFeatureActive()) {
            $groups = FrontController::getCurrentCustomerGroups();
            $sql_groups = ' AND EXISTS(SELECT 1 FROM `' . _DB_PREFIX_ . 'category_product` cp
                JOIN `' . _DB_PREFIX_ . 'category_group` cg ON (cp.id_category = cg.id_category AND cg.`id_group` ' . (count($groups) ? 'IN (' . implode(',', $groups) . ')' : '=' . (int) Configuration::get('PS_UNIDENTIFIED_GROUP')) . ')
                WHERE cp.`id_product` = p.`id_product`)';
        }
        if ($count) {
            return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
            SELECT COUNT(DISTINCT p.`id_product`)
            FROM `' . _DB_PREFIX_ . 'product` p
            ' . Shop::addSqlAssociation('product', 'p') . '
            WHERE product_shop.`active` = 1
            AND product_shop.`show_price` = 1
            ' . ($front ? ' AND product_shop.`visibility` IN ("both", "catalog")' : '') . '
            ' . ((!$beginning && !$ending) ? 'AND p.`id_product` IN(' . ((is_array($tab_id_product) && count($tab_id_product)) ? implode(', ', $tab_id_product) : 0) . ')' : '') . '
            ' . $sql_groups);
        }
        if (strpos($order_by, '.') > 0) {
            $order_by = explode('.', $order_by);
            $order_by = pSQL($order_by[0]) . '.`' . pSQL($order_by[1]) . '`';
        }
        $result = self::getPricesDropAlmacen($id_lang, $page_number, $nb_products, $order_by, $order_way, $beginning, $ending,
                $context, $front, $tab_id_product, $sql_groups, $order_by_prefix, !Validate::isLoadedObject($context->warehouse));
        
        if (!$result) {
            return false;
        }
        if ($order_by == 'price') {
            Tools::orderbyPrice($result, $order_way);
        }
        return Product::getProductsProperties($id_lang, $result);
    }
    
    /**
     * Devuelve el resultado de la consulta.
     * @param int $id_lang
     * @param int $page_number
     * @param int $nb_products
     * @param string $order_by
     * @param string $order_way
     * @param boolean $beginning
     * @param boolean $ending
     * @param Context $context
     * @param boolean $front
     * @param array $tab_id_product
     * @param string $sql_groups
     * @param string $order_by_prefix
     * @param boolean $almacenesOrdenados
     * @return array
     */
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    private static function getPricesDropAlmacen($id_lang, $page_number, $nb_products, $order_by, $order_way, $beginning, $ending,
            Context $context, $front, $tab_id_product, $sql_groups, $order_by_prefix, $almacenesOrdenados) {
        $sql = '
        SELECT
            p.*, product_shop.*, stock.out_of_stock, IFNULL('.($almacenesOrdenados ? 'SUM(sw.usable_quantity)' : 'sw.usable_quantity').', 0) as quantity, pl.`description`, pl.`description_short`, pl.`available_now`, pl.`available_later`,
            IFNULL(product_attribute_shop.id_product_attribute, 0) id_product_attribute,
            pl.`link_rewrite`, pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`,
            pl.`name`, image_shop.`id_image` id_image, il.`legend`, m.`name` AS manufacturer_name,
            DATEDIFF(
                p.`date_add`,
                DATE_SUB(
                    "' . date('Y-m-d') . ' 00:00:00",
                    INTERVAL ' . (Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20) . ' DAY
                )
            ) > 0 AS new
        FROM `' . _DB_PREFIX_ . 'product` p
        ' . Shop::addSqlAssociation('product', 'p') . '
        LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_shop` product_attribute_shop
            ON (p.`id_product` = product_attribute_shop.`id_product` AND product_attribute_shop.`default_on` = 1 AND product_attribute_shop.id_shop=' . (int) $context->shop->id . ')
        ' . Product::sqlStock('p', 0, false, $context->shop) . '
        ' . Product::sqlStockWarehouse($context, 'p', 0, false) . '
        LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (
            p.`id_product` = pl.`id_product`
            AND pl.`id_lang` = ' . (int) $id_lang . Shop::addSqlRestrictionOnLang('pl') . '
        )
        LEFT JOIN `' . _DB_PREFIX_ . 'image_shop` image_shop
            ON (image_shop.`id_product` = p.`id_product` AND image_shop.cover=1 AND image_shop.id_shop=' . (int) $context->shop->id . ')
        LEFT JOIN `' . _DB_PREFIX_ . 'image_lang` il ON (image_shop.`id_image` = il.`id_image` AND il.`id_lang` = ' . (int) $id_lang . ')
        LEFT JOIN `' . _DB_PREFIX_ . 'manufacturer` m ON (m.`id_manufacturer` = p.`id_manufacturer`)
        WHERE product_shop.`active` = 1
        AND product_shop.`show_price` = 1
        ' . ($front ? ' AND product_shop.`visibility` IN ("both", "catalog")' : '') . '
        ' . ((!$beginning && !$ending) ? ' AND p.`id_product` IN (' . ((is_array($tab_id_product) && count($tab_id_product)) ? implode(', ', $tab_id_product) : 0) . ')' : '') . '
        ' . $sql_groups .
        ($almacenesOrdenados ? ' GROUP BY sw.`id_product_attribute`, sw.`id_product`' : '').'
        ORDER BY ' . (isset($order_by_prefix) ? pSQL($order_by_prefix) . '.' : '') . pSQL($order_by) . ' ' . pSQL($order_way) . '
        LIMIT ' . (int) (($page_number - 1) * $nb_products) . ', ' . (int) $nb_products;
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function getAttributesColorList(array $products, $have_stock = true) 
    {
        if (!count($products)) {
            return array();
        }
        
        $context = Context::getContext();
        $id_lang = Context::getContext()->language->id;
        $check_stock = !Configuration::get('PS_DISP_UNAVAILABLE_ATTR');
        if(Validate::isLoadedObject($context->warehouse)) {
            $join = 'LEFT JOIN `' . _DB_PREFIX_ . 'stock` sw 
                ON sw.id_product = pa.id_product AND sw.id_product_attribute = pa.id_product_attribute AND sw.id_warehouse = '.(int)$context->warehouse->id;
        }
        else {
            $join = 'LEFT JOIN `' . _DB_PREFIX_ . 'stock` sw 
                ON sw.id_product = pa.id_product AND sw.id_product_attribute = pa.id_product_attribute';
        }
        
        $sql = '
            SELECT pa.`id_product`, a.`color`, pac.`id_product_attribute`, ' . ($check_stock ? 'SUM(IF(sw.`usable_quantity` > 0, 1, 0))' : '0') . ' qty, a.`id_attribute`, al.`name`, IF(color = "", a.id_attribute, color) group_by
            FROM `' . _DB_PREFIX_ . 'product_attribute` pa
            ' . Shop::addSqlAssociation('product_attribute', 'pa') .
            ($check_stock ? $join : '') . '
            JOIN `' . _DB_PREFIX_ . 'product_attribute_combination` pac ON (pac.`id_product_attribute` = product_attribute_shop.`id_product_attribute`)
            JOIN `' . _DB_PREFIX_ . 'attribute` a ON (a.`id_attribute` = pac.`id_attribute`)
            JOIN `' . _DB_PREFIX_ . 'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute` AND al.`id_lang` = ' . (int) $id_lang . ')
            JOIN `' . _DB_PREFIX_ . 'attribute_group` ag ON (a.id_attribute_group = ag.`id_attribute_group`)
            WHERE pa.`id_product` IN (' . implode(',', array_map('intval', $products)) . ') AND ag.`is_color_group` = 1
            GROUP BY pa.`id_product`, a.`id_attribute`, `group_by`
            ' . ($check_stock ? 'HAVING qty > 0' : '') . '
            ORDER BY a.`position` ASC;';
        if (!$res = Db::getInstance()->executeS($sql)) {
            return false;
        }
        $colors = array();
        foreach ($res as $row) {
            $row['texture'] = '';
            if (Tools::isEmpty($row['color']) && !@filemtime(_PS_COL_IMG_DIR_ . $row['id_attribute'] . '.jpg')) {
                continue;
            } elseif (Tools::isEmpty($row['color']) && @filemtime(_PS_COL_IMG_DIR_ . $row['id_attribute'] . '.jpg')) {
                $row['texture'] = _THEME_COL_DIR_ . $row['id_attribute'] . '.jpg';
            }
            $colors[(int) $row['id_product']][] = array('id_product_attribute' => (int) $row['id_product_attribute'], 'color' => $row['color'], 'texture' => $row['texture'], 'id_product' => $row['id_product'], 'name' => $row['name'], 'id_attribute' => $row['id_attribute']);
        }
        return $colors;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function getAttributesGroups($id_lang, $id_product_attribute = null)
    {
        if (!Combination::isFeatureActive()) {
            return array();
        }
        
        $context = Context::getContext();
        $almacenesOrdenados = !Validate::isLoadedObject($context->warehouse);
        if(Db::getInstance()->getValue('SELECT 1 FROM information_schema.tables 
                WHERE table_schema = "'._DB_NAME_.'" AND table_name = "'._DB_PREFIX_.'product_attribute_lang"')) {
            $palCampos = ', pal.`available_now`, pal.`available_later`';
            $palTabla = 'LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_lang` pal
                    ON (
                        pa.`id_product_attribute` = pal.`id_product_attribute` AND
                        pal.`id_lang` = ' . (int) $context->language->id . ')';
        }
        else {
            $palCampos = '';
            $palTabla = '';
        }
        
        $sql = 'SELECT ag.`id_attribute_group`, ag.`is_color_group`, agl.`name` AS group_name, agl.`public_name` AS public_group_name,
                    a.`id_attribute`, al.`name` AS attribute_name, a.`color` AS attribute_color, product_attribute_shop.`id_product_attribute`,
                    IFNULL('.($almacenesOrdenados ? 'SUM(sw.usable_quantity)' : 'sw.usable_quantity').', 0) as quantity, product_attribute_shop.`price`, product_attribute_shop.`ecotax`, product_attribute_shop.`weight`,
                    product_attribute_shop.`default_on`, pa.`reference`, pa.`ean13`, "" AS mpn, pa.`upc`, pa.`isbn`, product_attribute_shop.`unit_price_impact`,
                    product_attribute_shop.`minimal_quantity`, product_attribute_shop.`available_date`, ag.`group_type`'.$palCampos.'
                FROM `' . _DB_PREFIX_ . 'product_attribute` pa
                ' . Shop::addSqlAssociation('product_attribute', 'pa') . '
                LEFT JOIN `' . _DB_PREFIX_ . 'stock` sw
                     ON sw.id_product = pa.id_product AND sw.id_product_attribute = pa.id_product_attribute'.($almacenesOrdenados ? '' : ' AND sw.id_warehouse = '.(int)$context->warehouse->id).'
                '.$palTabla.'
                LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_combination` pac ON (pac.`id_product_attribute` = pa.`id_product_attribute`)
                LEFT JOIN `' . _DB_PREFIX_ . 'attribute` a ON (a.`id_attribute` = pac.`id_attribute`)
                LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group` ag ON (ag.`id_attribute_group` = a.`id_attribute_group`)
                LEFT JOIN `' . _DB_PREFIX_ . 'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute`)
                LEFT JOIN `' . _DB_PREFIX_ . 'attribute_group_lang` agl ON (ag.`id_attribute_group` = agl.`id_attribute_group`)
                ' . Shop::addSqlAssociation('attribute', 'a') . '
                WHERE pa.`id_product` = ' . (int) $this->id . '
                    AND al.`id_lang` = ' . (int) $id_lang . '
                    AND agl.`id_lang` = ' . (int) $id_lang;
        
        if ($id_product_attribute !== null) {
            $sql .= ' AND product_attribute_shop.`id_product_attribute` = ' . (int) $id_product_attribute . ' ';
        }
        
        $sql .= ' GROUP BY id_attribute_group, id_product_attribute
                ORDER BY ag.`position` ASC, a.`position` ASC, agl.`name` ASC';
        return Db::getInstance()->executeS($sql);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function getAccessories($id_lang, $active = true)
    {
        $context = Context::getContext();
        $almacenesOrdenados = !Validate::isLoadedObject($context->warehouse);
        
        $sql = 'SELECT p.*, product_shop.*, stock.out_of_stock, IFNULL('.($almacenesOrdenados ? 'SUM(sw.usable_quantity)' : 'sw.usable_quantity').', 0) as quantity, pl.`description`, pl.`description_short`, pl.`link_rewrite`,
                    pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`, pl.`available_now`, pl.`available_later`,
                    image_shop.`id_image` id_image, il.`legend`, m.`name` as manufacturer_name, cl.`name` AS category_default, IFNULL(product_attribute_shop.id_product_attribute, 0) id_product_attribute,
                    DATEDIFF(
                        p.`date_add`,
                        DATE_SUB(
                            "' . date('Y-m-d') . ' 00:00:00",
                            INTERVAL ' . (Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20) . ' DAY
                        )
                    ) > 0 AS new
                FROM `' . _DB_PREFIX_ . 'accessory`
                LEFT JOIN `' . _DB_PREFIX_ . 'product` p ON p.`id_product` = `id_product_2`
                ' . Shop::addSqlAssociation('product', 'p') . '
                LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute_shop` product_attribute_shop
                    ON (p.`id_product` = product_attribute_shop.`id_product` AND product_attribute_shop.`default_on` = 1 AND product_attribute_shop.id_shop=' . (int) $this->id_shop . ')
                LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (
                    p.`id_product` = pl.`id_product`
                    AND pl.`id_lang` = ' . (int) $id_lang . Shop::addSqlRestrictionOnLang('pl') . '
                )
                LEFT JOIN `' . _DB_PREFIX_ . 'category_lang` cl ON (
                    product_shop.`id_category_default` = cl.`id_category`
                    AND cl.`id_lang` = ' . (int) $id_lang . Shop::addSqlRestrictionOnLang('cl') . '
                )
                LEFT JOIN `' . _DB_PREFIX_ . 'image_shop` image_shop
                    ON (image_shop.`id_product` = p.`id_product` AND image_shop.cover=1 AND image_shop.id_shop=' . (int) $this->id_shop . ')
                LEFT JOIN `' . _DB_PREFIX_ . 'image_lang` il ON (image_shop.`id_image` = il.`id_image` AND il.`id_lang` = ' . (int) $id_lang . ')
                LEFT JOIN `' . _DB_PREFIX_ . 'manufacturer` m ON (p.`id_manufacturer`= m.`id_manufacturer`)
                ' . Product::sqlStock('p', 0) . '
                ' . Product::sqlStockWarehouse($context, 'p', 0) . '
                WHERE `id_product_1` = ' . (int) $this->id .
                ($active ? ' AND product_shop.`active` = 1 AND product_shop.`visibility` != \'none\'' : '') . '
                GROUP BY product_shop.id_product';
        if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql)) {
            return array();
        }
        foreach ($result as $k => &$row) {
            if (!Product::checkAccessStatic((int) $row['id_product'], false)) {
                unset($result[$k]);
                continue;
            } else {
                $row['id_product_attribute'] = Product::getDefaultAttribute((int) $row['id_product']);
            }
        }
        return $this->getProductsProperties($id_lang, $result);
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function searchByName($id_lang, $query, Context $context = null, $limit = NULL)
    {
        if (!$context) {
            $context = Context::getContext();
        }
        $sql = new DbQuery();
        $sql->select('p.`id_product`, pl.`name`, p.`ean13`, p.`isbn`, "" as mpn, p.`upc`, p.`active`, p.`reference`, m.`name` AS manufacturer_name, '.($almacenesOrdenados ? 'SUM(sw.usable_quantity) usable_quantity' : 'sw.usable_quantity').', product_shop.advanced_stock_management, p.`customizable`');
        $sql->from('product', 'p');
        $sql->join(Shop::addSqlAssociation('product', 'p'));
        $sql->leftJoin(
            'product_lang',
            'pl',
            'p.`id_product` = pl.`id_product`
            AND pl.`id_lang` = ' . (int) $id_lang . Shop::addSqlRestrictionOnLang('pl')
        );
        $sql->leftJoin('manufacturer', 'm', 'm.`id_manufacturer` = p.`id_manufacturer`');
        $where = 'pl.`name` LIKE \'%' . pSQL($query) . '%\'
        OR p.`ean13` LIKE \'%' . pSQL($query) . '%\'
        OR p.`isbn` LIKE \'%' . pSQL($query) . '%\'
        OR p.`upc` LIKE \'%' . pSQL($query) . '%\'
        OR p.`reference` LIKE \'%' . pSQL($query) . '%\'
        OR p.`supplier_reference` LIKE \'%' . pSQL($query) . '%\'
        OR EXISTS(SELECT * FROM `' . _DB_PREFIX_ . 'product_supplier` sp WHERE sp.`id_product` = p.`id_product` AND `product_supplier_reference` LIKE \'%' . pSQL($query) . '%\')';
        $sql->orderBy('pl.`name` ASC');
        
        if ($limit) {
            $sql->limit($limit);
        }
        if (Combination::isFeatureActive()) {
            $where .= ' OR EXISTS(SELECT * FROM `' . _DB_PREFIX_ . 'product_attribute` `pa` WHERE pa.`id_product` = p.`id_product` AND (pa.`reference` LIKE \'%' . pSQL($query) . '%\'
            OR pa.`supplier_reference` LIKE \'%' . pSQL($query) . '%\'
            OR pa.`ean13` LIKE \'%' . pSQL($query) . '%\'
            OR pa.`isbn` LIKE \'%' . pSQL($query) . '%\'
            OR pa.`upc` LIKE \'%' . pSQL($query) . '%\'))';
        }
        $sql->where($where);
        $sql->leftJoin('stock', 'sw', 'sw.`id_product` = p.`id_product` AND sw.`id_product_attribute` = 0'.($almacenesOrdenados ? '' : ' AND sw.id_warehouse = '.(int)$context->warehouse->id));
        if($almacenesOrdenados) {
            $sql->groupBy('sw.`id_product`');
        }
        $result = Db::getInstance()->executeS($sql);
        if (!$result) {
            return false;
        }
        $results_array = array();
        foreach ($result as $row) {
            $row['price_tax_incl'] = Product::getPriceStatic($row['id_product'], true, null, 2);
            $row['price_tax_excl'] = Product::getPriceStatic($row['id_product'], false, null, 2);
            $results_array[] = $row;
        }
        return $results_array;
    }
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public function addAttribute(
        $price,
        $weight,
        $unit_impact,
        $ecotax,
        $id_images,
        $reference,
        $ean13,
        $default,
        $location = null,
        $upc = null,
        $minimal_quantity = 1,
        array $id_shop_list = array(),
        $available_date = null,
        $quantity = 0,
        $isbn = '',
        $low_stock_threshold = null,
        $low_stock_alert = false,
        $mpn = null,
        $available_now = [],
        $available_later = []
    ) {
        if (!$this->id) {
            return;
        }
        $price = str_replace(',', '.', $price);
        $weight = str_replace(',', '.', $weight);
        $combination = new CombinationCore();
        $combination->id_product = (int) $this->id;
        $combination->price = (float) $price;
        $combination->ecotax = (float) $ecotax;
        $combination->quantity = (int) $quantity;
        $combination->weight = (float) $weight;
        $combination->unit_price_impact = (float) $unit_impact;
        $combination->reference = pSQL($reference);
        $combination->location = pSQL($location);
        $combination->ean13 = pSQL($ean13);
        $combination->isbn = pSQL($isbn);
        $combination->upc = pSQL($upc);
        $combination->mpn = pSQL($mpn);
        $combination->default_on = (int) $default;
        $combination->minimal_quantity = (int) $minimal_quantity;
        $combination->low_stock_threshold = empty($low_stock_threshold) && '0' != $low_stock_threshold ? null : (int) $low_stock_threshold;
        $combination->low_stock_alert = !empty($low_stock_alert);
        $combination->available_date = $available_date;
        if($available_now) {
            $combination->available_now = $available_now;
        }
        if($available_later) {
            $combination->available_later = $available_later;
        }
        if (count($id_shop_list)) {
            $combination->id_shop_list = array_unique($id_shop_list);
        }
        $combination->add();
        if (!$combination->id) {
            return false;
        }
        $total_quantity = StockAvailable::getQuantityAvailableByProduct($this->id);
        if (!$total_quantity) {
            StockAvailable::setQuantity($this->id, 0, 0);
        }
        $id_default_attribute = Product::updateDefaultAttribute($this->id);
        if ($id_default_attribute) {
            $this->cache_default_attribute = $id_default_attribute;
            if (!$combination->available_date) {
                $this->setAvailableDate();
            }
        }
        if (!empty($id_images)) {
            $combination->setImages($id_images);
        }
        Tools::clearColorListCache($this->id);
        if (Configuration::get('PS_DEFAULT_WAREHOUSE_NEW_PRODUCT') != 0 && Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')) {
            $warehouse_location_entity = new WarehouseProductLocation();
            $warehouse_location_entity->id_product = $this->id;
            $warehouse_location_entity->id_product_attribute = (int) $combination->id;
            $warehouse_location_entity->id_warehouse = Configuration::get('PS_DEFAULT_WAREHOUSE_NEW_PRODUCT');
            $warehouse_location_entity->location = pSQL('');
            $warehouse_location_entity->save();
        }
        return (int) $combination->id;
    }
    
    /*
    * module: imaxmultialmacen
    * date: 2024-10-23 08:39:58
    * version: 1.64
    */
    public static function sqlStockWarehouse($context, $product_alias, $product_attribute = null, $inner_join = false)
    {
        $sql = (($inner_join) ? ' INNER ' : ' LEFT ')
            . 'JOIN ' . _DB_PREFIX_ . 'stock sw
            ON (sw.id_product = `' . bqSQL($product_alias) . '`.id_product';
        if (null !== $product_attribute) {
            if (!Combination::isFeatureActive()) {
                $sql .= ' AND sw.id_product_attribute = 0';
            } elseif (is_numeric($product_attribute)) {
                $sql .= ' AND sw.id_product_attribute = ' . $product_attribute;
            } elseif (is_string($product_attribute)) {
                $sql .= ' AND sw.id_product_attribute = IFNULL(`' . bqSQL($product_attribute) . '`.id_product_attribute, 0)';
            }
        }
        
        if(Validate::isLoadedObject($context->warehouse)) {
            $sql .= ' AND sw.id_warehouse = '.(int)$context->warehouse->id . ')';
        }
        else {
            $sql .= ')';
        }
        return $sql;
    }
}
