<?php

class Rawsqltool extends Module
{
	/* @var boolean error */
        private static $data_to_export;
        private static $col_name = array();
        private $config;
	protected $error = false;
	public static $security = 'if you have a better idea for security, let me know';
	public function __construct()
	{
	 	$this->name = 'rawsqltool';
	 	$this->tab = 'Custom Module';
	 	$this->version = '1.23';
		$this->author = 'Math_php';
		$this->need_instance = 0;

	 	parent::__construct();

        $this->displayName = $this->l('RawSqltool');
        $this->description = $this->l('Rawsqltool is a powerfull tool to use with a lot of care. Get new versions on prestashop.com forum');
		$this->confirmUninstall = $this->l('Are you sure you want to delete rawsqltool ?');
	}
	
	public function install()
	{
            $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'rawsqltool` (
        `id_rawsqltool` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(200) NOT NULL,
        `sql` text NOT NULL,
        PRIMARY KEY (`id_rawsqltool`)
) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;';
            
	 	if (!parent::install() 
                        || !Db::getInstance()->Execute($sql))
	 		return false;
	 	return true;
	}
	public function uninstall()
	{
	 	if (!parent::uninstall())
	 		return false;
	 	return true;
	}
	

        public function get_table_selector(){
            $rq ='SHOW TABLES';
                $selector ='<select id="select_table">';
                $result = Db::getInstance()->ExecuteS($rq);
                
                foreach ($result as $table){
                    foreach ($table as $key => $value)
                    $selector .= "<option>$value</option>";
                }
                return $selector.'</select>';
            
        }
        
        public function get_query_selector(){
            $rq ='select * from `'._DB_PREFIX_.'rawsqltool`';
                $selector ='<select id="select_saved_query">
                    <option value="" >'.$this->l('Saved queries').'</option>';
                $result = Db::getInstance()->ExecuteS($rq);
                
                foreach ($result as $query){
                    $selector .= '<option value="'.$query['id_rawsqltool'].' '.htmlentities($query['sql']).'">'.htmlentities($query['name']).'</option>';
                }
                return $selector.'</select>';
            
        }
        
        private function update_config(){
           $charset = Tools::getValue('charset','');
           Configuration::updateValue('rawsqltool_output_charset', $charset);
           
           $zip_export = tools::getValue('zip_export');
           Configuration::updateValue('rawsqltool_zip_export', $zip_export);
           
        }
        
	public function getContent(){
            //var_dump(ini_get('disable_functions')); // readfile is sometime disabled for security reason
                                                    // fpassthru to replace ?
            $this->_html.='Disabled function on your hosting :<br>'.ini_get('disable_functions').'<br>';
            
            if (Tools::isSubmit('save_config')){  $this->update_config();} 
    
            $token = Tools::getAdminToken(self::$security);
        
            $charset = Configuration::get('rawsqltool_output_charset');
            $zip_export = Configuration::get('rawsqltool_zip_export');
        
            if ($charset === false) $charset='utf-8';
        
        
        $tbl_sel = $this->get_table_selector();    
        
        $rq = trim(tools::getValue('sql_request',''));
            
        if (Tools::isSubmit('save_request')){   $this->save_query($rq);}
        
        $sel_saved_query = $this->get_query_selector();
        
     	if ($rq === '') $rq = 'select * from `'._DB_PREFIX_.'currency`';
        
         $this->_html.='
             <script type="text/javascript" src="'.$this->_path.'rawsqltool.js?'.($this->version*100).'"></script>
            
             <h2><img src="'.$this->_path.'danger.png" width=64 height=64 alt="Dangerous effects" title="Warning, check what you are doing"> RawSqlTool</h2>
             <fieldset>
             <legend>'.$this->l('Configuration').'</legend>
             <form method="POST">   
                <label>'.$this->l('Output charset').'</label>
                <div class="margin-form">
                    <select name="charset">
                        <option value="utf-8" '. ( $charset == "utf-8" ? 'selected' : '') .'>utf-8</option>
                        <option value="iso-8859-1" '. ($charset == "iso-8859-1" ? 'selected' : '').'>iso-8859-1</option>
                    </select>
                </div>
                <label>'.$this->l('Zip export').'</label>
                <div class="margin-form">
                    <input type="checkbox" name="zip_export" value="1" '.($zip_export == '1' ? 'checked="checked"' : '').'>
                </div>
              
                <div class="margin-form">
                    <input type="submit" name="save_config" value="'.$this->l('Save').'">
                </div>
                </form>
             </fieldset>
             

             <fieldset>
             <legend>Queries</legend>
             <form method="POST">   
               <label>'.$this->l('Table list').'</label>
                <div class="margin-form">
                '.$tbl_sel.'<input type="button" id="sql_request_add" value="'.$this->l('add').'">
                </div>    

            <label>'.$this->l('Query list').'</label>
                <div class="margin-form">
                '.$sel_saved_query.'
                    <input type="hidden" value="'.$token.'" name="security" id="token">
                    
                    <a class="export_link" target="_blank" style="display:none" id="link_excel" href="'.$this->_path.'export.php?">
                        <img src="'.$this->_path.'excel.png" title="microsoft csv">
                    </a>
                    <a class="export_link" target="_blank" style="display:none" id="link_csv"   href="'.$this->_path.'export.php?">
                        <img src="'.$this->_path.'csv.png" title="standard csv">
                      </a>
                      <a class="export_link" target="_blank" style="display:none" id="link_xml"   href="'.$this->_path.'export.php?">
                        <img src="'.$this->_path.'xml.png" title="xml export">
                      </a>
                </div>    
                

                 <label>'.$this->l('Query').'</label>
                <div class="margin-form">
                    <textarea name="sql_request" id="sql_request" cols=80 rows=5 >'.$rq.'</textarea>
                        </div>
               <label>'.$this->l('Save as').'</label>     
                 <div class="margin-form">
                    <input type="text" name="query_name"><input type="submit" id="save_request" name="save_request" value="Save">
                        </div>
                        
                <label>'.$this->l('Make back up before').'</label>
                <div class="margin-form">
                <input type="submit" value="'.$this->l('exec !').'" id="exec_sql_request" name="exec_sql_request"></div>
            </form>
            </fieldset>';
         if (!Tools::isSubmit('save_request'))  $this->process_request($rq);
        
        return $this->_html;
    }
    
    public function save_query($rq){
        if ($rq == '') return;
        $name = pSQL(Tools::getValue('query_name','no_name'));
        $sql = 'INSERT INTO `'._DB_PREFIX_."rawsqltool` (`name`,`sql`) VALUES ('$name','".pSQL($rq)."')";
        $bExec = Db::getInstance()->Execute($sql);
    }
    
   public static function zipit($file){
       if (! class_exists('ZipArchive')) return false;
       $zip = new ZipArchive();
       
       $filename = $file.".zip";

       if ($zip->open($filename, ZIPARCHIVE::CREATE)!==TRUE) {
           Logger::addLog("fail to create file $filename"); 
           return false;
        }
        $zip->addFile($file,$file);
        $zip->close();
        return true;
   }
   
   private static function build_xml($filename){
        foreach (array_keys(self::$data_to_export[0]) as $key){
                self::$col_name[] = $key;
        }
        
        $xml = new SimpleXMLElement('<xml/>');
         foreach (self::$data_to_export as $line){
           $rang = $xml->addChild('rang');
            foreach (self::$col_name as $col){
                $rang->addChild($col,$line[$col]);
            }
        }
                
                file_put_contents($filename, $xml->asXML()); 
       
   }
   private static function build_csv($filename,$format){
       // linux \n mac \r crosoft \r\n
        if ($format == 'excel'){$eol = "\r\n";}
        else { $eol = "\n";}
        
       
       if ( ! $handle = fopen($filename, 'w')) die("Unable to open output file : $filename");
            foreach (array_keys(self::$data_to_export[0]) as $key){
                self::$col_name[] = $key;
                fputs($handle, "$key;");
        }
        
        switch ($format){
              case 'excel':
                foreach (self::$data_to_export as $line){
                    fputs($handle,$eol);
                    foreach (self::$col_name as $col){
                        fputs($handle,'="'.str_replace('"', '""',$line[$col] ).'";');       // doubler les double quote
                    }
                }
                break;
            case 'csv':
                foreach (self::$data_to_export as $line){
                    fputs($handle,$eol);
                    foreach (self::$col_name as $col){
                        fputs($handle,$line[$col].';');
                    }
                }
                break;
            default :
                die('No export format specified');
        }
        fclose($handle);
   }
   private static function fix_charset(){
       $charset = Configuration::get('rawsqltool_output_charset')  ;
        
        if ($charset === false) $charset = 'utf-8';
        
        if ($charset !== 'utf-8'){  // conversion
            $content = iconv("UTF-8", "CP1252", file_get_contents($filename));      // utf8 decode to iso but € does not belong to iso 8859-1
            file_put_contents($filename, $content);
        }
        return $charset;
   }
   
   public static function export($id_query, $format='csv'){
        $export_dir = 'export/';
        if (!is_writable($export_dir)) die('modules/rawsqltool/export/ is not writable');
        
        // todo : si " ou ; dans le champ
        
        // is_filename
        
        // downloadable size
        // if (function_exists('bzopen'))       // class backup
//		{
//			$backupfile .= '.bz2';
//			$fp = @bzopen($backupfile, 'w');
//		}

                        

        
        
        
        
        $sql = db::getInstance()->getValue('select `sql` from `'._DB_PREFIX_.'rawsqltool` where id_rawsqltool = '.(int)$id_query);
        self::$data_to_export =  Db::getInstance()->executeS($sql);
    
        if ( ! self::$data_to_export) die('Query answer empty');
        
        
        switch ($format){
            case 'xml':
                $filename = $export_dir.'export_'.(int)$id_query.'.xml';
               self::build_xml($filename);
               break;
            default :
                $filename = $export_dir.'export_'.(int)$id_query.'.csv';
                self::build_csv($filename,$format);
                break;
            }

            
        if ( !file_exists($filename)) die('Unable to open exported file');
        
        
        
        // default charset is set to utf-8 for every table in Mysql by Prestashop
        
        $charset =     self::fix_charset($filename);
        $zip_export = Configuration::get('rawsqltool_zip_export');
        
        
        if ( $zip_export == 1 && self::zipit($filename)){
            unlink($filename);
            $filename = "$filename.zip";
            header("Content-Description: File Transfer");
            header("Content-type: application/octet-stream");
            header("Content-Transfer-Encoding: binary");
        }
        else {
            if ($format == 'csv'){
            header('Content-Type: text/csv; charset='.$charset);
            }
            else {
               header('Content-Type: text/xml; charset='.$charset);
            }
        }
        header('Cache-Control: no-store, no-cache');
        header('Content-Disposition: attachment; filename="'.$filename.'"');
        header('Content-Length: '.filesize($filename));
        
        self::output_file($filename);
        unlink($filename);
        die();
    }
    
    private static function output_file($filename){
        $disabled = ini_get('disable_functions');
        
        if ( strpos($disabled, 'readfile') === false){
            
            readfile(   $filename);
        }
        else {
            if ($handle = fopen($filename,'r')){
                fpassthru($handle);
                fopen($handle);
            }
            
        }
    }


    public function process_request($rq){
        global $cookie;        
        if ($rq == '') return;
        $arr_rq = explode(' ',  strtoupper($rq));
        
        if ( $arr_rq[0] == 'SELECT' || $arr_rq[0] == 'SHOW'){
                $this->display_result($rq);
        }        
        else {
            if ((int)$cookie->profile === 1 ){
                $bExec = Db::getInstance()->Execute($rq);
                }
                else {
                    $this->_html .= 'You are not allowed to do modification request (delete, truncate, drop)<br>';
                }
        }
    }
    
    
    public function display_result($rq){
        $result = Db::getInstance()->ExecuteS($rq);
    
        $this->_html .= '<table class="table"><thead><tr>';
        
        if (!isset($result[0])) return;
        foreach ($result[0] as $key => $value){
            $this->_html .= "<th>$key</th>";
        }
        $this->_html .= '</tr></thead>
            <tbody>';
        
        foreach ($result as $line){
                           $this->_html .= '<tr>';
            foreach ($line as $cell){
                $this->_html .= "<td>$cell</td>";
            }
            $this->_html .= '</tr>';
        }
        $this->_html .= '</tbody></table>';
    }
}
?>