<?php
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxscanean.php');

$context = Context::getContext();
$modulo = new imaxscanean();
$multiAlmacen = Module::getInstanceByName('imaxmultialmacen');

//Comprobamos logueo
if(empty($context->employee->id) || !$context->employee->isLoggedBack()) {
    Tools::redirectAdmin($context->shop->getBaseURL().'modules/imaxscanean/pda/index.php');
}


$unidadesIniciales = Configuration::getGlobalValue(imaxscanean::prefijo.'UNIDADES');
$editarStock = Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_STOCK');
$editarUbicacion = Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_UBICACION');
$urlImaximprimepedidosservidor = $context->link->getBaseLink().'modules/imaximprimepedidosservidor/menu';
$options = '';
$motivos = Configuration::getGlobalValue(imaxscanean::prefijo.'MOTIVOS');
$mostrarResolucion = Configuration::getGlobalValue(imaxscanean::prefijo.'MOSTRAR_RESOLUCION');
$multialmacen = (int) Module::isEnabled('imaxmultialmacen');
$arrayMotivos = explode(',', $motivos);
foreach($arrayMotivos as $motivo) {
    $options .= "<option value='$motivo'>$motivo</option>";
}

$almacenes =[];
if($multialmacen){
    $almacenes = $multiAlmacen->getFunciones()->getWarehouses(true, null, false);
    $almacenes = array_values($modulo->quitarAlmacenStockVirtual($almacenes));
    $almacenes = array_map(function($almacen) {
        return [
            'id' => $almacen['id_warehouse'],
            'idBusquedas' => $almacen['reference'],
            'nombre' => $almacen['name'],
        ];
    }, $almacenes);
}

$cuerpo = 'principal.php';
$js[] = 'principal.js';
$js[] = 'AsignacionIndividual.js';
$css[] = 'principal.css';
$css[] = 'asignacionIndividual.css';
$traducciones = array('mensaje_errorProducto' => $modulo->l('Error al obtener el producto.', 'imaxscanean'), 
    'mensaje_errorActualizar' => $modulo->l('Error al actualizar el producto.', 'imaxscanean'), 
    'mensaje_actualizar' => $modulo->l('Producto actualizado correctamente.', 'imaxscanean'),
    'mensaje_errorAlmacen' => $modulo->l('Seleccione un almacén de destino por favor.', 'imaxscanean'));
$nombreUsuario = $context->employee->firstname;
$nombrePagina = $modulo->l('Producto', 'ImaxImprimePedidosServidor');
$srcLogo = $context->link->getBaseLink().'img/'.Configuration::get('PS_LOGO');
require_once 'vistas/base.php';