$(function () {
    var id_product = 0, id_product_attribute = 0, stockActual = 0;

    var popUp = new AsignacionIndividual(almacenes, function(elemento){
        $('#inputAlmacenDestino').attr('data-idwarehouse', elemento.id);
        $('#inputAlmacenDestino').val(elemento.nombre);
    });
    window.onresize = function (event) {
        if(mostrarResolucion === '1'){
            resolucionPantalla();
        }
    };
    
    if(mostrarResolucion === '1') {
        resolucionPantalla();
    }else{
        $('.resolucionPantalla').hide();
    }
    /**
     * Obtiene un producto por ean y coloca el foco donde corresponda.
     * @param int ean 
     */
    function obtenerProducto(ean) {
        $.getJSON('ajax.php?callback=?', {
            accion: 'obtenerProducto',
            ean: ean
        }, function (respuesta) {
            if (respuesta.ok) {
                $('select[name="motivoRegularizacion"]').val($('select[name="motivoRegularizacion"] option:first-child').val());
                $('input[name="variacionStock"]').val(unidadesIniciales);
                $('#referencia').html(respuesta.datos.referencia);
                if(multialmacen == '0'){
                    $('#stockActual').html(respuesta.datos.stock);
                    $('#ubicacionActual td:last-child').html(respuesta.datos.ubicacion);
                }
                
                $('#infoProducto').html('<strong>' + respuesta.datos.nombre + '</strong>' + '<img src="' + respuesta.datos.imagen + '" alt=""/> ');
                $('#infoProducto').after(respuesta.datos.tablaStocks);
                $('input[name="ubicacionStock"]').val(respuesta.datos.ubicacion);
                $('#contenedorCuerpo').show();
                $('#contenedorGuardar').show();
                $('.editarStock, .editarUbicacion').hide();
                
                if(editarStock){
                    $('.editarStock').show();
                    $('#ubicacionActual').show();
                }
                
                if(multialmacen == '0' && editarUbicacion){
                    $('.editarUbicacion').show();
                    $('#ubicacionActual').hide();
                }
                id_product = respuesta.datos.id_product;
                id_product_attribute = respuesta.datos.id_product_attribute;
                stockActual = respuesta.datos.stock;
                
                focoEnInput('inputAlmacenDestino');
            }
            else {
                mensaje(mensaje_errorProducto, 'error');
            }
        });
    }
    
    /**
     * Actualiza el stock del producto.
     */
    function actualizar() {
        var almacenDestino = $('#inputAlmacenDestino').data('idwarehouse');
        if(typeof almacenDestino == 'undefined'){
            mensaje(mensaje_errorAlmacen, 'error');
        }else{
            $.getJSON('ajax.php?callback=?', {
                accion: 'actualizar',
                id_product: id_product,
                id_product_attribute: id_product_attribute,
                variacionStock: $.trim($('input[name="variacionStock"]').val()),
                stockActual: stockActual,
                motivo: $.trim($('select[name="motivoRegularizacion"]').val()),
                forzarDisminucion: ($('input[name="variacionNegativa"]').is(':checked') ? 1 : 0),
                almacenDestino : almacenDestino,
                ubicacion: $.trim($('input[name="ubicacionStock"]').val())
            }, function (respuesta) {
                limpiarControles();
                
                if (respuesta.ok) {
                    mensaje(mensaje_actualizar, 'correcto');
                }
                else {
                    mensaje(mensaje_errorActualizar, 'error');
                }
            });
        }
    }

    /**
     * Actualiza la ubicación del stock del producto
     */
    function actualizarUbicacion() {
        $.getJSON('ajax.php?callback=?', {
            accion: 'actualizarUbicacion',
            id_product: id_product,
            id_product_attribute: id_product_attribute,
            ubicacion: $.trim($('input[name="ubicacionStock"]').val())
        }, function (respuesta) {
            limpiarControles();
            
            if (respuesta.ok) {
                mensaje(mensaje_ubicacionActualizada, 'correcto');
            }
            else {
                mensaje(mensaje_errorActualizaUbicacion, 'error');
            }
        });
    }
    
    /**
     * Modifica los controles para solicitar otro ean.
     */
    function limpiarControles() {
        $('#tablaStocks').remove();
        $('select[name="motivoRegularizacion"]').val($('select[name="motivoRegularizacion"] option:first-child').val());
        $('input[name="variacionStock"]').val(unidadesIniciales);
        $('#stockActual').html('');
        $('input[name="ean"]').val('');
        $('#infoProducto').html('');
        
        $('#contenedorCuerpo').hide();
        $('#contenedorGuardar').hide();
        id_product = 0;
        id_product_attribute = 0;
        stockActual = 0;

        focoEnInput('ean');
    }

    function focoEnInput(inputName) {
        var input = $('input[name="' + inputName + '"]');
        if(!input.is(':focus')) {
            input.attr('readonly', 'readonly');
            input.focus();
            input.get(0).selectionStart = input.get(0).selectionEnd = input.val().length;
            setTimeout(function() {
                input.removeAttr('readonly');
            }, 50);
        }
    }
    
    //Iniciamos
    $('input[name="ean"]').val('');
    $('input[name="ean"]').keyup(function(e) {
        if(e.keyCode == 13) {
            var numero = $('input[name="ean"]').val();
            limpiarControles();
            obtenerProducto(numero);
        }
    });
    
    $('input[name="variacionStock"]').keyup(function(e) {
        if(e.keyCode == 13) {
            $('#actualizar').click();
        }
    });
    
    $('select[name="motivoRegularizacion"]').change(function(e) {
        focoEnInput('variacionStock');
    });
    
    $('#actualizar').click(function() {
        actualizar();
    });
    
    focoEnInput('ean');

    function resolucionPantalla() {
        $(".resolucionPantalla").remove();
        var ancho = pixelesRealesNavegador()[0];
    
        if (ancho >= 1200) {
            dispositivo = "LG";
        } else if (ancho >= 992) {
            dispositivo = "MD";
        } else if (ancho >= 768) {
            dispositivo = "SM";
        } else {
            dispositivo = "XS";
        }
    
        $("body").append("<span class='resolucionPantalla' style='position:fixed;top:0px;left:0px;color:white;background:red;z-index:999999999999;'>" + dispositivo + ":" + ancho + "px</span>");
    }
    
    function pixelesRealesNavegador() {
        var tam = [0, 0];
        if (typeof window.innerWidth != 'undefined') {
            tam = [window.innerWidth, window.innerHeight];
        }
        else if (typeof document.documentElement != 'undefined'
            && typeof document.documentElement.clientWidth !=
            'undefined' && document.documentElement.clientWidth != 0) {
            tam = [
                document.documentElement.clientWidth,
                document.documentElement.clientHeight
            ];
        }
        else {
            tam = [
                document.getElementsByTagName('body')[0].clientWidth,
                document.getElementsByTagName('body')[0].clientHeight
            ];
        }
        return tam;
    }

    $('#inputAlmacenDestino').click(function(e){
        $('#inputAlmacenDestino').select();
    });

    $('#inputAlmacenDestino').keyup(function(e){
        if (e.keyCode == 13) {
            popUp.mostrar('Almacenes Destino');
            $('input[name="textoBusquedaIndividual"]').val($('#inputAlmacenDestino').val());
            $('input[name="textoBusquedaIndividual"]').trigger($.Event('keyup', { keyCode: 13 }));
            $('.listadoIndividual li span').click(function(e){
                focoEnInput('variacionStock');
            });
            $('input[name="textoBusquedaIndividual"]').keyup(function(e){
                if (e.keyCode == 13) {
                focoEnInput('variacionStock');  
                }
            });
            focoEnInput('variacionStock');
          }
    });



});