<?php
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__).'../../../../config/config.inc.php');
include_once(dirname(__FILE__).'/../imaxscanean.php');

$context = Context::getContext();
$context->shop->setUrl();
if (version_compare(_PS_VERSION_, '8.0.0.0 ', '>=')) {
    //Inicializamos el kernel

    if (!class_exists('AppKernel')) {
        require_once __DIR__ . '/../app/AppKernel.php';
    }
    global $kernel;
    $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
    $kernel->boot();
    Context::getContext()->container = SymfonyContainer::getInstance();
}

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'obtenerProducto':
            $ean = trim(Tools::getValue('ean'));
            $imax = new imaxscanean();
            $resultado['datos'] = $imax->obtenerProductoPDA($ean);
            $resultado['ok'] = (boolean)$resultado['datos'];
            break;
        
        case 'actualizar':
            $variacionStock = (int)trim(Tools::getValue('variacionStock'));
            if(Tools::getValue('forzarDisminucion')) {
                $variacionStock = -abs($variacionStock);
            }
            $stockAnterior = (int)trim(Tools::getValue('stockActual'));
            if(Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_STOCK')){
                $nuevoStock = $stockAnterior + $variacionStock;
            }else{
                $nuevoStock = $stockAnterior;
            }
            $ubicacion = trim(Tools::getValue('ubicacion'));
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $motivo = trim(Tools::getValue('motivo'));
            
            $imax = new imaxscanean();
            $almacenDestino = 0;
            if(Module::isEnabled('imaxmultialmacen') && Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_STOCK')){
                $almacenDestino = Tools::getValue('almacenDestino');
                $razonMvtEntrada = Configuration::getGlobalValue(imaxscanean::prefijo.'RAZON_MVT_ENTRADA');
                StockAvailable::updateQuantity($id_product, $id_product_attribute, $variacionStock, null, false, array(), $almacenDestino);
                $resultado['ok'] = $imax->generarMovimiento($id_product,$id_product_attribute, $variacionStock, $razonMvtEntrada, $almacenDestino);
            }elseif(Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_STOCK')){
                $resultado['ok'] = (boolean)StockAvailable::updateQuantity($id_product, $id_product_attribute, $variacionStock);
            }
            $imax->guardarMonitorizacion($id_product, $id_product_attribute, ($nuevoStock >= 0 ? $nuevoStock : 0), $stockAnterior, $motivo, $almacenDestino);
            if(!Module::isEnabled('imaxmultialmacen') && Configuration::getGlobalValue(imaxscanean::prefijo.'EDITAR_UBICACION')){
                try {
                    StockAvailable::setLocation($id_product, $ubicacion, null, $id_product_attribute );
                    $resultado['ok'] = true;
                } catch (Exception $e) {
                    $resultado['ok'] = false;
                }
            }
            break;
        case 'cargarStock':
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $almacenDestino = (int)Tools::getValue('almacenDestino');
            try {
                $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $almacenDestino);
                $stock = new Stock($idStock);
                $resultado['datos']['stock'] = $stock;
                $resultado['ok'] = true;
            } catch (Exception $e) {
                $resultado['ok'] = false;
            }
            break;
    }
}

echo Tools::getValue('callback').'('.json_encode($resultado).')';
