<?php

class imaxscanean extends Module {

    var $versionPS;
    var $idShop;
    var $idLang;
    var $idTab;
    var $ean;
    var $stock;
    private $_html = '';
    public $idManual, $forceCheck, $sufijo, $producto, $tabla;

    const prefijo = 'imaxscanean';

    public function __construct() {
        $this->name = 'imaxscanean';
        $this->tab = 'administration';
        $this->version = '1.23';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->idManual = '';
        $this->forceCheck = 0;
        $this->sufijo = self::prefijo;
        parent::__construct();
        $this->displayName = $this->l('Cambia Stock con Lector');
        $this->description = $this->l('');

        $context = Context::getContext();
        $this->idShop = $context->shop->id;
        $this->idLang = $context->language->id;

        if (version_compare(_PS_VERSION_, '8.0.0.0 ', '>=')) {
            $this->versionPS = 18;
        } else if (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            $this->versionPS = 17;
        } else if (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
            $this->versionPS = 16;
        } else if (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
        }
        $this->ps_versions_compliancy = ['min' => '1.5.0.0', 'max' => _PS_VERSION_];
        
    }

    public function install() {
        $directorioAdmin = getcwd();
        if (!@copy(dirname(__FILE__).'/imaxscanean_ajax.php', $directorioAdmin.'/imaxscanean_ajax.php')) {
            $this->_errors[] = $this->l('Ha fallado al copiar el fichero de JS');
            return false;
        }


        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (!Configuration::updateGlobalValue($indice, $valor)) {
                return false;
            }
        }

        if (!parent::install())
            return false;

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                $this->_errors[] = $this->l('Ha fallado la instalacion del hook:').' '.$hook;
                return false;
            }
        }

        include(dirname(__FILE__).'/sql-install.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }

        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Error al instalar el tab');
            return false;
        }

        //Crear redireccion hacia pda
        Db::getInstance()->execute('INSERT IGNORE INTO `'._DB_PREFIX_.'meta` (page, configurable) VALUES ("module-imaxscanean-pda", 1)');
        $idMeta = Db::getInstance()->Insert_ID();
        $tiendas = Shop::getShops();
        $idiomas = Language::getLanguages();
        foreach ($tiendas as $tienda) {
            foreach ($idiomas as $idioma) {
                Db::getInstance()->execute('
                    INSERT IGNORE INTO `'._DB_PREFIX_."meta_lang` (id_meta, id_shop, id_lang, title, description, keywords, url_rewrite) 
                        VALUES ('$idMeta', '{$tienda['id_shop']}', '{$idioma['id_lang']}', 'PDA STOCK', 'Ayuda a modificar el stock de los productos.', 'pdaStock', 'pdaStock')");
            }
        }

        if (class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
                    INSERT IGNORE INTO `'._DB_PREFIX_."theme_meta` (id_theme, id_meta, left_column, right_column) 
                        VALUES ('$plantilla->id', '$idMeta', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }
        return true;
    }

    public function uninstall() {
        if (!parent::uninstall()) {
            return false;
        }

        include(dirname(__FILE__).'/sql-unninstall.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }
        $directorioAdmin = getcwd();


        if (!$this->uninstallTab()) {
            $this->_errors[] = $this->l('Error al eliminar el tab');
            return false;
        }

        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (Configuration::getGlobalValue($indice) !== FALSE) {
                if (!Configuration::deleteByName($indice)) {
                    return false;
                }
            }
        }

        return true;
    }

    public function getContent() {
        $this->getTxtFiles();
        $this->addCSS('css.css');
        $this->addCSS('asignacionIndividual.css');
        $this->addJS('functions.js');
        $this->addJS('AsignacionIndividual.js');
        $this->addCSS('publi.css');
        $this->_html .= $this->createHelpHeader();
        if (!empty($_POST))
            $this->_html .= $this->_postProcess();

        $this->_displayForm();
        $this->_html .= $this->getModuleFooter();
        return $this->_html;
    }

    private function _postProcess() {
        $accion = Tools::getValue("action");
        $this->idTab = Tools::getValue("idTab");
        $html = "";
        switch ($accion) {
            case 'gestionLicencia':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo.'LICENCIA', trim(Tools::getValue('licencia'))))
                    $html .= $this->displayConfirmation($this->l('Licencia guardada correctamente.'));
                else
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la licencia.'));
                break;
            case 'configuracionInical':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo.'UNIDADES', trim(Tools::getValue('unidades'))) &&
                        Configuration::updateGlobalValue(self::prefijo.'TIPO_IMAGEN', trim(Tools::getValue('tipoImagen'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'RAZON_MVT_ENTRADA', trim(Tools::getValue('razonMvtEntrada'))) &&
                        Configuration::updateGlobalValue(self::prefijo.'MOTIVOS', trim(Tools::getValue('motivos'))) &&
                        Configuration::updateGlobalValue(self::prefijo.'UNIDADES', trim(Tools::getValue('unidades'))) &&
                        Configuration::updateGlobalValue(self::prefijo.'EDITAR_STOCK', trim(Tools::getValue('editarStock'))) &&
                        Configuration::updateGlobalValue(self::prefijo.'EDITAR_UBICACION', trim(Tools::getValue('editarUbicacion'))) &&  
                        Configuration::updateGlobalValue(self::prefijo.'MOSTRAR_RESOLUCION', trim(Tools::getValue('mostrarResolucion')))   
                    )
                    $html .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
                else
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuración.'));
                break;
            case 'checkean':
                $this->ean = Tools::getValue('ean');
                if ($this->ean){
                    $this->producto = $this->getProductByEan();
                    if (!$this->producto && Module::isEnabled('imaxmultiean')) {
                        $imaxmultieanModule = Module::getInstanceByName('imaxmultiean');
                        $this->producto = $imaxmultieanModule->getFunciones()->getProductByEan($this->ean);
                    }
                    if(!$this->producto){
                        $this->producto = $this->buscarReferencia($this->ean);
                    }
                }   
                $this->stock = Tools::getValue('stock');
                $id_product = Tools::getValue('id_product');
                $id_product_attribute = Tools::getValue('id_product_attribute');
                if ($id_product) {
                    $this->producto = '';
                    $this->ean = '';

                    $almacenDestino = 0;
                    if(Module::isEnabled('imaxmultialmacen')){
                        $almacenDestino = Tools::getValue('almacenDestino');
                        $razonMvtEntrada = Configuration::getGlobalValue($this->sufijo.'RAZON_MVT_ENTRADA');
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, $this->stock, null, false, array(), $almacenDestino);
                        $this->generarMovimiento($id_product,$id_product_attribute, $this->stock, $razonMvtEntrada, $almacenDestino);
                        $stockLocal = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, null, $almacenDestino);
                        $s = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, null, $almacenDestino);
                    }else{
                        $stockLocal = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute);
                        $s = $stockLocal + $this->stock;
                        StockAvailable::setQuantity($id_product, $id_product_attribute, $s);
                        $s = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute);
                    }
                    if ($s) {
                        $html .= $this->displayConfirmation($this->l('El stock se ha cambiado a ').$s);
                        $this->guardarMonitorizacion($id_product, $id_product_attribute, $stockLocal, $this->stock, Tools::getValue('motivos'), $almacenDestino);
                    }
                    else
                        $html .= $this->displayError($this->l('Error al cambiar el stock'));
                }
                //$this->stock;
                break;

            case 'gestionLicenciaAdicional':
                $licenciasAdicionales = Tools::getValue('licenciaAdicional');
                Db::getInstance()->execute('TRUNCATE TABLE `'._DB_PREFIX_.self::prefijo.'licencias`');
                $erroresLicencias = array();
                $error = 0;
                $msg = $this->l('Licencias guardadas correctamente');
                foreach ($licenciasAdicionales AS $nombre => $licencia) {
                    if (trim($licencia) != '') {
                        $sql = 'INSERT INTO `'._DB_PREFIX_.self::prefijo.'licencias` '
                                .' (nombre, licencia)'
                                .' VALUES'
                                .' ("'.$nombre.'","'.$licencia.'")';
                        DB::getInstance()->execute($sql);
                        if (!$this->checkLicenciaAdicional($nombre, $licencia, 1)) {
                            $erroresLicencias[] = $nombre;
                            $error = 1;
                        }
                    }
                }
                if ($error == 1) {
                    $msg = $this->l('Se ha producido un error en los siguientes plugins: ');
                    $sw = 0;
                    foreach ($erroresLicencias AS $errorLicencia) {
                        if ($sw == 0) {
                            $msg .= '<br />'.$errorLicencia;
                            $sw = 1;
                        }
                        else {
                            $msg .= ', '.$errorLicencia;
                        }
                    }
                    $this->_html .= $this->displayError($msg);
                }
                else {
                    $this->_html .= $this->displayConfirmation($msg);
                }
                break;

            default:
                break;
        }

        return $html;
    }

    private function _displayForm() {
        $this->checkLicenciaAdicional('imaxscaneanpda', $this->getLicenciaAdicional('imaxscaneanpda', FALSE), 0);

        if (Configuration::getGlobalValue(self::prefijo.'LICENCIA') == '') {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>'.$this->l('ATENCION: SU LICENCIA ESTA VACIA').'</p>';
            $this->_html .= '<p>'.$this->l('Debe introducir un numero de licencia valido para continuar').'</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        }
        elseif (!$this->checkLicencia($this->forceCheck)) {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>'.$this->l('ATENCION: SU LICENCIA NO ES VALIDA').'</p>';
            $this->_html .= '<p>'.$this->l('Si ejecuta el modulo sin licencia los resultados no seran validos').'</p>';
            $this->_html .= '<p>'.$this->l('Haga esto bajo su responsabilidad, Informax no dara soporte ni aceptar quejas o peticiones derivadas del uso sin licencia de nuestros productos').'</p>';
            $this->_html .= '<p>'.$this->l('El uso de nuestro software sin licencia constituye una infraccion de las leyes de propiedad intelectual, y sera puesta en conocimiento de las autoridades pertinentes').'</p>';
            $this->_html .= '<p>'.$this->l('Si cree que este mensaje es un error, por favor, pongase en contacto con nosotros, enviandonos codigo de licencia, nombre del modulo, dominio de la tienda y copia de la factura de pago').'</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        }
        else {
            if ($this->_checkVersion()) {
                $this->_html .= $this->displayConfirmation($this->_checkVersion());
            }
            if ($this->idTab == '' || empty($this->idTab)) {
                $this->idTab = 1;
            }
            $urlTienda = self::getUrlAdmin();
            $token = Tools::getAdminTokenLite('AdminModules');
            $moduleLink = $urlTienda.'index.php?controller=AdminModules&token='.$token.'&configure='.$this->name.'&tab_module=administration&module_name='.$this->name;

            $this->_html .= '<script>'
                    .' var nameModule = "'.$this->name.'"; '
                    .' var url_admin = "'.$urlTienda.'"; '
                    .' var url_modulo = "'.$moduleLink.'"; '
                    .' </script>';
            $this->_html .= '<ul id="menuTab">
                    <li id="menuTab1" class="menuTabButton'.(($this->idTab == 1) ? " selected" : "").'">'.$this->l('Scan').'</li> 
                    <li id="menuTab2" class="menuTabButton'.(($this->idTab == 2) ? " selected" : "").'">'.$this->l('Configuracion').'</li> 
                    <li id="menuTab3" class="menuTabButton'.(($this->idTab == 3) ? " selected" : "").'">'.$this->l('Licencia').'</li>';
            $this->_html .= '</ul>';
            $this->_html .= '
		<div id="tabList">
                    <div id="menuTab1Sheet" class="tabItem'.(($this->idTab == 1) ? " selected" : "" ).'">'.$this->_configuracion().'</div>
                    <div id="menuTab2Sheet" class="tabItem'.(($this->idTab == 2) ? " selected" : "" ).'">'.$this->_configuracionInicial().'</div>
                    <div id="menuTab3Sheet" class="tabItem'.(($this->idTab == 3) ? " selected" : "" ).'">'.$this->_mostrarLicencia().'</div>';
            $this->_html .= '</div>';
            $this->_html .= '<style>
				#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
				#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
				#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
				#tabList { clear: left; }
				.tabItem { display: none; }
				.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
			</style>
			<script>
				$(".menuTabButton").click(function () {
				  $(".menuTabButton.selected").removeClass("selected");
				  $(this).addClass("selected");
				  $(".tabItem.selected").removeClass("selected");
				  $("#" + this.id + "Sheet").addClass("selected");                                 
				});
			</script>';
        }
    }

    private function _configuracion() {
        include_once(dirname(__FILE__).'/functionsForm.php');
        include_once(dirname(__FILE__).'/imaxAcordeon.php');
        $shopDomain = Configuration::getGlobalValue('PS_SHOP_DOMAIN');
        $unidades = Configuration::getGlobalValue($this->sufijo.'UNIDADES');
        $motivos = Configuration::getGlobalValue($this->sufijo.'MOTIVOS');
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "checkean");
        $form->createHidden("idTab", "1");
        if ($this->ean)
            $form->createFormTextGroup('ean', $this->ean, 'EAN o referencia', '', 0, 0, array('onclick' => "javascript: this.value = ''"), false);
        else
            $form->createFormTextGroup('ean', $this->ean, 'EAN o referencia', '', 0, 0, '', true);

        if (!empty($this->producto)) {
            $producto = new Product((int)$this->producto['id_product']);
            $imagenesDefecto = $producto->getImages($this->idLang);
            $idImagen = 0;
            if ($imagenesDefecto) {
                foreach ($imagenesDefecto as $imagenDefecto) {
                    if ($imagenDefecto['cover'] == 1) {
                        $idImagen = $imagenDefecto['id_image'];
                    }
                }
            }
            $combinaciones = $producto->getAttributesResume($this->idLang);
            $nombre = $producto->name[$this->idLang];
            if ($combinaciones) {
                foreach ($combinaciones AS $combinacion) {
                    if ($combinacion['id_product_attribute'] == $this->producto['id_product_attribute']) {
                        $nombre = $nombre.' - '.$combinacion['attribute_designation'];
                    }
                }
            }

            $img = new Link();
			      if (Configuration::get('PS_SSL_ENABLED') == 1) {
            $urlPrefijo = 'https://';
        } else {
            $urlPrefijo = 'http://';
        }
            $imagen = $urlPrefijo . $img->getImageLink($producto->link_rewrite[$this->idLang], $this->producto['id_product'].'-'.$idImagen, 'cart_default');
			
            $html = '';
            if (!empty($this->producto)) {
                $html .= '<div class="bootstrap">';
            }
            $html .= '<table class="table  tableDnD">';
            $html .= '<tr>';
            $html .= '<th>'.$this->l('Imagen').'</th>';
            $html .= '<th>'.$this->l('Nombre').'</th>';
            $html .= '</tr>';
            $html .= '<tr>';
            $html .= '<td><img src="'.$imagen.'" /></td>';
            $html .= '<td>'.$nombre.'</td>';
            $html .= '</tr>';
            $html .= '</table>';
            $almacenes = [];
            $almacenesDestinoCantidad = [];
            if(Module::isEnabled('imaxmultialmacen')){
                $almacenes = Warehouse::getWarehouses(true);
                $almacenes = $this->quitarAlmacenStockVirtual($almacenes);
                $almacenes = array_map(function($almacen) {
                    return [
                        'id' => $almacen['id_warehouse'],
                        'idBusquedas' => $almacen['reference'],
                        'nombre' => $almacen['name'],
                    ];
                }, $almacenes);
                $stockProducto = '-';
                $almacenesDestinoTemp = Warehouse::getWarehouses(true);
                $almacenesDestinoTemp = $this->quitarAlmacenStockVirtual($almacenesDestinoTemp);
                foreach($almacenesDestinoTemp as $almacenDestino){
                    $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($this->producto['id_product'], $this->producto['id_product_attribute'], $almacenDestino['id_warehouse']);
                    $stock = new Stock($idStock);
                    $almacenesDestinoCantidad[$almacenDestino['id_warehouse']] = $stock->usable_quantity;
                }
            }else{
                $stockProducto = StockAvailable::getQuantityAvailableByProduct($this->producto['id_product'], $this->producto['id_product_attribute']);
            }
            $form->addToForm("<script>var almacenes = ". json_encode($almacenes) ."</script>");
            $form->addToForm("<script>var almacenesDestinoCantidad = ". json_encode($almacenesDestinoCantidad) ."</script>");
            $form->addToForm($html);
            $form->createHidden('id_product', $this->producto['id_product']);
            $form->createHidden('id_product_attribute', $this->producto['id_product_attribute']);
            $form->createFormTextGroup('stockActual', $stockProducto, 'Stock Actual', '', 0, 0, '', false);
            $arraymotivos = explode(',', $motivos);
            $final_array = array_combine($arraymotivos, $arraymotivos);
            $form->createFormSelect('motivos', 'Motivos Regularización', $final_array, '');
            $form->createFormTextGroup('stock', $unidades, 'Stock a sumar', '', 0, 0, '', true);
            if(Module::isEnabled('imaxmultialmacen')){
                $almacenesDestino = [];
                foreach($almacenesDestinoTemp as $almacenDestino){
                    $almacenesDestino[$almacenDestino['id_warehouse']] = $almacenDestino['name'];
                }
                $form->createFormTextGroup('almacenDestino','','Seleccione el almacén de destino', 'almacenDestino', 0, 0,['data-idwarehouse' => '']);
            }
        }
        $text = '<b>'.$this->l('ATENCION:').'</b> '.$this->l('Los productos y las combinaciones han de tener EAN para que los reconozca el sistema.');
        $form->createFormInfomationText($text, true);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        if (!empty($this->producto)) {
            $form->addToForm('</div><br class="clear" />');
        }
        $html = $form->renderForm();

        unset($form);

        return $html;
    }

    private function _configuracionInicial() {
        include_once(dirname(__FILE__).'/functionsForm.php');
        include_once(dirname(__FILE__).'/imaxAcordeon.php');

        $html = '';
        if ($this->getLicenciaAdicional('imaxscaneanpda')) {
            $tienda = new Shop($this->idShop);
            $enlace = $tienda->getBaseURL();
            if ($enlace[strlen($enlace) - 1] == '/') {
                $enlace = substr($enlace, 0, -1);
            }

            require_once dirname(__FILE__).'/qrcode/qrlib.php';
            QRcode::png("$enlace/modules/imaxscanean/pda", dirname(__FILE__).'/css/qr.png', 'H', 2);

            $html .= '<fieldset><legend>'.$this->l('URL para acceder a pda stock (puede acceder escaneando el qr)').'</legend>
                    <p id="enlacePDA"><a href="'.$enlace.'/pdaStock" target="_blank">'.$enlace.'/pdaStock</a> <img src="'.$enlace.'/modules/imaxscanean/css/qr.png" alt=""/></p>
    			</fieldset><br/>';
        }

        $unidades = Configuration::getGlobalValue($this->sufijo.'UNIDADES');
        $tipoImagen = Configuration::getGlobalValue($this->sufijo.'TIPO_IMAGEN');
        $stockMvtReasons = StockMvtReason::getStockMvtReasons($this->idLang);
        $stockMvtReasonsFormat = array();
        foreach($stockMvtReasons as $stockMvtReason){
            $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
        }
        $razonMvtEntrada = Configuration::getGlobalValue($this->sufijo.'RAZON_MVT_ENTRADA');
        $motivos = Configuration::getGlobalValue($this->sufijo.'MOTIVOS');
        $editarStock = Configuration::getGlobalValue($this->sufijo.'EDITAR_STOCK');
        $editarUbicacion = Configuration::getGlobalValue($this->sufijo.'EDITAR_UBICACION');
        $mostrarResolucion = Configuration::getGlobalValue($this->sufijo.'MOSTRAR_RESOLUCION');
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("action", "configuracionInical");
        $form->createHidden("idTab", "2");
        $form->createFormTextGroup('unidades', $unidades, 'Unidades por defecto');
        $form->createSelectNameImages('tipoImagen', 'Imagen a usar', $tipoImagen);
        $form->createFormSelect('razonMvtEntrada', 'Razón del movimiento de stock de entrada', $stockMvtReasonsFormat, $razonMvtEntrada, 'razonMvtEntrada');
        $form->createFormTextGroup('motivos', $motivos, 'Motivos de Cambio de Stock');
        $form->createFormCheckboxGroup('editarStock', $this->l('Editar stock'), $editarStock);
        $form->createFormCheckboxGroup('editarUbicacion', $this->l('Editar ubicación'), $editarUbicacion);
        $form->createFormCheckboxGroup('mostrarResolucion', $this->l('Mostrar resolución'), $mostrarResolucion);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $form->renderForm();
        unset($form);
        return $html;
    }

    public function getProductByEan() {
        if ($this->ean) {
            $sql = 'SELECT *
			FROM `'._DB_PREFIX_.'product_attribute`  
			WHERE `ean13` = "'.$this->ean.'"';

            $resultado = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);
            if (!$resultado) {
                $sql = 'SELECT id_product,0 as id_product_attribute
			FROM `'._DB_PREFIX_.'product` 
			WHERE `ean13` = "'.$this->ean.'"';			
            }
            return Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);
        }
        else {
            return false;
        }
    }
    
    /**
     * Guarda datos sobre el cambio de stock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $nuevoStock
     * @param int $stockAnterior
     * @param string $motivo
     * @param int $almacen
     * @return boolean
     */
    public function guardarMonitorizacion($id_product, $id_product_attribute, $nuevoStock, $stockAnterior, $motivo, $almacen) {
        $sql = 'INSERT INTO '._DB_PREFIX_.self::prefijo.'monitorizacion 
                            (idEmployee, idProducto, idAtributo, stockModificado, stockAnterior, motivo, almacen)
                        VALUES
                            ('.(int)Context::getContext()->employee->id.', '.(int)$id_product.', '.(int)$id_product_attribute.', '.(int)$nuevoStock.', '.(int)$stockAnterior.',"'.pSQL(trim($motivo)).'" , '.(int)$almacen.')';
        return Db::getInstance()->execute($sql);
    }
    
    /**
     * Devuelve el id y la imagen de un producto.
     * @param string $ean
     * @return array
     */
    public function obtenerProductoPDA($ean) {
        $ean = pSQL(trim($ean));
        $resultado = array();
        
        $idsProducto = Db::getInstance()->getRow('SELECT id_product, id_product_attribute FROM `'._DB_PREFIX_."product_attribute` WHERE `ean13` = '$ean'");
        if(!$idsProducto) {
            $idsProducto = Db::getInstance()->getRow('SELECT id_product, 0 as id_product_attribute FROM `'._DB_PREFIX_."product` WHERE `ean13` = '$ean'");
        }
        if (!$idsProducto && Module::isEnabled('imaxmultiean')) {
            $imaxmultieanModule = Module::getInstanceByName('imaxmultiean');
            $idsProducto = $imaxmultieanModule->getFunciones()->getProductByEan($ean);
        }

        if(!$idsProducto){
            $idsProducto = $this->buscarReferencia($ean);
        }
        if($idsProducto) {
            $productoObj = new Product($idsProducto['id_product']);
            $id_image_temp = Product::getCover($productoObj->id);
            
            if($id_image_temp){
                $ids = $productoObj->id.'-'.$id_image_temp['id_image'];
            }else{
                $ids = Language::getIsoById($this->idLang).'-default';   
            }
            // legacy mode or default image
            $referencia = $productoObj->reference;
            if($idsProducto['id_product_attribute']) {
                $nombreCombinacionString = ' - ';
                
                $combinacion = new Combination($idsProducto['id_product_attribute']);
                $referencia = $combinacion->reference;
                $nombresCombinacion = Product::getAttributesParams($idsProducto['id_product'], $idsProducto['id_product_attribute']);
                foreach($nombresCombinacion as $nombreCombinacion) {
                    $nombreCombinacionString .= $nombreCombinacion['group'].': '.$nombreCombinacion['name'].', ';
                }
                $nombreCombinacionString = substr($nombreCombinacionString, 0, -2);
            }
            else {
                $nombreCombinacionString = '';
            }
            
            $tipoImagen = Configuration::getGlobalValue($this->sufijo.'TIPO_IMAGEN');
            if(empty($tipoImagen)){
                $tipoImagen = 'cart_default';
            }
            $resultado['imagen'] = $this->context->link->getImageLink($productoObj->link_rewrite[$this->idLang], $ids, $tipoImagen);
            $resultado['id_product'] = $idsProducto['id_product'];
            $resultado['id_product_attribute'] = $idsProducto['id_product_attribute'];
            $resultado['nombre'] = $productoObj->name[$this->idLang].$nombreCombinacionString;
            if(Module::isEnabled('imaxmultialmacen')){
                $resultado['stock'] = '-';
            }else{
                $resultado['stock'] = StockAvailable::getQuantityAvailableByProduct($idsProducto['id_product'], $idsProducto['id_product_attribute']);
            }
            $resultado['referencia'] = $referencia;
            $resultado['ubicacion'] = StockAvailable::getLocation($idsProducto['id_product'], $idsProducto['id_product_attribute']);
            $html = '';
            if(Module::isEnabled('imaxmultialmacen')){
                $imaxMultialmacen = Module::getInstanceByName('imaxmultialmacen');
                foreach($imaxMultialmacen->getFunciones()->obtenerAlmacenesProducto($resultado['id_product'],$resultado['id_product_attribute'], true) as $datosAlmacenes) {
                    $html .= '<table id="tablaStocks"><thead><tr><th>'.$this->l('Almacén / Ubicación').'</th><th>'.$this->l('Stock físico').'</th><th>'.$this->l('Stock usable').'</th></tr></thead><tbody>';
                    foreach($datosAlmacenes['almacenes'] as $almacen) {
                        $html .= "<tr><td>{$almacen['nombre']}</td><td>{$almacen['physical_quantity']}</td><td>{$almacen['usable_quantity']}</td></tr>";
                    }
                    $html .= '</tbody></table>';
                }
            }
            $resultado['tablaStocks'] = $html;
        }
        
        return $resultado;
    }
    
    private function checkLicenciaAdicional($nombreModulo, $numLicencia, $force = 0) {
        $data = array();
        $check = $this->getCheckLicenciaAdicional($nombreModulo);
        $url = Configuration::getGlobalValue(self::prefijo.'F_SERVER');
        $data['server'] = self::getDomain();
        $data['modulo'] = $nombreModulo;
        $data['action'] = 'checkLicenciaAdicional';
        $data['licencia'] = $numLicencia;
        if ($check >= 100 || $force == 1) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $datos = curl_exec($ch);
            $datos = json_decode($datos);
            $info = curl_getinfo($ch);
            if (!is_null($datos)) {
                if ($datos->codError != 0) {
                    $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
                    $this->updateValidateLicenciaAdicional($nombreModulo, 0);
                    return false;
                }
                else {
                    $this->updateCheckLicenciaAdicional($nombreModulo, 0);
                    $this->updateValidateLicenciaAdicional($nombreModulo, 1);
                    return true;
                }
            }
            else {
                $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
                $this->updateValidateLicenciaAdicional($nombreModulo, 0);
                return false;
            }
        }
        else {
            $this->updateCheckLicenciaAdicional($nombreModulo, $check + 1);
            return true;
        }
    }
    
    private function getOtrasLicencias() {
        $sql = 'SELECT * FROM '._DB_PREFIX_.self::prefijo.'licencias';
        return Db::getInstance()->executeS($sql);
    }

    private function getLicenciaAdicional($nombreModulo, $validada = true) {
        $sql = 'SELECT licencia FROM `'._DB_PREFIX_.self::prefijo.'licencias`'
                .' WHERE '
                .' nombre = "'.trim($nombreModulo).'"'.($validada ? ' AND validate = 1' : '');
        return DB::getInstance()->getValue($sql);
    }

    private function getCheckLicenciaAdicional($nombreModulo) {
        $sql = 'SELECT numCheck FROM `'._DB_PREFIX_.self::prefijo.'licencias`'
                .' WHERE '
                .' nombre = "'.trim($nombreModulo).'"';
        return DB::getInstance()->getValue($sql);
    }

    private function updateCheckLicenciaAdicional($nombreModulo, $numCheck) {
        $sql = 'UPDATE `'._DB_PREFIX_.self::prefijo.'licencias`'
                .' SET numCheck='.$numCheck.' '
                .' WHERE nombre="'.$nombreModulo.'"';
        return DB::getInstance()->execute($sql);
    }

    private function updateValidateLicenciaAdicional($nombreModulo, $activo) {
        $sql = 'UPDATE `'._DB_PREFIX_.self::prefijo.'licencias`'
                .' SET validate='.$activo.' '
                .' WHERE nombre="'.$nombreModulo.'"';
        return DB::getInstance()->execute($sql);
    }

    private function _mostrarLicencia() {
        $html = '';
        $licencia = Configuration::getGlobalValue(self::prefijo.'LICENCIA');
        $html .= '<fieldset><legend>'.$this->l('Licencia Principal').'</legend>';
        $html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">';
        $html .= '<p class="warn">'.$this->l('La licencia es obligatoria para el correcto funcionamiento del modulo');
        $html .= '<br />';
        $html .= $this->l('La licencia se deberia generar para el dominio: ').self::getDomain().'</p>';
        $html .= '<ul class="listaLicencia">';
        $html .= ' <li><label>'.$this->l('Numero de Licencia').'</label>';
        $html .= '<input type="text" name="licencia" value="'.$licencia.'" /></li>';
        $html .= '<input type="submit" name="submitLicencia" value="'.$this->l('Guardar').'" />';
        $html .= '<input type="hidden" name="action" value="gestionLicencia">';
        $html .= '<input type="hidden" name="idTab" value="3" />';
        $html .= '</form>';
        $html .= '</fieldset>';

        include(dirname(__FILE__)."/configuration.php");
        if (isset($plugins) && is_array($plugins) && !empty($plugins)) {
            $licenciasAdicionales = $this->getOtrasLicencias();
            $html .= '<br/><fieldset><legend>'.$this->l('Licencias Adicionales').'</legend>';
            $html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">';
            $html .= '<div class="bootstrap">';
            $html .= '<div class="module_confirmation conf confirm alert alert-success">';
            $html .= $this->l('Introduzca las licencias para los plugins adicionales');
            $html .= '<br />';
            $html .= $this->l('Puede obtener las licencias en: ');
            $html .= '<a href="tienda.informax.es" target="_blank">tienda.informax.es</a>';
            $html .= '</div>';
            $html .= '</div>';
            $html .= '<table class="table tableDnD tablaImportProductos listaLicencia">';
            $html .= '<tr>';
            $html .= '<th>'.$this->l('Nombre Plugin').'</th>';
            $html .= '<th>'.$this->l('Licencia').'</th>';
            $html .= '<th>'.$this->l('Estado').'</th>';
            $html .= '</tr>';
            foreach ($plugins AS $plugin) {
                $html .= '<tr>';
                $html .= '<td>';
                $html .= $plugin['nombre'].' ('.$plugin['descripcion'].')';
                $html .= '</td>';
                $valorLicencia = '';
                $estado = 'ausente';
                foreach ($licenciasAdicionales AS $licenciaAdicional) {
                    if ($licenciaAdicional['nombre'] == $plugin['nombre']) {
                        $valorLicencia = $licenciaAdicional['licencia'];
                        if ($licenciaAdicional['validate'] == 0) {
                            $estado = 'incorrecta';
                        }
                        else if ($licenciaAdicional['validate'] == 1) {
                            $estado = 'correcta';
                        }
                        continue;
                    }
                }
                $html .= '<td>';
                $html .= '<input type="text" name="licenciaAdicional['.$plugin['nombre'].']" value="'.$valorLicencia.'">';
                $html .= '</td>';
                $html .= '<td>';
                $html .= '<img src="'.$this->_path.'/css/estadoLicencia_'.$estado.'.png" alt="Licencia '.$estado.'" title="Licencia '.$estado.'">';
                $html .= '</td>';
                $html .= '</tr>';
            }
            $html .= '</table>';
            $html .= '<input type="submit" name="submitLicenciaAdicional" value="'.$this->l('Guardar').'" />';
            $html .= '<input type="hidden" name="action" value="gestionLicenciaAdicional">';
            $html .= '<input type="hidden" name="idTab" value="3" />';
            $html .= '</form>';
            $html .= '</fieldset>';
        }
        return $html;
    }

    private function _checkVersion() {
        return false;
    }

    public function hookActionProductSave($params) {
        
    }

    public function hookDisplayAdminOrder($params) {
        
    }

    public function hookDisplayProductExtra($params) {
        
    }

    function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addCss($this->_path.'css/'.$css, 'all');
        }
//$this->_html .= '<link type="text/css" rel="stylesheet" href="../modules/' . $this->name . '/css/' . $css . '" />' . "\n";
        return;
    }

    function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addJs($this->_path.'js/'.$js);
        }
//$this->_html .= '<link type="text/css" rel="stylesheet" href="../modules/' . $this->name . '/css/' . $css . '" />' . "\n";
        return;
    }

    function addJqueryUI($plugin) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addJqueryUI($plugin);
        }
        return;
    }

    public function createHelpHeader() {
        $html = '<div class="module-preheader">';
        $html .= $this->getDatosPubli('header');
        $html .= '</div>';

        $html .= '<div class="module-header">';
        $html .= '<div class="module-title-container">';
        $html .= '<h2 class="module-title">'.$this->displayName.'<small> by Informax</small></h2>';
        $html .= '<h3 class="module-version">'.$this->l('Version: ').$this->version.'</h3>';
        $html .= '</div>';

        $html .= '<div class="module-toolbar">';
        $html .= '<ul class="module-nav" >';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://www.informax.es">';
        $html .= '<img src="../modules/'.$this->name.'/img/informax.png">';
        $html .= '<div>'.$this->l('Informax').'</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://tickets.informax.es/open.php?topicId=10">';
        $html .= '<img src="../modules/'.$this->name.'/img/abrir-ticket.png">';
        $html .= '<div>'.$this->l('Asistencia').'</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://docs.informax.es/?p='.$this->idManual.'">';
        $html .= '<img src="../modules/'.$this->name.'/img/ir-a-manuales.png">';
        $html .= '<div>'.$this->l('Manuales').'</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getModuleFooter() {
        $url = Configuration::getGlobalValue(self::prefijo.'URL_FALDON');
        $html = '<div class="module-newsletter">';
        $html .= '<form action="http://www.informax.es/subscribe/" method="post" target="_blank">
                    <input type="hidden" name="accion" value="newsletter">
                    <input type="hidden" name="idTab" value="1" />';
        $html .= '<p>'.$this->l('Si deseas enterarte de todos los cambios en nuestros modulos, nuevos Modulos, como funciona Prestashop, apuntate a nuestras news').'</p>';
        $html .= ' <p>';
        $html .= ' <label>'.$this->l('email').'</label>';
        $html .= '<input type="text" name="email" value="" />';
        $html .= '<input type="submit" name="subscribe" value="'.$this->l('Guardar').'" />';
        $html .= '</p>';
        $html .= '</form><br />';
        $html .= '</div>';
        $html .= '<div class="module-footer">';
        $html .= '<div class="module-footer-left">';
        $html .= $this->getDatosPubli('footera');
        $html .= '</div>';
        $html .= '<div class="module-footer-right">';
        $html .= $this->getDatosPubli('footerb');
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getDatosPubli($tipo) {
        $datosCompletos = Configuration::getGlobalValue(self::prefijo.'TXT_FILE');

        $html = '';
        if ($datosCompletos) {
            $aperturaA = '';
            $cierreA = '';
            $datosCompletos = @unserialize($datosCompletos);
            if (!is_array($datosCompletos)) {
                return '';
            }
            shuffle($datosCompletos);
            foreach ($datosCompletos AS $datoElemento) {
                if ($datoElemento[1] == $tipo) {
                    if (trim($datoElemento[2]) != '') {
                        $aperturaA .= '<a href="'.$datoElemento[2].'" target="_blank">';
                        $cierreA = '</a>';
                    }
                    if (trim($datoElemento[0]) != '') {
                        $html = $aperturaA.'<img src="'.Configuration::getGlobalValue(self::prefijo.'URL_TXT').'/img/'.$datoElemento[0].'" />'.$cierreA;
                    }
                    return $html;
                }
            }
        }
        return $html;
    }

    public function getTxtFiles() {
        if (Configuration::getGlobalValue(self::prefijo.'DESCARGA_ARCHIVO') < 10000) {
            Configuration::updateGlobalValue(self::prefijo.'DESCARGA_ARCHIVO', Configuration::getGlobalValue(self::prefijo.'DESCARGA_ARCHIVO') + 1);
            return false;
        }
        $url = Configuration::getGlobalValue(self::prefijo.'URL_TXT').'/'.Configuration::getGlobalValue(self::prefijo.'TIPO').'.txt';
        $basedir_active = ini_get('open_basedir');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        if (!$basedir_active) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);
        if (!isset($infoCurl['http_code']) || $infoCurl['http_code'] != 200) {

            return false;
        }
        Configuration::updateGlobalValue(self::prefijo.'DESCARGA_ARCHIVO', 0);
        return Configuration::updateGlobalValue(self::prefijo.'TXT_FILE', $this->readCsv($datos));
    }

    private function readCsv($string) {
        $string = trim($string);
        $temp = explode("\n", $string);
        $respuesta = array();
        foreach ($temp AS $elemento) {
            $elementoInterno = array();
            $elementoInterno = explode(";", $elemento);
            $respuesta[] = $elementoInterno;
        }
        return serialize($respuesta);
    }

    function l($msg, $modulo = '', $locale = NULL) {
        if ($modulo == '') {
            $modulo = 'traducciones'.strtolower($this->name);
        }
        return parent::l($msg, $modulo);
    }

    /**
     * Crea un nuevo tab.
     * @param string $clase
     * @param string $nombre
     * @param string $padre
     * @return boolean
     */
    private function crearTab($clase, $nombre, $padre = '') {
        if (!Tab::getIdFromClassName($clase)) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $clase;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $nombre;
            }
            if ($padre == '') {
                $posicion = 0;
            }
            else {
                $posicion = Tab::getIdFromClassName($padre);
            }
            $tab->id_parent = intval($posicion);
            $tab->module = $this->name;
            try {
                if (!$tab->add()) {
                    return false;
                }
            }
            catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Borra un tab.
     * @param string $clase
     * @return boolean
     */
    private function borrarTab($clase) {
        $id_tab = (int)Tab::getIdFromClassName($clase);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            try {
                if (!$tab->delete()) {
                    return false;
                }
            }
            catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    private function installTab() {
        include(dirname(__FILE__).'/configuration.php');

        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Desinstala los tabs del módulo.
     * @return boolean
     */
    private function uninstallTab() {
        include(dirname(__FILE__).'/configuration.php');

        //Desinstalamos las tabs de este módulo
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                if (!$this->borrarTab($moduleTab['clase'])) {
                    return false;
                }
            }
        }

        //Desinstalamos el root si está vacío
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $id_tab = (int)Tab::getIdFromClassName($moduleTabRoot['clase']);
            if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
                if (!$this->borrarTab($moduleTabRoot['clase'])) {
                    return false;
                }
            }
        }

        return true;
    }

    private function checkLicencia($force = 0) {
        $data = array();
        $f = Configuration::getGlobalValue(self::prefijo.'F');
        $check = Configuration::getGlobalValue(self::prefijo.'F_CHECK');
        $url = Configuration::getGlobalValue(self::prefijo.'F_SERVER');
        $data['server'] = $this->getDomain();
        $data['modulo'] = $this->name;
        $data['action'] = 'checkLicencia';
        $data['licencia'] = Configuration::getGlobalValue(self::prefijo.'LICENCIA');
        if ($check >= 100 || $force == 1) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $datos = curl_exec($ch);
            $datos = json_decode($datos);
            $info = curl_getinfo($ch);
            if (!$datos || $datos->codError != 0) {
                Configuration::updateGlobalValue(self::prefijo.'F', '');
                Configuration::updateGlobalValue(self::prefijo.'F_CHECK', (int)$check + 1);
                return false;
            }
            else {
                Configuration::updateGlobalValue(self::prefijo.'F', $datos->msgError);
                Configuration::updateGlobalValue(self::prefijo.'F_CHECK', 0);
                return true;
            }
        }
        else {
            Configuration::updateGlobalValue(self::prefijo.'F_CHECK', (int)$check + 1);
            return true;
        }
    }

    private function cargarMapeoFormasPago() {
        if (!function_exists('cargarMapeoFormasPago_')) {
            $function = $this->getFunction();
            eval(gzuncompress(base64_decode($function)));
        }
        if (function_exists('cargarMapeoFormasPago_')) {
            return cargarMapeoFormasPago_($this->tabla);
        }

        echo $this->l('Este modulo no tiene una licencia valida');
        echo '<br />';
        echo $this->l('Contacte con nosotros para obtener una licencia valida');
        die();
    }

    private function getFunction() {
        $function = Configuration::getGlobalValue($this->sufijo.'F');
        return $function;
    }

    private static function getUrlAdmin() {
        $temp = explode('/', $_SERVER['PHP_SELF']);
        $dummy = array_pop(($temp));
        $urlAdmin = implode('/', $temp);
        if (Configuration::get('PS_SSL_ENABLED') == 1) {
            $url = 'https://';
        }
        else {
            $url = 'http://';
        }
        $url .= $_SERVER['SERVER_NAME'].$urlAdmin.'/';
        return $url;
    }

    public function displayWarning($error) {
        if ($this->versionPS == 15) {
            $output = '
			<div class="module_error alert warn">
				'.$error.'
			</div>';
        }
        else {
            $output = '<div class="bootstrap">'
                    .'<p class="warning warn alert alert-warning">'
                    .$error.
                    '</p></div>';
        }
        return $output;
    }

    public function getDomain() {
        $idShopDefault = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        $tienda = new Shop($idShopDefault);
        if (Validate::isLoadedObject($tienda)) {
            if (isset($tienda->domain)) {
                return $tienda->domain;
            }
        } return false;
    }

    /**
     * Busca un producto o combinaición por su referencia
     * @param mixed $reference
     * @return array
     */
    public function buscarReferencia($reference) {
        $reference = pSQL(trim($reference));
    
        $resultado = array();
        if($reference) {
            $sql = 'SELECT id_product , id_product_attribute '
                    . ' FROM ' . _DB_PREFIX_ . 'product_attribute '
                    . " WHERE reference = '$reference'";
            $resultado = Db::getInstance()->getRow($sql);
            if (!$resultado) {
                $sql = 'SELECT id_product ,0 AS id_product_attribute '
                        . ' FROM ' . _DB_PREFIX_ . 'product '
                        . " WHERE reference = '$reference'";
                $resultado = Db::getInstance()->getRow($sql);
            }
        }
    
        return $resultado;
    }
    
    /**
     * Elimina del array de almacenes los almacenes virtuales
     * @param array $almacenes
     * @return array
     */
    public function quitarAlmacenStockVirtual($almacenes) {
        Module::getInstanceByName('imaxmultialmacen');
        require_once dirname(__FILE__).'/../imaxmultialmacen/classes/AlmacenStockVirtual.php';
        $almacenesStockVirtualActuales = AlmacenStockVirtual::cargarRelaciones();
        
        // Obtener todos los id_warehouse de almacenesStockVirtualActuales en una lista
        $almacenesStockVirtualIds = array_keys($almacenesStockVirtualActuales);
    
        // Filtrar los almacenes para quitar los que están en almacenesStockVirtualIds
        $almacenesFiltrados = array_filter($almacenes, function($almacen) use ($almacenesStockVirtualIds) {
            return !in_array($almacen['id_warehouse'], $almacenesStockVirtualIds);
        });
        return $almacenesFiltrados;
    }

    /**
     * Devuelve la cantidad física de un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getStock($id_product, $id_product_attribute = null, $id_warehouse = null) {
        if($id_warehouse){
            $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
            $stock = new Stock($idStock);
            $resultado = ['quantity' => $stock->usable_quantity, 'physical_quantity' => $stock->physical_quantity];
        }else{
            $db = Db::getInstance();
            $id_product_attribute_condition = $id_product_attribute ? ' AND id_product_attribute = ' . (int)$id_product_attribute : ' AND id_product_attribute = 0';
            $sql = 'SELECT quantity, physical_quantity FROM ' . _DB_PREFIX_ . 'stock_available WHERE id_product = ' . (int)$id_product . $id_product_attribute_condition;
            $resultado = $db->getRow($sql);
        }
        return $resultado;
    }

    /**
     * Genera movimientos de stock de un producto
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     * @param int $razon
     * @param int $almacen
     */
    function generarMovimiento($id_product, $id_product_attribute, $cantidad, $razon, $almacen){ 
        if(Module::isEnabled('gestavdstock')) {
                Module::getInstanceByName('imaxmultialmacen');
                $lang_id = Context::getContext()->language->id;
                $id_employee = Context::getContext()->employee->id;
                $product = new Product($id_product, false, $lang_id);
                $product_name=$product->name;
                if($id_product_attribute){
                    $combination = new Combination($id_product_attribute, $lang_id);
                    $reference = pSQL($combination->reference);
                }else{
                    $reference= pSQL($product->reference);
                }
                $stock = $this->getStock($id_product, $id_product_attribute, $almacen);
                $mvt_physical = (int)$cantidad;
                $mvt_reserved = 0;
                $sign=-1;
                if($mvt_physical>0){
                    $sign=1;   
                }
    
                $stockMvtReasons = StockMvtReason::getStockMvtReasons($lang_id);
                $stockMvtReasonsFormat = array();
                foreach($stockMvtReasons as $stockMvtReason){
                    $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
                }
                $id_stock_mvt_reason = $stockMvtReasonsFormat[$razon];       
                $comments = $stockMvtReasonsFormat[$razon];
                $date_add= date('Y-m-d H:i:s');
                $physical_quantity = $stock['physical_quantity'] + (int)$cantidad;
    
                $sql = '
                    SELECT * FROM `'._DB_PREFIX_.'stock_available_advanced` saa
                        INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema 
                            ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
                    WHERE id_product="'.(int)$id_product.'" and id_product_attribute="'.(int)$id_product_attribute.'" 
                        and id_warehouse = "'.(int)$almacen.'" 
                    order by date_add DESC';
                
                if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity = $row['reserved_quantity'];
                }else{
                    $reserved_quantity = 0;
                }
                
                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced 
                        (id_order, id_order_status, product_name,reference,id_product,id_product_attribute,
                        stock_quantity, physical_quantity, reserved_quantity,
                        mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
                        VALUES (0, 0, "'.$product_name.'","'.$reference.'","'.$id_product.'",
                        "'.$id_product_attribute.'","'.$stock['quantity'].'",
                        "'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'",
                        "'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'",
                        "'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';
                Db::getInstance()->execute($sql);
                $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
                Configuration::set(ImaxMultiAlmacen::prefijo. 'ALMACEN_GENERAL', $almacen);
                Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
                (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $almacen)");
            }
        
                           
            return (new \PrestaShop\PrestaShop\Core\Stock\StockManager())->saveMovement(
                $id_product,
                $id_product_attribute,
                $cantidad,
                array(
                    'id_stock_mvt_reason' => $razon,
                )
            );
    }
}