<?php

class imaxAcordeon extends Module {
    protected $context, $_path;

    function __construct($modulePath) {
        $this->context = Context::getContext();
        $this->_path = $modulePath;
        $this->addCSS('acordeon.css');
        $this->addJS('acordeon.js');
        parent::__construct();
    }

    /**
     * CREA UN ACORDEN
     * @param string $titulo Titulo del acordeon
     * @param string $contenido Html con todo el contenido
     * @param boolean $interno True si va a estar dentro de otro acordeon
     */
    function renderAcordeon($titulo, $contenido, $interno = false) {
        $class = 'acordeon';
        if ($interno != false) {
            $class = 'acordeonInterno';
        }
        $html = '';
        $html = '<dl class="' . $class . '">';
        $html .= '<dt>' . $titulo . '</dt>';
        $html .= '<dd>';
        $html .= $contenido;
        $html .= '</dd>';
        $html .= '</dl>';
        return $html;
    }

    private function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addCss($this->_path . 'acordeon/' . $css, 'all');
        }
        return;
    }

    private function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addJs($this->_path . 'acordeon/' . $js);
        }
        return;
    }

}
