<?php
define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxrecoleccionpda.php');

$context = Context::getContext();
$modulo = new imaxrecoleccionpda();
$multiAlmacen = Module::getInstanceByName('imaxmultialmacen');

//Comprobamos logueo
if(empty($context->employee->id) || !$context->employee->isLoggedBack()) {
    Tools::redirectAdmin($context->shop->getBaseURL().'modules/imaxrecoleccionpda/pda/index.php');
}


$urlImaximprimepedidosservidor = $context->link->getBaseLink().'modules/imaximprimepedidosservidor/menu';
$options = '';


$almacenes = $multiAlmacen->getFunciones()->getWarehouses(true, null, false);
$almacenes = array_values($modulo->quitarAlmacenStockVirtual($almacenes));
$almacenes = array_map(function($almacen) {
    return [
        'id' => $almacen['id_warehouse'],
        'idBusquedas' => $almacen['reference'],
        'nombre' => $almacen['name'],
    ];
}, $almacenes);

$cuerpo = 'principal.php';
$js[] = 'principal.js';
$js[] = 'ProductosPedidos.js';
$js[] = 'ProductosAsignados.js';
$js[] = 'AsignacionIndividual.js';
$css[] = 'principal.css';
$css[] = 'asignacionIndividual.css';
$traducciones = array('mensaje_errorProducto' => $modulo->l('Error al obtener el producto.', 'imaxrecoleccionpda'), 
    'mensaje_errorRegistrarMovimiento' => $modulo->l('Error al registrar movimiento de stock del producto.', 'imaxrecoleccionpda'), 
    'mensaje_registrarMovimiento' => $modulo->l('Movimiento de stock del producto registrado correctamente.', 'imaxrecoleccionpda'),
    'mensaje_errorAlmacenesIguales' => $modulo->l('El almacén origen y el almacén destino tienen que ser distintos.', 'imaxrecoleccionpda'),
    'mensaje_asignarProducto' => $modulo->l('Producto asignado correctamente.', 'imaxrecoleccionpda'),
    'mensaje_errorAsignarProducto' => $modulo->l('Ha ocurrido un error al asigna el producto.', 'imaxrecoleccionpda'),
    'mensaje_desasignarProducto' => $modulo->l('Producto desasignado correctamente.', 'imaxrecoleccionpda'),
    'mensaje_errorDesasignarProducto' => $modulo->l('Ha ocurrido un error al desasigna el producto.', 'imaxrecoleccionpda'),
    'mensaje_guardarRecoleccion' => $modulo->l('Productos guardados correctamente.', 'imaxrecoleccionpda'),
    'mensaje_errorGuardarRecoleccion' => $modulo->l('Ha ocurrido un error al guardar los productos.', 'imaxrecoleccionpda'),
    'mensaje_errorDemasiadaCantidad' => $modulo->l('La cantidad introducida tiene que ser menor o igual a la cantidad disponible.', 'imaxrecoleccionpda'),
    'mensaje_errorCantidadNegativa' => $modulo->l('La cantidad introducida debe ser mayor a cero.', 'imaxmovimientospda')
);

$nombreUsuario = $context->employee->firstname;
$idUsuario = $context->employee->id;
$nombrePagina = $modulo->l('Producto', 'ImaxImprimePedidosServidor');
$srcLogo = $context->link->getBaseLink().'img/'.Configuration::get('PS_LOGO');
require_once 'vistas/base.php';