$(function () {

    // Variable para almacenar el input activo
    let inputActivo;
    var productosPedidos = new ProductosPedidos();
    var popUp = new AsignacionIndividual(almacenes, function(elemento) {
        // Usa la referencia al input activo para asignar los valores
        $(inputActivo).attr('data-idwarehouse', elemento.id);
        $(inputActivo).val(elemento.nombre);
    });

    var productosAsignados = new ProductosAsignados(inputActivo);

    $('#contenedorRM').hide();
    
    /**
     * Hace foco en sobre el elemento que le pasamos
     * @param {string} inputName 
     */
    function focoEnInput(inputName) {
        var input = $('input[name="' + inputName + '"]');
        if(!input.is(':focus')) {
            input.attr('readonly', 'readonly');
            input.focus();
            input.get(0).selectionStart = input.get(0).selectionEnd = input.val().length;
            setTimeout(function() {
                input.removeAttr('readonly');
            }, 50);
        }
    }
    
    //Iniciamos
    productosPedidos.mostrarTabla();
    
    $('#guardarRecoleccion').click(function(){
        $.getJSON('ajax.php?callback=?', {
            accion: 'guardarRecoleccion'
        }, function (respuesta) {
            if (respuesta.ok) {
                $('#contenedorProductos table').remove();
                $('#contenedorProductos').hide();
                $('#contenedorGuardar').hide();
                $('#contenedorRecoleccion').show();
                $('#contenedorCancelar').show();
                mensaje(mensaje_guardarRecoleccion, 'correcto');
                var $productos = respuesta.datos;
                productosAsignados.generarTablaProductosAsignados($productos);
            }
            else {
                mensaje(mensaje_errorGuardarRecoleccion, 'error');
            }
        });
    });

    $('#cancelarRecoleccion').click(function(){
        $('#contenedorRecoleccion table').remove();
        $('#contenedorProductos').show();
        $('#contenedorGuardar').show();
        $('#contenedorRecoleccion').hide();
        $('#contenedorCancelar').hide();
        productosPedidos.mostrarTabla();
    });

    $('#registrarMovimiento').click(function() {
        var stockDisponible = parseInt($('#stockDisponible').html());
        var cantidad = parseInt($('#cantidad').val());
        if(isNaN(cantidad) || cantidad <= 0){
            mensaje(mensaje_errorCantidadNegativa, 'error');
        }else if(isNaN(stockDisponible)  || cantidad <= stockDisponible){
            productosAsignados.registrarMovimiento();
        }else{
            mensaje(mensaje_errorDemasiadaCantidad, 'error');
        }
    });

    $('input[name="cantidad"]').keyup(function(e) {
        if(e.keyCode == 13) {
            var stockDisponible = parseInt($('#stockDisponible').html());
            var cantidad = parseInt($('#cantidad').val());
            if(isNaN(cantidad) || cantidad <= 0){
                mensaje(mensaje_errorCantidadNegativa, 'error');
            }else if(isNaN(stockDisponible)  || cantidad <= stockDisponible){
                productosAsignados.registrarMovimiento();
            }else{
                mensaje(mensaje_errorDemasiadaCantidad, 'error');
            }
        }
    });


    // Evento de selección para inputs de almacén
    $('#inputAlmacenOrigen, #inputAlmacenDestino').on('click', function(e) {
        $(this).select();
    });

    // Evento de keyup para ambos inputs
    $('#inputAlmacenOrigen, #inputAlmacenDestino').on('keyup', function(e) {
        if (e.keyCode == 13) {
            inputActivo = this; // Asigna el input que activó el evento
            productosAsignados.setInputActivo(inputActivo);
            let tipoAlmacen = $(this).attr('id') === 'inputAlmacenOrigen' ? 'Almacenes Origen' : 'Almacenes Destino';

            // Muestra el pop-up correspondiente
            let almacenDestinoVal = $('#inputAlmacenDestino').val();
            let popUpOrigen = productosAsignados.getPopUpOringen();
            (tipoAlmacen === 'Almacenes Origen') ? popUpOrigen.mostrar(tipoAlmacen) : popUp.mostrar(tipoAlmacen);

            $('input[name="textoBusquedaIndividual"]').val($(this).val());
            $('input[name="textoBusquedaIndividual"]').trigger($.Event('keyup', { keyCode: 13 }));

            // Define el próximo foco según el input activo
            let siguienteInput = (tipoAlmacen === 'Almacenes Origen' && !almacenDestinoVal) ? 'inputAlmacenDestino' : 'cantidad';

            // Evento para la selección de la lista
            $('.listadoIndividual li span').click(function(e) {
                focoEnInput(siguienteInput);
            });

            // Evento de keyup para textoBusquedaIndividual
            $('input[name="textoBusquedaIndividual"]').keyup(function(e) {
                if (e.keyCode == 13) {
                    focoEnInput();
                }
            });

            focoEnInput(siguienteInput);
        }
    });
});