class ProductosPedidos {
    constructor(){
        this.productos = [];

    }

    /**
     * Carga los productos atendiendo a los estado seleccionados y generamos la tabla
     */
    mostrarTabla(){
        var esto = this;
        $.getJSON('ajax.php?callback=?', {
            accion: 'obtenerProductos'
        }, function (respuesta) {
            if (respuesta.ok) {
                esto.productos = respuesta.datos;
                esto.generarTablaProductos();
            }
        });
    }

    /**
     * Carga el html con la tabla de los productos
     */
    generarTablaProductos() {
        var esto = this;
        var $contenedor = $('#contenedorProductos');
        var tabla = '<table><tr class="noClick"><th>Nombre</th><th>Cantidad</th></tr>';

        $.each(this.productos, function(index, producto) {
            var clase = '';
            if(producto.idUsuario){
                if(producto.idUsuario == idUsuario){
                    clase = 'seleccionado';
                }else{
                    clase = 'noSeleccionable';
                }
            }
            tabla += '<tr class="' + clase + '" data-id_producto="' + producto.id_producto + '" data-id_combinacion="' + producto.id_combinacion + '" data-ids_pedidos="' + producto.ids_pedidos + '" data-id_usuario="' + producto.idUsuario + '" >' +
                     '<td>' + producto.nombre + '</td>' +
                     '<td>' + producto.cantidad + '</td>' +
                     '</tr>';
        });

        tabla += '</table>';
        $('#contenedorProductos table').remove();
        $contenedor.append(tabla);
        
        $('#contenedorProductos tr').click(function(){
            $(this).toggleClass('seleccionado');
            
            if ($(this).hasClass('seleccionado')) {
                $.getJSON('ajax.php?callback=?', {
                    accion: 'asignarProducto',
                    id_product: $(this).data('id_producto'),
                    id_product_attribute: $(this).data('id_combinacion'),
                    idsPedidos : $(this).data('ids_pedidos'),
                }, function (respuesta) {
                    if (respuesta.ok) {
                        esto.mostrarTabla()
                        mensaje(mensaje_asignarProducto, 'correcto');
                    }
                    else {
                        mensaje(mensaje_errorAsignarProducto, 'error');
                    }
                });
            } else {
                $.getJSON('ajax.php?callback=?', {
                    accion: 'desasignarProducto',
                    id_product: $(this).data('id_producto'),
                    id_product_attribute: $(this).data('id_combinacion'),
                    idsPedidos : $(this).data('ids_pedidos'),
                    cantidad : $(this).find('td:eq(1)').text()
                }, function (respuesta) {
                    if (respuesta.ok) {
                        esto.mostrarTabla();
                        mensaje(mensaje_desasignarProducto, 'correcto');
                    }
                    else {
                        mensaje(mensaje_errorDesasignarProducto, 'error');
                    }
                });
            }
        });
    }
}