class ProductosAsignados {
    constructor(inputActivo){
        this.id_product;
        this.id_product_attribute;
        this.popUpOrigen;
        this.inputActivo = inputActivo;
    }
    generarTablaProductosAsignados(productos){
        var $contenedor = $('#contenedorRecoleccion');
        var tabla = '<table><tr class="noClick"><th>Nombre</th><th>Cantidad</th></tr>';

        $.each(productos, function(index, producto) {
            tabla += '<tr data-id_producto="' + producto.id_product + '" data-id_combinacion="' + producto.id_product_attribute + '" data-ids_pedidos="' + producto.ids_pedidos + '" data-id_usuario="" >' +
                     '<td>' + producto.nombre + '</td>' +
                     '<td>' + producto.cantidad + '</td>' +
                     '</tr>';
        });

        tabla += '</table>';
        $contenedor.append(tabla);
        var esto = this;
        $('#contenedorRecoleccion tr').on('click', function() {
            $(this).addClass('seleccionado');
            setTimeout(() => {
                $.getJSON('ajax.php?callback=?', {
                    accion: 'obtenerProducto',
                    id_product: $(this).data('id_producto'),
                    id_product_attribute: $(this).data('id_combinacion'),
                    idsPedidos : $(this).data('ids_pedidos'),
                    cantidad : $(this).find('td:eq(1)').text()
                }, function (respuesta) {
                    if (respuesta.ok) {
                        $('#contenedorRecoleccion table').remove();
                        $('#idsPedidos').val(respuesta.datos.idsPedidos);
                        $('#infoProducto').html('<strong>' + respuesta.datos.nombre + '</strong>' + '<img src="' + respuesta.datos.imagen + '" alt=""/> ');
                        $('#infoProducto').after(respuesta.datos.tablaStocks);
                        $('#referencia').html(respuesta.datos.referencia);
                        $('#ubicacionActual td:last-child').html(respuesta.datos.ubicacion);
                        $('#cantidad').val(respuesta.datos.cantidad);
                        if(respuesta.datos.almacenSalidaPorDefecto){
                            $('#inputAlmacenDestino').val(respuesta.datos.almacenSalidaPorDefecto.name);
                            $('#inputAlmacenDestino').attr('data-idwarehouse', respuesta.datos.almacenSalidaPorDefecto.id_warehouse);
                        }
                        $('#contenedorRecoleccion').hide();
                        $('#contenedorCancelar').hide();
                        $('#contenedorCuerpo').show();
                        $('#contenedorRM').show();
                        esto.id_product = respuesta.datos.id_product;
                        esto.id_product_attribute = respuesta.datos.id_product_attribute;
                        esto.almacenesOrigen = respuesta.datos.almacenesOrigen;
                        esto.popUpOrigen = new AsignacionIndividual(esto.almacenesOrigen, function(elemento) {
                            // Usa la referencia al input activo para asignar los valores
                            $(esto.inputActivo).attr('data-idwarehouse', elemento.id);
                            $(esto.inputActivo).val(elemento.nombre);
                        });
                        esto.focoEnInput('inputAlmacenOrigen');
                    }
                    else {
                        esto.limpiarControles();
                        
                        mensaje(mensaje_errorProducto, 'error');
                    }
                });
            }, 500); // 1000 milisegundos = 1 segundo
        });
        $('#cancelarMovimiento').off('click').on('click', function() {
            esto.limpiarControles();
        });
        
    
    }
    
    /**
     * Hace foco en sobre el elemento que le pasamos
     * @param {string} inputName 
     */
    focoEnInput(inputName) {
        var input = $('input[name="' + inputName + '"]');
        if(!input.is(':focus')) {
            input.attr('readonly', 'readonly');
            input.focus();
            input.get(0).selectionStart = input.get(0).selectionEnd = input.val().length;
            setTimeout(function() {
                input.removeAttr('readonly');
            }, 50);
        }
    }

    /**
     * Registrar el movimiento de stock de un producto
     */
    registrarMovimiento() {
        var esto = this;
        var idsPedidos = $('#idsPedidos').val();
        var almacenOrigen = $('#inputAlmacenOrigen').data('idwarehouse');
        var almacenDestino  = $('#inputAlmacenDestino').data('idwarehouse');
        if(almacenOrigen == almacenDestino){
            mensaje(mensaje_errorAlmacenesIguales, 'error');

        }else{
            $.getJSON('ajax.php?callback=?', {
                accion: 'registrarMovimiento',
                id_product: esto.id_product,
                id_product_attribute: esto.id_product_attribute,
                almacenOrigen : almacenOrigen,
                almacenDestino : almacenDestino,
                idsPedidos : idsPedidos,
                cantidad : $('#cantidad').val()
            }, function (respuesta) {
                esto.limpiarControles();
                if (respuesta.ok) {
                    mensaje(mensaje_registrarMovimiento, 'correcto');
                }
                else {
                    mensaje(mensaje_errorRegistrarMovimiento, 'error');
                }
            });
        }
    }

    /**
     * Modifica los controles para solicitar otro ean.
     */
    limpiarControles() {
        var esto = this;
        $('#tablaStocks').remove();
        $('#cantidad').val('');
        $('#infoProducto').html('');
        $('#inputAlmacenOrigen').val('').attr('data-idwarehouse', '');
        $('#inputAlmacenDestino').val('').attr('data-idwarehouse', '');
        $('#contenedorCuerpo').hide();
        $('#contenedorRM').hide();
        $('#contenedorRecoleccion').show();
        $('#contenedorCancelar').show();
        
        $.getJSON('ajax.php?callback=?', {
            accion: 'guardarRecoleccion'
        }, function (respuesta) {
            if (respuesta.ok) {
                mensaje(mensaje_guardarRecoleccion, 'correcto');
                var $productos = respuesta.datos;
                esto.generarTablaProductosAsignados($productos);
            }
            else {
                mensaje(mensaje_errorGuardarRecoleccion, 'error');
                esto.obtenerProductos();
                $('#contenedorProductos').show();
                $('#contenedorGuardar').show();
        
                $('#contenedorRecoleccion').hide();
                $('#contenedorCancelar').hide();
            }
        });
    }
    obtenerProductos(){
        $.getJSON('ajax.php?callback=?', {
            accion: 'obtenerProductos'
        }, function (respuesta) {
            if (respuesta.ok) {
                var productosPedidos = new ProductosPedidos();
                productosPedidos.productos = respuesta.datos;
                productosPedidos.generarTablaProductos();
            }
        });
    }

    /**
     * Devuelve el popUpOrigen
     * @returns {AsignacionIndividual}
     */
    getPopUpOringen(){
        return this.popUpOrigen;
    }

    /**
     * Instanacia el input de almacenes que se encuentra activo
     * @param {jQuery} inputActivo 
     */
    setInputActivo(inputActivo){
        this.inputActivo = inputActivo;
    }
}