/**
 * Sirve para permitir al usuario seleccionar un elemento.
 * @type {AsignacionIndividual}
 */
class AsignacionIndividual 
{
    /**
     * 
     * @param {Array} elementos Debe contener "id", "idBusquedas" y "nombre".
     * @param {function} callbackSeleccion
     * @returns {AsignacionIndividual}
     */
    constructor(elementos, callbackSeleccion) {
        this.elementos = elementos;
        this.callbackSeleccion = callbackSeleccion;
    }
    
    /**
     * Muestra una ventana para seleccionar un único elemento.
     * @param {String} titulo 
     */
    mostrar(titulo) {
        var esto = this;
        let contenido = '<div class="busquedaIndividual clearfix"><input type="text" name="textoBusquedaIndividual" value=""/></div>';
        contenido += '<ul class="listadoIndividual">' + this.obtenerElementosListado(this.elementos).join('') + '</ul>';
        this.abrirDialogo(titulo, contenido);
        //Foco en input
        $('.busquedaIndividual input').focus();
        //Buscar elemento
        $('[name="textoBusquedaIndividual"]').keyup(function(ev) {
            $('.listadoIndividual').html(esto.obtenerElementosListado(esto.buscarNombreElementos($(this).val())).join(''));
            //Seleccionar un resultado con enter
            if(ev.keyCode === 13) {
                let elementoEncontrado = esto.buscarIdBusquedasElemento($(this).val());
                if(elementoEncontrado) {
                    esto.callbackSeleccion(elementoEncontrado);
                    esto.cerrarDialogo();
                }
            }
        });
        //Seleccionar elemento
        $('.listadoIndividual').on('click', 'li span', function() {
            esto.callbackSeleccion(esto.buscarIdElemento($(this).data('id')));
            esto.cerrarDialogo();
        });
    }
    
    /**
     * Crea un array de elementos para la visualización.
     * @param {Array} elementos
     * @returns {Array}
     */
    obtenerElementosListado(elementos) {
        var lista = [];
        elementos.forEach(function(elemento) {
            lista.push('<li><span data-id="' + elemento.id + '">' + elemento.nombre + '</span></li>');
        });
        return lista;
    }
    
    /**
     * Devuelve los elementos que coincidan con la búsqueda.
     * @param {String} texto
     * @returns {Array}
     */
    buscarNombreElementos(texto) {
        var textoLower = texto.toLowerCase();
        return this.elementos.filter(function(elemento) {
            return elemento.nombre.toLowerCase().includes(textoLower);
        });
    }
    
    /**
     * Devuelve el elemento con el id indicado.
     * @param {int} id
     * @returns {Object}
     */
    buscarIdElemento(id) {
        return this.elementos.find(function(elemento) {
            return elemento.id == id;
        });
    }
    
    /**
     * Devuelve el elemento con el idBusquedas indicado.
     * @param {String} idBusquedas
     * @returns {Object}
     */
    buscarIdBusquedasElemento(idBusquedas) {
        var encontrado;
        if(idBusquedas) {
            encontrado = this.elementos.find(function(elemento) {
                return elemento.idBusquedas == idBusquedas;
            });
        }
        return encontrado;
    }
    
    /**
     * Abre una superposicion.
     * @param {String} titulo
     * @param {String} contenido
     */
    abrirDialogo(titulo, contenido) {
        var esto = this;
        $('body').append('<div class="fondoOscuroIndividual"></div>');
        $('body').append(
                '<div class="contenedorIndividual">' + 
                '<h2>' + titulo + '</h2>' +
                '<div class="contenidoIndividual">' + contenido + '</div><span class="botonCerrarIndividual">X</span>' + 
                '</div>');
        $('.botonCerrarIndividual').click(function() {
            esto.cerrarDialogo();
        });
    }

    /**
     * Cierra la superposicion.
     */
    cerrarDialogo() {
        $('.fondoOscuroIndividual').remove();
        $('.contenedorIndividual').remove();
    }
}