<?php

use Composer\Installers\TuskInstaller;

define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__) . '../../../../config/config.inc.php');
include_once(dirname(__FILE__) . '/../imaxrecoleccionpda.php');

$context = Context::getContext();
$modulo = new imaxrecoleccionpda();

//Comprobamos logueo
if(!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    if(isset($_POST['logout'])) {
        $context->employee->logout();
    }
    else {
        Tools::redirectAdmin($context->shop->getBaseURL(true).'modules/imaxrecoleccionpda/pda/principal.php');
    }
}

$cuerpo = 'login.php';
$css[] = 'login.css';

if(isset($_POST['submit'])) {
    /* Check fields validity */
    $errors = array();
    $passwd = trim(Tools::getValue('pass'));
    $email = trim(Tools::getValue('email'));
    if (empty($email)) {
        $errors[] = Tools::displayError($modulo->l('El email esta vacio.', 'imaxrecoleccionpda'));
    } elseif (!Validate::isEmail($email)) {
        $errors[] = Tools::displayError($modulo->l('La direccion de email es incorrecta.', 'imaxrecoleccionpda'));
    }

    if (empty($passwd)) {
        $errors[] = Tools::displayError($modulo->l('El password esta en blanco.', 'imaxinventariodiferido'));
    } else{
        if (version_compare(_PS_VERSION_, '8.0.0', '>=')) {
            // Para PrestaShop 8.0.0 o posterior    
            if (!Validate::isAcceptablePasswordLength($passwd)) {
                $errors[] = Tools::displayError($modulo->l('El password es incorrecto.', 'ImaxImprimePedidosServidor'));
            }
        } else {
            // Para PrestaShop 1.7 o anterior
            if (!Validate::isPasswd($passwd)) {
                $errors[] = Tools::displayError($modulo->l('El password es incorrecto.', 'ImaxImprimePedidosServidor'));
            }
        }
    }

    if (!count($errors)) {
        // Find employee
        $context->employee = new Employee();
        $is_employee_loaded = $context->employee->getByEmail($email, $passwd);
        $employee_associated_shop = $context->employee->getAssociatedShops();
        if (!$is_employee_loaded) {
            $errors[] = Tools::displayError($modulo->l('No existe el empleado o el password es incorrecto.', 'imaxrecoleccionpda'));
            $context->employee->logout();
        } elseif (empty($employee_associated_shop) && !$context->employee->isSuperAdmin()) {
            $errors[] = Tools::displayError($modulo->l('El empleado no esta configurado para la tienda.', 'imaxrecoleccionpda'));
            $context->employee->logout();
        } else {
            if(class_exists('PrestaShopLogger')) {
                PrestaShopLogger::addLog('Back Office connection from Informax PDA ('.Tools::getRemoteAddr().')', 1, null, '', 0, true, (int)$context->employee->id);
            }

            $context->employee->remote_addr = (int)ip2long(Tools::getRemoteAddr());
            // Update cookie
            $cookie = Context::getContext()->cookie;
            $cookie->id_employee = $context->employee->id;
            $cookie->email = $context->employee->email;
            $cookie->profile = $context->employee->id_profile;
            $cookie->passwd = $context->employee->passwd;
            $cookie->remote_addr = $context->employee->remote_addr;

            if(method_exists($cookie, 'registerSession')) {
                $cookie->registerSession(new EmployeeSession());
            }

            if (!Tools::getValue('mantenerSesion')) {
                $cookie->last_activity = time();
            }

            $cookie->write();
            
            Tools::redirectAdmin($context->shop->getBaseURL(true).'modules/imaxrecoleccionpda/pda/principal.php');
        }
    }
}

require_once 'vistas/base.php';