<?php
use PrestaShop\PrestaShop\Adapter\SymfonyContainer;

define('_PS_ADMIN_DIR_', '');
include_once(dirname(__FILE__).'../../../../config/config.inc.php');
include_once(dirname(__FILE__).'/../imaxrecoleccionpda.php');
$context = Context::getContext();
$context->shop->setUrl();
//Inicializamos el kernel
if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
    if(!class_exists('AppKernel')) {
        require_once __DIR__.'/../../../app/AppKernel.php';
    }

    global $kernel;
    $kernel = new AppKernel(_PS_MODE_DEV_ ? 'dev' : 'prod', _PS_MODE_DEV_ ? true : false);
    $kernel->boot();
    Context::getContext()->container = SymfonyContainer::getInstance();
}

$resultado['ok'] = false;
$resultado['datos'] = array();
//Comprobamos logueo
if (!empty($context->employee->id) && $context->employee->isLoggedBack()) {
    switch (Tools::getValue('accion')) {
        case 'obtenerProductos':
            $imax = new imaxrecoleccionpda();
            $productos = $imax->cargarProductosDePedidosConEstados();
            $resultado['datos'] = $productos;
            $resultado['ok'] = (boolean)$resultado['datos'];
            break;
        case 'obtenerProducto':
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $idsPedidos = Tools::getValue('idsPedidos');
            $cantidad = (int)trim(Tools::getValue('cantidad'));
            $imax = new imaxrecoleccionpda();
            $resultado['datos'] = $imax->obtenerProductoPDA($id_product, $id_product_attribute);
            $resultado['datos']['cantidad'] = $cantidad;
            $resultado['datos']['idsPedidos'] = $idsPedidos;
            $resultado['ok'] = (boolean)$resultado['datos'];
            break;
        
        case 'registrarMovimiento':
            $idsPedidos = explode(',', Tools::getValue('idsPedidos'));
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $almacenOrigen = Tools::getValue('almacenOrigen');
            $almacenDestino = Tools::getValue('almacenDestino');
            $cantidad = (int)trim(Tools::getValue('cantidad'));
            $imax = new imaxrecoleccionpda();
            $razonMvtSalida = Configuration::getGlobalValue($imax->sufijo .'RAZON_MVT_SALIDA');
            $razonMvtEntrada = Configuration::getGlobalValue($imax->sufijo.'RAZON_MVT_ENTRADA');
            // Verificar stock en el almacén de origen
            if($almacenOrigen){
                $stockOrigen = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, null, $almacenOrigen); 
                if ($stockOrigen >= $cantidad) {
                    try {
                        // Reducir stock en el almacén de origen
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, -$cantidad, null, false, array(), $almacenOrigen);
                        $imax->generarMovimiento($id_product,$id_product_attribute, -$cantidad, $razonMvtSalida, $almacenOrigen);
        
                        // Aumentar stock en el almacén de destino
                        StockAvailable::updateQuantity($id_product, $id_product_attribute, $cantidad, null, false, array(), $almacenDestino);
                        $imax->generarMovimiento($id_product,$id_product_attribute, $cantidad, $razonMvtEntrada, $almacenDestino);
                        if(Module::isEnabled('imaxmultialmacen')){
                            include_once(dirname(__FILE__).'/../../imaxmultialmacen/classes/ActualizarStockFisico.php');
                            $actualizarStockFisico = new ActualizarStockFisico();
                            $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenOrigen, -$cantidad);
                            $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenDestino, $cantidad);
                            $multiAlmacen = Module::getInstanceByName('imaxmultialmacen');
                            $multiAlmacen->movimientoStockVirtual($cantidad, $id_product, $id_product_attribute, $almacenOrigen, $almacenDestino);
                        }
                        foreach($idsPedidos as $idPedido){
                            $imax->asignacionProductoFinalizado($id_product, $id_product_attribute, $idPedido);
                        }
                        $resultado['ok'] = true;
                    } catch (Exception $e) {
                        $resultado['ok'] = false;
                    }      
                } else {
                    $resultado['ok'] = false;
                }
            } else{
                try {
                    // Aumentar stock en el almacén de destino
                    StockAvailable::updateQuantity($id_product, $id_product_attribute, $cantidad, null, false, array(), $almacenDestino);
                    $imax->generarMovimiento($id_product,$id_product_attribute, $cantidad, $razonMvtEntrada, $almacenDestino);
                    if(Module::isEnabled('imaxmultialmacen')){
                        include_once(dirname(__FILE__).'/../../imaxmultialmacen/classes/ActualizarStockFisico.php');
                        $actualizarStockFisico = new ActualizarStockFisico();
                        $actualizarStockFisico->modificarStockFisico($id_product, $id_product_attribute, $almacenDestino, $cantidad);
                        $multiAlmacen = Module::getInstanceByName('imaxmultialmacen');
                        $multiAlmacen->movimientoStockVirtual($cantidad, $id_product, $id_product_attribute, null, $almacenDestino);
                    }
                    foreach($idsPedidos as $idPedido){
                        $imax->asignacionProductoFinalizado($id_product, $id_product_attribute, $idPedido);
                    }
                    $resultado['ok'] = true;
                } catch (Exception $e) {
                    $resultado['ok'] = false;
                }      
            }
            break;
        case 'asignarProducto':
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $idsPedidos = explode(',', Tools::getValue('idsPedidos'));
            $idUsuario = $context->employee->id;
            $imax = new imaxrecoleccionpda();
            foreach($idsPedidos as $idPedido){
                $idPedido = (int)$idPedido;
                $sql = "SELECT product_quantity FROM `"._DB_PREFIX_."order_detail` WHERE product_id=$id_product AND product_attribute_id=$id_product_attribute AND id_order= $idPedido";
                $cantidad = Db::getInstance()->getValue($sql);
                $imax->asignarProducto($id_product, $id_product_attribute, $cantidad, $idPedido, $idUsuario);
            }
            $resultado['ok'] = true;
            break;
        case 'desasignarProducto':
            $id_product = (int)trim(Tools::getValue('id_product'));
            $id_product_attribute = (int)trim(Tools::getValue('id_product_attribute'));
            $idsPedidos = explode(',', Tools::getValue('idsPedidos'));
            $imax = new imaxrecoleccionpda();
            foreach($idsPedidos as $idPedido){
                $imax->desasignarProducto($id_product, $id_product_attribute, $idPedido);
            }
            $resultado['ok'] = true;
            break;
        case 'guardarRecoleccion':
            $idUsuario = $context->employee->id;
            $imax = new imaxrecoleccionpda();
            $resultado['datos'] = $imax->cargarAsignacionProductos($idUsuario);
            $resultado['ok'] = true;
            break;
    }
}

echo Tools::getValue('callback').'('.json_encode($resultado).')';
