/**
 * Comprueba que se pulse una sucesión de teclas, manteniendo ctrl + alt. Normalmente hay que hacer click sobre la web para que funcione.
 * @param {string} sucesion Las teclas que hay que pulsar, hay que tener en cuenta que algunas teclas son distintas cuando se pulsa ctrl + alt (alt gr).
 * @param {function} callback Se llama cuando la sucesión es correcta.
 * @returns {SucesionTeclas}
 */
function SucesionTeclas(sucesion, callback) {
    this.sucesion = sucesion;
    this.callback = callback;
    
    var posActual = 0, esto = this;
    
    $(document).keyup(function(ev) {
        if(ev.altKey && ev.ctrlKey && esto.sucesion.substr(posActual, 1) == ev.key) {
            //Correcto
            if(posActual == esto.sucesion.length - 1) {
                //Finalizado
                callback();
            }
            else {
                posActual++;
            }
        }
        else {
            //Error
            posActual = 0;
        }
    });
}
