<?php

require_once dirname(__FILE__).'/ComunesImaxRecoleccionPda.php';
require_once dirname(__FILE__).'/FuncionesImaxRecoleccionPda.php';

class ImaxRecoleccionPda extends Module {
	
	use ComunesImaxRecoleccionPda;

    var $versionPS;
    var $idShop;
    var $idLang;
    var $idTab;
    private $_html = '';
	public $idManual, $forceCheck, $sufijo, $prefijo;
	private static $funciones;
    
    const prefijo = 'imaxrecolecpda_';

    public function __construct() {
        $this->name = 'imaxrecoleccionpda';
        $this->tab = 'administration';
        $this->version = '1.13';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->idManual = '';
        $this->forceCheck = 0;
        $this->sufijo = self::prefijo;
        $this->prefijo = self::prefijo;
        parent::__construct();
        $nombreModulo = Configuration::getGlobalValue($this->sufijo . 'NOMBRE_MODULO');
        $descripcionModulo = Configuration::getGlobalValue($this->sufijo . 'DESCRIPCION_MODULO');
        if ($nombreModulo) {
            $this->displayName = $nombreModulo;
            $this->description = $descripcionModulo;
        } 
        else {
            $this->displayName = $this->l('Recolección de mercacía para los pedidos');
            $this->description = $this->l('El módulo ayuda a mover la mercancía entre almacenes para la gestión de pedidos.');
        }

        $context = Context::getContext();
        $this->idShop = $context->shop->id;
        $this->idLang = $context->language->id;

        if (version_compare(_PS_VERSION_, '8.0.0.0 ', '>=')) {
            $this->versionPS = 18;
        } else if (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            $this->versionPS = 17;
        } else if (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
            $this->versionPS = 16;
        } else if (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
        }
        $this->ps_versions_compliancy = ['min' => '1.5.0.0', 'max' => _PS_VERSION_];
    }

    public function install() {
        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (!Configuration::updateGlobalValue($indice, $valor)) {
                return false;
            }
        }

        if (!parent::install())
            return false;

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                $this->_errors[] = $this->l('Ha fallado la instalacion del hook:').' '.$hook;
                return false;
            }
        }

        include(dirname(__FILE__).'/sql-install.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }

        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Error al instalar el tab');
            return false;
        }

        //Crear redireccion hacia pda
        Db::getInstance()->execute('INSERT IGNORE INTO `' . _DB_PREFIX_ . 'meta` (page, configurable) VALUES ("module-imaxrecoleccionpda-pda", 1)');
        $idMeta = Db::getInstance()->Insert_ID();
        $tiendas = Shop::getShops();
        $idiomas = Language::getLanguages();
        foreach ($tiendas as $tienda) {
            foreach ($idiomas as $idioma) {
                Db::getInstance()->execute('
                    INSERT IGNORE INTO `' . _DB_PREFIX_ . "meta_lang` (id_meta, id_shop, id_lang, title, description, keywords, url_rewrite) 
                        VALUES ('$idMeta', '{$tienda['id_shop']}', '{$idioma['id_lang']}', 'RECOLECCION PDA', 'Ayuda a modificar el stock de los productos.', 'recoleccionPda', 'recoleccionPda')");
            }
        }

        if (class_exists('Theme')) {
            $plantillas = Theme::getThemes();
            foreach ($plantillas as $plantilla) {
                Db::getInstance()->execute('
                INSERT IGNORE INTO `' . _DB_PREFIX_ . "theme_meta` (id_theme, id_meta, left_column, right_column) 
                    VALUES ('$plantilla->id', '$idMeta', '$plantilla->default_left_column', '$plantilla->default_right_column')");
            }
        }
        return true;
    }

    public function uninstall() {
        if (!parent::uninstall()) {
            return false;
        }

        include(dirname(__FILE__).'/sql-unninstall.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }

        if (!$this->uninstallTab()) {
            $this->_errors[] = $this->l('Error al eliminar el tab');
            return false;
        }

        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (Configuration::getGlobalValue($indice) !== FALSE) {
                if (!Configuration::deleteByName($indice)) {
                    return false;
                }
            }
        }

        return true;
    }

    public function getContent() {
        $this->getTxtFiles();
        $this->addCSS('css.css');
        $this->addJS('SucesionTeclas.js');
        $this->addJS('functions.js');
        $this->addCSS('publi.css');
        $this->_html .= $this->createHelpHeader();
        if (!empty($_POST)) {
            $this->_html .= $this->_postProcess();
        }

        $this->_displayForm();
        $this->_html .= $this->getModuleFooter();
        return $this->_html;
    }

    private function _postProcess() {
        $accion = Tools::getValue("accion");
        $this->idTab = Tools::getValue("idTab");
        $html = "";
        switch ($accion) {  
            case 'opcionesConfiguracion':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo . 'TIPO_IMAGEN', trim(Tools::getValue('tipoImagen'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'RAZON_MVT_SALIDA', trim(Tools::getValue('razonMvtSalida'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'RAZON_MVT_ENTRADA', trim(Tools::getValue('razonMvtEntrada'))) &&
                    Configuration::updateGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA', trim(Tools::getValue('origenUbicacionPDA')))
                    ) {
                    $html .= $this->displayConfirmation($this->l('Configuración guardada correctamente'));
				}
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuración.'));
				}
                break;
            case 'estados':
                if (ConfigurationCore::updateGlobalValue(self::prefijo . 'ESTADOS', serialize(Tools::getValue('estados', [])))) {
                    $this->_html .= $this->displayConfirmation('Se han insertado correctamente los estados de los pedidos');
                } else {
                    $this->_html .= $this->displayError('Ha ocurrido un error al insertar los estados de los pedidos');
                }
                break;       
			case 'gestionLicencia':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo . 'LICENCIA', trim(Tools::getValue('licencia')))) {
                    $html .= $this->displayConfirmation($this->l('Licencia guardada correctamente.'));
				}
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la licencia.'));
				}
                break;
              case 'gestionPubli':
                Configuration::updateGlobalValue($this->sufijo . 'TXT_FILE', '');
                $urlPubli = trim(Tools::getValue('urlPubli'));
                $tipoPubli = trim(Tools::getValue('namePubli'));
                $nombre = trim(Tools::getValue('nameDeveloper'));
                $urlEmpresa = trim(Tools::getValue('urlEmpresa'));
                $urlManual = trim(Tools::getValue('urlManual'));
                $urlSoporte = trim(Tools::getValue('urlSoporte'));
                $descripcionModulo = trim(Tools::getValue('descripcionModulo'));
                $nombreModulo = trim(Tools::getValue('nombreModulo'));
                if (Configuration::updateGlobalValue($this->sufijo . 'URL_TXT', $urlPubli) &&
                        Configuration::updateGlobalValue($this->sufijo . 'TIPO', $tipoPubli) &&
                        Configuration::updateGlobalValue($this->sufijo . 'URL_DEVELOPER', $urlEmpresa) &&
                        Configuration::updateGlobalValue($this->sufijo . 'URL_TICKETS', $urlSoporte) &&
                        Configuration::updateGlobalValue($this->sufijo . 'URL_MANUAL', $urlManual) &&
                        Configuration::updateGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER', $nombre) &&
                        Configuration::updateGlobalValue($this->sufijo . 'DESCRIPCION_MODULO', $descripcionModulo) &&
                        Configuration::updateGlobalValue($this->sufijo . 'NOMBRE_MODULO', $nombreModulo)) {
                    Configuration::updateGlobalValue($this->sufijo . 'DESCARGA_ARCHIVO', 100001);
                    $html .= $this->displayConfirmation('Datos guardados correctamente.');
                    $this->installTabNewData();
                } else {
                    $html .= $this->displayError('Ha ocurrido un error al guardar los datos de desarrollador.');
                }
                $this->forceCheck = 1;
            default:
                break;
        }

        return $html;
    }
	
	public function _displayForm() {
        return $this->displayFormTrait(array('_configuracion' => $this->l('Configuracion'), '_mostrarLicencia' => $this->l('Licencia')), '');
    }
    
    private function _mostrarLicencia() {
        return $this->mostrarLicenciaTrait(2);
    }

    private function _configuracion() {        
        include_once(dirname(__FILE__).'/functionsForm.php');
        include_once(dirname(__FILE__).'/imaxAcordeon.php');        
        $stockMvtReasons = StockMvtReason::getStockMvtReasons($this->idLang);
        $stockMvtReasonsFormat = array();
        foreach($stockMvtReasons as $stockMvtReason){
            $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
        }
        
        $razonMvtSalida = Configuration::getGlobalValue($this->sufijo.'RAZON_MVT_SALIDA');
        $razonMvtEntrada = Configuration::getGlobalValue($this->sufijo.'RAZON_MVT_ENTRADA');
        $tipoImagen = Configuration::getGlobalValue($this->sufijo.'TIPO_IMAGEN');
        $origenUbicacionPDA = Configuration::getGlobalValue($this->sufijo . 'ORIGEN_UBI_PDA');
        $origenesUbicacion = [];
        if(Module::isEnabled('imaximprimepedidosservidor')){
            $moduloLocalizacion = Module::getInstanceByName('imaximprimepedidosservidor');
            $origenesUbicacion[1] = $this->l('Del modulo').' '.$moduloLocalizacion->displayName;
        }
        if(Module::isEnabled('obswarehouselocation')) {
            $moduloLocalizacion = Module::getInstanceByName('obswarehouselocation');
            $origenesUbicacion[2] = $this->l('Del modulo').' '.$moduloLocalizacion->displayName;
        }
        if($this->hayUbicacionesPresta()) {
            $origenesUbicacion[3] = $this->l('De Prestashop');
        }

        $acordeon = new imaxAcordeon($this->_path);

        $form = new imaxForm($this, $this->_path);
        $form->createHidden("accion", "opcionesConfiguracion");
        $form->createHidden("idTab", "1");
        $form->createFormSelect('razonMvtSalida', 'Razón del movimiento de stock de salida', $stockMvtReasonsFormat, $razonMvtSalida,'razonMvtSalida');
        $form->createFormSelect('razonMvtEntrada', 'Razón del movimiento de stock de entrada', $stockMvtReasonsFormat, $razonMvtEntrada, 'razonMvtEntrada');
        $form->createSelectNameImages('tipoImagen', 'Imagen a usar', $tipoImagen);
        $form->createFormSelect('origenUbicacionPDA', $this->l('Origen de la ubicacion del producto (PDA)'), $origenesUbicacion, $origenUbicacionPDA);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html = $acordeon->renderAcordeon($this->l('Configuracion'), $form->renderForm());
        
        unset($form);
        $orderStates = OrderState::getOrderStates($this->idLang);
        $modifiedOrderStates = [];
        foreach ($orderStates as $orderState) {
            $temp = [];
            $temp['value'] = $orderState['id_order_state'];
            $temp['text'] = $orderState['name'];
            $modifiedOrderStates[] = $temp;
        }
        $estadosSeleccionados = unserialize(Configuration::getGlobalValue($this->sufijo . 'ESTADOS'));
        if (!$estadosSeleccionados) {
            $estadosSeleccionados = array();
        }

        $form = new imaxForm($this, $this->_path);
        $form->createHidden('id_tab', 1);
        $form->createHidden('accion', 'estados');
        $form->createFormInfomationText($this->l('Se cargaran los productos que se encuentren dentro de algún pedido que tenga este estado'));
        $form->createFormCheckboxGroupList('estados', $this->l('Estado del pedido para para cargar productos'), $this->l('Estado del pedido para para cargar productos'), $modifiedOrderStates, $estadosSeleccionados);
        $form->createSubmitButton('submit', 'Guardar');
        $html .= $acordeon->renderAcordeon($this->l('Estados de pedidos para cargar productos'), $form->renderForm());

        unset($form);
        $tienda = new Shop($this->idShop);
        $enlace = $tienda->getBaseURL();
        if ($enlace[strlen($enlace) - 1] == '/') {
            $enlace = substr($enlace, 0, -1);
        }
        require_once dirname(__FILE__) . '/qrcode/qrlib.php';
        QRcode::png("$enlace/modules/imaxrecoleccionpda/pda", dirname(__FILE__) . '/css/qr.png', 'H', 2);
        $form = new imaxForm($this, $this->_path);
        $form->createHidden("idTab", "1");
        $url = '<p id="enlacePDA"><a href="' . $enlace . '/recoleccionPda" target="_blank">' . $enlace . '/recoleccionPda</a> <img src="' . $enlace . '/modules/imaxrecoleccionpda/css/qr.png" alt=""/></p>';
        $form->addToForm($url);
        $form->addToForm('<div style="clear:both"></div>');
        $html .= $acordeon->renderAcordeon($this->l('URL para acceder a recolección pda (puede acceder escaneando el qr)'), $form->renderForm());

        return $html;
    }
	
	/**
     * Devuelve las funciones especificas del modulo.
     * @return FuncionesImaxRecoleccionPda
     */
    private function getFunciones() {
        if(!self::$funciones) {
            self::$funciones = new FuncionesImaxRecoleccionPda($this);
        }

        return self::$funciones;
    }


    /**
     * Devuelve el id y la imagen de un producto.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    public function obtenerProductoPDA($id_product, $id_product_attribute) {
        $productoObj = new Product($id_product);
        $id_image_temp = Product::getCover($productoObj->id);
        if($id_image_temp){
            $ids = $productoObj->id.'-'.$id_image_temp['id_image'];
        }else{
            $ids = Language::getIsoById($this->idLang).'-default';   
        }
        
        // legacy mode or default image
        $referencia = $productoObj->reference;
        if($id_product_attribute) {
            $nombreCombinacionString = ' - ';
            
            $combinacion = new Combination($id_product_attribute);
            $referencia = $combinacion->reference;
            $nombresCombinacion = Product::getAttributesParams($id_product, $id_product_attribute);
            foreach($nombresCombinacion as $nombreCombinacion) {
                $nombreCombinacionString .= $nombreCombinacion['group'].': '.$nombreCombinacion['name'].', ';
            }
            $nombreCombinacionString = substr($nombreCombinacionString, 0, -2);
        }
        else {
            $nombreCombinacionString = '';
        }
        
        $tipoImagen = Configuration::getGlobalValue($this->sufijo.'TIPO_IMAGEN');
        if(empty($tipoImagen)){
            $tipoImagen = 'cart_default';
        }
        $resultado['imagen'] = $this->context->link->getImageLink($productoObj->link_rewrite[$this->idLang], $ids, $tipoImagen);
        $resultado['id_product'] = $id_product;
        $resultado['id_product_attribute'] = $id_product_attribute;
        $resultado['nombre'] = $productoObj->name[$this->idLang].$nombreCombinacionString;
        $resultado['stock'] = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute);
        $resultado['referencia'] = $referencia;
        $html = '';
        
        $imaxMultialmacen = Module::getInstanceByName('imaxmultialmacen');
        foreach($imaxMultialmacen->getFunciones()->obtenerAlmacenesProducto($resultado['id_product'], $resultado['id_product_attribute'], true) as $datosAlmacenes) {
            $html .= '<table id="tablaStocks"><thead><tr><th>'.$this->l('Ubicación').'</th><th>'.$this->l('Stock físico').'</th><th>'.$this->l('Stock web').'</th></tr></thead><tbody>';
            foreach($datosAlmacenes['almacenes'] as $almacen) {
                $html .= "<tr><td>{$almacen['nombre']}</td><td>{$almacen['physical_quantity']}</td><td>{$almacen['usable_quantity']}</td></tr>";
            }
            $html .= '</tbody></table>';
        }
        $resultado['tablaStocks'] = $html;

        $almacenesOrigen = $this->getWarehousesByProduct($id_product, $id_product_attribute);
        $almacenesOrigen = array_values($this->quitarAlmacenStockVirtual($almacenesOrigen));
        $almacenesOrigen = array_map(function($almacen) {
            return [
                'id' => $almacen['id_warehouse'],
                'idBusquedas' => $almacen['reference'],
                'nombre' => $almacen['name'],
            ];
        }, $almacenesOrigen);
       
        $resultado['almacenSalidaPorDefecto'] = '';
        $imprime = Module::getInstanceByName('imaximprimepedidosservidor');
        
        $opcionesAlmacen = $imprime->cargarOpcionAlmacen($resultado['id_product'], $resultado['id_product_attribute']);
        if(isset($opcionesAlmacen['almacenSalidaPorDefecto']) && $opcionesAlmacen['almacenSalidaPorDefecto']) {
            $idAlmacenSalidaPorDefecto = $opcionesAlmacen['almacenSalidaPorDefecto'];
            $resultado['almacenSalidaPorDefecto'] = $imaxMultialmacen->getFunciones()->getWarehouseById($idAlmacenSalidaPorDefecto);
            usort($almacenesOrigen, function($a, $b) use ($idAlmacenSalidaPorDefecto) {
                // Si $a o $b tiene el id igual a $idAlmacenSalidaPorDefecto, lo posicionamos primero
                if ($a['id'] == $idAlmacenSalidaPorDefecto) {
                    return -1;
                }
                if ($b['id'] == $idAlmacenSalidaPorDefecto) {
                    return 1;
                }
                // Si ninguno es el almacen por defecto, mantener el orden
                return 0;
            });
        }
        $resultado['almacenesOrigen'] = $almacenesOrigen;
        return $resultado;
    }

    /**
     * Busca un producto o combinaición por su referencia
     * @param mixed $reference
     * @return array
     */
    public function buscarReferencia($reference) {
        $reference = pSQL(trim($reference));
    
        $resultado = array();
        if($reference) {
            $sql = 'SELECT id_product , id_product_attribute '
                    . ' FROM ' . _DB_PREFIX_ . 'product_attribute '
                    . " WHERE reference = '$reference'";
            $resultado = Db::getInstance()->getRow($sql);
            if (!$resultado) {
                $sql = 'SELECT id_product ,0 AS id_product_attribute '
                        . ' FROM ' . _DB_PREFIX_ . 'product '
                        . " WHERE reference = '$reference'";
                $resultado = Db::getInstance()->getRow($sql);
            }
        }
    
        return $resultado;
    }

       // /**
    //  * Genera movimientos de stock de un producto
    //  * @param int $id_product
    //  * @param int $id_product_attribute
    //  * @param int $cantidad
    //  * @param int $razon
    //  * @param int $almacen
    //  * @param Module $modulo
    //  */
    // function generarMovimiento_($id_product, $id_product_attribute, $cantidad, $razon, $almacen, $modulo){ 
    //     if(Module::isEnabled('gestavdstock')) {
    //             Module::getInstanceByName('imaxmultialmacen');
    //             $lang_id = Context::getContext()->language->id;
    //             $id_employee = Context::getContext()->employee->id;
    //             $product = new Product($id_product, false, $lang_id);
    //             $product_name=$product->name;
    //             if($id_product_attribute){
    //                 $combination = new Combination($id_product_attribute, $lang_id);
    //                 $reference = pSQL($combination->reference);
    //             }else{
    //                 $reference= pSQL($product->reference);
    //             }
    //             
    //             $stock = $modulo->getStock($id_product, $id_product_attribute, $almacen);
    //             $mvt_physical = (int)$cantidad;
    //             $mvt_reserved = 0;
    //             $sign=-1;
    //             if($mvt_physical>0){
    //                 $sign=1;   
    //             }
    
    //             $stockMvtReasons = StockMvtReason::getStockMvtReasons($lang_id);
    //             $stockMvtReasonsFormat = array();
    //             foreach($stockMvtReasons as $stockMvtReason){
    //                 $stockMvtReasonsFormat[$stockMvtReason['id_stock_mvt_reason']] = $stockMvtReason['name'];
    //             }
    //             $id_stock_mvt_reason = $stockMvtReasonsFormat[$razon];       
    //             $comments = $stockMvtReasonsFormat[$razon];
    //             $date_add= date('Y-m-d H:i:s');
    //             $physical_quantity = $stock['physical_quantity'] + (int)$cantidad;
    
    //             $sql = '
    //                 SELECT * FROM `'._DB_PREFIX_.'stock_available_advanced` saa
    //                     INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'extraMovimiento_advanced` ema 
    //                         ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
    //                 WHERE id_product="'.(int)$id_product.'" and id_product_attribute="'.(int)$id_product_attribute.'" 
    //                     and id_warehouse = "'.(int)$almacen.'" 
    //                 order by date_add DESC';
                
    //             if($row = Db::getInstance()->getRow($sql)){
    //                 $reserved_quantity = $row['reserved_quantity'];
    //             }else{
    //                 $reserved_quantity = 0;
    //             }
                
    //             $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced 
    //                     (id_order, id_order_status, product_name,reference,id_product,id_product_attribute,
    //                     stock_quantity, physical_quantity, reserved_quantity,
    //                     mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) 
    //                     VALUES (0, 0, "'.$product_name.'","'.$reference.'","'.$id_product.'",
    //                     "'.$id_product_attribute.'","'.$stock['quantity'].'",
    //                     "'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'",
    //                     "'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'",
    //                     "'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';
    //             Db::getInstance()->execute($sql);
    //             $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
    //             Configuration::set(ImaxMultiAlmacen::prefijo. 'ALMACEN_GENERAL', $almacen);
    //             Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
    //             (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $almacen)");
    //         }
        
                           
    //         return (new \PrestaShop\PrestaShop\Core\Stock\StockManager())->saveMovement(
    //             $id_product,
    //             $id_product_attribute,
    //             $cantidad,
    //             array(
    //                 'id_stock_mvt_reason' => $razon,
    //             )
    //         );
    // }

    public function generarMovimiento($id_product, $id_product_attribute, $cantidad, $razon, $almacen) {
        if (!function_exists('generarMovimiento_')) {
            $function = $this->getFunction();
            eval(gzuncompress(base64_decode($function)));
        }
        if (function_exists('generarMovimiento_')) {
            return generarMovimiento_($id_product, $id_product_attribute, $cantidad, $razon, $almacen, $this);
        }

        echo $this->l('Este modulo no tiene una licencia valida: ').$this->name;
        echo '<br />';
        echo $this->l('Contacte con nosotros para obtener una licencia valida');
        die();
    }
    
    /**
     * Devuelvo los almacenes en los que se encuentra un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getWarehousesByProduct($id_product, $id_product_attribute){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $sql = 'SELECT w.id_warehouse, CONCAT(w.reference, " - " ,w.name) as name , w.reference FROM `'._DB_PREFIX_.'stock` s 
                INNER JOIN `'._DB_PREFIX_."warehouse` w ON s.id_warehouse = w.id_warehouse
                WHERE s.id_product = $id_product AND s.id_product_attribute = $id_product_attribute GROUP BY s.id_warehouse";
        return Db::getInstance()->executeS($sql);
    }


    /**
     * Cargar todos los productos y sus combinaciones de pedidos que se encuentran en ciertos estados
     * @return array
     */
    public function cargarProductosDePedidosConEstados() {
        $estados = unserialize(Configuration::getGlobalValue($this->sufijo . 'ESTADOS'));
        $query = "SELECT 
        od.product_id, 
        od.product_attribute_id, 
        od.product_name, 
        od.product_quantity, 
        o.id_order,
        ap.idUsuario
        FROM 
            "._DB_PREFIX_."order_detail od
        LEFT JOIN 
            "._DB_PREFIX_."orders o ON (od.id_order = o.id_order)
        LEFT JOIN 
            "._DB_PREFIX_.self::prefijo."asignacion_productos ap ON (od.product_id = ap.id_product AND od.product_attribute_id = ap.id_product_attribute AND o.id_order = ap.idPedido)
        WHERE 
            o.current_state IN (" . implode(',', array_map('intval', $estados)) . ")
            AND (ap.finalizado IS NULL OR ap.finalizado = 0);
        ";
    
        $result = Db::getInstance()->executeS($query);
    
        // Procesar los resultados
        $productos = [];
        foreach ($result as $row) {
            $key = $row['product_id'] . '-' . $row['product_attribute_id'] . '-' . (int)$row['idUsuario'];
    
            if (!isset($productos[$key])) {
                $productos[$key] = [
                    'id_producto' => $row['product_id'],
                    'id_combinacion' => $row['product_attribute_id'],
                    'nombre' => $row['product_name'],
                    'cantidad' => 0,
                    'idUsuario' => $row['idUsuario'],
                    'ids_pedidos' => [],
                ];
            }
    
            $productos[$key]['cantidad'] += $row['product_quantity'];
            if (!in_array($row['id_order'], $productos[$key]['ids_pedidos'])) {
                $productos[$key]['ids_pedidos'][] = $row['id_order'];
            }
        }

        $productos = $this->checkQuantityProducts($productos);
        return $productos;
    }    
 
    /**
     * Si el producto tiene suficiente cantidad en almacén se retira
     * @param array $productos
     * @return array
     */
    private function checkQuantityProducts($productos){
        $imprime = Module::getInstanceByName('imaximprimepedidosservidor');
        foreach($productos as $key => $producto) {
            $opcionesAlmacen = $imprime->cargarOpcionAlmacen($producto['id_producto'], $producto['id_combinacion']);
            if(!isset($opcionesAlmacen['almacenSalidaPorDefecto']) || !$opcionesAlmacen['almacenSalidaPorDefecto']) {
                continue;
            }
            
            $cantidadDisponible = $this->getStock($producto['id_producto'], $producto['id_combinacion'], $opcionesAlmacen['almacenSalidaPorDefecto']);
            $cantidadFinal = $producto['cantidad'] - $cantidadDisponible['physical_quantity'];
            if($cantidadFinal <= 0) {
                unset($productos[$key]);
            }else{
                $producto['cantidad'] = $cantidadFinal;
            }
        }
        return $productos;        
    }

    /**
     * Asigna un producto a un usuario
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @param mixed $cantidad
     * @param mixed $idsPedidos
     * @param mixed $idUsuario
     * @return bool
     */
    public function asignarProducto($id_product, $id_product_attribute, $cantidad, $idPedido, $idUsuario) {    
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $cantidad = (int) $cantidad;
        $idPedido = (int) $idPedido;
        $idUsuario = (int) $idUsuario;
        $sql = "REPLACE INTO " . _DB_PREFIX_ . self::prefijo . "asignacion_productos (id_product, id_product_attribute, cantidad, idPedido, idUsuario) 
                VALUES ($id_product, $id_product_attribute, $cantidad, $idPedido, $idUsuario)";
        return Db::getInstance()->execute($sql);
    }
    
    /**
     * Desasignar un producto a un usuario
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @param mixed $idPedido
     * @return bool
     */
    public function desasignarProducto($id_product, $id_product_attribute, $idPedido){
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $idPedido = (int) $idPedido;
        $sql = "DELETE FROM " . _DB_PREFIX_ . self::prefijo . "asignacion_productos 
                WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute AND idPedido = $idPedido";
        return Db::getInstance()->execute($sql);
    }

    /**
     * Carga los productos que tiene asignado un asuario apartir de su id
     * @param mixed $idUsuario
     * @return array
     */
    public function cargarAsignacionProductos($idUsuario){
        $idUsuario = (int) $idUsuario;
        $sql = "SELECT 
            id_product, 
            id_product_attribute, 
            SUM(cantidad) as cantidad, 
            GROUP_CONCAT(idPedido) as ids_pedidos
        FROM " . _DB_PREFIX_ . self::prefijo . "asignacion_productos 
        WHERE idUsuario = $idUsuario AND finalizado = 0
        GROUP BY id_product, id_product_attribute";

        $productosAsignados = Db::getInstance()->executeS($sql);
        foreach($productosAsignados as &$productoAsignado){
            $productoAsignado['nombre'] = Product::getProductName($productoAsignado['id_product'], $productoAsignado['id_product_attribute']);
        }
        return $productosAsignados;
    }

    /**
     * Actualiza a finalizado los productos asociados a un pedido y usuario
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $idPedido
     * @return bool
     */
    public function asignacionProductoFinalizado($id_product, $id_product_attribute, $idPedido) {
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $idPedido = (int) $idPedido;
        $sql = "UPDATE `"._DB_PREFIX_.self::prefijo."asignacion_productos`
                SET `finalizado` = 1
                WHERE `id_product` = ".(int)$id_product." 
                AND `id_product_attribute` = ".(int)$id_product_attribute." 
                AND `idPedido` = ".(int)$idPedido;
            
        Db::getInstance()->execute($sql);
    }
    
    /**
     * Devuelve la cantidad física de un producto
     * @param mixed $id_product
     * @param mixed $id_product_attribute
     * @return array
     */
    public function getStock($id_product, $id_product_attribute = null, $id_warehouse = null) {
        if($id_warehouse){
            $idStock = StockAvailable::getWarehouseStockAvailableIdByProductId($id_product, $id_product_attribute, $id_warehouse);
            $stock = new Stock($idStock);
            $resultado = ['quantity' => $stock->usable_quantity, 'physical_quantity' => $stock->physical_quantity];
        }else{
            $db = Db::getInstance();
            $id_product_attribute_condition = $id_product_attribute ? ' AND id_product_attribute = ' . (int)$id_product_attribute : ' AND id_product_attribute = 0';
            $sql = 'SELECT quantity, physical_quantity FROM ' . _DB_PREFIX_ . 'stock_available WHERE id_product = ' . (int)$id_product . $id_product_attribute_condition;
            $resultado = $db->getRow($sql);
        }
        return $resultado;
    }

    /**
     * Devuelve datos extra del producto.
     * @param int $id_product
     * @param int $id_product_attribute Si es false se ignora.
     * @return array
     */
    public function cargarExtraProducto($id_product, $id_product_attribute = false) {
        return ($id_product_attribute !== false ? $this->cargarExtraUnaCombinacion($id_product, (int) $id_product_attribute) : 
            $this->cargarExtraTodasCombinaciones($id_product));
    }
    
    /**
     * Devuelve los datos extra para una combinacion.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    private function cargarExtraUnaCombinacion($id_product, $id_product_attribute) {
        //Datos extra
        $id_product = (int) $id_product;
        $id_product_attribute = (int) $id_product_attribute;
        $resultado = array();
        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1){
            $modulo = Module::getInstanceByName('imaximprimepedidosservidor');
            $resultado = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . $modulo->sufijo . "extraProducto` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
        }elseif($origenUbicacion == 2) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 3) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $resultado['id_product'] = $id_product;
                $resultado['id_product_attribute'] = $id_product_attribute;
                $resultado['ubicacion'] = Db::getInstance()->getValue('SELECT location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product' AND id_product_attribute = '$id_product_attribute'");
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve los datos extra de un producto.
     * @param int $id_product
     * @return array
     */
    private function cargarExtraTodasCombinaciones($id_product) {
        $resultado = array();
        
        //Datos extra
        $id_product = (int) $id_product;
        
        $origenUbicacion = Configuration::getGlobalValue(self::prefijo . 'ORIGEN_UBI_PDA');
        if($origenUbicacion == 1){
            $modulo = Module::getInstanceByName('imaximprimepedidosservidor');
            $temp = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . $modulo->sufijo . "extraProducto` WHERE id_product = '$id_product'");
            foreach($temp as $t) {
                $resultado[$t['id_product_attribute']] = $t;
            }
        }elseif($origenUbicacion == 2) {
            //obswarehouselocation
            $modulo = Module::getInstanceByName('obswarehouselocation');
            if($modulo) {
                $localizacion = $modulo->getWarehouseLocation($id_product);
                $resultado[0]['id_product'] = $id_product;
                $resultado[0]['id_product_attribute'] = 0;
                $resultado[0]['ubicacion'] = $localizacion;
            }
        }
        elseif($origenUbicacion == 3) {
            //Prestashop
            if($this->hayUbicacionesPresta()) {
                $localizaciones = Db::getInstance()->executeS('SELECT id_product_attribute, location FROM `'._DB_PREFIX_."stock_available` WHERE id_product = '$id_product'");
                foreach($localizaciones as $localizacion) {
                    $resultado[$localizacion['id_product_attribute']]['id_product'] = $id_product;
                    $resultado[$localizacion['id_product_attribute']]['id_product_attribute'] = $localizacion['id_product_attribute'];
                    $resultado[$localizacion['id_product_attribute']]['ubicacion'] = $localizacion['location'];
                }
            }
        }

        return $resultado;
    }

    /**
     * Indica si están disponibles las ubicaciones de Prestashop.
     * @return boolean
     */
    private function hayUbicacionesPresta() {
        $ubicaciones = false;
        
        $columnas = Db::getInstance()->executeS('DESCRIBE '._DB_PREFIX_.'stock_available');
        foreach($columnas as $columna) {
            if($columna['Field'] == 'location') {
                $ubicaciones = true;
                break;
            }
        }
        
        return $ubicaciones;
    }

    /**
     * Elimina del array de almacenes los almacenes virtuales
     * @param array $almacenes
     * @return array
     */
    public function quitarAlmacenStockVirtual($almacenes) {
        Module::getInstanceByName('imaxmultialmacen');
        require_once dirname(__FILE__).'/../imaxmultialmacen/classes/AlmacenStockVirtual.php';
        $almacenesStockVirtualActuales = AlmacenStockVirtual::cargarRelaciones();
        
        // Obtener todos los id_warehouse de almacenesStockVirtualActuales en una lista
        $almacenesStockVirtualIds = array_keys($almacenesStockVirtualActuales);
    
        // Filtrar los almacenes para quitar los que están en almacenesStockVirtualIds
        $almacenesFiltrados = array_filter($almacenes, function($almacen) use ($almacenesStockVirtualIds) {
            return !in_array($almacen['id_warehouse'], $almacenesStockVirtualIds);
        });
        return $almacenesFiltrados;
    }
}
