<?php

/**
 * Contiene las funciones comunes de los modulos.
 * @version 1.5
 */
Trait ComunesImaxRecoleccionPda {

    public function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addCss($this->_path.'css/'.$css, 'all');
        }

        return;
    }

    public function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            $this->context->controller->addJs($this->_path.'js/'.$js);
        }

        return;
    }

    public function addJqueryUI($plugin) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass) {
                $this->context->controller = new AdminModulesController();
            }
            $this->context->controller->addJqueryUI($plugin);
        }
        return;
    }

    public function createHelpHeader() {
        $html = '<div class="module-preheader">';
        $html .= $this->getDatosPubli('header');
        $html .= '</div>';

        $html .= '<div class="module-header">';
        $html .= '<div class="module-title-container">';
        $html .= '<h2 class="module-title">' . $this->displayName . '<small>' . (Configuration::getGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER') ? "  " . Configuration::getGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER') . " " : ' by Informax ' ) . '</small></h2>';
        $html .= '<h3 class="module-version">' . $this->l('Version: ') . $this->version . '</h3>';
        $html .= '</div>';

        $html .= '<div class="module-toolbar">';
        $html .= '<ul class="module-nav" >';

        $html .= '<li>';
        $html .= '<a target="_blank" href="' .
                (Configuration::getGlobalValue($this->sufijo . 'URL_DEVELOPER') ? "  " . Configuration::getGlobalValue($this->sufijo . 'URL_DEVELOPER') . " " : 'http://www.informax.es' ) . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/informax.png">';
        $html .= '<div>' . (Configuration::getGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER') ? Configuration::getGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER') : ($this->l('Informax'))) . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="' .
                (Configuration::getGlobalValue($this->sufijo . 'URL_TICKETS') ? "  " . Configuration::getGlobalValue($this->sufijo . 'URL_TICKETS') . " " : 'http://tickets.informax.es/open.php?topicId=10' ) . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/abrir-ticket.png">';
        $html .= '<div>' . $this->l('Asistencia') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="' .
                (Configuration::getGlobalValue($this->sufijo . 'URL_MANUAL') ? "  " . Configuration::getGlobalValue($this->sufijo . 'URL_MANUAL') . " " : 'http://docs.informax.es/?p=' . $this->idManual ) . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/ir-a-manuales.png">';
        $html .= '<div>' . $this->l('Manuales') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        
        return $html;
    }

    public function getModuleFooter() {
        $url = Configuration::getGlobalValue(self::prefijo.'URL_FALDON');
        $html = '<div class="module-newsletter">';
        $html .= '<form action="http://www.informax.es/subscribe/" method="post" target="_blank">
                    <input type="hidden" name="accion" value="newsletter">
                    <input type="hidden" name="idTab" value="1" />';
        $html .= '<p>'.$this->l('Si deseas enterarte de todos los cambios en nuestros modulos, nuevos Modulos, como funciona Prestashop, apuntate a nuestras news').'</p>';
        $html .= ' <p>';
        $html .= ' <label>'.$this->l('email').'</label>';
        $html .= '<input type="text" name="email" value="" />';
        $html .= '<input type="submit" name="subscribe" value="'.$this->l('Guardar').'" />';
        $html .= '</p>';
        $html .= '</form><br />';
        $html .= '</div>';
        $html .= '<div class="module-footer">';
        $html .= '<div class="module-footer-left">';
        $html .= $this->getDatosPubli('footera');
        $html .= '</div>';
        $html .= '<div class="module-footer-right">';
        $html .= $this->getDatosPubli('footerb');
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getDatosPubli($tipo) {
        $datosCompletos = Configuration::getGlobalValue(self::prefijo.'TXT_FILE');

        $html = '';
        if ($datosCompletos) {
            $aperturaA = '';
            $cierreA = '';
            $datosCompletos = @unserialize($datosCompletos);
            if (!is_array($datosCompletos)) {
                return '';
            }
            shuffle($datosCompletos);
            foreach ($datosCompletos AS $datoElemento) {
                if ($datoElemento[1] == $tipo) {
                    if (trim($datoElemento[2]) != '') {
                        $aperturaA .= '<a href="'.$datoElemento[2].'" target="_blank">';
                        $cierreA = '</a>';
                    }
                    if (trim($datoElemento[0]) != '') {
                        $html = $aperturaA.'<img src="'.Configuration::getGlobalValue(self::prefijo.'URL_TXT').'/img/'.$datoElemento[0].'" />'.$cierreA;
                    }
                    return $html;
                }
            }
        }
        return $html;
    }

    public function getTxtFiles() {
        if (Configuration::getGlobalValue(self::prefijo.'DESCARGA_ARCHIVO') < 10000) {
            Configuration::updateGlobalValue(self::prefijo.'DESCARGA_ARCHIVO', Configuration::getGlobalValue(self::prefijo.'DESCARGA_ARCHIVO') + 1);
            return false;
        }
        $url = Configuration::getGlobalValue(self::prefijo.'URL_TXT').'/'.Configuration::getGlobalValue(self::prefijo.'TIPO').'.txt';
        $basedir_active = ini_get('open_basedir');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        if (!$basedir_active) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);
        if (!isset($infoCurl['http_code']) || $infoCurl['http_code'] != 200) {

            return false;
        }
        Configuration::updateGlobalValue(self::prefijo.'DESCARGA_ARCHIVO', 0);
        return Configuration::updateGlobalValue(self::prefijo.'TXT_FILE', $this->readCsv($datos));
    }

    private function readCsv($string) {
        $string = trim($string);
        $temp = explode("\n", $string);
        $respuesta = array();
        foreach ($temp AS $elemento) {
            $elementoInterno = array();
            $elementoInterno = explode(";", $elemento);
            $respuesta[] = $elementoInterno;
        }
        return serialize($respuesta);
    }

    public function l($msg, $modulo = '', $locale = null) {
        if ($modulo == '') {
            $modulo = 'traducciones' . strtolower($this->name);
        }
        return parent::l($msg, $modulo, $locale);
    }

    /**
     * Crea un nuevo tab.
     * @param string $clase
     * @param string $nombre
     * @param string $padre
     * @return boolean
     */
    private function crearTab($clase, $nombre, $padre = '') {
        if (!Tab::getIdFromClassName($clase)) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $clase;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $nombre;
            }
            if ($padre == '') {
                $posicion = 0;
            }
            else {
                $posicion = Tab::getIdFromClassName($padre);
            }
            $tab->id_parent = intval($posicion);
            $tab->module = $this->name;
            try {
                if (!$tab->add()) {
                    return false;
                }
            }
            catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Borra un tab.
     * @param string $clase
     * @return boolean
     */
    private function borrarTab($clase) {
        $id_tab = (int)Tab::getIdFromClassName($clase);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            try {
                if (!$tab->delete()) {
                    return false;
                }
            }
            catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    private function installTab() {
        include(dirname(__FILE__).'/configuration.php');

        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Desinstala los tabs del módulo.
     * @return boolean
     */
    private function uninstallTab() {
        include(dirname(__FILE__).'/configuration.php');

        //Desinstalamos las tabs de este módulo
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                if (!$this->borrarTab($moduleTab['clase'])) {
                    return false;
                }
            }
        }

        //Desinstalamos el root si está vacío
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $id_tab = (int)Tab::getIdFromClassName($moduleTabRoot['clase']);
            if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
                if (!$this->borrarTab($moduleTabRoot['clase'])) {
                    return false;
                }
            }
        }

        return true;
    }

    public function checkLicencia($force = 0) {
        $data = array();
        $f = Configuration::getGlobalValue(self::prefijo.'F');
        $check = Configuration::getGlobalValue(self::prefijo.'F_CHECK');
        $url = Configuration::getGlobalValue(self::prefijo.'F_SERVER');
        $data['server'] = $this->getDomain();
        $data['modulo'] = $this->name;
        $data['action'] = 'checkLicencia';
        $data['licencia'] = Configuration::getGlobalValue(self::prefijo.'LICENCIA');
        if ($check >= 100 || $force == 1) {
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $datos = curl_exec($ch);
            $datos = json_decode($datos);
            $info = curl_getinfo($ch);
            if (!$datos || $datos->codError != 0) {
                Configuration::updateGlobalValue(self::prefijo.'F', '');
                Configuration::updateGlobalValue(self::prefijo.'F_CHECK', (int)$check + 1);
                return false;
            }
            else {
                Configuration::updateGlobalValue(self::prefijo.'F', $datos->msgError);
                Configuration::updateGlobalValue(self::prefijo.'F_CHECK', 0);
                return true;
            }
        }
        else {
            Configuration::updateGlobalValue(self::prefijo.'F_CHECK', (int)$check + 1);
            return true;
        }
    }

    private function getFunction() {
        $function = Configuration::getGlobalValue($this->sufijo.'F');
        return $function;
    }

    private static function getUrlAdmin() {
        $temp = explode('/', $_SERVER['PHP_SELF']);
        $dummy = array_pop(($temp));
        $urlAdmin = implode('/', $temp);
        if (Configuration::get('PS_SSL_ENABLED') == 1) {
            $url = 'https://';
        }
        else {
            $url = 'http://';
        }
        $url .= $_SERVER['SERVER_NAME'].$urlAdmin.'/';
        return $url;
    }

    public function getDomain() {
        $idShopDefault = Configuration::getGlobalValue('PS_SHOP_DEFAULT');
        $tienda = new Shop($idShopDefault);
        if (Validate::isLoadedObject($tienda)) {
            if (isset($tienda->domain)) {
                return $tienda->domain;
            }
        } return false;
    }

    public function displayWarning($error) {
        if ($this->versionPS == 15) {
            $output = '
			<div class="module_error alert warn">
				'.$error.'
			</div>';
        }
        else {
            $output = '<div class="bootstrap">'
                    .'<p class="warning warn alert alert-warning">'
                    .$error.
                    '</p></div>';
        }
        return $output;
    }

    private function _checkVersion() {
        return false;
    }

    /**
     * Version comun de displayForm.
     * @param string[] $tabsArray [$funcion => $nombreTab]
     * @param string $extra Para meter incrustado algun js o css.
     */
    private function displayFormTrait($tabsArray, $extra = '') {
        if (Configuration::getGlobalValue(self::prefijo.'LICENCIA') == '') {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>'.$this->l('ATENCION: SU LICENCIA ESTA VACIA').'</p>';
            $this->_html .= '<p>'.$this->l('Debe introducir un numero de licencia valido para continuar').'</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        }
        elseif (!$this->checkLicencia($this->forceCheck)) {
            $this->_html .= '<div class="bootstrap" style="width:100%">';
            $this->_html .= '<div class="alert alert-warning">';
            $this->_html .= '<p>'.$this->l('ATENCION: SU LICENCIA NO ES VALIDA').'</p>';
            $this->_html .= '<p>'.$this->l('Si ejecuta el modulo sin licencia los resultados no seran validos').'</p>';
            $this->_html .= '<p>'.$this->l('Haga esto bajo su responsabilidad, Informax no dara soporte ni aceptar quejas o peticiones derivadas del uso sin licencia de nuestros productos').'</p>';
            $this->_html .= '<p>'.$this->l('El uso de nuestro software sin licencia constituye una infraccion de las leyes de propiedad intelectual, y sera puesta en conocimiento de las autoridades pertinentes').'</p>';
            $this->_html .= '<p>'.$this->l('Si cree que este mensaje es un error, por favor, pongase en contacto con nosotros, enviandonos codigo de licencia, nombre del modulo, dominio de la tienda y copia de la factura de pago').'</p>';
            $this->_html .= '</div>';
            $this->_html .= '</div>';
            $this->_html .= $this->_mostrarLicencia();
            $this->forceCheck = 0;
        }
        else {
            if ($this->_checkVersion()) {
                $this->_html .= $this->displayConfirmation($this->_checkVersion());
            }
            if ($this->idTab == '' || empty($this->idTab)) {
                $this->idTab = 1;
            }
            $urlTienda = self::getUrlAdmin();
            $token = Tools::getAdminTokenLite('AdminModules');
            $moduleLink = $urlTienda.'index.php?controller=AdminModules&token='.$token.'&configure='.$this->name.'&tab_module=administration&module_name='.$this->name;

            $this->_html .= '<script>'
                    .' var nameModule = "'.$this->name.'"; '
                    .' var url_admin = "'.$urlTienda.'"; '
                    .' var url_modulo = "'.$moduleLink.'"; '
                    .' var baseUrl = "'.$this->_path.'"; '
                    .' </script>'
                    .$extra;
            $this->_html .= '<ul id="menuTab">';
            $i = 1;
            foreach ($tabsArray as $funcion => $nombreTab) {
                $this->_html .= '<li id="menuTab'.$i.'" class="menuTabButton'.(($this->idTab == $i) ? " selected" : "").'">'.$nombreTab.'</li>';
                $i++;
            }
            $this->_html .= '</ul>';
            $this->_html .= '<div id="tabList">';
            $i = 1;
            foreach ($tabsArray as $funcion => $nombreTab) {
                $this->_html .= '<div id="menuTab'.$i.'Sheet" class="tabItem'.(($this->idTab == $i) ? " selected" : "" ).'">'.$this->{$funcion}().'</div>';
                $i++;
            }
            $this->_html .= '</div>';
            $this->_html .= '<style>
				#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
				#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
				#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
				#tabList { clear: left; }
				.tabItem { display: none; }
				.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
			</style>
			<script>
				$(".menuTabButton").click(function () {
				  $(".menuTabButton.selected").removeClass("selected");
				  $(this).addClass("selected");
				  $(".tabItem.selected").removeClass("selected");
				  $("#" + this.id + "Sheet").addClass("selected");                                 
				});
			</script>';
        }
    }

    private function mostrarLicenciaTrait($idTab) {
        include_once(dirname(__FILE__).'/functionsForm.php');
        include_once(dirname(__FILE__).'/imaxAcordeon.php');
        $licenseDomain = $this->getDomain();
        $html = '';
        $form = new imaxForm($this, $this->_path);
        $acordeon = new imaxAcordeon($this->_path);
        if (!$licenseDomain) {
            $form->createFormInfomationText($this->l('La configuracion de su tienda no es correcta. No se puede determinar el dominio'));
            $html .= $acordeon->renderAcordeon($this->l('Gestion Licencia'), $form->renderForm());
            Configuration::updateGlobalValue(self::prefijo.'LICENCIA', '');
            Configuration::updateGlobalValue(self::prefijo.'F', '');
            Configuration::updateGlobalValue(self::prefijo.'F_CHECK', 1001);
        }
        else {
            $licencia = Configuration::getGlobalValue(self::prefijo.'LICENCIA');
            $form->createHidden("accion", "gestionLicencia");
            $form->createHidden("idTab", $idTab);
            $form->createFormInfomationText($this->l('ATENCION: La licencia es obligatoria para el correcto funcionamiento del modulo'));
            $form->createFormInfomationText($this->l('La licencia se deberia generar para el dominio: ').$licenseDomain, 'notice');
            $form->createFormTextGroup('licencia', $licencia, $this->l('Numero de Licencia'));
            $form->createSubmitButton('submitLicencia', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Gestion Licencia'), $form->renderForm());
        }
        
        $urlPubli = Configuration::getGlobalValue($this->sufijo . 'URL_TXT');
        $tipoPubli = Configuration::getGlobalValue($this->sufijo . 'TIPO');
        $nombre = Configuration::getGlobalValue($this->sufijo . 'NOMBRE_DEVELOPER');
        $descripcionModulo = Configuration::getGlobalValue($this->sufijo . 'DESCRIPCION_MODULO');
        $nombreModulo = Configuration::getGlobalValue($this->sufijo . 'NOMBRE_MODULO');
        $urlEmpresa = Configuration::getGlobalValue($this->sufijo . 'URL_DEVELOPER');
        $urlManual = Configuration::getGlobalValue($this->sufijo . 'URL_MANUAL');
        $urlSoporte = Configuration::getGlobalValue($this->sufijo . 'URL_TICKETS');
        $sampleFile = "Ejemplo file con el nombre de Fichero:<br/> <code>cabecera.jpg;header;https://www.informax.es <br/>
                        footer_a.jpg;footera;https://tienda.informax.es <br/>
                        footer_b.jpg;footerb;https://www.informax.es <br/>";

        $form = new imaxForm($this, $this->_path);
        $form->createHidden("accion", "gestionPubli");
        $form->createHidden("idTab", $idTab);
        $form->createFormTextGroup('urlPubli', $urlPubli, $this->l('Url Publicidad: '));
        $form->createFormTextGroup('nameDeveloper', $nombre, $this->l('Nombre Desarrollador: '));
        $form->createFormTextGroup('nombreModulo', $nombreModulo, $this->l('Nombre Modulo: '));
        $form->createFormTextGroup('descripcionModulo', $descripcionModulo, $this->l('Descripcion Modulo: '));
        $form->createFormTextGroup('namePubli', $tipoPubli, $this->l('Tipo o nombre del Fichero'));
        $form->createFormTextGroup('urlEmpresa', $urlEmpresa, $this->l('Url Empresa'));
        $form->createFormTextGroup('urlManual', $urlManual, $this->l('Url Manual'));
        $form->createFormTextGroup('urlSoporte', $urlSoporte, $this->l('Url Tickets o Soporte'));
        $form->createFormInfomationText($sampleFile);
        $form->createSubmitButton('submitLicencia', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Gestion Publicidad'), $form->renderForm(), false, 'acordeonPubli', 'imaxHidden');

        return $html;
    }

    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    private function installTabNewData() {
        $this->uninstallTab();

        $moduleTabRoot = array();
        $moduleTabRoot['name'] = 'Informax';
        $moduleTabRoot['clase'] = 'AdminInformax';
        $moduleTabRoot['padre'] = '';
        $moduleTabRoot['imagen'] = 'informax.gif';


        $nombreModulo = Configuration::getGlobalValue($this->sufijo . 'NOMBRE_MODULO');
        $moduleTabs = array();
        $moduleTabs[0] = array();
        $moduleTabs[0]['name'] = $nombreModulo;
        $moduleTabs[0]['clase'] = 'AdminImaxRecoleccionPda';
        $moduleTabs[0]['padre'] = 'AdminInformax';
        $moduleTabs[0]['imagen'] = 'informax.gif';


        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }
}