/* global baseUrlAlmacenes, almacenSeleccionado, almacenActual, esModoPago */

$(function() {
    /**
     * Abre una ventana modal.
     * @param {String} selector
     */
    function abrirModal(selector) {
        $('body').append('<div id="overlay"></div>');
        $.fancybox({
            modal: true,
            content: $(selector)
        });
    }
    
    /**
     * Cambia el almacen actual.
     * @param {int} id_warehouse
     * @param {function} callback
     */
    function cambiarAlmacen(id_warehouse, callback) {
        $.getJSON(baseUrlAlmacenes + 'imaxmultialmacen_ajax.php?callback=?', {
            accion: 'almacenSeleccionado',
            id_warehouse: id_warehouse
        }, callback);
    }
    
    if(!almacenSeleccionado) {
        abrirModal('.selectorMultiAlmacen');
    }
    
    $('.imaxSeleccionaAlmacen,#imaxSeleccionaFormaPago').click(function(ev) {
        ev.preventDefault();
        abrirModal('.selectorMultiAlmacen');
    });
    
    $('#selectorAlmacenes li').click(function() {
        cambiarAlmacen($(this).data('id'), function(resultado) {
            //Mostramos la ventana de los productos sin stock de ser necesaria
            if(resultado.ventanaProductosSinStock) {
                //Quitamos la ventana actual y ponemos la nueva por detrás
                $('#ventanaAvisoCambiosCarrito').remove();
                $.fancybox.close();
                $('body').append(resultado.ventanaProductosSinStock);
                //Acepta perder los productos sin stock
                $('#aceptarCambios').click(function() {
                    $.getJSON(baseUrlAlmacenes + 'imaxmultialmacen_ajax.php?callback=?', {
                        accion: 'ajustarCarrito'
                    }, function() {
                        location.reload();
                    });
                });
                //Quiere volver a lo anterior
                $('#cancelarCambios').click(function() {
                    cambiarAlmacen(almacenActual);
                });
                //Eliminamos el overlay y abrimos la nueva ventana
                $('#overlay').remove();
                $('#ventanaAvisoCambiosCarrito').modal('show');
            }
            else {
                location.reload();
            }
        });
    });
    $('#selectorFormaPago li').click(function() {
        $.getJSON(baseUrlAlmacenes + 'imaxmultialmacen_ajax.php?callback=?', {
            accion: 'formaPagoSeleccionada',
            formaPago: $(this).data('forma_pago')
        }, function(resultado) {
            if(esModoPago){
                if(resultado.ok){ 
                    location.reload();
                } else {
                    $('html').removeClass('fancybox-margin');
                    $('html').removeClass('fancybox-lock');
                    $('#overlay').remove();
                    $('.fancybox-overlay').hide();
                    $('#mensajeFormaPagoAlmacen').remove();
                    $('body').append(resultado.datos);
                }
            }else{
                location.reload();
            }
            
            
        });
    });
});