<table class="table" id='tablaVisualizacionStock'>
    <thead>
        <tr>
            <th>{l s='Almacen' mod='imaxmultialmacen'}</th>
            <th>{l s='Mostrar nombre del almacen' mod='imaxmultialmacen'}</th>
            <th>{l s='Mostrar a grupos de clientes' mod='imaxmultialmacen'}</th>
            <th>{l s='Mostrar a comerciales' mod='imaxmultialmacen'}</th>
            <th>{l s='Mostrar a clientes' mod='imaxmultialmacen'}</th>
        </tr>
    </thead>
    <tbody>
        {foreach $almacenesMostrar as $almacen}
            <tr>
                <td>
                    {$almacen->getNombreOriginal()}
                    <input type="hidden" name="almacenes[{$almacen->id_warehouse}][grupos]" value="{','|implode:$almacen->grupos}"/>
                </td>
                <td>
                    <div class="form-group bootstrap">
                        {foreach $idiomas as $idioma}
                            <div class="control-label translatable-field row lang-{$idioma.id_lang}">
                                <div class="col-lg-9">
                                    <input type='text' id='nombreVisible_{$almacen->id_warehouse}_{$idioma.id_lang}' name='almacenes[{$almacen->id_warehouse}][nombreVisible][{$idioma.id_lang}]' value='{$almacen->getNombreVisible($id_lang)}' />
                                </div>
                                <div class="col-lg-2">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        {$idioma.iso_code}
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        {foreach $idiomas as $idiomaSelect}
                                            <li><a href="javascript:hideOtherLanguage({$idiomaSelect.id_lang});">{$idiomaSelect.name}</a></li>
                                        {/foreach}
                                    </ul>
                                </div>
                            </div>
                        {/foreach}
                    </div>
                </td>
                <td>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarGrupos]" value="0" {if $almacen->mostrarGrupos == 0}checked='checked'{/if}/> 
                        {l s='Ningún grupo' mod='imaxmultialmacen'}
                    </label>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarGrupos]" value="1" {if $almacen->mostrarGrupos == 1}checked='checked'{/if}/> 
                        {l s='Todos los grupos' mod='imaxmultialmacen'}
                    </label>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarGrupos]" value="2" {if $almacen->mostrarGrupos == 2}checked='checked'{/if}/> 
                        {l s='Los grupos seleccionados' mod='imaxmultialmacen'}
                        <button name="asignarGrupos" type="button" data-id_warehouse="{$almacen->id_warehouse}">{l s='Seleccionar' mod='imaxmultialmacen'}</button>
                    </label>
                </td>
                <td>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarComerciales]" value="0" {if $almacen->mostrarComerciales == 0}checked='checked'{/if}/> 
                        {l s='Semáforo' mod='imaxmultialmacen'}
                    </label>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarComerciales]" value="1" {if $almacen->mostrarComerciales == 1}checked='checked'{/if}/> 
                        {l s='Cantidad' mod='imaxmultialmacen'}
                    </label>
                </td>
                <td>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarClientes]" value="0" {if $almacen->mostrarClientes == 0}checked='checked'{/if}/> 
                        {l s='Semáforo' mod='imaxmultialmacen'}
                    </label>
                    <label>
                        <input type="radio" name="almacenes[{$almacen->id_warehouse}][mostrarClientes]" value="1" {if $almacen->mostrarClientes == 1}checked='checked'{/if}/> 
                        {l s='Cantidad' mod='imaxmultialmacen'}
                    </label>
                </td>
            </tr>
        {/foreach}
    </tbody>
</table>