<table id="almacenes" class="dataTable" style="width:100%">
    <thead>
        <tr>
            <th>{l s='ID' mod='imaxmultialmacen'}</th>
            <th>{l s='Referencia' mod='imaxmultialmacen'}</th>
            <th>{l s='Nombre' mod='imaxmultialmacen'}</th>
            <th>{l s='Direccion' mod='imaxmultialmacen'}</th>
        </tr>
    </thead>
    
    <tbody></tbody>
</table>

<script>
    $(function() {
        var dialogoDireccion = {$plantillaDireccion nofilter};
        var imagenesActuales = {$imagenesActuales nofilter};

        var archivoImagen = null;
        var editor = new $.fn.dataTable.Editor( {
            ajax: '{$baseUrl}datatableAjax.php?callback=?',
            table: '#almacenes',
            attr : { autocomplete : "off" },
            i18n: traduccionesDatatablesEditorEs,
            fields: [                
                { name: 'warehouse_id', data: '{$prefijoTabla}warehouse.id_warehouse', type: 'hidden' },
                { label: '{l s='Referencia' mod='imaxmultialmacen'}', name: '{$prefijoTabla}warehouse.reference' },
                { label: '{l s='Nombre' mod='imaxmultialmacen'}', name: '{$prefijoTabla}warehouse.name' },
                { 
                    label: '{l s='Direccion' mod='imaxmultialmacen'}', 
                    name: '{$prefijoTabla}warehouse.id_address',
                    type:  "select",
                    options: {$direcciones}
                },
                { 
                    label: '{l s='imagen' mod='imaxmultialmacen'}', 
                    name: 'imagen',
                    type:  'upload',
                    dragDrop: false,
                    clearText: '{l s='Eliminar' mod='imaxmultialmacen'}',
                    fileReadText: '{l s='Procesando' mod='imaxmultialmacen'}',
                    noFileText: '{l s='Sin imagen' mod='imaxmultialmacen'}',
                    processingText: '{l s='Procesando' mod='imaxmultialmacen'}',
                    uploadText: '{l s='Subir' mod='imaxmultialmacen'}',
                    display: function (imagen) {
                        var img = '';
                        if(typeof imagen === 'object') {
                            //Tenemos un file
                            img = '<img class="imagenASubir" src="' + URL.createObjectURL(imagen) + '"/>';
                        }
                        else {
                            //Tenemos el id del almacen
                            img = '<img class="imagenASubir" src="{$baseUrl}images/' + imagen + '.jpg?rand=' + Math.random() + '"/>';
                        }
                        
                        return img;
                    },
                    ajax: function(archivos, upload) {
                        var reader = new FileReader();
                        reader.readAsDataURL(archivos[0]);
                        reader.onload = function () {
                            archivoImagen = reader.result;
                            upload(archivos);
                        };
                        reader.onerror = function (error) {
                            archivoImagen = null;
                            editor.error(error);
                        };
                    }
                }
            ]
        });

        editor.on('open', function ( e, mode, action ) {
            //Botones para crear y editar direcciones
            if($('button[name="crearDireccion"]').length === 0) {
                var btnEditar = $('<button class="btn" name="editarDireccion">{l s='Editar' mod='imaxmultialmacen'}</button>');
                btnEditar.click(function() {
                    obtenerPlantillaDireccion($('#DTE_Field_{$prefijoTabla}warehouse-id_address').val());
                });
                $('body').on('change', '#DTE_Field_{$prefijoTabla}warehouse-id_address', function() {
                    if($(this).val() == 0) {
                        btnEditar.addClass('disabledBtn');
                        btnEditar.attr('disabled', true);
                    }
                    else {
                        btnEditar.removeClass('disabledBtn');
                        btnEditar.attr('disabled', false);
                    }
                });
                $('#DTE_Field_{$prefijoTabla}warehouse-id_address').parent().append(btnEditar);
                
                var btnCrear = $('<button class="btn" name="crearDireccion">{l s='Nueva' mod='imaxmultialmacen'}</button>');
                btnCrear.click(function() {
                    abrirDialogo(dialogoDireccion, function() {
                        $('#nuevaDireccion #address_id_country').change();
                        $('#address_alias').focus();
                    }, null, 'dialogoGrande');
                });
                $('#DTE_Field_{$prefijoTabla}warehouse-id_address').parent().append(btnCrear);
            }
            $('#DTE_Field_{$prefijoTabla}warehouse-id_address').trigger('change');
            
            //Si disponemos de la imagen agregamos el id para que la muestre
            if(imagenesActuales.includes(parseInt(editor.field('warehouse_id').val()))) {
                editor.field('imagen').val(editor.field('warehouse_id').val());
            }
        });

        editor.on( 'preSubmit', function ( e, data, action ) {
            if($('.imagenASubir').length === 0) {
                //No hay imagen asignada, indicamos que se debe borrar
                archivoImagen = '';
            }
            else if(!archivoImagen) {
                //Hay imagen asignada pero no hay datos para enviar, indicamos que no hay que hacer nada
                archivoImagen = '1';
            }
            
            $.each( data.data, function ( key, values ) {
                data.data[key]['imagen'] = archivoImagen;
            });
        });
        
        editor.on('postSubmit', function ( e, data ) {
            $.each( data.data, function ( key, values ) {
                if($('.imagenASubir').length === 0) {
                    //No hay imagen asignada, la quitamos del array de disponibles
                    var index = imagenesActuales.indexOf(parseInt(data.data[key]['{$prefijoTabla}warehouse']['id_warehouse']));
                    if (index > -1) {
                        imagenesActuales.splice(index, 1);
                    }
                }
                else {
                    //Hay imagen asignada, la añadimos al array de disponibles
                    imagenesActuales.push(parseInt(data.data[key]['{$prefijoTabla}warehouse']['id_warehouse']));
                    imagenesActuales = Array.from(new Set(imagenesActuales));
                }
            });
        });

        $('#almacenes').DataTable( {
            ajax: '{$baseUrl}datatableAjax.php?callback=?',
            dom: 'Bfrtip',
            language: {
                url: '{$baseUrl}datatable_lang.php?callback=?'
            },
            columns: [
                { data: '{$prefijoTabla}warehouse.id_warehouse' },
                { data: '{$prefijoTabla}warehouse.reference' },
                { data: '{$prefijoTabla}warehouse.name' },
                { 
                    data: '{$prefijoTabla}warehouse.id_address',
                    render: function(data, type, row, meta) {
                        if(row['{$prefijoTabla}address']['alias']) {
                            return data + ' - ' + row['{$prefijoTabla}address']['alias'];
                        }
                        else {
                            return '';
                        }
                    }
                }
            ],
            select: true,
            buttons: [
                { extend: 'create', editor: editor },
                { extend: 'edit',   editor: editor },
                { extend: 'remove', editor: editor }
            ]
        } );
    });
</script>