<?php
function upgrade_module_1_7($module) {
    $sql = [];
    $sql[] = "ALTER TABLE `"._DB_PREFIX_.$module->sufijo."asignacionAlmacen`
        ADD COLUMN `id_group` INT(10) NOT NULL DEFAULT '0' AFTER `id_state`,
        DROP PRIMARY KEY,
        ADD PRIMARY KEY (`id_country`, `id_state`, `id_group`);";
    
    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.$module->sufijo."text_stock` (
        `id` INT(10) NOT NULL AUTO_INCREMENT,
        `product_id` INT(10) NOT NULL,
        `product_attribute_id` INT(10) NOT NULL DEFAULT 0,
        `id_group` INT(10) NOT NULL DEFAULT 0,
        `id_warehouse` INT(10) NOT NULL,
        `orden_almacen` INT(10) NOT NULL DEFAULT 1,
        `regla_stock_ref` INT(10) NOT NULL,
        `stock_ref` INT(10) NOT NULL,
        `text_con_stock` VARCHAR(255) NULL,
        `text_sin_stock` VARCHAR(255) NULL,
        PRIMARY KEY (`id`),
        INDEX (`product_id`, `product_attribute_id`, `id_warehouse`),
        INDEX (`orden_almacen`)
            )
            COLLATE='utf8_general_ci'
            ENGINE=MyIsam;";

    $sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.$module->sufijo."text_stock_idi` (
        `id` INT(10) NOT NULL AUTO_INCREMENT,
        `id_text_stock` INT(10) NOT NULL,
        `id_lang` INT(10) NOT NULL,
        `text_con_stock` VARCHAR(255) NULL,
        `text_sin_stock` VARCHAR(255) NULL,
        PRIMARY KEY (`id`),
        INDEX (`id_text_stock`),
        INDEX (`id_lang`)
            )
            COLLATE='utf8_general_ci'
            ENGINE=MyIsam;";
    

    $sql[] = "ALTER TABLE `"._DB_PREFIX_."stock`
        ADD INDEX (`id_product`, `id_product_attribute`,`id_warehouse`);";
    
    foreach($sql as $s) {
        if(!Db::getInstance()->execute($s)) {
            return false;
        }
    }
    
    return $module->uninstallOverrides() && $module->installOverrides() && $module->registerHook('displayStockMessage') && $module->checkLicencia(1);
}