<?php

namespace Informax\ImaxMultiAlmacen;

use Context;
use PrestaShopBundle\Entity\StockMvt;
use StockAvailable;
use StockOrdenado;
use Validate;

class StockMovementRepository extends \PrestaShopBundle\Entity\Repository\StockMovementRepository {

    public function saveStockMvt(StockMvt $stockMvt)
    {
        if(!$stockMvt->getIdStockMvt()) {
            //Cambiamos el id del stock de uno de stock_available a uno de stock
            $context = Context::getContext();
            if(Validate::isLoadedObject($context->warehouse)) {
                $id_warehouse = $context->warehouse->id;
            }
            else {
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
            }
            $stockAvailable = new StockAvailable($stockMvt->getIdStock());
            $id_stock = (int) StockAvailable::getWarehouseStockAvailableIdByProductId($stockAvailable->id_product, 
                    $stockAvailable->id_product_attribute, $id_warehouse);
            $stockMvt->setIdStock($id_stock);
        }
        return parent::saveStockMvt($stockMvt);
    }
}
