<?php

namespace Informax\ImaxMultiAlmacen;

use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Warehouse;
use Context;
use Configuration;

class RequestListener {
    private $twig;

    public function __construct($twig) {
        $this->twig = $twig;
    }

    public function onKernelRequest(GetResponseEvent $event) {
        if($event->getRequest()->attributes->get('_controller') == 'PrestaShopBundle\Controller\Admin\StockController::overviewAction') {
            $id_warehouse = (int)Configuration::getGlobalValue('imax_multi_alma_sell_stock_warehouse');
            
            $this->twig->addGlobal('almacenes', Warehouse::getWarehouses(true));
            $this->twig->addGlobal('almacenActual', ($id_warehouse ? $id_warehouse : Context::getContext()->warehouse->id));
            $this->twig->addGlobal('imaxBaseUrl', Context::getContext()->link->getBaseLink());
        }
    }
}
