<?php

namespace Informax\ImaxMultiAlmacen;

use PrestaShop\PrestaShop\Adapter\Product\Stock\QueryHandler\GetProductStockMovementsHandler as GetProductStockMovementsHandlerPresta;
use PrestaShop\PrestaShop\Core\Domain\Product\Stock\Query\GetProductStockMovements;
use Doctrine\DBAL\Connection;
use PrestaShop\PrestaShop\Core\Domain\Product\Stock\ValueObject\StockId;
use PrestaShop\PrestaShop\Adapter\Product\Stock\Repository\StockAvailableRepository;
use PrestaShop\PrestaShop\Adapter\Product\Stock\Repository\StockMovementRepository;
use Symfony\Contracts\Translation\TranslatorInterface;
use Context;

class GetProductStockMovementsHandler extends GetProductStockMovementsHandlerPresta
{
    private $inner, $connection, $dbPrefix;
    
    public function __construct(
            GetProductStockMovementsHandlerPresta $inner,
            Connection $connection,
            string $dbPrefix,
            StockAvailableRepository $stockAvailableRepository,
            StockMovementRepository $stockMovementRepository,
            TranslatorInterface $translator) {
        parent::__construct($stockAvailableRepository, $stockMovementRepository, $translator);
        $this->connection = $connection;
        $this->dbPrefix = $dbPrefix;
        $this->inner = $inner;
    }
    
    public function handle(GetProductStockMovements $query): array
    {
        $queryBuilder = $this->connection->createQueryBuilder();
        $id_stock = $queryBuilder
            ->select('id_stock')
            ->from($this->dbPrefix . 'stock')
            ->where('id_product = :productId AND id_product_attribute = 0 AND id_warehouse = :warehouseId')
            ->setParameter('productId', $query->getProductId()->getValue())
            ->setParameter('warehouseId', Context::getContext()->warehouse->id)
            ->execute()->fetchOne();
        
        return $this->getStockMovements(
            new StockId($id_stock),
            $query->getOffset(),
            $query->getLimit()
        );
    }
}
