<?php

namespace Informax\ImaxMultiAlmacen;

use PrestaShop\PrestaShop\Adapter\Product\Stock\QueryHandler\GetCombinationStockMovementsHandler as GetCombinationStockMovementsHandlerPresta;
use PrestaShop\PrestaShop\Core\Domain\Product\Stock\Query\GetCombinationStockMovements;
use Doctrine\DBAL\Connection;
use PrestaShop\PrestaShop\Core\Domain\Product\Stock\ValueObject\StockId;
use PrestaShop\PrestaShop\Adapter\Product\Stock\Repository\StockAvailableRepository;
use PrestaShop\PrestaShop\Adapter\Product\Stock\Repository\StockMovementRepository;
use Symfony\Contracts\Translation\TranslatorInterface;
use Context;

class GetCombinationStockMovementsHandler extends GetCombinationStockMovementsHandlerPresta 
{
    private $inner, $connection, $dbPrefix;
    
    public function __construct(
            GetCombinationStockMovementsHandlerPresta $inner,
            Connection $connection,
            string $dbPrefix,
            StockAvailableRepository $stockAvailableRepository,
            StockMovementRepository $stockMovementRepository,
            TranslatorInterface $translator) {
        parent::__construct($stockAvailableRepository, $stockMovementRepository, $translator);
        $this->connection = $connection;
        $this->dbPrefix = $dbPrefix;
        $this->inner = $inner;
    }

    public function handle(GetCombinationStockMovements $query): array
    {
        $queryBuilder = $this->connection->createQueryBuilder();
        $id_stock = $queryBuilder
            ->select('id_stock')
            ->from($this->dbPrefix . 'stock')
            ->where('id_product_attribute = :combinationId AND id_warehouse = :warehouseId')
            ->setParameter('combinationId', $query->getCombinationId()->getValue())
            ->setParameter('warehouseId', Context::getContext()->warehouse->id)
            ->execute()->fetchOne();
        
        return $this->getStockMovements(
            new StockId($id_stock),
            $query->getOffset(),
            $query->getLimit()
        );
    }
}
