<?php
$sql = array();

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."asignacionAlmacen` (
	`id_country` INT(10) NOT NULL,
	`id_state` INT(10) NOT NULL DEFAULT 0,
        `id_group` INT(10) NOT NULL DEFAULT 0,
	`id_warehouse` INT(10) NOT NULL,
	PRIMARY KEY (`id_country`, `id_state`, `id_group`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."asignacionAlmacenPago` (
	`forma_pago` VARCHAR(200) NOT NULL,
        `id_group` INT(10) NOT NULL DEFAULT 0,
	`id_warehouse` INT(10) NOT NULL,
	PRIMARY KEY (`forma_pago`, `id_group`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."text_stock` (
	`id` INT(10) NOT NULL AUTO_INCREMENT,
	`product_id` INT(10) NOT NULL,
        `product_attribute_id` INT(10) NOT NULL DEFAULT 0,
	`id_group` INT(10) NOT NULL DEFAULT 0,
	`id_warehouse` INT(10) NOT NULL,
        `orden_almacen` INT(10) NOT NULL DEFAULT 1,
	`regla_stock_ref` INT(10) NOT NULL,
	`stock_ref` INT(10) NOT NULL,
	`text_con_stock` VARCHAR(255) NULL,
	`text_sin_stock` VARCHAR(255) NULL,
	PRIMARY KEY (`id`),
    INDEX (`product_id`, `product_attribute_id`, `id_warehouse`),
    INDEX (`orden_almacen`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."text_stock_idi` (
	`id` INT(10) NOT NULL AUTO_INCREMENT,
	`id_text_stock` INT(10) NOT NULL,
        `id_lang` INT(10) NOT NULL,
	`text_con_stock` VARCHAR(255) NULL,
	`text_sin_stock` VARCHAR(255) NULL,
	PRIMARY KEY (`id`),
    INDEX (`id_text_stock`),
    INDEX (`id_lang`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "ALTER TABLE `"._DB_PREFIX_."stock`
	ADD INDEX (`id_warehouse`, `id_product`, `id_product_attribute`);";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_order` (
	`id_order` INT(10) NOT NULL,
	`id_warehouse` INT(10) NOT NULL,
	PRIMARY KEY (`id_order`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_show` (
	`id_warehouse` INT(10) NOT NULL,
	`mostrarGrupos` TINYINT(1) NOT NULL DEFAULT '0',
	`mostrarComerciales` TINYINT(1) NOT NULL DEFAULT '0',
	`mostrarClientes` TINYINT(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id_warehouse`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_show_lang` (
	`id_warehouse` INT(10) NOT NULL,
	`id_lang` INT(10) NOT NULL,
	`nombreVisible` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`id_warehouse`, `id_lang`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_show_group` (
	`id_warehouse` INT(10) NOT NULL,
	`id_group` INT(10) NOT NULL,
	PRIMARY KEY (`id_warehouse`, `id_group`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."almacenStockVirtual` (
	`id_warehouse` INT(10) NOT NULL,
	`id_warehouse_origen` INT(10) NOT NULL,
	PRIMARY KEY (`id_warehouse`, `id_warehouse_origen`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."extraMovimiento_advanced` (
	`id_stock_available_advanced` INT(11) unsigned NOT NULL,
	`id_warehouse` INT(11) NOT NULL,
	PRIMARY KEY (`id_stock_available_advanced`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."extraStock_advanced` (
	`id_stock` INT(11) unsigned NOT NULL,
	`comments` varchar(255) DEFAULT NULL,
	PRIMARY KEY (`id_stock`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_cart` (
	`id_cart` INT(10) NOT NULL,
	`id_warehouse` INT(10) NOT NULL,
	PRIMARY KEY (`id_cart`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";

$sql[] = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_.self::prefijo."warehouse_carrier` (
	`id_warehouse` INT(10) NOT NULL,
	`transportistas` BLOB NULL,
	PRIMARY KEY (`id_warehouse`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=MyIsam;";