<?php

class Stock extends StockCore 
{
    
    public function update($null_values = false) {
        $result = parent::update($null_values);
        if($result) {
            $result &= $this->postSave();
        }
        
        return $result;
    }

    /**
     * @see ObjectModel::add()
     */
    public function add($autodate = true, $null_values = false) {
        $result = parent::add($autodate, $null_values);
        if($result) {
            $result &= $this->postSave();
        }
        
        return $result;
    }
    
    public function postSave() {
        if ($this->id_product_attribute == 0) {
            return true;
        }

        if (!Configuration::get('PS_DISP_UNAVAILABLE_ATTR')) {
            $combination = new Combination((int) $this->id_product_attribute);
            if ($colors = $combination->getColorsAttributes()) {
                $product = new Product((int) $this->id_product);
                foreach ($colors as $color) {
                    if ($product->isColorUnavailable((int) $color['id_attribute'])) {
                        Tools::clearColorListCache($product->id);

                        break;
                    }
                }
            }
        }

        //Actualizamos la agrupación de stock
        $total_quantity = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow(
            '
			SELECT SUM(usable_quantity) as usable, SUM(physical_quantity) as physical
			FROM `' . _DB_PREFIX_ . 'stock`
			WHERE id_product = ' . (int) $this->id_product . '
			AND id_product_attribute <> 0 AND id_warehouse = '. (int)$this->id_warehouse
        );
        
        $id_stock = (int) StockAvailable::getWarehouseStockAvailableIdByProductId($this->id_product, 0, $this->id_warehouse);
        if ($id_stock) {
            $stockObj = new Stock($id_stock);
            $stockObj->usable_quantity = $total_quantity['usable'];
            $stockObj->physical_quantity = $total_quantity['physical'];
            $stockObj->update();
        } 
        else {
            $stockObj = new Stock($id_stock);
            $stockObj->id_product = (int) $this->id_product;
            $stockObj->id_product_attribute = 0;
            $stockObj->id_warehouse = $this->id_warehouse;
            $stockObj->usable_quantity = $total_quantity['usable'];
            $stockObj->physical_quantity = $total_quantity['physical'];
            $stockObj->price_te = 0;
            $stockObj->add();
        }
        
        Hook::exec(
            'actionUpdateQuantity',
            array(
                'id_product' => $this->id_product,
                'id_product_attribute' => 0,
                'quantity' => $total_quantity['usable'],
            )
        );
        
        return true;
    }
}
