<?php

use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;

class ProductPresenterFactory extends ProductPresenterFactoryCore 
{
    private $context;

    /**
     * ProductPresenterFactory constructor.
     *
     * @param Context $context
     * @param \TaxConfiguration|null $taxConfiguration
     */
    public function __construct(Context $context, TaxConfiguration $taxConfiguration = null)
    {
        parent::__construct($context, $taxConfiguration);
        $this->context = $context;
    }
    
    public function getPresenter()
    {
        require_once _PS_MODULE_DIR_.'imaxmultialmacen/classes/ImaxProductPresenter.php';
        require_once _PS_MODULE_DIR_.'imaxmultialmacen/classes/ImaxProductListingPresenter.php';
        
        $imageRetriever = new ImageRetriever(
            $this->context->link
        );

        if (is_a($this->context->controller, 'ProductListingFrontControllerCore')) {
            return new ImaxProductListingPresenter(
                $imageRetriever,
                $this->context->link,
                new PriceFormatter(),
                new ProductColorsRetriever(),
                $this->context->getTranslator()
            );
        }

        return new ImaxProductPresenter(
            $imageRetriever,
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
    }
}
