/* global listaGruposCliente, gruposClienteSeleccionados, baseUrl, textoBuscarGrupo, textoCancelar, textoAceptar, filaVacia, listaGruposClienteObj, textoSinGrupo, textoConfirmarEliminacion, prefijoTabla, asignacionesFormaPago, traducciones, formasPagoDisponibles, gruposDisponibles, almacenesDisponibles, idLang, textoFaltaTextoBoton, textoFaltaTextoTitulo, gruposActuales, almacenes, traduccionesStockVirtual, almacenesStockVirtualActuales, esModoPago, transportistasClienteSeleccionados, textoBuscarTransportista, textoSinTransportista, listaTransportistasTodos, listaTransportistasTodosObj, textoPerderStock */

/**
* Abre una superposicion.
* @param {String} contenido
* @param {function} callback
* @param {function} callbackAceptar
* @param {String} claseCss
*/
function abrirDialogo(contenido, callback, callbackAceptar, claseCss) {
   if(typeof claseCss === 'undefined') {
       claseCss = '';
   }
   $('body').append('<div class="fondoOscuroDialogo"></div>');
   $('body').append('<div class="contenedorDialogo ' + claseCss + '"><div class="contenidoDialogo">' + contenido + '</div><span class="botonCerrarDialogo">X</span></div>');
   $('.botonCerrarDialogo,.contenedorDialogo input[name="cancelar"]').click(function() {
       cerrarDialogo();
   });
   $('.contenedorDialogo input[name="aceptar"]').click(function() {
       if(typeof callbackAceptar === 'function') {
           callbackAceptar();
       }
       cerrarDialogo();
   });
   if(typeof callback === 'function') {
       callback();
   }
}

/**
* Cierra la superposicion.
*/
function cerrarDialogo() {
   $('.fondoOscuroDialogo').remove();
   $('.contenedorDialogo').remove();
}

/**
 * Devuelve la plantilla de editar direcciones.
 * @param {int} id_address
 */
function obtenerPlantillaDireccion(id_address) {
    $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', {
        accion: 'obtenerPlantillaDireccion',
        id_address: id_address
    }, function(response) {
        if(response.ok) {
            abrirDialogo(response.datos, function() {
                $('#nuevaDireccion #address_id_country').change();
                $('#address_alias').focus();
            }, null, 'dialogoGrande');
        }
    });
}

/**
 * Devuelve los nombres de las etiquetas.
 * @param {Array} tags
 * @param {Array} lista
 * @returns {Array}
 */
function getTagsName(tags, lista) {
   var names = [];
   if(tags.length > 0) {
       tags.forEach(function(tag) {
           names.push(tag.value);
       });
   }
   else {
       names.push(lista[0].value);
   }

   return names;
}

/**
 * Devuelve los ids de las etiquetas.
 * @param {Array} tags
 * @returns {Array}
 */
function getTagsId(tags) {
   var ids = [];
   if(tags.length > 0) {
       tags.forEach(function(tag) {
           ids.push(tag.code);
       });
   }
   else {
       ids.push(0);
   }

   return ids;
}


$(function () {
    new SucesionTeclas('i', function() {
        $('#cargaInicial').toggle();
    });
    
    $('[name="ejecutarCargaInicial"]').click(function(ev) {
        if(!confirm(textoPerderStock)) {
            ev.preventDefault();
        }
    });
    
    if(typeof esModoPago !== 'undefined') {
        if(esModoPago){
            if($('#solicitarSeleccion').is(':checked')){
                $('input[name="modoMostrarVentana"]').parents('.form-group').show();
            } else {
                $('input[name="modoMostrarVentana"]').parents('.form-group').hide();
            }
            
            $('#solicitarSeleccion').change(function() {
                if ($(this).is(':checked')) {
                    $('input[name="modoMostrarVentana"]').parents('.form-group').show();
                } else {
                    $('input[name="modoMostrarVentana"]').parents('.form-group').hide();
                }
            });
            
        }
    }
    
    //Ventana de transportistas visibles
    var ventanaSeleccionTransportistas = new VentanaSeleccionTransportistas(listaTransportistasTodosObj, transportistasClienteSeleccionados);
    ventanaSeleccionTransportistas.rellenarTablaTransportistasSeleccionados();
    $('[name="editarTransportistasAlmacen"]').click(function() {
        ventanaSeleccionTransportistas.mostrar($(this).data('id_warehouse'));
    });
    
    //Eventos de la ventana de cerrar dialogo
    $('body').on('click', '#nuevaDireccion .cancelar', function(ev) {
        //Cancelar
        ev.preventDefault();
        cerrarDialogo();
    });
    $('body').on('click', '#nuevaDireccion .aceptar', function(ev) {
        //Aceptar
        ev.preventDefault();
        var formData = $('#nuevaDireccion').serialize();
        $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?&accion=procesarDireccion', formData, function(response) {
            if(response.ok) {
                var idDireccion = $('#nuevaDireccion input[name="address[id]"]').val();
                if(!idDireccion) {
                    //Nueva direccion
                    $('#almacenes').DataTable().editor().field(prefijoTabla + 'warehouse.id_address').update([
                        { label: response.datos[1].alias, value: response.datos[1].id }], true);
                }
                else {
                    //Direccion editada
                    var options = [];
                    $('#DTE_Field_' + prefijoTabla + 'warehouse-id_address').children().each(function() {
                        if($(this).val() == idDireccion) {
                            options.push({ label: response.datos[1].alias, value: response.datos[1].id });
                        }
                        else {
                            options.push({ label: $(this).html(), value: $(this).val() });
                        }
                    });
                    $('#almacenes').DataTable().editor().field(prefijoTabla + 'warehouse.id_address').update(options);
                }
                cerrarDialogo();
            }
            else {
                $('#ajax_confirmation').html(response.datos[0]).show();
                $('.contenedorDialogo').scrollTop(0);
            }
        });
    });
    $('body').on('change', '#nuevaDireccion #address_id_country', function(ev) {
        //Cambio de pais
        $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', { 
            accion: 'obtenerProvincias',
            id_country: $('select[name="address[id_country]"]').val()
        }, function(response) {
            $('#address_id_state').empty();
            if(response.ok && response.datos.length > 0) {
                for(var i=0,len=response.datos.length;i < len;i++) {
                    $('#address_id_state').append('<option value="' + response.datos[i].id_state + '">' + response.datos[i].name + '</option>');
                }
                $('#address_id_state').val($('#nuevaDireccion input[name="id_state"]').val());
                $('#address_id_state').show();
            }
            else {
                $('#address_id_state').hide();
            }
        });
    });
    
    if(typeof gruposClienteSeleccionados !== 'undefined') {
        var asignaciones = { };
        for(var id_country in gruposClienteSeleccionados) {
            if(typeof asignaciones[id_country] === 'undefined') {
                asignaciones[id_country] = { };
            }

            for(var id_state in gruposClienteSeleccionados[id_country]) {
                if(typeof asignaciones[id_country][id_state] === 'undefined') {
                    asignaciones[id_country][id_state] = [ ];
                }

                for(var id_group in gruposClienteSeleccionados[id_country][id_state]) {
                    asignaciones[id_country][id_state].push(new Asignacion(gruposClienteSeleccionados[id_country][id_state][id_group], id_group));
                }
            }
        }

        /**
         * Inserta una nueva fila vacia.
         * @param {int} id_country
         * @param {int} id_state
         * @param {Array} groups
         */
        function insertarFila(id_country, id_state, groups) {
            var fila = $(filaVacia).clone();
            fila.find('select[name^="almacenOrigen"]').attr('name', 'almacenOrigen[' + id_country + '][' + id_state + ']');
            fila.find('td:first-child').html(groups.join(', '));
            $('table[data-id_country="' + id_country + '"][data-id_state="' + id_state + '"] tbody').append(fila);
        }

        /**
         * Edita los grupos de una fila.
         * @param {int} id_country
         * @param {int} id_state
         * @param {int} posFila
         * @param {Array} groups
         */
        function editarFila(id_country, id_state, posFila, groups) {
            var fila = $('table[data-id_country="' + id_country + '"][data-id_state="' + id_state + '"] tbody').find('tr').eq(posFila);
            fila.find('td:first-child').html(groups.join(', '));
        }

        /**
         * Abre la ventana de asignacion de grupos.
         * @param {jQuery} boton
         * @param {int} posFila
         */
        function abrirVentanaEditarGrupos(boton, posFila) {
            var tagify;
            var tabla = boton.closest('table');
            var id_country = tabla.data('id_country');
            var id_state = tabla.data('id_state');

            abrirDialogo(
                '<div><label>' + textoBuscarGrupo + ' <input type="text" name="buscarGrupo" value=""/></label></div>' +
                '<div class="resultadosBusquedaGrupos clearfix"></div>' + 
                '<div class="contenedorResultados col-lg-6"><input name="gruposPaisEstado" value=""/></div>' +
                '<p>' + textoSinGrupo + '</p>' + 
                '<div class="clearfix"><input type="button" name="aceptar" value="' + textoAceptar + '"/> <input type="button" name="cancelar" value="' + textoCancelar + '"/></div>'
            , function() {
                //Etiquetas para los grupos
                tagify = new Tagify($('input[name^="gruposPaisEstado"]')[0], {
                    whitelist: listaGruposCliente,
                    enforceWhitelist : true,
                    delimiters: null,
                    dropdown: {
                        classname: "tags-look",
                        enabled: 0,
                        closeOnSelect: false,
                        maxItems: 300
                    }
                });

                //Si ya tenemos grupos asignados los mostramos
                if(posFila >= 0 && typeof asignaciones[id_country] !== 'undefined' && typeof asignaciones[id_country][id_state] !== 'undefined') {
                    var tags = [];
                    tags.push(listaGruposClienteObj[asignaciones[id_country][id_state][posFila].ids_group]);
                    tagify.addTags(tags);
                }

                //Buscamos los grupos y los mostramos
                $('input[name="buscarGrupo"]').keyup(function() {
                    if(ajaxBuscarGrupo) {
                        ajaxBuscarGrupo.abort();
                    }

                    ajaxBuscarGrupo = $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', {
                        accion: 'buscarGrupo',
                        texto: $(this).val()
                    }, function(respuesta) {
                        if(respuesta.ok) {
                            var html = [];
                            respuesta.datos.forEach(function(grupo) {
                                html.push('<div>' + grupo.id_group + '-' + grupo.name + ' <input type="button" name="agregarGrupo" value="+" data-value="' + grupo.name + '" data-code="' + grupo.id_group + '"/></div>');
                            });
                            $('.resultadosBusquedaGrupos').html(html.join(''));

                            $('input[name="agregarGrupo"]').click(function() {
                                tagify.addTags([{value: $(this).data('value'), code: $(this).data('code')}]);
                            });
                        }
                    });
                });
            }, function() {
                if(posFila >= 0) {
                    //Editamos una fila
                    asignaciones[id_country][id_state][posFila].ids_group = getTagsId(tagify.value);

                    editarFila(id_country, id_state, posFila, getTagsName(tagify.value, listaGruposClienteObj));
                }
                else {
                    //Nueva fila de grupos
                    if(typeof asignaciones[id_country] === 'undefined') {
                        asignaciones[id_country] = { };
                    }
                    if(typeof asignaciones[id_country][id_state] === 'undefined') {
                        asignaciones[id_country][id_state] = [ ];
                    }
                    asignaciones[id_country][id_state].push(new Asignacion(0, getTagsId(tagify.value)));

                    insertarFila(id_country, id_state, getTagsName(tagify.value, listaGruposClienteObj));
                }
            });
        }

        //Asignamos el evento de eliminar fila
        $('#asignacionesAlmacenes').on('click', 'input[name="eliminarGrupos"]', function() {
            if(confirm(textoConfirmarEliminacion)) {
                var tabla = $(this).closest('table');
                var id_country = tabla.data('id_country');
                var id_state = tabla.data('id_state');
                asignaciones[id_country][id_state].splice($(this).closest('tr').index(), 1);

                $(this).closest('tr').remove();
            }
        });

        //Asignamos el evento de editar fila
        $('#asignacionesAlmacenes').on('click', 'input[name="editarGrupos"]', function() {
            abrirVentanaEditarGrupos($(this), $(this).closest('tr').index());
        });

        //Abrimos la ventana de editar grupos para agregar una fila nueva
        var ajaxBuscarGrupo = null;
        $('input[name="agregarGrupos"]').click(function() {
            abrirVentanaEditarGrupos($(this), -1);
        });

        //Evento guardar
        $('button[name="guardarAsignaciones"]').click(function() {
            var asignacionesOrdenadas = {};
            for(var id_country in asignaciones) {
                for(var id_state in asignaciones[id_country]) {
                    asignaciones[id_country][id_state].forEach(function(asignacion) {
                        if(typeof asignacionesOrdenadas[id_country] === 'undefined') {
                            asignacionesOrdenadas[id_country] = { };
                        }
                        if(typeof asignacionesOrdenadas[id_country][id_state] === 'undefined') {
                            asignacionesOrdenadas[id_country][id_state] = { };
                        }
                        if (typeof asignacionesOrdenadas[id_country][id_state][asignacion.ids_group] === 'undefined') {
                            asignacionesOrdenadas[id_country][id_state][asignacion.ids_group] = { };
                        }
                        asignacionesOrdenadas[id_country][id_state][asignacion.ids_group]['id_warehouse'] = asignacion.id_warehouse;
                    });
                }
            }

            $('input[name="asignaciones"]').val(JSON.stringify(asignacionesOrdenadas));
            $('input[name="transportistasVisibles"]').val(JSON.stringify(ventanaSeleccionTransportistas.obtenerSeleccionados()));
        });

        //Cambio de almacen
        $('#asignacionesAlmacenes').on('change', 'select[name^="almacenOrigen"]', function() {
            var id_warehouse = $(this).val();
            var id_country = $(this).closest('table').data('id_country');
            var id_state = $(this).closest('table').data('id_state');
            var index = $(this).closest('tr').index();
            asignaciones[id_country][id_state][index].id_warehouse = id_warehouse;
        });
    }
    
    //Asignaciones forma pago
    if(typeof asignacionesFormaPago !== 'undefined') {
        var asignacionesFormaPagoObj = new AsignacionesFormaPago(asignacionesFormaPago, traducciones, formasPagoDisponibles, gruposDisponibles, 
            almacenesDisponibles, '#contenedorAsignacionesFormaPago');
        asignacionesFormaPagoObj.deserializar(asignacionesFormaPago);
        asignacionesFormaPagoObj.dibujar();
        
        $('button[name="guardarAsignaciones"]').click(function() {
            $('input[name="asignacionesFormaPago"]').val(JSON.stringify(asignacionesFormaPagoObj.serializar()));
        });
    }
    
    //Datos obligatorios
    $('button[name="guardarAsignaciones"]').click(function(ev) {
        if($('#mostrarBotonAlmacen').is(':checked') && !$('#textoBotonAlmacen_' + idLang).val().trim()) {
            ev.preventDefault();
            showErrorMessage(textoFaltaTextoBoton);
        }
        if(($('#mostrarBotonAlmacen').is(':checked') || $('#solicitarSeleccion').is(':checked')) && !$('#tituloSeleccion_' + idLang).val().trim()) {
            ev.preventDefault();
            showErrorMessage(textoFaltaTextoTitulo);
        }
    });
    
    //Visibilidad del stock
    $('body').on('click', 'button[name="asignarGrupos"]', function() {
        var id_warehouse = $(this).data('id_warehouse');
        $('[name="almacenes[' + id_warehouse + '][mostrarGrupos]"]').attr('checked', false);
        $('[name="almacenes[' + id_warehouse + '][mostrarGrupos]"][value="2"]').attr('checked', 'checked');
        var asignacionGrupos = new AsignacionGrupos(gruposActuales[id_warehouse], gruposDisponibles, traducciones, function(grupos) {
            var idsGrupo = grupos.map(function(grupo) {
                return grupo.id;
            });
            $('[name="almacenes[' + id_warehouse + '][grupos]"]').val(idsGrupo.join(','));
        });
        asignacionGrupos.abrirVentanaAsignacion();
    });
    
    //Stock virtual
    var stockVirtual = new StockVirtual($('#controlesStockVirtual'), almacenes, traduccionesStockVirtual);
    for(var id_warehouse in almacenesStockVirtualActuales) {
        stockVirtual.agregarAlmacenStockVirtual(id_warehouse, almacenesStockVirtualActuales[id_warehouse]);
    }
    $('[name="agregarStockVirtual"]').click(function() {
        stockVirtual.agregarAlmacenStockVirtual($('[name="nuevoStockVirtual"]').val(), []);
        stockVirtual.cambiarAlmacenStockVirtualActual($('[name="nuevoStockVirtual"]').val());
    });
    $('[name="guardarVirtual"]').click(function() {
        $('[name="almacenesStockVirtualActuales"]').val(JSON.stringify(stockVirtual.exportar()));
    });
    stockVirtual.aplicarHtml();
    
    //Modificaciones visuales según el modo
    $('#modo').change(function() {
        if($(this).val() == 1) {
            $('#distinguirFisico').closest('.form-group').hide();
        }
        else {
            $('#distinguirFisico').closest('.form-group').show();
        }
    });
    $('#modo').change();
    
    //Desolapar cron
    new SucesionTeclas('s', function() {
        $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', {
            accion: 'desolapar'
        }, function(respuesta) {
            if (respuesta.ok) {
                showSuccessMessage(respuesta.datos.mensaje);
            }
            else {
                showErrorMessage(respuesta.datos.mensaje);
            }
        });
    });
});
