/* global textoBuscarTransportista, textoSinTransportista, textoAceptar, textoCancelar */

/**
 * Maneja la ventana de selección de transportistas visibles.
 * @type {VentanaSeleccionTransportistas}
 */
class VentanaSeleccionTransportistas {
    /**
     * 
     * @param {Object} transportistas
     * @param {Object} transportistasSeleccionados
     * @returns {VentanaSeleccionTransportistas}
     */
    constructor(transportistas, transportistasSeleccionados) {
        this.transportistas = transportistas;
        this.transportistasSeleccionados = transportistasSeleccionados;
    }
    
    /**
     * Muestra la ventana de selección de transportistas visibles.
     * @param {int} id_warehouse
     */
    mostrar(id_warehouse) {
        var tagifyTransportistas, ajaxBuscarTransportista, esto = this;

        abrirDialogo(
            '<div><label>' + textoBuscarTransportista + ' <input type="text" name="buscarTransportista" value=""/></label></div>' +
            '<div class="resultadosBusquedaTransportistas clearfix"></div>' + 
            '<div class="contenedorResultadosTransportista col-lg-6"><input name="etiquetasTransportistas" value=""/></div>' +
            '<p>' + textoSinTransportista + '</p>' + 
            '<div class="clearfix"><input type="button" name="aceptar" value="' + textoAceptar + '"/> <input type="button" name="cancelar" value="' + textoCancelar + '"/></div>'
        , function() {
            //Etiquetas para los transportistas
            tagifyTransportistas = new Tagify($('input[name^="etiquetasTransportistas"]')[0], {
                whitelist: Object.values(esto.transportistas),
                enforceWhitelist : true,
                delimiters: null,
                dropdown: {
                    classname: "tags-look",
                    enabled: 0,
                    closeOnSelect: false,
                    maxItems: 300
                }
            });

            //Si ya tenemos transportistas asignados los mostramos
            var tags = [];
            if(typeof esto.transportistasSeleccionados[id_warehouse] !== 'undefined') {
                esto.transportistasSeleccionados[id_warehouse].forEach(function(id_carrier) {
                    tags.push(esto.transportistas[id_carrier]);
                });
            }
            if(tags.length === 0) {
                tags.push(esto.transportistas[0]);
            }
            tagifyTransportistas.addTags(tags);

            //Buscamos los transportistas y los mostramos
            $('input[name="buscarTransportista"]').keyup(function() {
                if(ajaxBuscarTransportista) {
                    ajaxBuscarTransportista.abort();
                }

                ajaxBuscarTransportista = $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', {
                    accion: 'buscarTransportista',
                    texto: $(this).val()
                }, function(respuesta) {
                    if(respuesta.ok) {
                        var html = [];
                        respuesta.datos.forEach(function(carrier) {
                            html.push('<div>' + carrier.id_reference + '-' + carrier.name + ' <input type="button" name="agregarTransportista" value="+" data-value="' + carrier.name + '" data-code="' + carrier.id_reference + '"/></div>');
                        });
                        $('.resultadosBusquedaTransportistas').html(html.join(''));

                        $('input[name="agregarTransportista"]').click(function() {
                            tagifyTransportistas.addTags([{value: $(this).data('value'), code: $(this).data('code')}]);
                        });
                    }
                });
            });
        }, function() {
            //Editamos una fila
            esto.transportistasSeleccionados[id_warehouse] = getTagsId(tagifyTransportistas.value);
            if(esto.transportistasSeleccionados[id_warehouse].includes(0)) {
                esto.transportistasSeleccionados[id_warehouse] = [];
                tagifyTransportistas.value = [];
            }
            $('#transportistasVisibles_' + id_warehouse).html(getTagsName(tagifyTransportistas.value, esto.transportistas).join(', '));
        });
    }
    
    /**
     * Devuelve los transportistas seleccionados.
     * @returns {Object}
     */
    obtenerSeleccionados() {
        return this.transportistasSeleccionados;
    }
    
    /**
     * Modifica la columna de transportistas visibles.
     */
    rellenarTablaTransportistasSeleccionados() {
        var esto = this;
        for(var id_warehouse in this.transportistasSeleccionados) {
            var nombresTransportistas = [];
            var transportistasAlmacen = this.transportistasSeleccionados[id_warehouse];
            if(transportistasAlmacen.length > 0) {
                transportistasAlmacen.forEach(function(transportistaAlmacen) {
                    nombresTransportistas.push(esto.transportistas[transportistaAlmacen].value);
                });
            }
            else {
                nombresTransportistas.push(this.transportistas[0].value);
            }
            
            $('#transportistasVisibles_' + id_warehouse).html(nombresTransportistas.join(', '));
        }
    }
}