/**
 * Sirve para poder hacer revisiones justo antes de que se envie un pedido.
 * @type {Tapa}
 */
class Tapa {
    static instancia;
    
    /*
     * 
     * @returns {Tapa}
     */
    constructor() {
        this.manejadores = [];
    }
    
    /**
     * Devuelve la instancia unica de la tapa.
     * @returns {Tapa}
     */
    static obtenerInstancia() {
        if(!this.instancia) {
            this.instancia = new Tapa();
        }
        
        return this.instancia;
    }
    
    /**
     * Agrega un manejador del evento de la tapa.
     * @param {function} manejador Una funcion que recibe como parametro otra funcion a la que debe llamar al finalizar pasandole un boolean que 
     * indique si se debe continuar o no.
     */
    agregarManejador(manejador) {
        this.manejadores.push(manejador);
    }
    
    /**
     * Pone la tapa sobre el boton de compra.
     */
    colocarTapa() {
        if($('.tapaPaymentConfirmation').length === 0 && $('#payment-confirmation').length > 0) {
            
            $('body').append(
                '<style>#payment-confirmation { position: relative; } ' + 
                '.tapaPaymentConfirmation { position: absolute; height: 100%; width: 100%; top: 0; left: 0; cursor: not-allowed; }</style>'
            );

            var esto = this;
            var bloqueado = true;
            var tapa = $('<div class="tapaPaymentConfirmation"></div>');
            tapa.click(function (ev) {
                if(!bloqueado) {
                    ev.stopImmediatePropagation();
                    $('#payment-confirmation').find('button').attr('disabled', 'disabled');

                    var correctos = 0, totales = 0, total = esto.manejadores.length;
                    var procesado = function(resultado) {
                        if(resultado) {
                            correctos++;
                        }
                        totales++;
                        
                        if(totales >= total) {
                            $('#payment-confirmation').find('button').attr('disabled', false);
                            if(correctos >= total) {
                                //Continuamos con la compra
                                $('#payment-confirmation .btn').each(function() {
                                    var buttonPos = $(this).offset();
                                    if(ev.pageX >= buttonPos.left && ev.pageX <= buttonPos.left + $(this).outerWidth() &&
                                            ev.pageY >= buttonPos.top && ev.pageY <= buttonPos.top + $(this).outerHeight()) {
                                        $(this).click();
                                    }
                                });
                            }
                        }
                    };
                    for(var i in esto.manejadores) {
                        esto.manejadores[i](procesado);
                    }
                }
            });
            $('#payment-confirmation').append(tapa);

            //Cambiamos el icono del boton "Pagar y confirmar"
            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (mutation.type === "attributes") {
                        if ($('#payment-confirmation .btn-primary').is(':disabled')) {
                            tapa.css({ 'cursor': 'not-allowed' });
                            bloqueado = true;
                        } else {
                            tapa.css({ 'cursor': 'pointer' });
                            bloqueado = false;
                        }
                    }
                });
            });
            observer.observe($('#payment-confirmation .btn-primary')[0], {
                attributes: true
            });
        }
    }
}