/**
 * Para trabajar con almacenes de stock virtual.
 * @type {StockVirtual}
 */
class StockVirtual {
    /**
     * 
     * @param {jQuery} contenedor
     * @param {Array} almacenes
     * @param {Object} traducciones
     * @returns {StockVirtual}
     */
    constructor(contenedor, almacenes, traducciones) {
        this.contenedor = contenedor;
        this.almacenesStockVirtual = [];
        this.almacenes = almacenes;
        this.traducciones = traducciones;
        this.almacenStockVirtualActual = null;
    }
    
    /**
     * Traduce un texto.
     * @param {String} texto
     * @returns {String}
     */
    l(texto) {
        return (typeof this.traducciones[texto] !== 'undefined' ? this.traducciones[texto] : texto);
    }
    
    /**
     * Coloca el html donde se indica.
     * @returns {String}
     */
    aplicarHtml() {
        var html = '', esto = this, elementos = null;
        //Almacenes con stock virtual
        html += '<div>';
        this.almacenesStockVirtual.forEach(function(almacenStockVirtual) {
            var seleccionado = (esto.almacenStockVirtualActual && 
                    esto.almacenStockVirtualActual.id_warehouse == almacenStockVirtual.id_warehouse ? 'virtualSeleccionado' : '');
            html += "<div class='contenedorAlmacenVirtual " + seleccionado + "'><p>" + almacenStockVirtual.nombreVisible + "</p>" + 
                    "<p><button name='almacenStockVirtual' data-id_warehouse='" + almacenStockVirtual.id_warehouse + "'>" + 
                    esto.traducciones['Configurar'] + "</button></p></div>";
        });
        html += '</div>';
        if(this.almacenesStockVirtual.length > 0 && this.almacenStockVirtualActual) {
            html += '<div>';
            html += '<input type="button" name="eliminarStockVirtual" value="' + this.l('Eliminar') + '"/>';
            html += '<label><input type="checkbox" name="todosStockVirtual" value="1"/> ' + this.l('Seleccionar todos') + '</label>';
            html += '</div>';
            //Lista de almacenes origen seleccionables
            html += '<div>';
            this.almacenes.forEach(function(almacen) {
                if(this.almacenStockVirtualActual.id_warehouse != almacen.id) {
                    var seleccionado = (this.almacenStockVirtualActual.seleccionado(almacen.id) ? 'checked="checked"' : '');
                    html += "<label><input type='checkbox' name='almacenOrigen[]' value='" + almacen.id + "' " + seleccionado + "/> " + almacen.nombre + '</label>';
                }
            }.bind(this));
            html += '</div>';
            
            elementos = $(html);
            //Elimina un almacén de stock virtual
            elementos.find('[name="eliminarStockVirtual"]').click(function() {
                esto.eliminarAlmacenStockVirtual(esto.almacenStockVirtualActual.id_warehouse);
                esto.cambiarAlmacenStockVirtualActual(null);
            });
            //Marcada nueva relación de stock virtual
            elementos.find('[name="almacenOrigen[]"]').click(function() {
                if($(this).is(':checked')) {
                    esto.almacenStockVirtualActual.agregarAlmacenSeleccionado($(this).val());
                }
                else {
                    esto.almacenStockVirtualActual.eliminarAlmacenSeleccionado($(this).val());
                }
            });
            //Marcamos o desmarcamos todas las relaciones
            elementos.find('[name="todosStockVirtual"]').click(function() {
                var marcar = $(this).is(':checked');
                $('[name="almacenOrigen[]"]').each(function() {
                    if((marcar && !$(this).is(':checked')) || (!marcar && $(this).is(':checked'))) {
                        $(this).click();
                    }
                });
            });
        }
        
        if(!elementos) {
            elementos = $(html);
        }
        //Cambio de almacén de stock virtual actual
        elementos.find('[name="almacenStockVirtual"]').click(function() {
            esto.cambiarAlmacenStockVirtualActual($(this).data('id_warehouse'));
        });
        elementos.find('button').click(function(ev) {
            ev.preventDefault();
            $(this).children('input').click();
        });

        this.contenedor.empty();
        this.contenedor.append(elementos);
    }
    
    /**
     * Elimina el almacén de stock virtual del array.
     * @param {int} id_warehouse
     */
    eliminarAlmacenStockVirtual(id_warehouse) {
        var pos = -1;
        for(var i in this.almacenesStockVirtual) {
            if(this.almacenesStockVirtual[i].id_warehouse == id_warehouse) {
                pos = i;
                break;
            }
        }
        
        if(pos > -1) {
            this.almacenesStockVirtual.splice(pos, 1);
        }
    }
    
    /**
     * Agrega el almacén de stock virtual si no está ya.
     * @param {int} id_warehouse
     * @param {int[]} almacenesSeleccionados
     */
    agregarAlmacenStockVirtual(id_warehouse, almacenesSeleccionados) {
        //Comprobamos que no está ya y lo agregamos
        if(!this.buscarAlmacenStockVirtual(id_warehouse)) {
            var almacen = this.buscarAlmacen(id_warehouse);
            if(almacen) {
                var nuevoAlmacen = new AlmacenStockVirtual(id_warehouse, almacen.nombre, almacenesSeleccionados);
                this.almacenesStockVirtual.push(nuevoAlmacen);
            }
        }
    }
    
    /**
     * Cambia el almacén actual.
     * @param {int} id_warehouse null para deseleccionar.
     */
    cambiarAlmacenStockVirtualActual(id_warehouse) {
        if(id_warehouse) {
            var almacenEncontrado = this.buscarAlmacenStockVirtual(id_warehouse);
            if(almacenEncontrado) {
                this.almacenStockVirtualActual = almacenEncontrado;
                this.aplicarHtml();
            }
        }
        else {
            this.almacenStockVirtualActual = null;
            this.aplicarHtml();
        }
    }
    
    /**
     * Devuelve el almacén de stock virtual de la lista.
     * @param {int} id_warehouse
     * @returns {AlmacenStockVirtual}
     */
    buscarAlmacenStockVirtual(id_warehouse) {
        var almacen = null;
        for(var i in this.almacenesStockVirtual) {
            if(this.almacenesStockVirtual[i].id_warehouse == id_warehouse) {
                almacen = this.almacenesStockVirtual[i];
                break;
            }
        }
        
        return almacen;
    }
    
    /**
     * Devuelve los datos del almacén buscado.
     * @param {int} id_warehouse
     * @returns {Array}
     */
    buscarAlmacen(id_warehouse) {
        var almacen = null;
        for(var i in this.almacenes) {
            if(this.almacenes[i].id == id_warehouse) {
                almacen = this.almacenes[i];
                break;
            }
        }
        
        return almacen;
    }
    
    /**
     * Devuelve id_warehouse: [ids_warehouse].
     * @returns {Object}
     */
    exportar() {
        var resultado = {};
        this.almacenesStockVirtual.forEach(function(almacenStockVirtual) {
            resultado[almacenStockVirtual.id_warehouse] = almacenStockVirtual.almacenesSeleccionados;
        });
        
        return resultado;
    }
}