/* global baseUrl */

/**
 * Clase para manejar la visualización de las asignaciones de grupos.
 * @type AsignacionGrupos
 */
class AsignacionGrupos {
    /**
     * 
     * @param {Array} gruposActuales
     * @param {Array} gruposDisponibles
     * @param {Object} traducciones
     * @param {function} callbackAsignacion Se le pasa la nueva asignación de grupos.
     * @returns {AsignacionGrupos}
     */
    constructor(gruposActuales, gruposDisponibles, traducciones, callbackAsignacion) {
        this.gruposActuales = gruposActuales;
        this.traducciones = traducciones;
        this.gruposDisponibles = gruposDisponibles;
        this.callbackAsignacion = callbackAsignacion;
    }
    
    /**
     * Traduce un texto.
     * @param {String} texto
     * @returns {String}
     */
    l(texto) {
        return (typeof this.traducciones[texto] === 'undefined' ? texto : this.traducciones[texto]);
    }
    
    /**
     * Abre una ventana para configurar la asignación de grupos.
     */
    abrirVentanaAsignacion() {
        var esto = this, tagify;
        abrirDialogo(
            '<div><label class="titulo">' + this.l('Buscar grupo:') + ' <input type="text" name="buscarGrupo" value=""/></label></div>' +
            '<div class="resultadosBusquedaGrupos clearfix"></div>' + 
            '<div class="contenedorResultados col-lg-6"><input name="gruposSeleccionados" value=""/></div>' +
            '<div class="clearfix"><input type="button" name="aceptar" value="' + this.l('Aceptar') + '"/> <input type="button" name="cancelar" value="' + this.l('Cancelar') + '"/></div>'
        , function() {
            //Etiquetas para los grupos
            tagify = new Tagify($('input[name="gruposSeleccionados"]')[0], {
                whitelist: esto.gruposDisponibles.map(function(grupoDisponible) { return { code: grupoDisponible.id, value: grupoDisponible.nombre }; }),
                enforceWhitelist : true,
                delimiters: null,
                dropdown: {
                    classname: "tags-look",
                    enabled: 0,
                    closeOnSelect: false,
                    maxItems: 300
                }
            });
            //Si ya tenemos grupos asignados los mostramos
            var tags = [];
            esto.gruposActuales.forEach(function(grupo) {
                tags.push({ code: grupo.id, value: grupo.nombre });
            });
            tagify.addTags(tags);

            //Buscamos los grupos y los mostramos
            var ajaxBuscarGrupo = null;
            $('input[name="buscarGrupo"]').keyup(function() {
                if(ajaxBuscarGrupo) {
                    ajaxBuscarGrupo.abort();
                }

                ajaxBuscarGrupo = $.getJSON(baseUrl + 'imaxmultialmacen_ajax.php?callback=?', {
                    accion: 'buscarGrupo',
                    texto: $(this).val()
                }, function(respuesta) {
                    if(respuesta.ok) {
                        var html = [];
                        respuesta.datos.forEach(function(grupo) {
                            html.push('<div>' + grupo.id_group + '-' + grupo.name + ' <input type="button" name="agregarGrupo" value="+" data-value="' + grupo.name + '" data-code="' + grupo.id_group + '"/></div>');
                        });
                        $('.resultadosBusquedaGrupos').html(html.join(''));

                        $('input[name="agregarGrupo"]').click(function() {
                            tagify.addTags([{value: $(this).data('value'), code: $(this).data('code')}]);
                        });
                    }
                });
            });
        }, function() {
            //Ejecutamos el callback con los nuevos grupos
            var grupos = [];
            tagify.value.forEach(function(elemento) {
                grupos.push({
                    id: elemento.code,
                    nombre: elemento.value
                });
            });
            esto.callbackAsignacion(grupos);
        }, 'ventaAsignacionGrupos');
    }
}