/**
 * Representa una fila de la tabla de asignaciones por forma de pago.
 * @type AsignacionFormaPago
 */
class AsignacionFormaPago {
    /**
     * 
     * @param {Array} formasPago
     * @param {Array} grupos
     * @param {int} almacen
     * @param {Object} traducciones
     * @param {Array} almacenesDisponibles
     * @returns {AsignacionFormaPago}
     */
    constructor(formasPago, grupos, almacen, traducciones, almacenesDisponibles) {
        this.formasPago = formasPago;
        this.grupos = grupos;
        this.almacen = almacen;
        this.traducciones = traducciones;
        this.almacenesDisponibles = almacenesDisponibles;
        this.id = 'asignacionformapago_' + Math.floor(Math.random() * 1000);
    }
    
    /**
     * Traduce un texto.
     * @param {String} texto
     * @returns {String}
     */
    l(texto) {
        return (typeof this.traducciones[texto] === 'undefined' ? texto : this.traducciones[texto]);
    }

    /**
     * Devuelve una fila de la tabla de asignaciones.
     * @returns {String}
     */
    html() {
        var nombresGrupo = this.grupos.map(function(grupo) {
            return grupo.nombre;
        }).join(', ');
        
        var nombresFormasPago = this.formasPago.map(function(formaPago) {
            return formaPago.nombre;
        }).join(', ');
        
        var optionsAlmacenes = '', esto = this;
        this.almacenesDisponibles.forEach(function(almacen) {
            var selected = (almacen.id == esto.almacen ? 'selected="selected"' : '');
            optionsAlmacenes += '<option value="' + almacen.id + '" ' + selected + '>' + almacen.nombre + '</option>';
        });
        
        var html = '<tr data-id="' + this.id + '">';
        html += '<td>' + (nombresGrupo ? nombresGrupo : this.l('- Todos -')) + '</td>';
        html += '<td>' + nombresFormasPago + '</td>';
        html += '<td><select name="almacenFormaPago">' + optionsAlmacenes + '</select></td>';
        html += '<td><input type="button" name="editarGrupos" value="' + this.l('Editar') + '"></td>';
        html += '<td><input type="button" name="eliminarGrupos" value="' + this.l('Eliminar') + '"></td>';
        html += '</tr>';
        
        return html;
    }
    
    /**
     * Devuelve los datos a guardar.
     * @returns {Object}
     */
    serializar() {
        return {
            formasPago: this.formasPago.map(function(formaPago) { return formaPago.id; }),
            grupos: this.grupos.map(function(grupo) { return grupo.id; }),
            almacen: this.almacen
        };
    }
}