/**
 * Representa un almacén de stock virtual.
 * @type {AlmacenStockVirtual}
 */
class AlmacenStockVirtual {
    /**
     * 
     * @param {int} id_warehouse
     * @param {String} nombreVisible
     * @param {int[]} almacenesSeleccionados
     * @returns {AlmacenStockVirtual}
     */
    constructor(id_warehouse, nombreVisible, almacenesSeleccionados) {
        this.id_warehouse = id_warehouse;
        this.nombreVisible = nombreVisible;
        this.almacenesSeleccionados = almacenesSeleccionados;
    }
    
    /**
     * Agrega un almacén de origen.
     * @param {int} id_warehouse
     */
    agregarAlmacenSeleccionado(id_warehouse) {
        if(!this.almacenesSeleccionados.includes(id_warehouse)) {
            this.almacenesSeleccionados.push(id_warehouse);
        }
    }
    
    /**
     * Elimina un almacén de origen.
     * @param {int} id_warehouse
     */
    eliminarAlmacenSeleccionado(id_warehouse) {
        var pos = -1;
        for(var i in this.almacenesSeleccionados) {
            if(this.almacenesSeleccionados[i] == id_warehouse) {
                pos = i;
                break;
            }
        }
        
        if(pos > -1) {
            this.almacenesSeleccionados.splice(pos, 1);
        }
    }
    
    /**
     * Indica si el almacén pasado está seleccionado como almacén origen.
     * @param {int} id_warehouse
     * @returns {bool}
     */
    seleccionado(id_warehouse) {
        return this.almacenesSeleccionados.includes(id_warehouse);
    }
}