<?php

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../init.php');
include(dirname(__FILE__).'/imaxmultialmacen.php');


$accion = Tools::getValue('accion');
$resultado = array('ok' => false, 'datos' => array());

switch ($accion) {
    case 'cambiarAlmacen':
        $resultado['ok'] = Configuration::updateGlobalValue(ImaxMultiAlmacen::prefijo.'sell_stock_warehouse', Tools::getValue('id_warehouse'));
        break;
    
    case 'almacenSeleccionado':
        Context::getContext()->cookie->selected_warehouse = Tools::getValue('id_warehouse');
        Context::getContext()->cookie->write();
        
        $imax = Module::getInstanceByName('imaxmultialmacen');
        if($imax->getModoActual() == ImaxMultiAlmacen::MODO_TRANSPORTISTA && Context::getContext()->cart && Context::getContext()->cart->id_carrier) {
            //Tenemos que asegurarnos de que el transportista actual es del nuevo almacén
            require_once __DIR__.'/../imaxpuntosrecogida/classes/TransportistaExtra.php';
            $transportista = new Carrier(Context::getContext()->cart->id_carrier);
            $transportistaExtra = TransportistaExtra::cargar($transportista->id_reference);

            if($transportistaExtra->id_warehouse != Tools::getValue('id_warehouse')) {
                //Cambiamos de transportista
                $deliveryOptionList = Context::getContext()->cart->getDeliveryOptionList();
                if($deliveryOptionList) {
                    foreach($deliveryOptionList as $id_address_delivery => $deliveryOptionListTemp) {
                        foreach($deliveryOptionListTemp as $id_carrier => $deliveryOption) {
                            $transportista = new Carrier($id_carrier);
                            $transportistaExtra = TransportistaExtra::cargar($transportista->id_reference);
                            if($transportistaExtra->id_warehouse == Tools::getValue('id_warehouse')) {
                                Context::getContext()->cart->setDeliveryOption([$id_address_delivery => $id_carrier]);
                                Context::getContext()->cart->save();
                            }
                        }
                    }
                }
                else {
                    Context::getContext()->cart->setDeliveryOption();
                    Context::getContext()->cart->save();
                }
            }
        }
        
        //Ajustamos el carrito según el stock
        $ajuste = $imax->comprobarCarrito();
        
        $resultado['ok'] = true;
        $resultado['ventanaProductosSinStock'] = $ajuste[0];
        break;
    
    case 'formaPagoSeleccionada':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        if($imax->getFunciones()->esPosibleCambiarFormaPago(Tools::getValue('formaPago', ''))){
            $imax->setSavePayment(Tools::getValue('formaPago', ''));
            $resultado['ok'] = true;
        } else {
            $warehouse = $imax->getWarehouse();
            $idWarehouse = $warehouse->id;
            $almacenShowStock = new WarehouseShowStock($idWarehouse);
            $warehouseName = $almacenShowStock->getNombreVisible(Context::getContext()->language->id);
            $resultado['datos'] = $imax->getFunciones()->plantillaMensajeFormaPagoAlmacen($warehouseName);
            $resultado['ok'] = false;
        }
        
        break;
    
    case 'buscarGrupo':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $resultado['ok'] = true;
        $resultado['datos'] = $imax->getFunciones()->buscarGrupo(Tools::getValue('texto'));
        break;
    
    case 'buscarTransportista':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $resultado['ok'] = true;
        $resultado['datos'] = $imax->getFunciones()->buscarTransportista(Tools::getValue('texto'));
        break;
    
    case 'obtenerProvincias':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $resultado['ok'] = true;
        $resultado['datos'] = $imax->getFunciones()->cargarEstados(Tools::getValue('id_country'));
        break;
    
    case 'procesarDireccion':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $datosDireccion = Tools::getValue('address');
        $resultado['datos'] = $imax->getFunciones()->procesarDireccion($datosDireccion);
        $resultado['ok'] = !$resultado['datos'][0];
        break;
    
    case 'obtenerPlantillaDireccion':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $id_address = Tools::getValue('id_address');
        $resultado['datos'] = $imax->getFunciones()->plantillaDireccion($id_address);
        $resultado['ok'] = (boolean)$resultado['datos'];
        break;
    
    case 'ajustarCarrito':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $resultado['datos'] = ['todosSinStock' => $imax->ajustarCarrito()];
        $resultado['ok'] = true;
        break;
    
    case 'anotarCarritoAlmacen':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $resultado['ok'] = $imax->getFunciones()->anotarCarritoPedido(Context::getContext()->cart->id, $imax->getWarehouse()->id);
        $resultado['datos'] = [];
        break;
    
    case 'desolapar':
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $imax->getFunciones()->terminarProceso('sv');
        $resultado['ok'] = true;
        $resultado['datos']['mensaje'] = $imax->l('Cron desolapado');
        break;
}

echo Tools::getValue('callback').'('.json_encode($resultado).')';
