<?php

require_once dirname(__FILE__).'/ComunesImaxMultiAlmacen.php';
require_once dirname(__FILE__).'/FuncionesImaxMultiAlmacen.php';
require_once dirname(__FILE__).'/classes/StockOrdenado.php';
require_once dirname(__FILE__).'/classes/AsignacionAlmacenPago.php';
require_once dirname(__FILE__).'/classes/WarehouseShowStock.php';
require_once dirname(__FILE__).'/classes/ModificadorClases.php';
require_once dirname(__FILE__).'/classes/AlmacenStockVirtual.php';
require_once dirname(__FILE__).'/classes/ActualizarStockFisico.php';
require_once dirname(__FILE__).'/classes/AlmacenesVirtuales.php';
require_once dirname(__FILE__).'/classes/GestAvdStockClass.php';

class ImaxMultiAlmacen extends Module implements \PrestaShop\PrestaShop\Core\Module\WidgetInterface {//TODO: ¿qué ajustes hay que hacer al instalar (ejecutar cron virtual, stock reservado positivo)? El actualizador de stock físico lo liaría todo de ejecutarse en todocampers. Los movimientos y el stock se desincronizan (revisar). Meter índices en la tabla de movimientos.
	
	use ComunesImaxMultiAlmacen;

    var $versionPS;
    var $idShop;
    var $idLang;
    var $idTab;
    private $_html = '';
	public $idManual, $forceCheck, $sufijo, $prefijo;
	
	private static $funciones, $almacenGuardado;
	public static $actualizandoStock = false;
    
    const prefijo = 'imax_multi_alma_', DIRECCION_FACTURACION = 1, DIRECCION_ENTREGA = 2;
    const MODO_DIRECCION = 0, MODO_ORDENADOS = 1, MODO_PAGO = 2, MODO_TRANSPORTISTA = 3;

    public function __construct() {
        $this->name = 'imaxmultialmacen';
        $this->tab = 'administration';
        $this->version = '1.64';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->idManual = '';
        $this->forceCheck = 0;
		$this->sufijo = self::prefijo;
        $this->prefijo = self::prefijo;
        parent::__construct();
        $this->displayName = $this->l('Multi almacen avanzado');
        $this->description = $this->l('Permite tener multiples almacenes en Prestashop 1.7.');

        if (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            $this->versionPS = 17;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } 
        elseif (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
            $this->versionPS = 16;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } 
        elseif (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        }
        else {
            $this->_html .= $this->l("La version minima de funcionamiento para nuestros modulos es la 1.5");
        }  
    }
    
    public function install() {
        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (!Configuration::updateGlobalValue($indice, $valor)) {
                return false;
            }
        }

        if (!parent::install()) {
            return false;
        }

        foreach ($hooks as $hook) {
            if (!$this->registerHook($hook)) {
                $this->_errors[] = $this->l('Ha fallado la instalacion del hook:').' '.$hook;
                return false;
            }
        }

        include(dirname(__FILE__).'/sql-install.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }

		if(!$this->sobrescribirModulos()) {
            return false;
        }
    
        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Error al instalar el tab');
            return false;
        }

        return true;
    }

    public function uninstall() {
        if (!parent::uninstall()) {
            return false;
        }

        include(dirname(__FILE__).'/sql-unninstall.php');
        foreach ($sql as $s) {
            if (!Db::getInstance()->execute($s)) {
                $this->_errors[] = $this->l("Error al ejecutar").$s;
                return false;
            }
        }

        if (!$this->uninstallTab()) {
            $this->_errors[] = $this->l('Error al eliminar el tab');
            return false;
        }

        include(dirname(__FILE__).'/configuration.php');
        foreach ($configuracion AS $indice => $valor) {
            if (Configuration::getGlobalValue($indice) !== FALSE) {
                if (!Configuration::deleteByName($indice)) {
                    return false;
                }
            }
        }

        return true;
    }

    public function installOverrides() {
        //Product
        copy(__DIR__.'/overrideTemp/Product.php', __DIR__.'/override/classes/Product.php');
        //Cart
        if(!Module::isEnabled('historicoventas') && !Module::isEnabled('imaxopc')) {
            copy(__DIR__.'/overrideTemp/Cart.php', __DIR__.'/override/classes/Cart.php');
        }
        
        $modificadorClase = new Informax\ImaxMultiAlmacen\ModificadorClases(self::prefijo);
        
        if(Module::isEnabled('wim_get_custom_available_carrier') || Module::isEnabled('imaxopc')) {
            $modificadorClase->eliminarMetodo('Carrier', 'getAvailableCarrierList');
        }
        if(Module::isEnabled('imaxminquantity')) {
            $modificadorClase->eliminarMetodo('ProductPresenterFactory', 'getPresenter');
            $modificadorClase->eliminarMetodo('ProductPresenterFactory', '__construct');
        }
    
    	//Compatibilidad con el módulo gestavdstock
        if(Module::isEnabled('gestavdstock')) {
            $modificadorClase->eliminarMetodo('StockAvailable', 'setQuantity');
            $modificadorClase->eliminarMetodo('StockAvailable', 'insertInventario');
            $modificadorClase->eliminarMetodo('StockAvailable', 'insertInventarioCompleto');
            $modificadorClase->eliminarMetodo('OrderHistory', 'changeIdOrderState');
            copy(__DIR__.'/overrideTemp/OrderHistory.php', __DIR__.'/override/classes/order/OrderHistory.php');
        }
        
        //Registramos los servicios necesarios
        if(class_exists('PrestaShop\PrestaShop\Adapter\Product\Stock\Repository\StockAvailableRepository')) {
            if(class_exists('PrestaShop\PrestaShop\Adapter\Shop\Repository\ShopGroupRepository')) {
                $this->mergeYml('informax.imaxmultialmacen.stock_available_repository', 'stock_available_repository_18.yml');
            }
            else {
                $this->mergeYml('informax.imaxmultialmacen.stock_available_repository', 'stock_available_repository_17.yml');
            }
        }
        if(class_exists('PrestaShop\PrestaShop\Adapter\Product\Stock\QueryHandler\GetProductStockMovementsHandler')) {
            $this->mergeYml('informax.imaxmultialmacen.get_product_stock_movements_handler', 'get_product_stock_movements_handler.yml');
        }
        if(class_exists('PrestaShop\PrestaShop\Adapter\Product\Stock\QueryHandler\GetCombinationStockMovementsHandler')) {
            $this->mergeYml('informax.imaxmultialmacen.get_combination_stock_movements_handler', 'get_combination_stock_movements_handler.yml');
        }
    
        return parent::installOverrides();
    }
    
    /**
     * Agrega un yml al principal.
     * @param string $nuevoServicio El nombre del servicio que agrega.
     * @param string $otroYml El nombre del archivo yml.
     */
    private function mergeYml($nuevoServicio, $otroYml) {
        $actualYmlDatos = file_get_contents(__DIR__.'/config/services.yml');
        if(stripos($actualYmlDatos, $nuevoServicio) === false) {
            $otroYmlDatos = file_get_contents(__DIR__.'/config/'.$otroYml);
            file_put_contents(__DIR__.'/config/services.yml', $actualYmlDatos.$otroYmlDatos);
        }
    }
    
    public function parentUninstallOverrides() {
       return parent::uninstallOverrides();
    }
    
    public function uninstallOverrides() {
        if(!parent::uninstallOverrides()){
            return false;
        }
        
        if(is_file(__DIR__.'/override/classes/Cart.php')) {
            unlink(__DIR__.'/override/classes/Cart.php');
            
            if(Module::isEnabled('imaxopc')) {
                copy(__DIR__."/../imaxopc/override_$this->versionPS/Cart.php", __DIR__.'/../imaxopc/override/classes/Cart.php');
                try {
                    $imaxopc = Module::getInstanceByName('imaxopc');
                    if(method_exists($imaxopc, 'parentUninstallOverrides')){
                        $imaxopc->parentUninstallOverrides();
                    } else {
                        $imaxopc->uninstallOverrides();
                    }
                    $imaxopc->installOverrides();
                }
                catch(Exception $ex) {
                    $result = false;
                }
            }
            elseif(Module::isEnabled('historicoventas')) {
                copy(__DIR__.'/../historicoventas/overrideTemp/Cart.php', __DIR__.'/../historicoventas/override/classes/Cart.php');
                try {
                    $historicoventas = Module::getInstanceByName('historicoventas');
                    if(method_exists($historicoventas, 'parentUninstallOverrides')){
                        $historicoventas->parentUninstallOverrides();
                    } else {
                        $historicoventas->uninstallOverrides();
                    }
                    $historicoventas->installOverrides();
                }
                catch(Exception $ex) {
                    $result = false;
                }
            }
        }
        
        $modificadorClase = new Informax\ImaxMultiAlmacen\ModificadorClases(self::prefijo);
        
        if(Module::isEnabled('imaxminquantity')) {
            $modificadorClase->restaurarMetodo('ProductPresenterFactory', 'getPresenter');
            $modificadorClase->restaurarMetodo('ProductPresenterFactory', '__construct');
        }
    
    	//Compatibilidad con el módulo gestavdstock
        if(Module::isEnabled('gestavdstock')) {
            $modificadorClase->restaurarMetodo('StockAvailable', 'setQuantity');
            $modificadorClase->restaurarMetodo('StockAvailable', 'insertInventario');
            $modificadorClase->restaurarMetodo('StockAvailable', 'insertInventarioCompleto');
            $modificadorClase->restaurarMetodo('OrderHistory', 'changeIdOrderState');
        }
        
        if(Module::isEnabled('wim_get_custom_available_carrier') && !Module::isEnabled('imaxopc')) {
            if(!$modificadorClase->restaurarMetodo('Carrier', 'getAvailableCarrierList')) {
                $modificadorClase->agregarMetodo('Carrier', '
                    /*
                    * module: wim_get_custom_available_carrier
                    * date: 2022-05-18 11:21:00
                    * version: 1.0.0
                    */
                    public static function getAvailableCarrierList(Product $product, $id_warehouse, $id_address_delivery = null, $id_shop = null, $cart = null, &$error = [])
                    {

                        $availableCarrierList = parent::getAvailableCarrierList($product, $id_warehouse, $id_address_delivery, $id_shop, $cart, $error);

                        $overrideGetAvailableCarrierList = Hook::exec(\'overrideGetAvailableCarrierList\', array(
                            \'availableCarrierList\' => $availableCarrierList
                        ),null, false, true, false, null, true); 

                        return $overrideGetAvailableCarrierList;
                    }

                ');
            }
        }
        
        return true;
    }

    public function getContent() { 
        $this->getTxtFiles();
        $this->addCSS('../datatableeditor/css/datatables.min.css');
        $this->addCSS('../datatableeditor/css/editor.dataTables.min.css');
        $this->addCSS('tagify.css');
        $this->addCSS('css.css');
        $this->addCSS('publi.css');
        $this->addCSS('asignacionIndividual.css');
        $this->addJS('../datatableeditor/js/datatables.min.js');
        $this->addJS('../datatableeditor/js/dataTables.editor.min.js');
        $this->addJS('datatableeditor.es.js');
        $this->addJS('jQuery.tagify.min.js');
        $this->addJS('SucesionTeclas.js');
        $this->addJS('Asignacion.js');
        $this->addJS('AsignacionTransportista.js');
        $this->addJS('AsignacionesFormaPago.js');
        $this->addJS('AsignacionFormaPago.js');
        $this->addJS('AsignacionGrupos.js');
		$this->addJS('StockVirtual.js');
        $this->addJS('AlmacenStockVirtual.js');
        $this->addJS('VentanaSeleccionTransportistas.js');
        $this->addJS('Tapa.js');
        $this->addJS('AsignacionIndividual.js');
        $this->addJS('functions.js');

        $this->_html .= $this->createHelpHeader();
        if (!empty($_POST)) {
            $this->_html .= $this->_postProcess();
        }

        $this->_displayForm();
        $this->_html .= $this->getModuleFooter();
        return $this->_html;
    }

    private function _postProcess() {
        $accion = Tools::getValue("accion");
        $this->idTab = Tools::getValue("idTab");
        $html = "";
        switch ($accion) {         
			case 'gestionLicencia':
                $this->forceCheck = 1;
                if (Configuration::updateGlobalValue(self::prefijo . 'LICENCIA', trim(Tools::getValue('licencia')))) {
                    $html .= $this->displayConfirmation($this->l('Licencia guardada correctamente.'));
				}
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la licencia.'));
				}
                break;
                
            case 'asignarAlmacenes':
                $this->getFunciones()->eliminarAsignacionesAlmacen();
                
                $asignaciones = json_decode(Tools::getValue('asignaciones', ''));       
                foreach($asignaciones as $id_country => $asignacionesTemp1) {
                    foreach($asignacionesTemp1 as $id_state => $asignacionesTemp2) {
                        foreach($asignacionesTemp2 as $ids_group => $data) {
                            $grupos = explode(',', $ids_group);
                            foreach ($grupos as $id_group) {
                                $this->getFunciones()->grabarAsignacionAlmacen($id_country, $id_state, $id_group, $data->id_warehouse);
                            }
                        }
                    }
                }
                
                $this->getFunciones()->eliminarTransportistasAlmacen();
                $transportistasVisibles = json_decode(Tools::getValue('transportistasVisibles', '[]'));
                foreach($transportistasVisibles as $id_warehouse => $transportistas) {
                    $this->getFunciones()->grabarTransportistasAlmacen($id_warehouse, $transportistas);
                }

                if (Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_BOTON_ALMACEN', Tools::getValue('mostrarBotonAlmacen')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'TEXTO_BOTON_ALMACEN', serialize(Tools::getValue('textoBotonAlmacen'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'HOOK_BOTON_ALMACEN', Tools::getValue('hookBotonAlmacen')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_ALMACEN_ACTUAL', Tools::getValue('mostrarAlmacenActual')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'SOLICITAR_SELECCION', Tools::getValue('solicitarSeleccion')) &&
                        Configuration::updateGlobalValue(self::prefijo . 'TITULO_SELECCION', serialize(Tools::getValue('tituloSeleccion'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'TIPO_DIRECCION', trim(Tools::getValue('tipoDireccion')))) {
                    $this->registerHook(Tools::getValue('hookBotonAlmacen'));
                    $html .= $this->displayConfirmation($this->l('Asignaciones guardadas correctamente.'));
				}
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar las asignaciones.'));
				}
                break;
                
            case 'asignarAlmacenesFormaPago':
                AsignacionAlmacenPago::eliminarTodas();
                $asignaciones = json_decode(Tools::getValue('asignacionesFormaPago', ''), true);
                foreach($asignaciones as $asignacion) {
                    if($asignacion['formasPago']) {
                        if(!$asignacion['grupos']) {
                            $asignacion['grupos'] = [0];
                        }
                        foreach($asignacion['formasPago'] as $formaPago) {
                            foreach($asignacion['grupos'] as $grupo) {
                                $asignacionObj = new AsignacionAlmacenPago($formaPago, $grupo, $asignacion['almacen']);
                                $asignacionObj->grabar();
                            }
                        }
                    }
                }
                Configuration::updateGlobalValue(self::prefijo . 'SOLICITAR_SELECCION', Tools::getValue('solicitarSeleccion'));
                Configuration::updateGlobalValue(self::prefijo.'MODO_MOSTRAR_VENTANA', Tools::getValue('modoMostrarVentana'));
                $html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                break;
                
            case 'modo':
                if (Configuration::updateGlobalValue(self::prefijo . 'ALMACEN_GENERAL', trim(Tools::getValue('almacenGeneral'))) && 
                        Configuration::updateGlobalValue(self::prefijo . 'ALMACEN_ERROR', trim(Tools::getValue('almacenError'))) && 
                        Configuration::updateGlobalValue(self::prefijo . 'MODO', trim(Tools::getValue('modo'))) &&
                        Configuration::updateGlobalValue(self::prefijo . 'DISTINGUIR_FISICO', trim(Tools::getValue('distinguirFisico')))) {
                    $html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
				}
                else {
                    $html .= $this->displayError($this->l('Ha ocurrido un error al guardar la configuracion.'));
				}
                break;
                
            case 'visualizacionStock':
                foreach(Tools::getValue('almacenes') as $id_warehouse => $almacen) {
                    $warehouseShowStock = new WarehouseShowStock($id_warehouse);
                    $warehouseShowStock->mostrarClientes = $almacen['mostrarClientes'];
                    $warehouseShowStock->mostrarComerciales = $almacen['mostrarComerciales'];
                    $warehouseShowStock->mostrarGrupos = $almacen['mostrarGrupos'];
                    $warehouseShowStock->nombreVisible = $almacen['nombreVisible'];
                    if($almacen['grupos']) {
                        $warehouseShowStock->grupos = explode(',', $almacen['grupos']);
                    }
                    else {
                        $warehouseShowStock->grupos = [];
                    }
                    $warehouseShowStock->grabar();
                }
                $mensajeFormaPagoAlmacen = array();
                foreach(Tools::getAllValues() as $clave => $valor) {
                    if(stripos($clave, 'mensajeFormaPagoAlmacen_') === 0) {
                        $partes = explode('_', $clave);
                        $mensajeFormaPagoAlmacen[$partes[1]] = trim($valor);
                    }
                }
                $mostrarSelectorFormaPagoWidget = Tools::getValue('mostrarSelectorFormaPagoWidget');
                Configuration::updateGlobalValue(self::prefijo . 'MOSTRAR_SELECTOR_FORMA_PAGO_WIDGET', $mostrarSelectorFormaPagoWidget);
                Configuration::updateGlobalValue(self::prefijo.'MENSAJE_FORMA_PAGO_ALMACEN', serialize($mensajeFormaPagoAlmacen), true);
                $html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                break;
                
            case 'stockVirtual':
                (new AlmacenesVirtuales())->grabarRelaciones(json_decode(Tools::getValue('almacenesStockVirtualActuales')));
                $html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente.'));
                break;
            
            case 'cargaInicial':
                $this->getFunciones()->copiarStockAvailableEnStock(Tools::getValue('tiendaOrigen'), Tools::getValue('almacenDestino'));
                $html .= $this->displayConfirmation($this->l('Datos copiados correctamente.'));
                break;
            
            case 'editarAlmacenes':
                //Importamos los almacenes
                if (isset($_FILES['importarAlmacenes']) && $_FILES['importarAlmacenes']['error'] == UPLOAD_ERR_OK && 
                        is_file($_FILES['importarAlmacenes']['tmp_name'])) {
                    $correctos = 0;
                    $existentes = 0;
                    $totales = 0;
                    
                    $fh = fopen($_FILES['importarAlmacenes']['tmp_name'], 'r');
                    fgetcsv($fh, 0, ';');
                    while(($fila = fgetcsv($fh, 0, ';'))) {
                        $totales++;
                        if(count($fila) >= 3) {
                            $referencia = trim($fila[0]);
                            $referenciaSql = pSQL($referencia);
                            $nombre = trim($fila[1]);
                            $id_address = (int)trim($fila[2]);
                            //Comprobamos si tiene referencia que no exista ya
                            if(!$fila[0] || !Db::getInstance()->getValue('SELECT 1 FROM `'._DB_PREFIX_."warehouse` 
                                    WHERE reference = '$referenciaSql'")) {
                                //Creamos el almacén
                                $almacen = new Warehouse();
                                $almacen->reference = $referencia;
                                $almacen->name = $nombre;
                                $almacen->id_address = $id_address;
                                $almacen->id_currency = 0;
                                $almacen->id_employee = $this->context->employee->id;
                                $almacen->management_type = 'WA';
                                if($almacen->add()) {
                                    $correctos++;
                                }
                            }
                            else {
                                $existentes++;
                            }
                        }
                    }
                    fclose($fh);
                    
                    $html .= $this->displayConfirmation($this->l('Almacenes / Ubicaciones creados:') . " $correctos. " . 
                            $this->l('Ignorados por referencia ya existente: ') . " $existentes. " . $this->l('Líneas totales:') . " $totales.");
                }
                else {
                    $html .= $this->displayError($this->l('Error en la subida del archivo.'));
                }
                break;
                
            default:
                break;
        }

        return $html;
    }
	
	public function _displayForm() {
        return $this->displayFormTrait(array('_configuracion' => $this->l('Configuracion'), '_mostrarLicencia' => $this->l('Licencia')), '<script>var prefijoTabla = "'._DB_PREFIX_.'";</script>');
    }
    
    private function _mostrarLicencia() {
        return $this->mostrarLicenciaTrait(2);
    }

    private function _configuracion() {        
        include_once(dirname(__FILE__).'/functionsForm.php');
        include_once(dirname(__FILE__).'/imaxAcordeon.php');        
        include_once(dirname(__FILE__).'/forms/ImaxFormWrapper.php');
        
        $languages = Language::getLanguages();  
        
        //Datos
        $direcciones = $this->getFunciones()->cargarDirecciones();
        $direccionesFormateadas = array(array('label' => $this->l('- Ninguna -'), 'value' => 0));
        foreach($direcciones as $direccion) {
            $direccionesFormateadas[] = array('label' => $direccion['alias'], 'value' => $direccion['id_address']);
        }
        $almacenes = $this->getFunciones()->getWarehouses(true, null, false);
        $tablaTransportistasVisibles = $this->generarTablaTransportistasVisibles($almacenes);
        $transportistasClienteSeleccionados = [];
        $almacenesFormateados = array();
        foreach($almacenes as $almacen) {
            $almacenesFormateados[$almacen['id_warehouse']] = $almacen['reference'] . ' - ' . $almacen['name'];
            $transportistasClienteSeleccionados[$almacen['id_warehouse']] = $this->getFunciones()->obtenerTransportistasAlmacen($almacen['id_warehouse']);
        }
        $almacenGeneral = Configuration::getGlobalValue(self::prefijo.'ALMACEN_GENERAL');
        $almacenError = Configuration::getGlobalValue(self::prefijo.'ALMACEN_ERROR');
        $tipoDireccion = Configuration::getGlobalValue(self::prefijo.'TIPO_DIRECCION');
        $paises = Country::getCountries($this->idLang, true);
        $datosAsignaciones = $this->getFunciones()->cargarAsignacionesAlmacenes();
        $asignacionesFormateadas = '<table id="asignacionesAlmacenes" class="table"><thead><tr><th>'.$this->l('Pais').'</th><th>'.$this->l('Asignacion').'</th></tr></thead> <tbody>';
        foreach($paises as $pais) {
            $asignacionesFormateadas .= "<tr><td>{$pais['name']}</td><td>";
            if(!empty($pais['states'])) {
                //Con estados
                $asignacionesFormateadas .= '<table>';
                foreach($pais['states'] as $estado) {
                    if(empty($datosAsignaciones[$pais['id_country']][$estado['id_state']])) {
                        $datosAsignaciones[$pais['id_country']][$estado['id_state']][0] = 0;
                        $asignacionesTransportistas[$pais['id_country']][$estado['id_state']][0] = 0;
                    }
                    $tablaAsignaciones = $this->generarTablaGrupos($almacenesFormateados, $datosAsignaciones, $pais['id_country'], $estado['id_state']);
                    $asignacionesFormateadas .= "<tr><td>{$estado['name']}</td><td>$tablaAsignaciones</td></tr>";
                }
                $asignacionesFormateadas .= '</table>';
            }
            else {
                //Sin estados
                if(empty($datosAsignaciones[$pais['id_country']][0])) {
                    $datosAsignaciones[$pais['id_country']][0][0] = 0;
                    $asignacionesTransportistas[$pais['id_country']][0][0] = 0;
                }
                $asignacionesFormateadas .= $this->generarTablaGrupos($almacenesFormateados, $datosAsignaciones, $pais['id_country'], 0);
            }
            $asignacionesFormateadas .= '</td></tr>';
        }
        $asignacionesFormateadas .= '</tbody></table>';
        
        $gruposCliente = Group::getGroups($this->idLang);
        usort($gruposCliente, function($a, $b) {
            return strcasecmp($a['name'], $b['name']);
        });
        $listaGruposCliente = array(0 => array('value' => $this->l('- Todos -'), 'code' => 0));
        foreach($gruposCliente as $grupoCliente) {
            $listaGruposCliente[$grupoCliente['id_group']] = array('value' => $grupoCliente['name'], 'code' => $grupoCliente['id_group']);
        }
        
        $transportistasTodos = Carrier::getCarriers($this->idLang, true, false, false, null, Carrier::ALL_CARRIERS);
        usort($transportistasTodos, function($a, $b) {
            return strcasecmp($a['name'], $b['name']);
        });
        $listaTransportistasTodos = array(0 => array('value' => $this->l('- Todos -'), 'code' => 0));
        foreach($transportistasTodos as $transportistasTodo) {
            $listaTransportistasTodos[$transportistasTodo['id_reference']] = array('value' => $transportistasTodo['name'], 'code' => $transportistasTodo['id_reference']);
        }
        
        //Agrupamos los grupos por almacen
        $asignacionesActualesIntercambiadas = [];
        foreach($datosAsignaciones as $id_country => $asignacionesActualesTemp1) {
            foreach($asignacionesActualesTemp1 as $id_state => $asignacionesActualesTemp2) {
                $asignacionesActualesIntercambiadas[$id_country][$id_state] = $asignacionesActualesTemp2;
            }
        }

        $this->smarty->assign(array(
            'baseUrl' => $this->_path,
            'urlImagenes' => $this->context->shop->getBaseURL(true).'modules/imaxmultialmacen/images/',
            'prefijoTabla' => _DB_PREFIX_,
            'direcciones' => json_encode($direccionesFormateadas),
            'link' => $this->context->link,
            'plantillaDireccion' => json_encode($this->getFunciones()->plantillaDireccion(0)),
            'imagenesActuales' => json_encode($this->obtenerImangesAlmacenActuales())
        ));
        
		$distinguirFisico = Configuration::getGlobalValue(self::prefijo.'DISTINGUIR_FISICO');
        
        //Visualizacion
        $acordeon = new imaxAcordeon($this->_path);

        $form = new imaxForm($this, $this->_path, '', 'post', '', 'multipart/form-data');
        $form->createHidden("accion", "editarAlmacenes");
        $form->createHidden("idTab", "1");
        $form->addToForm($this->display($this->name, 'almacenes.tpl'));
        $form->createFormInfomationText($this->l('Para mostrar los textos de los almacenes se puede utilizar el hook "displayStockMessage", se 
            le debe pasar un parametro "product" que contenga "id_product", "id_product_attribute" y "quantity_wanted".'), 'confirm');
        $form->addToForm('<div><a href="'. $this->_path .'sampleFiles/ejemploAlmacenes.csv">'.$this->l('Archivo de ejemplo').'</a></div>');
        $form->createFormUploadFile('importarAlmacenes', $this->l('Importar almacenes / ubicaciones'), $this->l('Formato: referencia;nombre;id dirección'));
        $form->createSubmitButton('importar', $this->l('Importar'));
        $html = $acordeon->renderAcordeon($this->l('Almacenes / Ubicaciones'), $form->renderForm());
        
        //Modo de funcionamiento
        $modo = $this->getModoActual();
        if(Module::isEnabled('imaxpuntosrecogida')) {
            $modos = [
                self::MODO_TRANSPORTISTA => $this->l('Basado en el transportista')
            ];
        }
        else {
            $modos = [
                self::MODO_DIRECCION => $this->l('Basado en la direccion'),
                self::MODO_ORDENADOS => $this->l('Basado en el orden de almacen'), 
                self::MODO_PAGO => $this->l('Basado en la forma de pago')
            ];
        }
        
        unset($form);
        
        $form = new ImaxFormWrapper(new imaxForm($this, $this->_path));
        $form->createHidden("accion", "modo");
        $form->createHidden("idTab", "1");
        $form->createFormSelect('modo', $this->l('Modo de funcionamiento'), $modos, $modo);
        $form->createFormSelect('almacenGeneral', $this->l('Almacen por defecto'), array(0 => $this->l('- Selecciona uno - ')) + $almacenesFormateados, $almacenGeneral, $this->l('Almacen por defecto'));
        $form->createFormSelect('almacenError', $this->l('Almacen para productos desubicados'), array(0 => $this->l('- Selecciona uno - ')) + $almacenesFormateados, $almacenError, $this->l('Almacen para productos desubicados'));
        $form->createCheckbox('distinguirFisico', $this->l('Distinguir stock fisico y disponible'), $distinguirFisico);
        $form->createSubmitButton('opcionesConfiguracion', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Modo de funcionamiento'), $form->renderForm());

        //Asignaciones
        $almacenesDisponibles = [['id' => 0, 'nombre' => $this->l('- Almacén por defecto -'), 'referencia' => '']];
        foreach($almacenes as $almacen) {
            $almacenesDisponibles[] = ['id' => $almacen['id_warehouse'], 'nombre' => $almacen['name'], 'referencia' => $almacen['reference']];
        }
        $formasPagoDisponibles = [];
        $modulosPago = PaymentModule::getInstalledPaymentModules();
        foreach($modulosPago as $moduloPago) {
            $moduloObj = Module::getInstanceByName($moduloPago['name']);
            if($moduloObj) {
                $formasPagoDisponibles[] = [
                    'id' => $moduloPago['name'], 
                    'nombre' => trim($moduloObj->displayName),
                    'descripcion' => trim($moduloObj->description)
                ];
            }
        }
        $mostrarBotonAlmacen = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_BOTON_ALMACEN');
        $textoBotonAlmacen = unserialize(Configuration::getGlobalValue(self::prefijo.'TEXTO_BOTON_ALMACEN'));
        $hookBotonAlmacen = Configuration::getGlobalValue(self::prefijo.'HOOK_BOTON_ALMACEN');
        $mostrarAlmacenActual = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_ALMACEN_ACTUAL');
        $solicitarSeleccion = Configuration::getGlobalValue(self::prefijo.'SOLICITAR_SELECCION');
        $tituloSeleccion = unserialize(Configuration::getGlobalValue(self::prefijo.'TITULO_SELECCION'));

        if($modo == self::MODO_PAGO) {
            $modoMostrarVentana = Configuration::getGlobalValue(self::prefijo . 'MODO_MOSTRAR_VENTANA');
            $modoMostrarVentanaRadios = [
                [
                    'name' => 'modoMostrarVentana', 'value' => 0, 
                    'text' => $this->l('Todos: mostrará la ventana para todos los clientes.'), 
                    'checked' => ($modoMostrarVentana == 0)
                ],
                [
                    'name' => 'modoMostrarVentana', 'value' => 1, 
                    'text' => $this->l('Solo grupos asignados: mostrara la ventana a los clientes que estén en un grupo de las asignaciones.'), 
                    'checked' => ($modoMostrarVentana == 1)
                ],
            ];
            
            $form = new ImaxFormWrapper(new imaxForm($this, $this->_path));
            $form->createHidden("accion", "asignarAlmacenesFormaPago");
            $form->createHidden("idTab", "1");
            $form->createHidden("asignacionesFormaPago", "");
            $form->addToForm('
                <script>
                    var esModoPago = true;
                    var asignacionesFormaPago = '.json_encode($this->cargarAsignacionesFormaPagoAgrupadas()).';
                    var almacenesDisponibles = '.json_encode($almacenesDisponibles).';
                    var formasPagoDisponibles = '.json_encode($formasPagoDisponibles).';
                </script>');
            $form->addToForm('<div id="contenedorAsignacionesFormaPago"></div>');
            $form->createCheckbox('solicitarSeleccion', $this->l('Abrir la ventana para cambiar de almacén si no hay ninguno seleccionado.'), $solicitarSeleccion);
            $form->createFormRadioButtonGroup($modoMostrarVentanaRadios, '');
            $form->createSubmitButton('guardarAsignaciones', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Asignaciones'), $form->renderForm());
        }
        elseif($modo == self::MODO_DIRECCION) {
            unset($form);
            $filaVacia = $this->generarFilaTablaGrupos([], $almacenesFormateados, [], 0, 0, []);
            $form = new ImaxFormWrapper(new imaxForm($this, $this->_path));
            $form->addToForm('
                <script>
                    var listaGruposClienteObj = '.json_encode($listaGruposCliente).';
                    var listaGruposCliente = '.json_encode(array_values($listaGruposCliente)).';
                    var listaTransportistasTodosObj = '.json_encode($listaTransportistasTodos).';
                    var listaTransportistasTodos = '.json_encode(array_values($listaTransportistasTodos)).';
                    var gruposClienteSeleccionados = '.json_encode($asignacionesActualesIntercambiadas).';
                    var transportistasClienteSeleccionados = '. json_encode($transportistasClienteSeleccionados) . '; 
                    var textoBuscarGrupo = "'.$this->l('Buscar grupo:').'";
                    var textoBuscarTransportista = "'.$this->l('Buscar transportista:').'";
                    var textoAceptar = "'.$this->l('Aceptar').'";
                    var textoCancelar = "'.$this->l('Cancelar').'";
                    var textoConfirmarEliminacion = "'.$this->l('¿Eliminar la entrada?').'";
                    var filaVacia = '.json_encode($filaVacia).';
                    var textoSinGrupo = "'.$this->l('Si no se selecciona grupo se utilizaran todos.').'";
                    var textoSinTransportista = "'.$this->l('Si no se selecciona transportista se utilizaran todos.').'";
                    var idLang = "'.$this->idLang.'";
                    var textoFaltaTextoBoton = "'.$this->l('Debe introducir el texto para el botón de cambiar almacén, al menos en el idioma').' \"'.Language::getIsoById($this->idLang).'\".";
                    var textoFaltaTextoTitulo = "'.$this->l('Debe introducir el texto para el título de la ventana, al menos en el idioma').' \"'.Language::getIsoById($this->idLang).'\".";
                </script>');
            $form->createHidden("accion", "asignarAlmacenes");
            $form->createHidden("idTab", "1");
            $form->createHidden("asignaciones", "");
            $form->createHidden("transportistasVisibles", "");
            $form->createCheckbox('mostrarBotonAlmacen', $this->l('Mostrar en la cabecera del Front, el botón para cambiar de almacén'), $mostrarBotonAlmacen);
            $form->createText('textoBotonAlmacen', $this->l('Texto para el botón de cambiar de almacén:'), $textoBotonAlmacen, true, ['maxlength' => 30]);
            $form->createSelect('hookBotonAlmacen', $this->l('Indicar el hook para posicionar el botón:'), $this->obtenerHooksVisualizacion(), $hookBotonAlmacen);
            $form->createCheckbox('mostrarAlmacenActual', $this->l('Mostrar el almacén actual en el botón.'), $mostrarAlmacenActual);
            $form->createCheckbox('solicitarSeleccion', $this->l('Abrir la ventana para cambiar de almacén si no hay ninguno seleccionado.'), $solicitarSeleccion);
            $form->createText('tituloSeleccion', $this->l('Título de la ventana:'), $tituloSeleccion, true);
            $form->createFormSelect('tipoDireccion', $this->l('Tipo de direccion'), array(self::DIRECCION_ENTREGA => $this->l('Direccion entrega'),
                self::DIRECCION_FACTURACION => $this->l('Direccion facturacion')), $tipoDireccion, $this->l('Tipo de direccion'));
            $form->addToForm('<div class="form-group"><label class="control-label"><span>'.$this->l('Transportistas visibles').'</span></label></div>');
            $form->addToForm($tablaTransportistasVisibles);
            $form->addToForm('<div class="form-group"><label class="control-label"><span>'.$this->l('Asignaciones almacenes').'</span></label></div>');
            $form->addToForm($asignacionesFormateadas);
            $form->createSubmitButton('guardarAsignaciones', $this->l('Guardar'));
            $html .= $acordeon->renderAcordeon($this->l('Asignaciones'), $form->renderForm());
        }
        elseif($modo == self::MODO_TRANSPORTISTA) {
            $enlaceRecogida = $this->context->link->getAdminLink('AdminModules', true, [], ['configure' => 'imaxpuntosrecogida']);
            $form = new imaxForm($this, $this->_path);
            $form->createFormInfomationText($this->l('Las asignaciones en este modo de funcionamiento se realizan en el modulo')." <a href='$enlaceRecogida'>Puntos de recogida</a>");
            $html .= $acordeon->renderAcordeon($this->l('Asignaciones'), $form->renderForm());
        }
        
        //Visualizacion de stock
        $traducciones = [
            '- Todos -' => $this->l('- Todos -'),
            'Grupos' => $this->l('Grupos'),
            'Forma de pago' => $this->l('Forma de pago'),
            'Almacén' => $this->l('Almacén'),
            'Buscar grupo:' => $this->l('Buscar grupo:'),
            'Si no se selecciona grupo se utilizarán todos. (Tendrá menos prioridad que los grupos específicos)' => $this->l('Si no se selecciona grupo se utilizarán todos. (Tendrá menos prioridad que los grupos específicos)'),
            'Formas de pago:' => $this->l('Formas de pago:'),
            'Aceptar' => $this->l('Aceptar'),
            'Cancelar' => $this->l('Cancelar'),
            'Agregar' => $this->l('Agregar'),
            'Editar' => $this->l('Editar'),
            'Eliminar' => $this->l('Eliminar'),
            '¿Está seguro de querer eliminar la asignación?' => $this->l('¿Está seguro de querer eliminar la asignación?')
        ];
        $almacenesMostrar = WarehouseShowStock::cargarAlmacenes();
        $this->smarty->assign([
            'almacenesMostrar' => $almacenesMostrar,
            'id_lang' => $this->idLang,
            'idiomas' => Language::getLanguages()
        ]);
        $gruposDisponibles = [['id' => 0, 'nombre' => $this->l('- Todos -')]];
        foreach($gruposCliente as $grupoCliente) {
            $gruposDisponibles[] = ['id' => $grupoCliente['id_group'], 'nombre' => $grupoCliente['name']];
        }
        $gruposActuales = [];
        foreach($almacenesMostrar as $almacen) {
            $gruposActualesTemp = [];
            foreach($almacen->grupos as $id_group) {
                $grupoObj = new Group($id_group, $this->idLang);
                $gruposActualesTemp[] = ['id' => $id_group, 'nombre' => $grupoObj->name];
            }
            $gruposActuales[$almacen->id_warehouse] = $gruposActualesTemp;
        }
        
        $acordeon = new imaxAcordeon($this->_path);

        $form = new imaxForm($this, $this->_path);
        $form->createHidden("accion", "visualizacionStock");
        $form->createHidden("idTab", "1");
        $form->createFormInfomationText($this->l('Para mostrar el stock de los almacenes se puede utilizar el widget:').
            "<br/>Autoseleccion: {widget name='imaxmultialmacen'}".
            "<br/>Manual: {widget name='imaxmultialmacen' id_product=1 id_product_attribute=1}", 'confirm');
        $form->addToForm('
            <script>
                var gruposActuales = '.json_encode($gruposActuales).';
                var gruposDisponibles = '.json_encode($gruposDisponibles).';
                var traducciones = '.json_encode($traducciones).';
            </script>');
        $form->addToForm($this->display($this->name, 'tablaVisualizacionStock.tpl'));
        
        if($modo == self::MODO_PAGO) {
            $mensajeFormaPagoAlmacen = unserialize(Configuration::getGlobalValue(self::prefijo.'MENSAJE_FORMA_PAGO_ALMACEN'));
            if(!$mensajeFormaPagoAlmacen){
                foreach ($languages AS $language) {
                    $mensajeFormaPagoAlmacen[$language['id_lang']] = $this->l('Tiene artículos que pertenecen al almacén %X%, si desea agregar productos de otro almacen antes finalice el pedido');
                }
            }
            $mostrarSelectorFormaPagoWidget = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_SELECTOR_FORMA_PAGO_WIDGET');
            
            $form->generarTextArea('mensajeFormaPagoAlmacen', $mensajeFormaPagoAlmacen, $this->l('Mensaje cuando se agregue un articulo de un almacén asociado a una forma de pago si el cliente no debe poder cambiar la forma de pago:'), '', true,false);
            $form->createFormCheckboxGroup('mostrarSelectorFormaPagoWidget', $this->l('Mostrar selector de forma de pago, encima de la tabla que muestra los almacenes'), $mostrarSelectorFormaPagoWidget);
        }
        
        $form->createSubmitButton('guardarAsignaciones', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Visualizacion stock'), $form->renderForm());
        
        //Almacenes con stock virtual
        $selectNuevo = $this->crearSelectAlmacen($almacenesFormateados);
        $textoVirtualesActuales = $this->l('Estos son los almacenes virtuales actuales:');
        $textoAgregar = $this->l('Agregar');
        $textoCronVirtual = $this->l('Debe ejecutarse un cron con la url siguiente para mantener el stock virtual actualizado:');
        $textoExplicacion = $this->l('El stock de los almacenes virtuales será la suma de los almacenes seleccionados en la configuración de cada almacén virtual.');
        $textoAgregarMas = $this->l('Aquí puedes agregar nuevos almacenes virtuales:');
        $traduccionesStockVirtual = [
            'Eliminar' => $this->l('Eliminar'),
            'Seleccionar todos' => $this->l('Seleccionar todos'),
            'Configurar' => $this->l('Configurar')
        ];
        $almacenesStockVirtualActuales = (new AlmacenesVirtuales())->cargarRelaciones();
        $urlTienda = $this->context->shop->getBaseURL(true, false).$this->_path;
        $token = Configuration::getGlobalValue($this->sufijo.'TOKEN');
        
        $acordeon = new imaxAcordeon($this->_path);

        $form = new imaxForm($this, $this->_path);
        $form->createHidden("accion", "stockVirtual");
        $form->createHidden("idTab", "1");
        $form->createHidden("almacenesStockVirtualActuales", "1");

        $almacenesJs = [];
        foreach(array_slice($almacenesDisponibles, 1) as $almacenDisponible) {
            $almacenesJs[] = [
                'id' => $almacenDisponible['id'],
                'idBusquedas' => $almacenDisponible['referencia'],
                'nombre' => $almacenDisponible['nombre'],
            ];
        }
        
        $form->addToForm('
            <script>
                var almacenesStockVirtualActuales = '.json_encode($almacenesStockVirtualActuales).';
                var almacenes = '.json_encode($almacenesJs).';
                var traduccionesStockVirtual = '.json_encode($traduccionesStockVirtual).';
            </script>');
        $form->addToForm("
            <p>$textoExplicacion</p>
            <p>$textoCronVirtual</p>
            <p class='tabulado1'><a href='{$urlTienda}imaxmultialmacen_cron.php?accion=sincronizarStockVirtual&token=$token' target='_blank'>{$urlTienda}imaxmultialmacen_cron.php?accion=sincronizarStockVirtual&token=$token</a></p>
            <p>$textoAgregarMas</p>
            <div id='controlNuevoStockVirtual' class='tabulado1'>
                $selectNuevo
                <input type='button' name='agregarStockVirtual' value='$textoAgregar'/>
            </div>
            <p>$textoVirtualesActuales</p>
            <div id='controlesStockVirtual' class='tabulado1'></div>
        ");
        $form->createSubmitButton('guardarVirtual', $this->l('Guardar'));
        $html .= $acordeon->renderAcordeon($this->l('Stock virtual'), $form->renderForm());
        
        //Carga inicial
        $tiendas = Shop::getShops();
        $idsAlmacenesVirtuales = array_keys($almacenesStockVirtualActuales);
        $almacenesNoVirtuales = array_filter($almacenesFormateados, function($id_warehouse) use ($idsAlmacenesVirtuales) {
            return !in_array($id_warehouse, $idsAlmacenesVirtuales);
        }, ARRAY_FILTER_USE_KEY);

        $acordeon = new imaxAcordeon($this->_path);

        $form = new imaxForm($this, $this->_path);
        $form->createHidden("accion", "cargaInicial");
        $form->createHidden("idTab", "1");
        $form->addToForm('
            <script>
                var textoPerderStock = "'.$this->l('Perderá los datos para el almacén indicado, ¿Desea continuar?').'";
            </script>');
        $form->addToForm('<p>'.$this->l('Reemplaza todos los datos de la tabla stock con los de la tabla stock_available. Se han eliminado los almacenes virtuales de la lista desplegable porque no se les puede asignar stock directamente.').'</p>');
        $form->createFormSelectFromArray('tiendaOrigen', $this->l('Tienda origen'), $tiendas, 'id_shop', 'name', reset($tiendas)['id_shop']);
        $form->createFormSelect('almacenDestino', $this->l('Almacen destino'), $almacenesNoVirtuales, 
                ($almacenesNoVirtuales ? array_keys($almacenesNoVirtuales)[0] : 0));
        $form->createSubmitButton('ejecutarCargaInicial', $this->l('Ejecutar'));
        $html .= $acordeon->renderAcordeon($this->l('Carga inicial'), $form->renderForm(), false, 'cargaInicial');

        return $html;
    }
    
    /**
     * Devuelve una tabla para relacionar los almacenes y los transportistas.
     * @param array $almacenes
     * @return string
     */
    private function generarTablaTransportistasVisibles($almacenes) {
        $tabla = '
            <table id="tablaTransportistasVisibles" class="table">
                <thead>
                    <tr>
                        <th>'.$this->l('Almacén').'</th>
                        <th>'.$this->l('Transportista').'</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>';
        foreach($almacenes as $almacen) {
            $tabla .= "
                <tr>
                    <td>{$almacen['name']}</td>
                    <td id='transportistasVisibles_{$almacen['id_warehouse']}'></td>
                    <td><input type='button' name='editarTransportistasAlmacen' value='".$this->l('Editar')."' data-id_warehouse='{$almacen['id_warehouse']}'></td>
                </tr>";
        }
        $tabla .= '</tbody></table>';
        
        return $tabla;
    }

    /**
     * Copia las sobrescrituras de módulos.
     * @return bool
     */
    public function sobrescribirModulos() {
        if(!is_dir(__DIR__.'/../../override/modules')) {
            mkdir(__DIR__.'/../../override/modules');
        }
        if(!is_dir(__DIR__.'/../../override/modules/gestavdstock')) {
            mkdir(__DIR__.'/../../override/modules/gestavdstock');
        }
        if(!is_dir(__DIR__.'/../../override/modules/gestavdstock/controllers')) {
            mkdir(__DIR__.'/../../override/modules/gestavdstock/controllers');
        }
        if(!is_dir(__DIR__.'/../../override/modules/gestavdstock/controllers/admin')) {
            mkdir(__DIR__.'/../../override/modules/gestavdstock/controllers/admin');
        }

        return copy(
                    __DIR__.'/override/modules/gestavdstock/controllers/admin/GestAvdStockController.php', 
                    __DIR__.'/../../override/modules/gestavdstock/controllers/admin/GestAvdStockController.php') && 
                copy(
                    __DIR__.'/override/modules/gestavdstock/controllers/admin/GestAvdStockMvtController.php', 
                    __DIR__.'/../../override/modules/gestavdstock/controllers/admin/GestAvdStockMvtController.php');
    }
    
    /**
     * Crea un select de almacenes.
     * @param array $almacenes
     * @return string
     */
    private function crearSelectAlmacen($almacenes) {
        $select = "<select name='nuevoStockVirtual'>";
        foreach($almacenes as $id => $almacen) {
            $select .= "<option value='$id'>$almacen</option>";
        }
        $select .= '</select>';

        return $select;
    }
    
    /**
     * Devuelve los ids de almacen con imagen.
     * @return int[]
     */
    private function obtenerImangesAlmacenActuales() {
        $imagenes = [];
        
        $dir = dir(__DIR__.'/images');
        while(($entry = $dir->read())) {
            if((int)$entry) {
                $imagenes[] = (int)$entry;
            }
        }
        
        return $imagenes;
    }
    
    /**
     * Devuelve los hooks de visualizacion.
     * @return array
     */
    private function obtenerHooksVisualizacion() {
        $hooks = [];
        $hooksTemp = Hook::getHooks(false, true);
        foreach($hooksTemp as $hookTemp) {
            $hooks[$hookTemp['name']] = $hookTemp['name'];
        }
        
        return $hooks;
    }
    
    /**
     * Devuelve las asignaciones actuales agrupadas.
     * @return array
     */
    private function cargarAsignacionesFormaPagoAgrupadas() {
        $asignacionesAgrupadas = [];
        $asignaciones = AsignacionAlmacenPago::cargarTodas();
        //Agrupamos por almacén
        foreach($asignaciones as $asignacion) {
            $clave = $asignacion['id_warehouse'].'_'.$asignacion['forma_pago'];
            if(empty($asignacionesAgrupadas[$clave])) {
                $asignacionesAgrupadas[$clave] = [
                    'formasPago' => [$asignacion['forma_pago']],
                    'grupos' => [$asignacion['id_group']],
                    'almacen' => $asignacion['id_warehouse']
                ];
            }
            else {
                $asignacionesAgrupadas[$clave]['grupos'][] = $asignacion['id_group'];
            }
        }
        //Limpiamos los duplicados
        foreach($asignacionesAgrupadas as &$asignacionAgrupada) {
            $asignacionAgrupada['grupos'] = array_values(array_unique($asignacionAgrupada['grupos']));
        }
        
        return array_values($asignacionesAgrupadas);
    }
    
    /**
     * Crea la tabla para los grupos de un pais-provincia.
     * @param array $almacenesFormateados
     * @param array $asignaciones
     * @param int $id_country
     * @param int $id_state
     * @return string
     */
    private function generarTablaGrupos($almacenesFormateados, $asignaciones, $id_country, $id_state) {
        $tabla = "<table data-id_country='$id_country' data-id_state='$id_state'><thead><tr><th>".$this->l('Grupos').'</th><th>'.$this->l('Almacen').'</th><th colspan="2"><input type="button" name="agregarGrupos" value="'.$this->l('Agregar').'"/></th></tr></thead><tbody>';
        if(!empty($asignaciones[$id_country][$id_state])) {
            $grupos = $asignaciones[$id_country][$id_state];
            foreach($grupos as $key => $warehouse) {
                $tabla .= $this->generarFilaTablaGrupos([$key => $warehouse], $almacenesFormateados, $asignaciones, $id_country, $id_state);
            }
        }
        $tabla .= '</tbody></table>';
        
        return $tabla;
    }
    
    /**
     * Devuelve una fila para la tabla de grupos.
     * @param int[] $ids_group
     * @param array $almacenesFormateados
     * @param array $asignaciones
     * @param int $id_country
     * @param int $id_state
     * @return string
     */
    private function generarFilaTablaGrupos($ids_group, $almacenesFormateados, $asignaciones, $id_country, $id_state) {
        $nombreGrupos = $this->idsGrupoANombres($ids_group);
        $almacenSeleccionado = (isset($asignaciones[$id_country][$id_state][key($ids_group)]) ? $asignaciones[$id_country][$id_state][key($ids_group)] : 0);
        $select = $this->generarSelectAlmacen($almacenesFormateados, $almacenSeleccionado, $id_country, $id_state);
        $editar = $this->l('Editar');
        $eliminar = $this->l('Eliminar');
        $fila = "
            <tr>
                <td>$nombreGrupos</td>
                <td>$select</td>
                <td><input type='button' name='editarGrupos' value='$editar'/></td>
                <td><input type='button' name='eliminarGrupos' value='$eliminar'/></td>
            </tr>";

        return $fila;
    }
    
    /**
     * Convierte los ids de grupo en sus nombres.
     * @param int[] $ids_group
     * @return string
     */
    private function idsGrupoANombres($ids_group) {
        $nombres = [];
        foreach($ids_group as $id_group => $warehouse) {
            if($id_group) {
                $grupo = new Group($id_group, $this->context->language->id);
                $nombres[] = $grupo->name;
            }
            else {
                $nombres[] = $this->l('- Todos -');
            }
        }
        
        return implode(', ', $nombres);
    }

    /*private function generarSelectAlmacen($almacenes, $almacenesSeleccionados, $id_country, $id_state = 0) {
        $almacenes = array(0 => $this->l('- Almacen por defecto -')) + $almacenes;
        $select = "<select name='almacenOrigen[$id_country][$id_state]'>";
        foreach($almacenes as $id => $almacen) {
            $seleccionado = ($id == $almacenesSeleccionados ? 'selected="selected"' : '');
            $select .= "<option value='$id' $seleccionado>$almacen</option>";
        }
        $select .= '</select>';

        return $select;
    }*/
    
    /**
     * Devuelve el select de almacenes.
     * @param array $almacenes
     * @param int $almacenesSeleccionados
     * @param int $id_country
     * @param int $id_state
     * @return string
     */
    private function generarSelectAlmacen($almacenes, $almacenesSeleccionados, $id_country, $id_state = 0) {
        if (!function_exists('generarSelectAlmacen_')) {
            $function = $this->getFunction();
            eval(gzuncompress(base64_decode($function)));
        }
        if (function_exists('generarSelectAlmacen_')) {
            return generarSelectAlmacen_($this, $almacenes, $almacenesSeleccionados, $id_country, $id_state);
        }

        return '';
    }
	
	/**
     * Devuelve las funciones especificas del modulo.
     * @return FuncionesImaxMultiAlmacen
     */
    public function getFunciones() {
        if(!self::$funciones) {
            self::$funciones = new FuncionesImaxMultiAlmacen($this);
        }

        return self::$funciones;
    }
    
    /**
     * Devuelve el modo actual de funcionamiento.
     * @return int
     */
    public function getModoActual() {
        if(Module::isEnabled('imaxpuntosrecogida')) {
            $modo = self::MODO_TRANSPORTISTA;
        }
        else {
            $modo = Configuration::getGlobalValue(self::prefijo.'MODO');
            if($modo == self::MODO_TRANSPORTISTA) {
                $modo = self::MODO_DIRECCION;
                Configuration::updateGlobalValue(self::prefijo.'MODO', $modo);
            }
        }
        
        return $modo;
    }
    
    /**
     * Devuelve el almacen actual.
     * @return \Warehouse
     */
    public function getWarehouse() {
        $modo = $this->getModoActual();
        if(defined('_PS_ADMIN_DIR_')) {
            if($modo == self::MODO_ORDENADOS) {
                //En este modo de funcionamiento usamos el primer almacen
                $id_warehouse = StockOrdenado::getInstance()->obtenerPrimerAlmacen();
            }
            else {
                //Es el admin, usamos el almacen general
                $id_warehouse = (int) Configuration::getGlobalValue(self::prefijo . 'ALMACEN_GENERAL');
            }
        }
        else {
            if($modo == self::MODO_ORDENADOS) {
                //En este modo de funcionamiento se usan todos los almacenes
                $id_warehouse = null;
            }
            elseif($modo == self::MODO_PAGO) {
                $id_warehouse = $this->getWarehouseByPayment();
            }
            elseif($modo == self::MODO_TRANSPORTISTA) {
                $id_warehouse = $this->getWarehouseByCarrier();
            }
            else {
                $id_warehouse = $this->getWarehouseByLocation();
            }
        }

        return new Warehouse($id_warehouse);
    }
    
    /**
     * Indica si el almacén es seleccionable por el cliente.
     * @return boolean
     */
    private function almacenSeleccionable() {
        return Configuration::getGlobalValue(self::prefijo.'MOSTRAR_BOTON_ALMACEN') || 
                Configuration::getGlobalValue(self::prefijo.'SOLICITAR_SELECCION');
    }
    
    /**
     * Devuelve el almacen correspondiente por transportista.
     * @return int
     */
    private function getWarehouseByCarrier() {
        if(self::$almacenGuardado) {
            $id_warehouse = self::$almacenGuardado;
        }
        else {
            include_once(dirname(__FILE__).'/../imaxpuntosrecogida/classes/TransportistaExtra.php');

            //El almacen para el metodo de envio
            if(!empty($this->context->cart->id_carrier)) {
                $carrier = new Carrier($this->context->cart->id_carrier);
                $transportistaExtra = TransportistaExtra::cargar($carrier->id_reference);
                $id_warehouse = $transportistaExtra->id_warehouse;
            }

            if(empty($id_warehouse) && $this->context->cookie->selected_warehouse && $this->almacenSeleccionable()) {
                //El almacen seleccionado por el cliente
                $id_warehouse = $this->context->cookie->selected_warehouse;
            }

            if(empty($id_warehouse)) {
                //El almacen general
                $id_warehouse = (int) Configuration::getGlobalValue(self::prefijo . 'ALMACEN_GENERAL');
            }
        }

        return $id_warehouse;
    }
    
    /**
     * Devuelve la forma de pago guardada.
     * @param boolean $recuperar Si hay una forma de pago asignada para un carrito anterior la convierte en la actual.
     * @return string
     */
    private function getSavePayment($recuperar = false) {
        $formaPago = false;
        if($this->context->cookie->imax_forma_pago) {
            $temp = explode('#', $this->context->cookie->imax_forma_pago);
            if($temp[0] && $temp[0] == $this->context->cart->id) {
                $formaPago = $temp[1];
            }
            elseif($recuperar && $temp[1]) {
                $oldCart = new Cart($temp[0]);
                if(Validate::isLoadedObject($oldCart) && $oldCart->id_customer == $this->context->customer->id) {
                    $this->setSavePayment($temp[1]);
                    $formaPago = $temp[1];
                }
            }
        }
        
        return $formaPago;
    }
    
    /**
     * Guarda la forma de pago actual.
     * @param string $formaPago
     */
    public function setSavePayment($formaPago) {
        if (!Validate::isLoadedObject(Context::getContext()->cart)) {
            $cart = new Cart();
            $cart->id_lang = (int) Context::getContext()->cookie->id_lang;
            $cart->id_currency = (int) Context::getContext()->cookie->id_currency;
            $cart->id_guest = (int) Context::getContext()->cookie->id_guest;
            $cart->id_shop_group = (int) Context::getContext()->shop->id_shop_group;
            $cart->id_shop = Context::getContext()->shop->id;
            if (Context::getContext()->cookie->id_customer) {
                $cart->id_customer = (int) Context::getContext()->cookie->id_customer;
                $cart->id_address_delivery = (int) Address::getFirstCustomerAddressId($cart->id_customer);
                $cart->id_address_invoice = (int) $cart->id_address_delivery;
            } else {
                $cart->id_address_delivery = 0;
                $cart->id_address_invoice = 0;
            }
            $cart->save();

            Context::getContext()->cookie->id_cart = $cart->id;
            Context::getContext()->cart = $cart;
            CartRule::autoAddToCart(Context::getContext());
            
            Context::getContext()->cart->checkAndUpdateAddresses();
        }

        Context::getContext()->cookie->imax_forma_pago = Context::getContext()->cart->id.'#'.$formaPago;
        Context::getContext()->cookie->write();
    }
    
    /**
     * Devuelve el almacen correspondiente por forma de pago.
     * 
     * @param string $payment forma de pago, si no se indica es la guardada.
     * @return int
     */
    public function getWarehouseByPayment($payment = null) {
        if(self::$almacenGuardado) {
            $id_warehouse = self::$almacenGuardado;
        }
        else {
            if($payment == null){
                $formaPago = $this->getSavePayment(true);
            } else{
                $formaPago = $payment;
            }
            if($formaPago) {
                if(Validate::isLoadedObject($this->context->customer)) {
                    $grupos = $this->context->customer->getGroups();
                }
                else {
                    $grupos = [Configuration::getGlobalValue('PS_GUEST_GROUP')];
                }
                $asignacion = AsignacionAlmacenPago::cargar($formaPago, $grupos);
                if($asignacion) {
                    $id_warehouse = $asignacion->id_warehouse;
                }
            }

            if(empty($id_warehouse)) {
                //El almacen general
                $id_warehouse = (int) Configuration::getGlobalValue(self::prefijo . 'ALMACEN_GENERAL');
            }
        }
        
        return $id_warehouse;
    }
    
    /**
     * Devuelve el id del almacen por el metodo de pais, provincia y grupo de cliente.
     * @return int
     */
    private function getWarehouseByLocation() {
        if(self::$almacenGuardado) {
            $id_warehouse = self::$almacenGuardado;
        }
        else {
            $tipoDireccion = ((int) Configuration::getGlobalValue(self::prefijo . 'TIPO_DIRECCION') == self::DIRECCION_FACTURACION ? 'id_address_invoice' : 'id_address_delivery');
            $direccion = new Address(($this->context->cart ? $this->context->cart->$tipoDireccion : 0));
            if($this->context->cookie->selected_warehouse && $this->almacenSeleccionable()) {
                //El almacen seleccionado por el cliente
                $id_warehouse = $this->context->cookie->selected_warehouse;
            }
            elseif(Validate::isLoadedObject($direccion)) {
                //Buscamos el almacen por la direccion del carrito
                if(Validate::isLoadedObject($this->context->customer)) {
                    $id_group = $this->context->customer->id_default_group;
                }
                else {
                    $id_group = Configuration::getGlobalValue('PS_GUEST_GROUP');
                }
                $id_warehouse = $this->getFunciones()->cargarAsignacionAlmacen($direccion->id_country, $direccion->id_state, $id_group);
            }
            elseif($this->context->customer && $this->context->customer->isLogged()) {
                //Buscamos la primera direccion del cliente
                $id_address = Address::getFirstCustomerAddressId($this->context->customer->id);
                if($id_address) {
                    $direccion = new Address($id_address);
                    $id_warehouse = $this->getFunciones()->cargarAsignacionAlmacen($direccion->id_country, $direccion->id_state, 
                            $this->context->customer->id_default_group);
                }
            }
            
            if(empty($id_warehouse)) {
                //El almacen general
                $id_warehouse = (int) Configuration::getGlobalValue(self::prefijo . 'ALMACEN_GENERAL');
            }
        }
        
        return $id_warehouse;
    }
    
    /**
     * Comprueba el carrito y devuelve la ventana de aviso.
     * @return array [ventanaAviso, todosSinStock]
     */
    public function comprobarCarrito() {
        $todosSinStock = false;
        $ventanaProductosSinStock = '';
        if($this->getModoActual() == ImaxMultiAlmacen::MODO_TRANSPORTISTA) {
            $productosSinStock = $this->comprobarStockCarrito();
            if($productosSinStock) {
                $todosSinStock = count($productosSinStock) == count($this->context->cart->getProducts());
                $this->context->smarty->assign([
                    'productosSinStock' => $productosSinStock,
                    'todosSinStock' => $todosSinStock,
                    'baseUrlAlmacenes' => $this->_path
                ]);
                $ventanaProductosSinStock = $this->context->smarty->fetch('module:imaxmultialmacen/views/templates/hook/productosEliminados.tpl');
            }
        }
        
        return [$ventanaProductosSinStock, $todosSinStock];
    }
    
    /**
     * Quita del carrito los productos sin stock.
     * @return boolean
     */
    public function ajustarCarrito() {
        $productosSinStock = $this->comprobarStockCarrito();
        $todosSinStock = count($productosSinStock) == count($this->context->cart->getProducts());
        //Quitamos los productos sin stock del carrito
        foreach($productosSinStock as $productoSinStock) {
            $this->context->cart->deleteProduct($productoSinStock['id_product'], $productoSinStock['id_product_attribute'], 
                $productoSinStock['id_customization']);
        }
        
        return $todosSinStock;
    }
    
    /**
     * Devuelve los productos que no tienen stock suficiente.
     * @return array
     */
    private function comprobarStockCarrito() {
        $productosSinStock = [];
        foreach($this->context->cart->getProducts(true) as $product) {
            if(!$product['allow_oosp'] && $product['stock_quantity'] < $product['cart_quantity']) {
                $productosSinStock[] = $product;
            }
            elseif(!$product['allow_oosp']) {
                $productQuantity = Product::getQuantity(
                    $product['id_product'],
                    $product['id_product_attribute'],
                    null,
                    $this->context->cart,
                    $product['id_customization']
                );

                if ($productQuantity < 0) {
                    $productosSinStock[] = $product;
                }
            }
        }

        return $productosSinStock;
    }
    
    /**
     * Indica si hay almacen disponible para el front.
     * @param boolean $ignorarSeleccionado 
     * @return boolean
     */
    private function hasWarehouse($ignorarSeleccionado = false) {
        $modo = $this->getModoActual();
        if($modo == self::MODO_ORDENADOS) {
            $resultado = true;
        }
        elseif($modo == self::MODO_PAGO) {
            $resultado = (boolean)$this->getSavePayment(true);
        }
        elseif($modo == self::MODO_TRANSPORTISTA) {
            $resultado = !empty($this->context->cart->id_carrier);
            if(!$resultado && !$ignorarSeleccionado && $this->context->cookie->selected_warehouse) {
                //El almacen seleccionado por el cliente
                $resultado = (boolean)$this->context->cookie->selected_warehouse;
            }
        }
        else {
            $resultado = false;

            $tipoDireccion = ((int) Configuration::getGlobalValue(self::prefijo . 'TIPO_DIRECCION') == self::DIRECCION_FACTURACION ? 'id_address_invoice' : 'id_address_delivery');
            $direccion = new Address($this->context->cart->$tipoDireccion);
            if(Validate::isLoadedObject($direccion)) {
                //Buscamos el almacen por la direccion del carrito
                if(Validate::isLoadedObject($this->context->customer)) {
                    $id_group = $this->context->customer->id_default_group;
                }
                else {
                    $id_group = Configuration::getGlobalValue('PS_GUEST_GROUP');
                }
                $resultado = (boolean)$this->getFunciones()->cargarAsignacionAlmacen($direccion->id_country, $direccion->id_state, $id_group);
            }
            elseif($this->context->customer && $this->context->customer->isLogged()) {
                //Buscamos la primera direccion del cliente
                $id_address = Address::getFirstCustomerAddressId($this->context->customer->id);
                if($id_address) {
                    $direccion = new Address($id_address);
                    $resultado = (boolean)$this->getFunciones()->cargarAsignacionAlmacen($direccion->id_country, $direccion->id_state, 
                            $this->context->customer->id_default_group);
                }
            }

            if(!$resultado && !$ignorarSeleccionado && $this->context->cookie->selected_warehouse) {
                //El almacen seleccionado por el cliente
                $resultado = (boolean)$this->context->cookie->selected_warehouse;
            }
        }
        
        return $resultado;
    }
    
    public function hookActionCustomerLogoutBefore($params) {
        unset($this->context->cookie->selected_warehouse);
    }

    public function hookActionAdminProductsListingFieldsModifier($params) {
        $params['sql_select']['sav_quantity']['field'] = 'usable_quantity';
        $params['sql_select']['badge_danger']['select'] = 'IF(sav.`usable_quantity`<=0, 1, 0)';
        $params['sql_select']['badge_danger']['filtering'] = 'IF(sav.`usable_quantity`<=0, 1, 0) = %s';
        $params['sql_table']['sav']['table'] = 'stock';
        $params['sql_table']['sav']['on'] = 'sav.`id_product` = p.`id_product` AND sav.`id_product_attribute` = 0 AND sav.`id_warehouse` = '.(int)$this->context->warehouse->id;
    }
    
    public function hookDisplayBackofficeHeader($params) {
        $css = '';
        if(Tools::getValue('controller') == 'AdminStockManagement') {
            $css = '<style>#head_tabs .nav-item:nth-child(2) { display:none; }</style>';
        }
        elseif(Tools::getValue('controller') == 'AdminProducts') {
            //Ocultamos la modificación de stock si el almacén es el virtual
            $almacenesVirtuales = array_keys((new AlmacenesVirtuales())->cargarRelaciones());
            if(in_array($this->getWarehouse()->id, $almacenesVirtuales)) {
                $mensaje = '- '.$this->l('No se puede modificar el stock del producto ya que el almacén por defecto es virtual. Acceda a la configuración del módulo si desea modificarlo.');
                $css = '
                    <style>
                        #product_stock #product_stock_quantities #product_stock_quantities_delta_quantity_delta { pointer-events: none; }
                        #combination_list .delta-quantity-delta { pointer-events: none; }
                        #combination_form #combination_form_stock_quantities_delta_quantity_delta { pointer-events: none; }

                        #accordion_combinations .attribute-quantity input { pointer-events: none; }
                        .combination-form [name$="[attribute_quantity]"] { pointer-events: none; }
                        #step3 [name="form[step3][qty_0]"] { pointer-events: none; }
                    </style>
                    <script>
                        $(function() {
                            $(".product-header-v2").after("<div style=\"color: #c05c67;margin-bottom: 15px;\">'.$mensaje.'</div>");
                            $(".product-header").append("<div style=\"color: #c05c67;\">'.$mensaje.'</div>");
                        });
                    </script>';
            }
        }
        
        return $css;
    }
    
    public function hookActionFrontControllerSetMedia($params) {
        $modo = $this->getModoActual();
        if($modo == self::MODO_PAGO || 
                (($modo == self::MODO_DIRECCION || $modo == self::MODO_TRANSPORTISTA) && $this->almacenSeleccionable())) {
            $this->context->controller->registerStylesheet('selectorAlmacen', "modules/$this->name/views/templates/css/selector.css");
            $this->context->controller->addjQueryPlugin('fancybox');
            Media::addJsDef(['esModoPago' => $modo == self::MODO_PAGO]);
            $this->context->controller->registerJavascript('selectorAlmacen', "modules/$this->name/views/templates/js/selector.js");
        }
        
        if($this->context->controller->php_self == 'order') {
            $this->context->controller->registerJavascript(
                'module-informax-tapa',
                'modules/'.$this->name.'/js/Tapa.js',
                [
                  'media' => 'all',
                  'priority' => 200,
                ]
            );
        }
    }
    
    public function hookDisplayTop($params) {
        $html = '';
        
        $modo = $this->getModoActual();
        if($modo == self::MODO_PAGO) {
            $comprobacionesFormaPagoAlmacen = $this->comprobacionesFormaPagoAlmacen($modo);
            $modulosPagoInfo = $comprobacionesFormaPagoAlmacen[2];
            $this->context->smarty->assign(array(
                'formasPago' => $modulosPagoInfo,
                'formaPagoActual' => $this->getSavePayment()
            ));
            
            $html = $this->display($this->name, 'views/templates/hook/seleccion_formaPago.tpl'); 
        } 
        elseif(($modo == self::MODO_DIRECCION || $modo == self::MODO_TRANSPORTISTA) && $this->almacenSeleccionable()) {
            $tituloSeleccion = unserialize(Configuration::getGlobalValue(self::prefijo.'TITULO_SELECCION'));
            if(!empty($tituloSeleccion[$this->context->language->id])) {
                $titulo = $tituloSeleccion[$this->context->language->id];
            }
            else {
                $titulo = $this->l('Por favor seleccione el almacén');
            }
            $puntosRecogida = [];
            if(Module::isEnabled('imaxpuntosrecogida') && !Configuration::getGlobalValue('imax_multi_alma_NO_MOSTRAR_EN_SELECTOR')) {
                Module::getInstanceByName('imaxpuntosrecogida');
                include_once(dirname(__FILE__).'/../imaxpuntosrecogida/classes/TransportistaExtra.php');
                include_once(dirname(__FILE__).'/../imaxpuntosrecogida/classes/DireccionPuntoRecogida.php');
                $transportistas = Carrier::getCarriers($this->idLang, true, false, false, null, Carrier::ALL_CARRIERS);
                //Les agregamos las direcciones y el nombre del transportista
                foreach($transportistas as $transportista) {
                    $transportistaExtra = TransportistaExtra::cargar($transportista['id_reference']);
                    $transportistaObj = Carrier::getCarrierByReference($transportistaExtra->id_reference, $this->idLang);
                    $transportistaExtra->transportista = $transportistaObj->name;
                    if($transportistaExtra->id_direccion_punto_recogida) {
                        $direccionObj = new DireccionPuntoRecogida($transportistaExtra->id_direccion_punto_recogida);
                        $direccionObj->state = ($direccionObj->id_state ? State::getNameById($direccionObj->id_state) : '');
                        $direccionObj->country = Country::getNameById($this->idLang, $direccionObj->id_country);
                        $transportistaExtra->direccion = $direccionObj;
                    }
                    else {
                        $transportistaExtra->direccion = null;
                    }
                    $imagen = '';
                    if(is_file(__DIR__.'/../imaxpuntosrecogida/images/'.$transportista['id_reference'].'.jpg')) {
                        $imagen = $this->_path.'../imaxpuntosrecogida/images/'.$transportista['id_reference'].'.jpg';
                    }
                    $transportistaExtra->imagen = $imagen;
                    $puntosRecogida[$transportistaExtra->id_warehouse][] = $transportistaExtra;
                }
            }
            
            $almacenes = $this->getFunciones()->getWarehouses(true);
            $nombreVisibleAlmacenes = [];
            foreach ($almacenes as $almacen){
                $idAlmacen = $almacen['id_warehouse'];
                $almacenShowStock = new WarehouseShowStock($idAlmacen);
                $nombreVisibleAlmacenes[$idAlmacen] = $almacenShowStock->getNombreVisible($this->idLang);
            }
            $this->context->smarty->assign(array(
                'almacenes' => $almacenes,
                'tituloSeleccion' => $titulo,
                'puntosRecogida' => $puntosRecogida,
                'idAlmacenActual' => $this->getWarehouse()->id,
                'nombreVisibleAlmacenes' => $nombreVisibleAlmacenes
            ));
            $html = $this->display($this->name, 'views/templates/hook/seleccion_almacen.tpl');
        }
        
        return $html.$this->renderWidget('displayTop', $params);
    }
    
    public function hookDisplayBeforeBodyClosingTag($params) {
        $html = '';
        $modo = $this->getModoActual();
        if(($modo == self::MODO_PAGO || 
                (($modo == self::MODO_DIRECCION || $modo == self::MODO_TRANSPORTISTA) && $this->almacenSeleccionable()))) {
            $html = "<script>var baseUrlAlmacenes = '$this->_path';</script>";

            $comprobacionesFormaPagoAlmacen = $this->comprobacionesFormaPagoAlmacen($modo);
            $seleccionado = $comprobacionesFormaPagoAlmacen[0];
            $idAlmacenActual = $comprobacionesFormaPagoAlmacen[1];
            $html .= "
                <script>
                    var almacenSeleccionado = $seleccionado;
                    var almacenActual = $idAlmacenActual;
                </script>";
        }
        
        if($modo == self::MODO_PAGO && $this->context->controller->php_self == 'order') {
            $imaxOpc = Module::getInstanceByName('imaxopc');
            if(!Module::isEnabled('imaxopc') || !$imaxOpc->getFunciones()->usoAutorizado()) {
                $formaPago = $this->getSavePayment(true);
                $this->smarty->assign([
                    'formaPago' => $formaPago,
                    'baseUrlAlmacenes' => $this->_path
                ]);
                $html .= $this->display($this->name, 'views/templates/hook/front.js.tpl');
            }
        }
        
        if($this->context->controller->php_self == 'order') {
            $this->smarty->assign([
                'baseUrlAlmacenes' => $this->_path
            ]);
            $html .= $this->display($this->name, 'views/templates/hook/order.js.tpl');
        }
        
        return $html;
    }

    public function hookDisplayStockMessage($params) {
        $mensajeString = '';

        if(Validate::isLoadedObject($this->context->customer)) {
            $ids_group = $this->context->customer->getGroups();
        }
        else {
            $ids_group = [Configuration::getGlobalValue('PS_GUEST_GROUP')];
        }
        $mensajesTemp = StockOrdenado::getInstance()->obtenerDatosOrdenados($this->idLang, $ids_group, $params['product']['id_product'], $params['product']['id_product_attribute']);
        
        $mensajeCantidad = [];
        $mensajeTexto = [];
        $quantity = (!empty($params['product']['quantity_wanted']) ? $params['product']['quantity_wanted'] : 1);
        $modo = $this->getModoActual();
        if($modo == self::MODO_ORDENADOS) {
            $i = 0;
            $count = count($mensajesTemp);
            foreach($mensajesTemp as $mensajes) {
                $mensaje = reset($mensajes);
                if($mensaje['usable_quantity'] > 0) {
                    foreach($mensajes as $mensaje) {
                        $cumpleRegla = StockOrdenado::getInstance()->comprobarReglaStock($mensaje['regla_stock_ref'], $mensaje['stock_ref'], 
                                $mensaje['usable_quantity']);
                        if($cumpleRegla) {
                            $mensajeTexto[] = $mensaje['text_con_stock'];
                            $mensajeCantidad[] = min([$quantity, $mensaje['usable_quantity']]);
                            $quantity -= min([$quantity, $mensaje['usable_quantity']]);
                            break;
                        }
                    }
                }
                
                if($i == $count - 1 && $quantity > 0) {
                    //Es el ultimo almacen y no se consumio el stock
                    $mensajeTexto[] = $mensaje['text_sin_stock'];
                    $mensajeCantidad[] = $quantity;
                }
                if($quantity <= 0) {
                    //Finalizado
                    break;
                }
                $i++;
            }
        }
        else {
                if(isset($mensajesTemp[$this->context->warehouse->id])) {
                    $mensaje = reset($mensajesTemp[$this->context->warehouse->id]);
                    if($mensaje['usable_quantity'] > 0) {
                        foreach($mensajesTemp[$this->context->warehouse->id] as $mensaje) {
                            $cumpleRegla = StockOrdenado::getInstance()->comprobarReglaStock($mensaje['regla_stock_ref'], $mensaje['stock_ref'], 
                                    $mensaje['usable_quantity']);
                            if($cumpleRegla) {
                                $mensajeTexto[] = $mensaje['text_con_stock'];
                                $mensajeCantidad[] = min([$quantity, $mensaje['usable_quantity']]);
                                $quantity -= min([$quantity, $mensaje['usable_quantity']]);
                                break;
                            }
                        }
                    }

                    if($quantity > 0) {
                        //No se consumio el stock
                        $mensajeTexto[] = $mensaje['text_sin_stock'];
                        $mensajeCantidad[] = $quantity;
                    }
                }
        }
        
        if($mensajeTexto) {
            if(count($mensajeTexto) > 1) {
                //Intercalamos las cantidades
                foreach($mensajeTexto as $i => $mensajeTextoTemp) {
                    $mensajeString .= $mensajeCantidad[$i].' '.$mensajeTextoTemp.'. ';
                }
            }
            else {
                $mensajeString .= $mensajeTexto[0];
            }
        }
        
        return $mensajeString;
    }
    
    public function hookActionValidateOrder($params) {
        $modo = $this->getModoActual();
        if($modo == self::MODO_DIRECCION || $modo == self::MODO_PAGO || $modo == self::MODO_TRANSPORTISTA) {
            $warehouse = $this->getWarehouse();
            $id_order = $params['order']->id;
            $this->getFunciones()->anotarAlmacenPedido($id_order, $warehouse->id);
        }
    }
    
    public function hookDisplayOrderConfirmation($params) {
        $this->hookActionValidateOrder($params);
    }

    public function hookActionOrderHistoryAddAfter($params) {
        if(Configuration::getGlobalValue(self::prefijo . 'DISTINGUIR_FISICO') && $this->getModoActual() != self::MODO_ORDENADOS) {
            $actualizarStockFisico = new ActualizarStockFisico($params['order_history']->id_order);
            $actualizarStockFisico->actualizar();
        }
    }
    
    public function hookDisplayAdminProductsExtra($params) {
        $html = '';
        foreach($this->getFunciones()->obtenerAlmacenesProducto($params['id_product'], false, true) as $datosAlmacenes) {
            if($datosAlmacenes['nombre']) {
                $html .= "<h3>{$datosAlmacenes['nombre']}</h3>";
            }
            $html .= '<table class="table"><thead><tr><th>'.$this->l('Almacén / Ubicación').'</th><th>'.$this->l('Stock físico').'</th><th>'.$this->l('Stock usable').'</th></tr></thead><tbody>';
            foreach($datosAlmacenes['almacenes'] as $almacen) {
                $html .= "<tr><td>{$almacen['nombre']}</td><td>{$almacen['physical_quantity']}</td><td>{$almacen['usable_quantity']}</td></tr>";
            }
            $html .= '</tbody></table>';
        }
        
        return $html;
    }
    
    public function hookActionObjectOrderAddBefore($params) {
        //Cargamos el almacén del carrito de haberlo
        self::$almacenGuardado = $this->getFunciones()->cargarAlmacenCarrito($params['object']->id_cart);
    }

    public function l($msg, $modulo = '', $locale = null) {
        if ($modulo == '') {
            $modulo = 'traducciones' . strtolower($this->name);
        }
        return parent::l($msg, $modulo, $locale);
    }

    public function getWidgetVariables($hookName, array $configuration) {
        //Obtenemos el id del producto y la combinación
        $id_product = (int)(isset($configuration['id_product']) ? $configuration['id_product'] : Tools::getValue('id_product'));
        if(isset($configuration['id_product'])) {
            $id_product_attribute = (int)$configuration['id_product_attribute'];
        }
        elseif(Tools::isSubmit('id_product_attribute')) {
            $id_product_attribute = (int)Tools::getValue('id_product_attribute');
        }
        else {
            try {
                $id_product_attribute = (int)Product::getIdProductAttributeByIdAttributes(
                    $id_product,
                    Tools::getValue('group'),
                    true
                );
            }
            catch(Exception $ex) {
                $id_product_attribute = 0;
            }
        }
        
        $almacenes = WarehouseShowStock::cargarAlmacenes();

        $modo = $this->getModoActual();
        if($modo == self::MODO_ORDENADOS) {
            $stockAlmacenes = [];
            $stockOrdenado = StockOrdenado::getInstance()->obtenerStockOrdenado($id_product, $id_product_attribute);
            foreach($stockOrdenado as $orden => $stock) {
                $stock['orden'] = $orden;
                $stockAlmacenes[$stock['id_warehouse']] = $stock;
            }
            
            foreach($almacenes as $almacen) {
                $almacen->usable_quantity = (isset($stockAlmacenes[$almacen->id_warehouse]) ? 
                        $stockAlmacenes[$almacen->id_warehouse]['usable_quantity'] : 0);
                $almacen->orden = (isset($stockAlmacenes[$almacen->id_warehouse]) ? 
                        $stockAlmacenes[$almacen->id_warehouse]['orden'] : PHP_INT_MAX);
            }
            usort($almacenes, function($a, $b) {
                return $a->orden - $b->orden;
            });
        }
        else {
            foreach($almacenes as $almacen) {
                $almacen->usable_quantity = StockAvailable::getQuantityAvailableByProduct($id_product, $id_product_attribute, null, $almacen->id_warehouse);
            }
        }
        $warehouseActual = $this->getWarehouse();
        $comerciales = Module::getInstanceByName('comerciales');
        if($comerciales) {
            $esComercial = (boolean)$comerciales->cargarComercialActual();
        }
        else {
            $esComercial = false;
        }

        return [
            'almacenes' => $almacenes,
            'id_warehouse_actual' => $warehouseActual->id,
            'id_lang' => $this->context->language->id,
            'id_product' => $id_product,
            'id_product_attribute' => $id_product_attribute,
            'esComercial' => $esComercial
        ];
    }

    public function renderWidget($hookName, array $configuration) {
        $hookBotonAlmacen = Configuration::getGlobalValue(self::prefijo.'HOOK_BOTON_ALMACEN');
        $mostrarSelectorFormaPagoWidget = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_SELECTOR_FORMA_PAGO_WIDGET');
        $modo = $this->getModoActual();
        $html = '';
        if(!$hookName) {
            $variables = $this->getWidgetVariables($hookName, $configuration);
            if($variables['id_product']) {
                if($mostrarSelectorFormaPagoWidget && $modo == self::MODO_PAGO){
                    $html .= $this->display($this->name, 'views/templates/hook/enlaceSeleccionFormaPago.tpl');
                }
                //Comprobamos si hay algún almacén que mostrar
                if($this->getFunciones()->algunAlmacenVisibleStock($variables['almacenes'])) {
                    $this->smarty->assign($variables);
                    $html .= $this->display($this->name, 'views/templates/hook/stockAlmacenes.tpl');
                }
            }
        }
        elseif($hookName == $hookBotonAlmacen) {
            $mostrarBotonAlmacen = Configuration::getGlobalValue(self::prefijo.'MOSTRAR_BOTON_ALMACEN');
            if($modo == self::MODO_PAGO) {
                if(!$mostrarSelectorFormaPagoWidget){
                    $html = $this->display($this->name, 'views/templates/hook/enlaceSeleccionFormaPago.tpl');
                }
            }
            elseif(($modo == self::MODO_DIRECCION || $modo == self::MODO_TRANSPORTISTA) && $mostrarBotonAlmacen) {
                $textoBotonAlmacen = unserialize(Configuration::getGlobalValue(self::prefijo.'TEXTO_BOTON_ALMACEN'));
                if(!empty($textoBotonAlmacen[$this->context->language->id])) {
                    $textoBoton = $textoBotonAlmacen[$this->context->language->id];
                }
                else {
                    $textoBoton = $this->l('Cambiar almacén');
                }
                if(Configuration::getGlobalValue(self::prefijo.'MOSTRAR_ALMACEN_ACTUAL')) {
                    $almacenActual = $this->getWarehouse();
                    $almacen = new WarehouseShowStock($almacenActual->id);
                    $nombreVisibleAlmacen = $almacen->getNombreVisible($this->idLang);
                    if(is_file(__DIR__."/images/$almacenActual->id.jpg")) {
                        $almacenActual->image = $this->_path."images/$almacenActual->id.jpg";
                    }
                    else {
                        $almacenActual->image = '';
                    }
                }
                else {
                    $almacenActual = false;
                    $nombreVisibleAlmacen = '';
                }
                $this->smarty->assign([
                    'textoBotonAlmacen' => $textoBoton,
                    'almacenActual' => $almacenActual,
                    'nombreVisibleAlmacen' => $nombreVisibleAlmacen
                ]);
                
                $html = $this->display($this->name, 'views/templates/hook/enlaceSeleccionAlmacen.tpl');
            }
        }
        
        return $html;
    }
    
    /**
     * 
     * @param int $modo
     * @return array
     */
    private function comprobacionesFormaPagoAlmacen($modo){
        $almacenActual = $this->getWarehouse();
        $solicitarSeleccion = (Configuration::getGlobalValue(self::prefijo . 'SOLICITAR_SELECCION'));
        if($solicitarSeleccion && $modo == self::MODO_PAGO){
            $modoMostrarVentana = Configuration::getGlobalValue(self::prefijo . 'MODO_MOSTRAR_VENTANA');
            if($modoMostrarVentana){
                $solicitarSeleccion = (bool) AsignacionAlmacenPago::cargarPorCliente(Context::getContext()->customer);
            } else {
                $asignaciones = AsignacionAlmacenPago::cargarPorCliente(Context::getContext()->customer);
                if($this->hasWarehouse()){
                    if(!$asignaciones){
                        $solicitarSeleccion = false;
                    } else {
                        foreach ($asignaciones as $asignacion) {
                            if($almacenActual->id == $asignacion['id_warehouse'] || !$asignacion['id_warehouse']){
                                $solicitarSeleccion = false;
                                break;
                            }
                        }
                        if($solicitarSeleccion){
                            $this->context->cookie->imax_forma_pago = '';
                            $this->context->cookie->write();
                            $almacenActual = null;
                        }
                    }
                } else {
                    $solicitarSeleccion = true;
                }
            }
        }

        $seleccionado = (int) (!$solicitarSeleccion || $this->hasWarehouse());
        
        if($seleccionado && $almacenActual) {
            $idAlmacenActual = (int)$almacenActual->id;
        } else {
            $idAlmacenActual = 0;
        }

        if($modo == self::MODO_PAGO && $idAlmacenActual){
            $asignaciones = AsignacionAlmacenPago::cargarPorCliente(Context::getContext()->customer);
            
            if($asignaciones){
                $almacenValido = false;
                foreach ($asignaciones as $asignacion) {
                    $esActual = $asignacion['id_warehouse'] == $idAlmacenActual;
                    $esGeneral = $asignacion['id_warehouse'] == 0 && $idAlmacenActual == Configuration::getGlobalValue(self::prefijo.'ALMACEN_GENERAL');
                    if($esActual || $esGeneral){
                        if(!$seleccionado){
                            $formaPago = $asignacion['forma_pago'];
                            $this->setSavePayment($formaPago);
                        }
                        $almacenValido = true;
                        break;
                    }
                }
                if(!$almacenValido){
                    $this->setSavePayment($asignaciones[0]['forma_pago']);
                }
            }
        }
        
        $modulosPagoInfo = [];
        if($modo == self::MODO_PAGO){
            $finder = new PaymentOptionsFinderCore();
            $modulosPago = $finder->find();
            $asignaciones = AsignacionAlmacenPago::cargarPorCliente(Context::getContext()->customer);
            $formaPagoAsignaciones = [];
            if($asignaciones){
                foreach ($asignaciones as $asignacion) {
                    if(!isset($formaPagoAsignaciones[$asignacion['forma_pago']])){
                        $formaPagoAsignaciones[$asignacion['forma_pago']] = true;
                    }
                }
            }
            
            foreach($modulosPago as $name => $formaPago) {
                if(!$asignaciones || isset($formaPagoAsignaciones[$name])){
                    $moduloObj = Module::getInstanceByName($name);
                    if($moduloObj) {
                        $modulosPagoInfo[] = [
                            'name' => $name, 
                            'displayName' => trim($moduloObj->displayName).(trim($moduloObj->description) ? ' - ' : '').trim($moduloObj->description)
                        ];
                    }
                }
            }
          
        }
        
        
        return [$seleccionado, $idAlmacenActual, $modulosPagoInfo];
    }
    
    /**
     * Anota movimientos y modifica el stock de los almacenes virtuales relacionados.
     * @param int $mvt_physical Debe ser siempre positivo.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse_origen
     * @param int $id_warehouse_destino
     */
    public function movimientoStockVirtual($mvt_physical, $id_product, $id_product_attribute = 0, $id_warehouse_origen = null, 
            $id_warehouse_destino = null) { 
        AlmacenStockVirtual::movimientoStockVirtual($mvt_physical, $id_product, $id_product_attribute, $id_warehouse_origen, $id_warehouse_destino);
    }
    
    /**
     * Inserta un movimiento de stock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $reserved_quantity
     * @param int $physical_quantity
     * @param int $mvt_reserved
     * @param int $mvt_physical
     * @param string $reason_presta
     * @param int $id_order
     * @param int $id_order_status
     * @param string $comments
     */
    public function insertarMovimiento($id_product, $id_product_attribute, $id_warehouse, $reserved_quantity, $physical_quantity, 
            $mvt_reserved, $mvt_physical, $reason_presta = 'Actualización', $id_order = 0, $id_order_status = 0, $comments = '') {
        (new GestAvdStockClass())->insertarMovimiento($id_product, $id_product_attribute, $id_warehouse, $reserved_quantity, $physical_quantity, 
                $mvt_reserved, $mvt_physical, $reason_presta, $id_order, $id_order_status, $comments);
    }
    
    /**
     * Devuelve el último movimiento de gestavdstock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $id_order
     * @return array
     */
    public function obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse, $id_order = 0) {
        return (new GestAvdStockClass())->obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse, $id_order);
    }

    /**
     * Devuelve datos de los productos de un almacén.
     * @param int $id_warehouse
     * @return array
     */
    public function obtenerProductosAlmacen($id_warehouse) {
        $id_warehouse = (int)$id_warehouse;
        $productos = Db::getInstance()->executeS('
            SELECT s.id_product, s.id_product_attribute, s.physical_quantity, s.usable_quantity, p.reference FROM `' . _DB_PREFIX_ . 'stock` s
                INNER JOIN `' . _DB_PREFIX_ . "product` p ON s.id_product = p.id_product
            WHERE id_warehouse = $id_warehouse AND physical_quantity > 0
            ORDER BY s.id_product ASC, s.id_product_attribute ASC");
        foreach($productos as &$producto) {
            $producto['name'] = Product::getProductName($producto['id_product'], $producto['id_product_attribute']);
        }
        
        return $productos;
    }
    
    /**
     * Crea un movimiento para el pedido en su almacén virtual.
     * @param int $mvt_physical Debe ser siempre positivo.
     * @param int $id_order
     * @param int $id_product
     * @param int $id_product_attribute
     */
    public function ajustarStockPedido($mvt_physical, $id_order, $id_product, $id_product_attribute = 0) {
        AlmacenStockVirtual::ajustarStockPedido($mvt_physical, $id_order, $id_product, $id_product_attribute);
    }
}
