<?php

include_once(dirname(__FILE__) . '../../../config/config.inc.php');
include_once(dirname(__FILE__) . '../../../init.php');

// DataTables PHP library
include( "datatableeditor/php/DataTables.php" );

// Alias Editor classes so they are easy to use
use
	DataTables\Editor,
	DataTables\Editor\Field,
	DataTables\Editor\Format,
	DataTables\Editor\Join,
	DataTables\Editor\Upload,
	DataTables\Editor\Validate;


//Metemos valores por defecto para las columnas que no usamos
if(isset($_REQUEST['data'][0])) {
    $_REQUEST['data'][0][_DB_PREFIX_.'warehouse']['id_currency'] = 0;
    $_REQUEST['data'][0][_DB_PREFIX_.'warehouse']['id_employee'] = 0;
    $_REQUEST['data'][0][_DB_PREFIX_.'warehouse']['id_address'] = (int)$_REQUEST['data'][0][_DB_PREFIX_.'warehouse']['id_address'];
}

$lastId = 0;
$tabla = _DB_PREFIX_. 'warehouse';
$tablaDirecciones = _DB_PREFIX_. 'address';
$datos = Editor::inst( $db, $tabla, 'id_warehouse' )
	->field( 
        Field::inst( $tabla.'.id_warehouse' ),
        Field::inst( $tabla.'.reference' ),
        Field::inst( $tabla.'.name' ),
        Field::inst( $tabla.'.id_address' ),
        Field::inst( $tabla.'.id_currency' ),
        Field::inst( $tabla.'.id_employee' ),
        Field::inst( $tablaDirecciones.'.alias' )
	)
    ->leftJoin($tablaDirecciones, $tabla.'.id_address', '=', $tablaDirecciones.'.id_address')
    ->on('postCreate', function($editor, $id, $values, $row) use (&$lastId) {
        $lastId = $id;
        if($id) {
            $tiendas = Shop::getShops();
            foreach($tiendas as $tienda) {
                Db::getInstance()->execute('INSERT IGNORE INTO `'._DB_PREFIX_."warehouse_shop` (id_shop, id_warehouse) 
                    VALUES ('{$tienda['id_shop']}', '$id')");
            }
            if($values[_DB_PREFIX_.'warehouse']['id_address']) {
                Db::getInstance()->execute('UPDATE `'._DB_PREFIX_."address` SET id_warehouse = '$id' WHERE id_address = '{$values[_DB_PREFIX_.'warehouse']['id_address']}'");
            }
        }
    })
    ->on('postEdit', function($editor, $id, $values, $row) {
        if($id) {
            Db::getInstance()->execute('UPDATE `'._DB_PREFIX_."address` SET id_warehouse = 0 WHERE id_warehouse = '$id'");
            if($values[_DB_PREFIX_.'warehouse']['id_address']) {
                Db::getInstance()->execute('UPDATE `'._DB_PREFIX_."address` SET id_warehouse = '$id' WHERE id_address = '{$values[_DB_PREFIX_.'warehouse']['id_address']}'");
            }
        }
    })
    ->on('postRemove', function($editor, $id, $rowData) {
        if($id) {
            Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_."warehouse_shop` WHERE id_warehouse = '$id'");
            Db::getInstance()->execute('UPDATE `'._DB_PREFIX_."address` SET id_warehouse = 0 WHERE id_warehouse = '$id'");
        }
    })
    ->process($_REQUEST)->data();

//Subida de imagen
if(isset($_REQUEST['data'])) {
    foreach($_REQUEST['data'] as $data) {
        $warehouse_id = (!empty($data['warehouse_id']) ? $data['warehouse_id'] : $lastId);
        if($warehouse_id) {
            if($data['imagen']) {
                if($data['imagen'] != 1) {
                    //Agregamos la imagen
                    file_put_contents(__DIR__."/images/$warehouse_id.jpg", base64_decode(substr($data['imagen'], strpos($data['imagen'], ','))));
                }
            }
            elseif(is_file(__DIR__."/images/$warehouse_id.jpg")) {
                //Eliminamos la imagen
                unlink(__DIR__."/images/$warehouse_id.jpg");
            }
        }
    }
}

echo $_GET['callback'].'('.json_encode($datos).')';
