<?php

/**
 * Almacena información sobre como se debe mostrar el stock del almacén en el front.
 */
class WarehouseShowStock {
    public $id_warehouse, $mostrarGrupos, $mostrarComerciales, $mostrarClientes, $nombreVisible, $grupos;
    
    /**
     * 
     * @param int $id_warehouse
     */
    public function __construct($id_warehouse) {
        $this->cargar($id_warehouse);
    }

    /**
     * Carga los datos en la clase.
     * @param int $id_warehouse
     */
    private function cargar($id_warehouse) {
        $this->id_warehouse = (int)$id_warehouse;
        $datos = Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show` 
            WHERE id_warehouse = '$this->id_warehouse'");
        if($datos) {
            //Datos básicos
            $this->mostrarClientes = $datos['mostrarClientes'];
            $this->mostrarComerciales = $datos['mostrarComerciales'];
            $this->mostrarGrupos = $datos['mostrarGrupos'];
            //Datos multiidioma
            $this->nombreVisible = [];
            $datosMultiidioma = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_lang` 
                WHERE id_warehouse = '$this->id_warehouse'");
            foreach($datosMultiidioma as $datoMultiidioma) {
                $this->nombreVisible[$datoMultiidioma['id_lang']] = $datoMultiidioma['nombreVisible'];
            }
            //Grupos
            $this->grupos = array_column(Db::getInstance()->executeS('
                SELECT id_group FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_group` 
                    WHERE id_warehouse = '$this->id_warehouse'"), 'id_group');
        }
        else {
            $this->mostrarClientes = 0;
            $this->mostrarComerciales = 0;
            $this->mostrarGrupos = 0;
            $this->nombreVisible = '';
            $this->grupos = [];
        }
    }
    
    /**
     * Graba la información.
     */
    public function grabar() {
        //Datos generales
        $id_warehouse = (int)$this->id_warehouse;
        $mostrarGrupos = (int)$this->mostrarGrupos;
        $mostrarComerciales = (int)$this->mostrarComerciales;
        $mostrarClientes = (int)$this->mostrarClientes;
        if(Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show` 
                (id_warehouse, mostrarGrupos, mostrarComerciales, mostrarClientes) VALUES 
                ($id_warehouse, $mostrarGrupos, $mostrarComerciales, $mostrarClientes)")) {
            //Idiomas
            if(Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_lang` 
                    WHERE id_warehouse = $id_warehouse")) {
                foreach($this->nombreVisible as $id_lang => $nombreVisible) {
                    $id_lang = (int)$id_lang;
                    $nombreVisible = pSQL($nombreVisible);

                    Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_lang` 
                        (id_warehouse, id_lang, nombreVisible) VALUES ($id_warehouse, $id_lang, '$nombreVisible')");
                }
            }
            //Grupos
            if(Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_group` 
                    WHERE id_warehouse = $id_warehouse")) {
                foreach($this->grupos as $grupo) {
                    $grupo = (int)$grupo;

                    Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."warehouse_show_group` 
                        (id_warehouse, id_group) VALUES ($id_warehouse, $grupo)");
                }
            }
        }
    }
    
    /**
     * Devuelve el nombre para el idioma indicado. Devuelve el nombre del almacén si no hay nombre visible configurado para el idioma.
     * @param int $id_lang
     * @return string
     */
    public function getNombreVisible($id_lang) {
        if(empty($this->nombreVisible[$id_lang])) {
            $nombreVisible = $this->getNombreOriginal();
        }
        else {
            $nombreVisible = $this->nombreVisible[$id_lang];
        }
        
        return $nombreVisible;
    }
    
    /**
     * Devuelve el nombre original del almacén.
     * @return string
     */
    public function getNombreOriginal() {
        $almacen = new Warehouse($this->id_warehouse);
        return $almacen->reference.' - '.$almacen->name;
    }
    
    /**
     * Devuelve los datos para todos los almacenes existentes.
     * @return \WarehouseShowStock[]
     */
    public static function cargarAlmacenes() {
        $almacenesObj = [];
        
        $imax = Module::getInstanceByName('imaxmultialmacen');
        $almacenes = $imax->getFunciones()->getWarehouses(true);
        foreach($almacenes as $almacen) {
            $almacenesObj[] = new WarehouseShowStock($almacen['id_warehouse']);
        }
        
        return $almacenesObj;
    }
}
