<?php

class StockOrdenado {
    private static $instance;
    private $primerAlmacen;
    
    /**
     * 
     * @return StockOrdenado
     */
    public static function getInstance() {
        if(!self::$instance) {
            self::$instance = new StockOrdenado();
        }
        
        return self::$instance;
    }

    /**
     * Devuelve el id del almacen de primer orden.
     * @return int
     */
    public function obtenerPrimerAlmacen() {
        if(!$this->primerAlmacen) {
            $this->primerAlmacen = (int)Db::getInstance()->getValue('SELECT id_warehouse FROM `'._DB_PREFIX_."imax_multi_alma_text_stock` ORDER BY orden_almacen ASC");
        }
        return $this->primerAlmacen;
    }
    
    /**
     * Devuelve los datos completos del stock.
     * @param int $idLang
     * @param int $ids_group
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    public function obtenerDatosOrdenados($idLang, $ids_group, $id_product, $id_product_attribute = 0) {
        $resultado = [];
        
        if($ids_group) {
            $ids_groupString = implode(',', array_map('intval', $ids_group));
            $filas = Db::getInstance()->executeS('
                SELECT s.*, ts.*, tsi.*, IF(LENGTH(tsi.text_con_stock), tsi.text_con_stock, ts.text_con_stock) text_con_stock, 
                        IF(LENGTH(tsi.text_sin_stock), tsi.text_sin_stock, ts.text_sin_stock) text_sin_stock FROM `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo.'text_stock` ts 
                    LEFT JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."text_stock_idi` tsi ON ts.id = tsi.id_text_stock AND tsi.id_lang = $idLang
                    LEFT JOIN `"._DB_PREFIX_."stock` s 
                        ON ts.product_id = s.id_product AND ts.product_attribute_id = s.id_product_attribute AND ts.id_warehouse = s.id_warehouse
                WHERE ts.product_id = '$id_product' AND ts.product_attribute_id = '$id_product_attribute' AND ts.id_group IN ($ids_groupString)
                ORDER BY ts.id_group ASC, ts.orden_almacen ASC");
            foreach($filas as $clave => $fila) {
                if($clave > 0 && $filas[$clave - 1]['id_group'] != $fila['id_group']) {
                    break;
                }
                $resultado[$fila['id_warehouse']][] = $fila;
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve el stock de todos los almacenes para el producto indicado.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return array
     */
    public function obtenerStockOrdenado($id_product, $id_product_attribute = 0) {
        return Db::getInstance()->executeS('
            SELECT s.* FROM `'._DB_PREFIX_.'stock` s 
                INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."text_stock` ts
                    ON ts.product_id = s.id_product AND ts.product_attribute_id = s.id_product_attribute AND ts.id_warehouse = s.id_warehouse
            WHERE s.id_product = '$id_product' AND s.id_product_attribute = '$id_product_attribute'
            GROUP BY s.id_warehouse
            ORDER BY ts.orden_almacen ASC");
    }

    /**
     * Indica si el almacen tiene stock segun su regla.
     * @param int $regla_stock_ref
     * @param int $stock_ref
     * @param int $stock
     * @return boolean
     */
    public function comprobarReglaStock($regla_stock_ref, $stock_ref, $stock) {
        switch($regla_stock_ref) {
            case 0:
                $stock = $stock < $stock_ref;
                break;
            
            case 1: 
                $stock = $stock <= $stock_ref;
                break;
            
            case 2:
                $stock = $stock == $stock_ref;
                break;
            
            case 3:
                $stock = $stock >= $stock_ref;
                break;
            
            case 4:
                $stock = $stock > $stock_ref;
                break;
        }
        
        return $stock;
    }
    
}
