<?php

namespace Informax\ImaxMultiAlmacen;

use Configuration;
use Exception;
use ReflectionClass;

/**
 * Modifica una clase
 * @version 1.1
 */
class ModificadorClases {
    
    private $prefijo;
    
    /**
     * 
     * @param string $prefijo
     */
    public function __construct($prefijo) {
        $this->prefijo = $prefijo;
    }
    
    /**
     * Elimina un metodo de una clase.
     * @param string $clase
     * @param string $metodo
     * @param string $ruta
     * @param boolean $copiaSeguridad
     */
    public function eliminarMetodo($clase, $metodo, $ruta = _PS_OVERRIDE_DIR_.'classes/', $copiaSeguridad = true) {
        try {
            if(is_file("$ruta/$clase.php")) {
                //Copiamos la clase
                $temp = tempnam(sys_get_temp_dir(), 'imax_');
                $tempContent = file_get_contents("$ruta/$clase.php");
                $newClass = $clase.'_'.uniqid();
                file_put_contents($temp, str_replace("class $clase", "class $newClass", $tempContent));
                require $temp;

                //La procesamos
                $linesBackup = [];
                $reflectionClass = new ReflectionClass($newClass);
                $reflectionMethod = $reflectionClass->getMethod($metodo);
                if($reflectionMethod->getDeclaringClass()->name == $newClass) {
                    $start = $reflectionMethod->getStartLine();
                    $end = $reflectionMethod->getEndLine();
                    $count = 1;
                    $lines = [];
                    $fp = fopen("$ruta/$clase.php", 'r+');
                    flock($fp, LOCK_SH);
                    while(($line = fgets($fp))) {
                        if($count < $start || $count > $end) {
                            $lines[] = $line;
                        }
                        elseif($copiaSeguridad) {
                            $linesBackup[] = $line;
                        }
                        $count++;
                    }
                    
                    if($linesBackup) {
                        Configuration::updateGlobalValue($this->prefijo.'copia_'.$clase.'_'.$metodo, implode('', $linesBackup));
                    }

                    if($lines) {
                        fseek($fp, 0);
                        ftruncate($fp, 0);
                        fputs($fp, implode('', $lines));
                    }
                    fclose($fp);
                }
            }
        }
        catch(Exception $ex) { }
    }
    
    /**
     * Recupera una copia de seguridad de existir.
     * @param string $clase
     * @param string $metodo
     * @param string $ruta
     * @return boolean Indica si se disponía de la copia.
     */
    public function restaurarMetodo($clase, $metodo, $ruta = _PS_OVERRIDE_DIR_.'classes/') {
        $codigo = Configuration::getGlobalValue($this->prefijo.'copia_'.$clase.'_'.$metodo);
        if($codigo) {
            $this->agregarMetodo($clase, $codigo, $ruta);
        }
        
        return (boolean)$codigo;
    }
    
    /**
     * Agrega un metodo al final de una clase sobrescrita.
     * @param string $clase
     * @param string $codigo
     * @param string $ruta
     */
    public function agregarMetodo($clase, $codigo, $ruta = _PS_OVERRIDE_DIR_.'classes/') {
        try {
            //Copiamos la clase
            $temp = tempnam(sys_get_temp_dir(), 'imax_');
            $tempContent = file_get_contents("$ruta/$clase.php");
            $newClass = $clase.'_'.uniqid();
            file_put_contents($temp, str_replace("class $clase", "class $newClass", $tempContent));
            require $temp;

            //La procesamos
            $reflectionClass = new ReflectionClass($newClass);
            if(!$this->existeMetodo($codigo, $reflectionClass)){
                $end = $reflectionClass->getEndLine();
                $count = 1;
                $lines = [];
                $fp = fopen("$ruta/$clase.php", 'r+');
                flock($fp, LOCK_SH);
                while(($line = fgets($fp))) {
                    if($count < $end) {
                        $lines[] = $line;
                    }
                    $count++;
                }

                if($lines) {
                    //Agregamos el metodo
                    $claseString = implode('', $lines).$codigo."\n}";

                    fseek($fp, 0);
                    ftruncate($fp, 0);
                    fputs($fp, $claseString);
                }
                fclose($fp);
            }
        }
        catch(Exception $ex) { }
    }
    
    /**
     * Comprueba si existe un método en una clase
     * 
     * @param string $code
     * @param ReflectionClass $reflectionClass
     * @return bool
     */
    private function existeMetodo($code, $reflectionClass){
        $matches = [];
        $pattern = '/\bfunction\s+([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*\(/';
        if (preg_match($pattern, $code, $matches)) {
            $methodName = $matches[1];
            return $reflectionClass->hasMethod($methodName);
        } else {
            return false;
        }
    }
    
    
}
