<?php

use PrestaShop\PrestaShop\Adapter\Presenter\Product\ProductLazyArray;
use PrestaShop\PrestaShop\Adapter\Presenter\Product\ProductListingLazyArray;
use PrestaShop\PrestaShop\Adapter\Presenter\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Core\Product\ProductPresentationSettings;

class ImaxProductListingPresenter extends ProductListingPresenter {
    /**
     * @param ProductPresentationSettings $settings
     * @param array $product
     * @param Language $language
     *
     * @return ProductLazyArray|ProductListingLazyArray
     *
     * @throws ReflectionException
     */
    public function present(
        ProductPresentationSettings $settings,
        array $product,
        Language $language
    ) {
        
        if(Module::isEnabled('imaxminquantity')){
            $imaxminquantity = Module::getInstanceByName('imaxminquantity');
            $quantity = $imaxminquantity->getFunciones()->obtenerCantidadMinima(Context::getContext()->customer, $product['id_product'], $product['id_product_attribute']);
            $product['minimal_quantity'] = $quantity;
            $product['quantity_wanted'] = $quantity;
        }

        $lazy = new ProductListingLazyArray(
            $settings,
            $product,
            $language,
            $this->imageRetriever,
            $this->link,
            $this->priceFormatter,
            $this->productColorsRetriever,
            $this->translator
        );
        
        if(Module::isEnabled('imaxmultialmacen')){
            $imaxmultialmacen = Module::getInstanceByName('imaxmultialmacen');
            $mensaje = $imaxmultialmacen->hookDisplayStockMessage(['product' => $product]);
            if($mensaje) {
                $lazy->availability_message = $mensaje;
            }
        }
        
        return $lazy;
    }
}
