<?php

/**
 * Contiene funciones para trabajar con movimientos de stock avanzados.
 */
class GestAvdStockClass
{
    /**
     * Inserta un movimiento en gestavdstock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $reserved_quantity
     * @param int $physical_quantity
     * @param int $mvt_reserved
     * @param int $mvt_physical
     * @param string $reason_presta
     * @param int $id_order
     * @param int $id_order_status
     * @param string $comments
     */
    public function insertarMovimiento($id_product, $id_product_attribute, $id_warehouse, $reserved_quantity, $physical_quantity, 
            $mvt_reserved, $mvt_physical, $reason_presta = 'Actualización', $id_order = 0, $id_order_status = 0, $comments = '') {
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $reserved_quantity = (int)$reserved_quantity;
        $physical_quantity = (int)$physical_quantity;
        $mvt_reserved = (int)$mvt_reserved;
        $mvt_physical = (int)$mvt_physical;
        $id_employee = (int)$this->obtenerEmpleado()->id;
        $nombreProducto = pSQL(Product::getProductName($id_product, $id_product_attribute));
        if($id_product_attribute) {
            $obj = new Combination($id_product_attribute);
        }
        else {
            $obj = new Product($id_product);
        }
        $referencia = pSQL($obj->reference);
        $usable_quantity = $physical_quantity - $reserved_quantity;
        $sign = -1;
        if($mvt_physical > 0) {
            $sign=1;
        }
        $reason_presta = pSQL($reason_presta);
        $date_add = date('Y-m-d H:i:s');
        $id_order = (int)$id_order;
        $id_order_status = (int)$id_order_status;
        $comments = pSQL($comments);
        
        $sql = 'INSERT INTO `' . _DB_PREFIX_ . "stock_available_advanced` (product_name, reference, id_product, id_product_attribute, id_order, id_order_status, stock_quantity, physical_quantity, reserved_quantity, mvt_physical, mvt_reserved, sign, id_employee, reason_presta, comments, date_add) 
            VALUES ('$nombreProducto', '$referencia', $id_product, $id_product_attribute, $id_order, $id_order_status, $usable_quantity, $physical_quantity, $reserved_quantity, $mvt_physical, $mvt_reserved, $sign, $id_employee, '$reason_presta', '$comments', '$date_add')";
        Db::getInstance()->execute($sql);

        $id_stock_available_advanced = (int)Db::getInstance()->Insert_ID();
        $id_warehouse = (int)$id_warehouse;
        Db::getInstance()->execute('REPLACE INTO `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` 
            (id_stock_available_advanced, id_warehouse) VALUES ($id_stock_available_advanced, $id_warehouse)");
    }
    
    /**
     * Devuelve un empleado.
     * @return Employee
     */
    private function obtenerEmpleado() {
        $employee = Context::getContext()->employee;
        if(!Validate::isLoadedObject($employee)) {
            $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1';
            $idEmployee = Db::getInstance()->getValue($sql);
            $employee = new Employee($idEmployee);
        }
        
        return $employee;
    }
    
    /**
     * Devuelve el último movimiento de gestavdstock.
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_warehouse
     * @param int $id_order
     * @return array
     */
    public function obtenerUltimoMovimiento($id_product, $id_product_attribute, $id_warehouse, $id_order = 0) {
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $id_warehouse = (int)$id_warehouse;
        $id_order = (int)$id_order;
        
        $sql = '
            SELECT * FROM `'._DB_PREFIX_.'stock_available_advanced` saa
                INNER JOIN `'._DB_PREFIX_.ImaxMultiAlmacen::prefijo."extraMovimiento_advanced` ema 
                    ON saa.id_stock_available_advanced = ema.id_stock_available_advanced
            WHERE id_product = $id_product AND id_product_attribute = $id_product_attribute AND ema.id_warehouse = $id_warehouse " .
                ($id_order ? "AND id_order = $id_order " : '') .
            'ORDER BY saa.id_stock_available_advanced DESC';
        return Db::getInstance()->getRow($sql);
    }
}
